/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.sm.client.zm.merge.RadioGroupButtonPanel;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JToggleButton;

final class ZActionEditor
extends DefaultCellEditor
implements ActionListener {
    private JToggleButton _left = null;
    private JToggleButton _right = null;
    private JToggleButton _action = null;
    private String _value = null;
    private ZMergeTableModel _model = null;
    private int _row = -1;
    private int _column = -1;

    public ZActionEditor(RadioGroupButtonPanel b) {
        super(new JCheckBox());
        this.editorComponent = b;
        this.setClickCountToStart(0);
        this._left = b.getButton(0);
        this._action = b.getButton(1);
        this._right = b.getButton(2);
        this._left.addActionListener(this);
        this._right.addActionListener(this);
        this._action.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this._value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._column = column;
        this._model = (ZMergeTableModel)table.getModel();
        this._value = (String)value;
        Object leftValue = table.getModel().getValueAt(row, column - 1);
        Object rightValue = table.getModel().getValueAt(row, column + 2);
        this._left.setEnabled(leftValue != null);
        this._right.setEnabled(rightValue != null);
        this._action.setEnabled(leftValue != null && rightValue != null);
        if (this._value != null) {
            if (this._value.equals("<")) {
                this._left.setSelected(true);
            } else if (this._value.equals("+")) {
                this._action.setSelected(true);
            } else if (this._value.equals(">")) {
                this._right.setSelected(true);
            } else {
                this._action.setSelected(true);
            }
        } else {
            this._action.setSelected(true);
        }
        if (isSelected) {
            this.editorComponent.setBackground(table.getSelectionBackground());
            this.editorComponent.setForeground(table.getSelectionForeground());
        } else {
            this.editorComponent.setBackground(table.getBackground());
            this.editorComponent.setForeground(table.getForeground());
        }
        int width = table.getColumnModel().getColumn(column).getPreferredWidth();
        int height = table.getRowHeight(row);
        this.editorComponent.setPreferredSize(new Dimension(width, height));
        return this.editorComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    void setValue(String value) {
        boolean actionSelectable;
        String oldValue = (String)this._model.getValueAt(this._row, this._column);
        Object leftValue = this._model.getValueAt(this._row, this._column - 1);
        Object rightValue = this._model.getValueAt(this._row, this._column + 2);
        boolean leftSelectable = leftValue != null;
        boolean rightSelectable = rightValue != null;
        boolean bl = actionSelectable = leftValue != null && rightValue != null;
        this._value = value != null ? (value.equals("<") ? (leftSelectable ? value : oldValue) : (value.equals(">") ? (rightSelectable ? value : oldValue) : (value.equals("+") ? (actionSelectable ? value : oldValue) : oldValue))) : oldValue;
    }
}

