/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.model.LicenseInfo;

class ZLicense {
    static final String PACKAGE = "ENTERPRISE_PKG";
    static final SnmpOID[] _UsageOids = new SnmpOID[]{new SnmpOID(MibNode.get("clmLicenseFlag").getOid(), "ENTERPRISE_PKG"), new SnmpOID(MibNode.get("clmNoOfLicenseCurrentUsages").getOid(), "ENTERPRISE_PKG"), new SnmpOID(MibNode.get("clmLicenseExpiryDate").getOid(), "ENTERPRISE_PKG"), new SnmpOID(MibNode.get("clmLicenseGracePeriod").getOid(), "ENTERPRISE_PKG"), new SnmpOID(MibNode.get("clmLicenseGracePeriodLeft").getOid(), "ENTERPRISE_PKG")};
    static final int[][] _CoOids = new int[][]{MibNode.get("clmLicenseConfigSpinLock").getOid(), MibNode.get("clmLicenseRequestFeatureName").getOid(), MibNode.get("clmLicenseRequestCommand").getOid()};

    private ZLicense() {
    }

    public static boolean isLicensed(SnmpPeer peer) {
        LicenseInfo info = ZLicense.queryLicense(peer);
        if (info != null) {
            return info.isLicensed();
        }
        return false;
    }

    public static LicenseInfo queryLicense(SnmpPeer peer) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(_UsageOids.length));
        for (int i = 0; i < _UsageOids.length; ++i) {
            pdu.addNull(_UsageOids[i]);
        }
        try {
            VarBindList vbl = peer.send(pdu).getVariables();
            byte[] licFlag = vbl.byteValue(0);
            if (licFlag.length == 0) {
                return null;
            }
            int usage = vbl.intValue(1);
            byte[] expDate = vbl.byteValue(2);
            int gracePeriod = 0;
            gracePeriod = vbl.getVb(3).getVar().getType() != 5 ? vbl.intValue(3) : vbl.intValue(4);
            LicenseInfo info = new LicenseInfo(null, PACKAGE, licFlag[0], usage, 0, 0, expDate, gracePeriod);
            return info;
        }
        catch (SnmpException ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

