/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.merge.ZExecutePanel;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeReport;
import com.cisco.dcbu.sm.client.zm.merge.ZSelectSwitch;
import com.cisco.dcbu.sm.client.zm.merge.ZStageZoneset;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ZMergeDialog {
    private String _home = null;
    private JWizard wizard = null;

    public ZMergeDialog(String home, JFrame parent) {
        this._home = home;
        this.loadDialog(parent);
        this.wizard.setSize(700, 500);
        this.wizard.setLocationRelativeTo(parent);
    }

    public void showDialog() {
        if (this.wizard != null) {
            this.wizard.first();
            this.wizard.setVisible(true);
        }
    }

    private JWizard loadDialog(JFrame parent) {
        String localTitle;
        this.wizard = new JWizard(parent);
        String title = localTitle = "Zone Merge";
        if (parent != null) {
            title = localTitle + ClientController.getInstance().getDialogFabricTitlePostfix();
        }
        this.wizard.setTitle(title);
        ClientController controller = ClientController.getInstance();
        Object[] vsans = null;
        Fabric fabric = controller.getFabric();
        if (fabric != null && (vsans = fabric.getVsans()) != null) {
            Arrays.sort(vsans);
        }
        if (fabric == null || vsans == null || vsans.length == 0) {
            JOptionPane.showMessageDialog(parent, "There are no VSANs in the current fabric.");
            return null;
        }
        ZSelectSwitch selectSwitch = new ZSelectSwitch(this._home, (Vsan[])vsans);
        ZMergeReport mergeReport = new ZMergeReport(this._home);
        ZStageZoneset stage = new ZStageZoneset(this._home);
        ZExecutePanel exec = new ZExecutePanel(this._home);
        this.wizard.addPanel("0", selectSwitch);
        this.wizard.addPanel("1", mergeReport);
        this.wizard.addPanel("2", stage);
        this.wizard.addPanel("3", exec);
        this.wizard.setModelValue("ZSelectSwitch", selectSwitch);
        this.wizard.setModelValue("ZMergeReport", mergeReport);
        this.wizard.setModelValue("ZStageZoneset", stage);
        this.wizard.setModelValue("ZExecutePanel", exec);
        this.wizard.first();
        return this.wizard;
    }

    public static void main(String[] args) {
        ZMergeDialog app = new ZMergeDialog(System.getProperty("user.home"), null);
        app.showDialog();
    }
}

