/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate;

import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.migrate.panels.EditorPanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.LoginPanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.TransferPanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.TranslatePanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.WWNPanel;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Main {
    private boolean _showList = true;
    private String _home = null;
    private WizardPanel _login = null;
    private WizardPanel _translate = null;
    private WizardPanel _wwn = null;
    private WizardPanel _editor = null;
    private WizardPanel _transfer = null;
    private static Main _Instance = null;
    private static JFrame _Parent = null;

    public static Main getInstance(String baseDir, JFrame parent) {
        if (_Instance == null) {
            _Instance = new Main(baseDir, parent);
        }
        return _Instance;
    }

    private Main(String home, JFrame parent) {
        this._home = home;
        _Parent = parent;
    }

    public void showDialog() {
        JWizard wizard = this.loadZMDialog(_Parent);
        wizard.pack();
        wizard.setLocationRelativeTo(_Parent);
        wizard.setVisible(true);
    }

    private JWizard loadZMDialog(JFrame parent) {
        ClientController controller = ClientController.getInstance();
        Object[] vsans = null;
        Fabric fabric = controller.getFabric();
        if (fabric != null) {
            vsans = fabric.getVsans();
        }
        if (fabric == null || vsans == null || vsans.length == 0) {
            JOptionPane.showMessageDialog(parent, "Please create VSANs before migrating non-MDS zones.");
            return null;
        }
        Arrays.sort(vsans);
        JWizard wizard = new JWizard(parent);
        wizard.getNavigator().getCancel().setText("Close");
        wizard.setTitle("Zone Migration" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this._login = new LoginPanel(this._home, (Vsan[])vsans);
        this._translate = new TranslatePanel(this._home);
        this._wwn = new WWNPanel(this._home);
        this._editor = new EditorPanel(this._home);
        this._transfer = new TransferPanel(this._home);
        wizard.addPanel("0", this._login);
        wizard.addPanel("1", this._translate);
        wizard.addPanel("2", this._wwn);
        wizard.addPanel("3", this._editor);
        wizard.addPanel("4", this._transfer);
        wizard.setModelValue("LoginPanel", this._login);
        wizard.setModelValue("TranslatePanel", this._translate);
        wizard.setModelValue("WWNPanel", this._wwn);
        wizard.setModelValue("EditorPanel", this._editor);
        wizard.setModelValue("TransferPanel", this._transfer);
        wizard.first();
        return wizard;
    }

    public static void main(String[] args) {
        Main app = Main.getInstance(System.getProperty("user.home"), new JFrame("Raj"));
        app.showDialog();
    }
}

