/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.panels;

import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.comps.ExecutePanel;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.San;
import java.awt.Component;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class TransferPanel
extends WizardPanel
implements IfVshStatus {
    private String _workingDir = null;
    private String _desc = "Select the MDS switches and press 'Finish' to transfer the zones.";
    private ExecutePanel _ep = null;
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemigrate.gif");

    public TransferPanel(String workingDir) {
        super("Step 5 of 5: Transfer Migrated Zones", "", ICON);
        super.setDescription(this._desc);
        this._workingDir = workingDir;
    }

    @Override
    public boolean refresh() {
        try {
            if (this._ep != null) {
                super.remove(this._ep);
            }
            StringBuffer aliasFileContent = null;
            try {
                aliasFileContent = (StringBuffer)this.getModelValue("LoginPanel.AliasFileContent");
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            if (aliasFileContent != null && aliasFileContent.length() > 0) {
                this.setTitle("Step 3 of 3 : Transfer Migrated Zones");
            }
            Component[] btns = new Component[]{this.getWizard().getNavigator().getBackBtn(), this.getWizard().getNavigator().getNextBtn()};
            JButton btnCancel = this.getWizard().getNavigator().getCancel();
            this._ep = new ExecutePanel(this._workingDir, false);
            this._ep.setBlockComponents(btns);
            this._ep.renameOnFinishTo(btnCancel, "Close");
            this.add((Component)this._ep, "Center");
            String script = (String)this.getModelValue("Execute.Script");
            this._ep.setScript(script);
            this._ep.setParent(this.getWizard());
            this._ep.setStatusListener(this);
            SnmpPeer[] peers = San.getInstance().getSnmpPeers(false, true);
            if (peers != null && peers.length > 0) {
                this._ep.setTargetDevices(peers);
            }
            try {
                this.getModelValue("LoginPanel.AliasFileContent");
            }
            catch (NullPointerException ex) {
                Set set = (Set)this.getModelValue("TranslatePanel.userSelectedDomains");
                this._ep.setPatternSelection(set.toArray(), 1);
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    @Override
    public void doFinish() {
        try {
            this.getWizard().setStatus("");
            this._ep.doApply(false);
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
        }
    }

    @Override
    public void doCancel() {
        this.getWizard().dispose();
    }

    @Override
    public void setStatus(String status) {
        this.getWizard().setStatus(status);
    }
}

