/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.panels;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.zm.migrate.panels.ZoneMarker;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Alias;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Zone;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneMember;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class UnResolvedMembersPanel
extends JPanel
implements ZoneMarker {
    private KTableModel _model = new KTableModel();
    private KTable _table = null;
    private JLabel _name = new JLabel();
    private static final String PWWN = "pWWN";
    private static final String FWWN = "fWWN";
    private static final String[] TYPES = new String[]{"pWWN", "fWWN"};
    private Zone _context = null;
    private Alias _alias = null;
    private JScrollPane _spTable = new JScrollPane();

    public UnResolvedMembersPanel() {
        this.setLayout(new BorderLayout());
        String[] headers = new String[]{"Zone Member", "Type"};
        boolean[] attrs = new boolean[]{false, true};
        this._model.setHeaders(headers);
        this._model.setEditable(attrs);
        this._table = new KTable(this._model);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._table.setColumnSelectionAllowed(false);
        this.add((Component)this._name, "North");
        this.add((Component)this._spTable, "Center");
    }

    @Override
    public void doInitialize(Zone context) {
        if (context == null) {
            return;
        }
        this._context = context;
        this._name.setText("Zone:" + context._zoneName);
        ZoneMember[] all = context._zoneMembers;
        Array<ZoneMember> data = new Array<ZoneMember>();
        for (int i = 0; i < all.length; ++i) {
            data.addElement(all[i]);
        }
        this._model.setData(this.getDataInTableFormat(data));
        this.setupTypeColumn();
        this._spTable.setViewportView(this._table);
        this._spTable.setPreferredSize(this._table.calcPreferredSize());
    }

    @Override
    public void doInitialize(Alias context) {
        if (context == null) {
            return;
        }
        this._alias = context;
        this._name.setText("Alias Name :" + context._aliasName);
        ZoneMember[] all = context._aliasMembers.toArray(new ZoneMember[0]);
        Array<ZoneMember> data = new Array<ZoneMember>();
        for (int i = 0; i < all.length; ++i) {
            data.addElement(all[i]);
        }
        this._model.setData(this.getDataInTableFormat(data));
        this.setupTypeColumn();
        this._spTable.setViewportView(this._table);
        this._spTable.setPreferredSize(this._table.calcPreferredSize());
    }

    @Override
    public Object getZoneContext(HashMap map) {
        ZoneMember[] all = null;
        all = this._context != null ? this._context._zoneMembers : this._alias._aliasMembers.toArray(new ZoneMember[0]);
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            ZoneMember now = null;
            String tmp = (String)this._model.getValueAt(i, 1);
            for (int j = 0; j < all.length; ++j) {
                if (!all[j]._zoneMemberOrig.toString().equals(this._model.getValueAt(i, 0).toString())) continue;
                now = all[j];
                break;
            }
            if (tmp == null) continue;
            if (tmp != null && !tmp.trim().equals("")) {
                if (tmp.trim().equals(FWWN)) {
                    now._zoneMemberType = 1;
                    continue;
                }
                if (!tmp.trim().equals(PWWN)) continue;
                now._zoneMemberType = 2;
                continue;
            }
            DefaultLogger._DefLogger.debug((Object)("Did not set value for member " + now));
        }
        if (this._context != null) {
            return this._context;
        }
        return this._alias;
    }

    private void setupTypeColumn() {
        TableColumn typeColumn = this._table.getColumnModel().getColumn(1);
        JComboBox<String> cb = new JComboBox<String>(TYPES);
        typeColumn.setCellRenderer(new ChangedCellRenderer());
        typeColumn.setCellEditor(new DefaultCellEditor(cb));
    }

    private Array getDataInTableFormat(Array d) {
        if (d == null) {
            return null;
        }
        Array<Object[]> tableData = new Array<Object[]>(d.capacity());
        for (int i = 0; i < tableData.capacity(); ++i) {
            ZoneMember from = (ZoneMember)d.elementAt(i);
            if (from == null || from._zoneMemberType == 4) continue;
            Object[] row = new Object[3];
            row[0] = from._zoneMemberOrig;
            row[1] = TYPES[0];
            tableData.addElement(row);
        }
        return tableData;
    }
}

