/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.DefaultZoneAttributes;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

class DefaultAttributeDlg
extends JDialog
implements ActionListener {
    static final MibEnum[] _qosPriorityEnums = MibNode.get("zoneQosPriority").getEnums();
    static final MibEnum[] _defZonePolicyEnums = MibNode.get("zoneDefaultZoneBehaviour").getEnums();
    static final MibEnum[] _zonePropagationEnums = MibNode.get("zoneSetPropagationMode").getEnums();
    private JComboBox _defZonePolicy;
    private JComboBox _zonePropagation;
    private JCheckBox _readOnlyChkBox;
    private JCheckBox _qosChkBox;
    private JComboBox _qosPriority;
    private JCheckBox _BroadCastChkBox;
    private ZoneCapability _capability;
    private DefaultZoneAttributes _attSel;
    private boolean _cancelled = false;

    DefaultAttributeDlg(JFrame parent, DefaultZoneAttributes att, ZoneCapability capability) {
        super(parent);
        this._capability = capability;
        this.setDefaultCloseOperation(2);
        this.setTitle("Modify Default Zone Properties" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this._readOnlyChkBox = new JCheckBox("Read Only");
        this._readOnlyChkBox.setSelected(att._readOnly);
        this._qosChkBox = new JCheckBox("Permit QoS Traffic with Priority: ");
        this._qosChkBox.setSelected(att._qos);
        this._qosChkBox.setActionCommand("QOS");
        this._qosChkBox.addActionListener(this);
        this._qosPriority = new JComboBox<MibEnum>(_qosPriorityEnums);
        if (this._capability.isQosSupported() && att._qosPriority > 0 && att._qosPriority - 1 < this._qosPriority.getItemCount()) {
            this._qosPriority.setSelectedIndex(att._qosPriority - 1);
        }
        this._qosPriority.setEnabled(att._qos);
        this._BroadCastChkBox = new JCheckBox("Restrict Broadcast Frames to Zone Members");
        this._readOnlyChkBox.setVisible(this._capability.isROSupported());
        this._qosChkBox.setVisible(this._capability.isQosSupported());
        this._qosPriority.setVisible(this._capability.isQosSupported());
        this._BroadCastChkBox.setVisible(this._capability.isBroadcastSupported());
        this._BroadCastChkBox.setSelected(att._broadcast);
        this._defZonePolicy = new JComboBox<MibEnum>(_defZonePolicyEnums);
        this._defZonePolicy.setSelectedIndex(att._defaultZonePolicy > 1 ? att._defaultZonePolicy - 1 : 0);
        this._zonePropagation = new JComboBox<MibEnum>(_zonePropagationEnums);
        this._zonePropagation.setSelectedIndex(att._zonePropagation > 1 ? att._zonePropagation - 1 : 0);
        JPanel pnl1 = new JPanel(new BorderLayout());
        pnl1.add((Component)this._qosChkBox, "West");
        JPanel pnl11 = new JPanel(new BorderLayout());
        pnl11.add((Component)this._qosPriority, "West");
        pnl1.add((Component)pnl11, "Center");
        String[] labels = new String[]{"Policy:", "Propagation:", null, null, null};
        DialogUtil.buildDialog(this, parent, DialogUtil.buildPanel(DialogUtil.buildLabels(labels), new JComponent[]{this._defZonePolicy, this._zonePropagation, this._readOnlyChkBox, pnl1, this._BroadCastChkBox}));
        this.setModal(true);
        this.setResizable(true);
    }

    boolean isReadOnly() {
        return this._readOnlyChkBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        if (cmd == 'O') {
            if (this._capability.isQosSupported() && this._qosChkBox.isSelected() && this._qosPriority.getSelectedIndex() == 0) {
                Util.errorMessage((Component)this, "Please Specify QoS Priority.");
                return;
            }
            this._attSel = new DefaultZoneAttributes();
            this._attSel._broadcast = this._BroadCastChkBox.isSelected();
            this._attSel._defaultZonePolicy = this._defZonePolicy.getSelectedIndex() + 1;
            this._attSel._qos = this._qosChkBox.isSelected();
            this._attSel._qosPriority = this._qosPriority.getSelectedIndex() + 1;
            this._attSel._readOnly = this._readOnlyChkBox.isSelected();
            this._attSel._zonePropagation = this._zonePropagation.getSelectedIndex() + 1;
        } else {
            if (cmd == 'Q') {
                this._qosPriority.setEnabled(this._qosChkBox.isSelected());
                return;
            }
            this._cancelled = true;
        }
        this.dispose();
    }

    DefaultZoneAttributes getSelectedValues() {
        return this._attSel;
    }

    boolean isCancelled() {
        return this._cancelled;
    }
}

