/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.DeviceAliasTableModel;
import com.cisco.dcbu.sm.client.zm.common.HostStorageRenderer;
import com.cisco.dcbu.sm.client.zm.common.IvrDeviceAlias;
import com.cisco.dcbu.sm.client.zm.common.ZoneDragTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DeviceAliasSelector
extends JDialog
implements ActionListener {
    private DeviceAlias[] _selectedDeviceAliases;
    private int[] _selEndPortVsan;
    private int[] _selDeviceType;
    private ZoneDragTable _eTable;
    private DeviceAliasTableModel _eModel = new DeviceAliasTableModel();

    DeviceAliasSelector(JFrame parent, DeviceAlias[] deviceAliases, Vsan vsan) {
        super(parent);
        this._eModel.updateData(deviceAliases, vsan);
        this._eTable = new ZoneDragTable((KTableModel)this._eModel, null);
        this._eTable.setAutoResizeMode(0);
        this._eTable.getColumnModel().getColumn(0).setCellRenderer(new HostStorageRenderer());
        this._eTable.setFixedWidth(0, 30);
        this._eTable.setSelectionMode(0);
        JScrollPane eTablePane = new JScrollPane(this._eTable);
        eTablePane.setPreferredSize(this._eTable.calcPreferredSize());
        this.setLocationRelativeTo(parent);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)eTablePane, "Center");
        DialogUtil.buildDialog(this, parent, pnl);
        if (this.getHeight() > 600) {
            this.setSize(this.getWidth(), 600);
        }
        if (this.getHeight() < 150) {
            this.setSize(this.getWidth(), 150);
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Device Alias" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'O': {
                int[] selRows = this._eTable.getSelectedRows();
                if (selRows == null || selRows.length == 0) {
                    Util.errorMessage((Component)this, "Please select a row");
                    return;
                }
                this._selectedDeviceAliases = new DeviceAlias[selRows.length];
                this._selEndPortVsan = new int[selRows.length];
                this._selDeviceType = new int[selRows.length];
                DeviceAliasTableModel theModel = (DeviceAliasTableModel)this._eTable.getModel();
                for (int k = 0; k < selRows.length; ++k) {
                    this._selectedDeviceAliases[k] = ((IvrDeviceAlias)theModel.getDragObject(selRows[k])).getDeviceAlias();
                    EndPort ep = this._selectedDeviceAliases[k].getEndPortFromCache();
                    Vsan selVsan = theModel.getDragObjectVsan(selRows[k]);
                    this._selEndPortVsan[k] = selVsan != null ? selVsan.getVsanId() : 1;
                    this._selDeviceType[k] = theModel.getDragObjectType(selRows[k]);
                }
            }
            case 'C': {
                this.dispose();
            }
        }
    }

    public DeviceAlias[] getSelectedAliases() {
        return this._selectedDeviceAliases;
    }

    public int[] getSelectedAliasVsan() {
        return this._selEndPortVsan;
    }

    public int[] getSelectedType() {
        return this._selDeviceType;
    }
}

