/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.ZoneImportExportAction;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class ZoneMerge
extends JDialog
implements ActionListener,
ItemListener,
PollerCallbackIf {
    static final int ZONE_MERGE_FAILURE_CAUSE = 24;
    static final int PORT_TYPE_E = 4;
    static final int PORT_TYPE_TE = 12;
    static final int VSAN_FP = 2;
    static final int PEER_FP = 3;
    static final int IFINDEX_FP = 4;
    static final String[] _Selector = new String[]{"Import Zoneset", "Export Zoneset"};
    private JComboBox _peerCb = new JComboBox();
    private JComboBox _vsanTf = new JComboBox();
    private MdsPortChooser _ifIndexTf;
    private JComponent[] _values;
    private JButton[] _buttons;
    private PortEditorCardAttribute[] _slotMembers;
    private ZoneImportExportAction _importAction;
    private CommandHandler _cmdHandler;
    private CommandHandler _refCmdHandler;
    private PollerManager _mgr;
    private boolean _failed;
    static final JComponent[] _Labels = new JComponent[]{null, new JLabel("Action:"), new JLabel("VSAN:"), new JLabel("Switch:"), new JLabel("ISL Interface:"), null, null};
    private JLabel _status;
    private Vsan _vsan;

    public ZoneMerge(JFrame parent, Vsan v, String port) throws SnmpException {
        super(parent);
        this.buildDialog(parent, v, port);
        this.setVsan(v);
    }

    public ZoneMerge(JFrame parent, Vsan v, String port, SnmpPeer peer) throws SnmpException {
        this(parent, v, port);
        this.selectPeer(peer);
    }

    public ZoneMerge(JDialog dialog, Vsan v, String port, CommandHandler cmdHandler) throws SnmpException {
        super(dialog);
        this._refCmdHandler = cmdHandler;
        this.buildDialog(Util.getFrameAncestor(dialog), v, port);
        this.setVsan(v);
    }

    private void buildDialog(JFrame parent, Vsan v, String port) {
        this.setTitle("Zone Merge Failure Recovery" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this._values = new JComponent[_Labels.length];
        this._values[0] = new DialogSeparator("If ISL failure is zoneMergeFailure");
        this._values[2] = this._vsanTf;
        this._values[3] = this._peerCb;
        this._ifIndexTf = new MdsPortChooser(this.getTitle(), 3, true);
        this._values[4] = this._ifIndexTf;
        this._ifIndexTf.setLogicalInterfaceType(10);
        this._ifIndexTf.setFilters(new PortEditorFilter(new int[]{1, 153, 152}));
        if (port != null) {
            this._ifIndexTf.setText(port);
        }
        this._values[5] = new JLabel("(e.g. fc1/12, channel1, fcip11)");
        this._values[6] = new JLabel("<html><B>(Active or Full Zones will be imported or<br>exported based on propagation policy)</html>");
        this._values[1] = new RadioButtonPanel(_Selector, 1, this);
        ((RadioButtonPanel)this._values[1]).getButton(0).setSelected(true);
        this._vsanTf.addItemListener(this);
        this._peerCb.addItemListener(this);
        JPanel dlgPnl = DialogUtil.buildPanel(_Labels, this._values);
        String[] bLabels = new String[]{"OK", "Close"};
        this._buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        southPanel.add("North", buttonPanel);
        this._status = new JLabel("");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        southPanel.add("South", this._status);
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add("Center", dlgPnl);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, southPanel);
        this.setSize(this.getWidth() + 15, this.getHeight() + 20);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setFabric(v.getFabric());
    }

    private void setFabric(Fabric fabric) {
        Object[] vsans = fabric.getVsans();
        Arrays.sort(vsans);
        this._vsanTf.setModel(new DefaultComboBoxModel<Object>(vsans));
        if (this._vsan != null) {
            this._vsanTf.setSelectedItem(this._vsan);
        }
    }

    private void setVsan(Vsan v) throws SnmpException {
        if (v != null && v != this._vsan) {
            this._vsan = v;
            this._vsanTf.setSelectedItem(this._vsan);
            this.setPeers(v.getSnmpPeers(true, true));
        }
    }

    private void setPeers(Object[] peers) throws SnmpException {
        if (peers != null) {
            Arrays.sort(peers);
        }
        this._peerCb.setModel(new DefaultComboBoxModel<Object>(peers));
        Switch seed = this._vsan.getFabric().getSeedSwitch();
        if (seed != null && seed.isMDS() && seed.isManageable()) {
            this.selectPeer(seed.getSnmpPeer());
        }
    }

    private void selectPeer(SnmpPeer peer) throws SnmpException {
        this._peerCb.setSelectedItem(peer);
        this.updatePortPicker((SnmpPeer)this._peerCb.getSelectedItem());
    }

    private void updatePortPicker(SnmpPeer peer) throws SnmpException {
        this.findSlotInfo(peer);
        this._ifIndexTf.setPeer(peer);
        if (((RadioButtonPanel)this._values[1]).getButton(0).isSelected()) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            this._ifIndexTf.getButton().setEnabled(sw != null && (sw.isMDS() || sw.isQuail()) && this._slotMembers != null && this._slotMembers.length > 0);
            this._ifIndexTf.setIfIndexIf(sw);
        }
        if (this._slotMembers == null) {
            return;
        }
        this._ifIndexTf.setSlotMembers(this._slotMembers);
    }

    void setSelectedPeer(SnmpPeer peer) {
        this._peerCb.setSelectedItem(peer);
    }

    void revertBtnActCmd() {
        this._buttons[0].setText("OK");
        this._buttons[0].setEnabled(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getStateChange() == 1) {
                if (e.getSource() instanceof JRadioButton) {
                    Switch sw;
                    boolean importSelected = ((RadioButtonPanel)this._values[1]).getButton(0).isSelected();
                    this._ifIndexTf.setEnabled(importSelected);
                    if (importSelected && (sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._peerCb.getSelectedItem()).getAddress())) != null && !sw.isMDS()) {
                        this._ifIndexTf.getButton().setEnabled(false);
                    }
                    this._values[5].setEnabled(((RadioButtonPanel)this._values[1]).getButton(0).isSelected());
                } else if (e.getSource() == this._vsanTf) {
                    this.setPeers(((Vsan)this._vsanTf.getSelectedItem()).getSnmpPeers(true, true));
                } else if (e.getSource() == this._peerCb) {
                    this.updatePortPicker((SnmpPeer)this._peerCb.getSelectedItem());
                }
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block2: {
            try {
                this.doIt(((JButton)e.getSource()).getText());
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                this.revertBtnActCmd();
                this._status.setText("Failed");
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    void doIt(String command) throws Exception {
        switch (command.charAt(0)) {
            case 'O': {
                this.doAction();
                break;
            }
            case 'C': {
                this.dispose();
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._status.setText(" ");
        } else {
            if (this._mgr != null) {
                this._mgr.stop();
            }
            this.revertBtnActCmd();
            this._status.setText(" ");
        }
        super.setVisible(b);
    }

    void doAction() throws Exception {
        this._buttons[0].setEnabled(false);
        this._failed = false;
        Vsan vsan = (Vsan)this._vsanTf.getSelectedItem();
        SnmpPeer peer = (SnmpPeer)this._peerCb.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw.isMDS() && sw.isVersion1_0()) {
            throw new Exception("Zone Merge via DCNM-SAN not supported for " + peer + " (ver 1.0).");
        }
        String strPortIndex = ((FieldPanel)this._values[4]).getText().trim();
        int ifIndex = -1;
        boolean importAction = ((RadioButtonPanel)this._values[1]).getButton(0).isSelected();
        if (importAction && (strPortIndex == null || strPortIndex.length() == 0)) {
            throw new Exception("Please specify ISL interface");
        }
        if (importAction) {
            if (sw.isMDS()) {
                ifIndex = sw.nameToIfIndex(strPortIndex);
                int type = IfIndexUtil.getType(ifIndex);
                if (type != 1 && type != 10 && type != 14 && type != 30 && type != 4) {
                    throw new Exception("Invalid port interface: " + strPortIndex);
                }
                int[] ports = new int[]{ifIndex};
                this.validateInput(peer, vsan, ports);
            } else {
                int slashLocation = strPortIndex.trim().indexOf("/");
                int fcIndex = strPortIndex.indexOf("fc");
                if (slashLocation != -1 && strPortIndex.length() > slashLocation && fcIndex != -1) {
                    try {
                        ifIndex = Integer.parseInt(strPortIndex.substring(slashLocation + 1).trim()) - 1;
                    }
                    catch (Exception ex) {
                        throw new Exception("Invalid port interface: " + strPortIndex);
                    }
                } else {
                    throw new Exception("Invalid port interface: " + strPortIndex);
                }
            }
        }
        if (this._refCmdHandler != null && this._refCmdHandler.getSnmpPeer().getAddress().equals(sw.getPeer().getAddress())) {
            this._cmdHandler = this._refCmdHandler;
        } else {
            VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(sw);
            this._cmdHandler = SmZoneUtil.getCommandHandler(verPeer.getNonIvrCapability(), vsan, verPeer, null);
        }
        this._mgr = new PollerManager(this, SmZoneUtil.getSwitchPeer(sw));
        this._importAction = (ZoneImportExportAction)ZoneImportExportAction.createAction(this._cmdHandler, vsan, this._mgr, importAction, ifIndex, this);
        this._mgr.start();
    }

    void validateInput(SnmpPeer peer, Vsan vsan, int[] ports) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        int MAXI = ports.length;
        for (int i = 0; i < MAXI; ++i) {
            int[] trunkIndex = new int[]{ports[i], vsan.getId()};
            pdu.addNull(new SnmpOID(MibNode.get("fcIfOperMode").getOid(), ports[i]));
            pdu.addNull(new SnmpOID(MibNode.get("fcIfOperStatusCause").getOid(), ports[i]));
            pdu.addNull(new SnmpOID(MibNode.get("fcTrunkIfOperStatusCause").getOid(), trunkIndex));
        }
        SnmpPDU resp = peer.send(pdu);
        VarBindList vbnds = resp.getVariables();
        int MAX = vbnds.size();
        for (int prt = 0; prt < MAX; prt += 3) {
            SnmpVarBind prtType = vbnds.getVb(prt * 3);
            SnmpVarBind prtEportStatus = vbnds.getVb(prt * 3 + 1);
            SnmpVarBind prtTEportStatus = vbnds.getVb(prt * 3 + 2);
            int[] oidType = prtType.getOid().getValue();
            int theIndex = oidType[oidType.length - 1];
            if (prtType.getVar() instanceof SnmpNull) {
                throw new Exception("Invalid port interface " + sw.ifIndexToName(theIndex));
            }
            int type = ((SnmpInt)prtType.getVar()).getValue();
            if (type != 4 && type != 12) {
                throw new Exception("Please select active FC ISL link. " + sw.ifIndexToName(theIndex) + " is not a valid FC ISL link.");
            }
            if (type == 4) {
                int ePrtStatus = ((SnmpInt)prtEportStatus.getVar()).getValue();
                if (ePrtStatus == 24) continue;
                throw new Exception("No zone merge failure at link " + sw.ifIndexToName(theIndex));
            }
            if (type != 12) continue;
            Vsan v = (Vsan)this._vsanTf.getSelectedItem();
            if (prtTEportStatus.getVar() instanceof SnmpNull) {
                throw new Exception("The VSAN " + v + " not part of active VSANs at link " + sw.ifIndexToName(theIndex));
            }
            int tePrtStatus = ((SnmpInt)prtTEportStatus.getVar()).getValue();
            if (tePrtStatus == 24) continue;
            throw new Exception("No zone merge failure at link " + sw.ifIndexToName(theIndex) + " for VSAN " + v);
        }
    }

    private int[] getFcipIndices(SnmpPeer peer) throws SnmpException {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw != null && sw.hasIPSCard()) {
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cfmFcipLinkIfIndex").getOid());
            VarBindList response = SnmpFetch.getBulk(peer, vbl).getVariables();
            if (response.size() > 0) {
                int[] indices = new int[response.size()];
                for (int k = 0; k < response.size(); ++k) {
                    indices[k] = response.intValue(k);
                }
                return indices;
            }
        }
        return null;
    }

    private void findSlotInfo(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Card[] cards = sw.getCards();
        if (cards == null) {
            return;
        }
        this._slotMembers = new PortEditorCardAttribute[sw.getNumSlots()];
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || cards[i].isFex() || FRUConstants.isInternalModule(cards[i].getType())) continue;
            int nOfPortonCard = cards[i].getNumPorts();
            int[] ifTypes = new int[nOfPortonCard];
            for (int j = 0; j < nOfPortonCard; ++j) {
                ifTypes[j] = cards[i].getIfType(j + 1);
            }
            if (cards[i].getSlotId() - 1 >= this._slotMembers.length) continue;
            this._slotMembers[cards[i].getSlotId() - 1] = new PortEditorCardAttribute(cards[i].getType(), nOfPortonCard, ifTypes, 0, Integer.toString(cards[i].getSlotId()));
        }
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        this._status.setText(status.toString());
        return 0;
    }

    @Override
    public void failed(PollerManager manager, SnmpException ex) {
        this._status.setText(ex.getMessage());
        this.cleanup();
        Util.errorMessage((Component)this, ex);
        this._failed = true;
        this.revertBtnActCmd();
    }

    @Override
    public void success(PollerManager manager, StringBuffer status) {
        if (!this._failed) {
            this._status.setText(status.toString());
        }
        this.cleanup();
        this.revertBtnActCmd();
    }

    private void cleanup() {
        if (this._cmdHandler != null) {
            if (this._refCmdHandler == null || !this._refCmdHandler.getSnmpPeer().getAddress().equals(this._cmdHandler.getSnmpPeer().getAddress())) {
                this._cmdHandler.cleanup();
            }
            this._cmdHandler = null;
        }
    }
}

