/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Histogram;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.CopyTopologyAction;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.OutputTextArea;
import com.cisco.dcbu.sm.client.zm.common.SmIvrZoneSwitch;
import com.cisco.dcbu.sm.client.zm.common.afidVsanSwitches;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrResultsPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class IvrResultsPanelActionsTable
implements StatusIf {
    static final int[] _VSAN2KOID = MibNode.get("civrTopologyConfigSwitchVsan2k").getOid();
    static final int[] _VSAN4KOID = MibNode.get("civrTopologyConfigSwitchVsan4k").getOid();
    protected OutputTextArea _output;
    protected IvrResultsPanel _panel;
    protected boolean _saveConfig;
    protected String _configFile;
    protected KTable _progressTable;
    protected KTableModel _progressTableModel;
    protected boolean[] _rowStatus;
    protected int[] _rowIndex;
    static final Color _PROGRESSBAR_CLR = new Color(200, 200, 200);
    static final int FONT_HEIGHT = 12;

    IvrResultsPanelActionsTable(IvrResultsPanel panel, OutputTextArea output, Object[][] steps) {
        this._panel = panel;
        this._output = output;
        this._rowStatus = new boolean[steps.length];
        this._rowIndex = new int[steps.length];
    }

    KTable buildProgreesTable() {
        this._progressTableModel = new KTableModel();
        this._progressTableModel.setHeaders(new String[]{"Step", "Action", "Progress (%)"});
        this._progressTableModel.setData(new Array());
        if (this._progressTable == null) {
            this._progressTable = new KTable(this._progressTableModel);
        }
        this._progressTable.setSortable(true);
        HistogramRenderer histogramRenderer = new HistogramRenderer();
        this._progressTable.getColumnModel().getColumn(2).setCellRenderer(histogramRenderer);
        this._progressTable.calcPreferredSize();
        this._progressTable.getColumnModel().getColumn(0).setMaxWidth(30);
        int clmn1Width = this._progressTable.getColumnModel().getColumn(2).getPreferredWidth();
        this._progressTable.getColumnModel().getColumn(2).setMaxWidth(clmn1Width);
        this._progressTable.getColumnModel().getColumn(2).setMinWidth(clmn1Width);
        histogramRenderer.setHorizontalAlignment(4);
        histogramRenderer.setCellWidth(this._progressTable.getColumnModel().getColumn(2).getPreferredWidth() - 2);
        return this._progressTable;
    }

    @Override
    public void dispose() {
    }

    static ArrayList buildAllowedDomainList(ArrayList vsans) {
        int i;
        ArrayList<Integer> allowedDomains = new ArrayList<Integer>();
        for (i = 1; i < 240; ++i) {
            allowedDomains.add(new Integer(i));
        }
        if (vsans != null) {
            for (i = 0; i < vsans.size(); ++i) {
                Vsan v = (Vsan)vsans.get(i);
                Switch[] switches = v.getSwitches();
                if (switches == null || switches.length <= 0) continue;
                for (int j = 0; j < switches.length; ++j) {
                    short did = switches[j].getDomainId(v.getId());
                    allowedDomains.remove(new Integer(did));
                }
            }
        }
        return allowedDomains;
    }

    abstract void setProgressBar();

    abstract boolean refreshForIVR();

    protected abstract void setActionsText();

    abstract void doFinish(boolean var1, String var2) throws SnmpException;

    abstract void insertSaveConfigActions(boolean var1, String var2);

    protected static ArrayList getIvrEnabledSwitchesInVsan(Vsan v, ArrayList swLst) {
        ArrayList<Switch> ivrVsanSw = new ArrayList<Switch>();
        Switch sw = null;
        if (swLst != null) {
            for (int i = 0; i < swLst.size(); ++i) {
                Object ob = swLst.get(i);
                sw = ob instanceof IvrZoneSwitch ? ((SmIvrZoneSwitch)ob).getSwitch() : (Switch)ob;
                if (!sw.isMemberOfVsan(v)) continue;
                ivrVsanSw.add(sw);
            }
        }
        return ivrVsanSw;
    }

    static boolean validateTopologyHashMap(HashMap map, StringBuffer errBuf, ArrayList ivrEnabledSw) {
        if (map.size() == 0) {
            return true;
        }
        errBuf.setLength(0);
        HashMap afidVsansMap = new HashMap();
        StringBuffer detailsBuf = new StringBuffer();
        for (Map.Entry obEntry : map.entrySet()) {
            StringBuffer buf;
            Vsan vv;
            block12: {
                ArrayList afidWwnList;
                block11: {
                    vv = (Vsan)obEntry.getKey();
                    afidWwnList = (ArrayList)obEntry.getValue();
                    buf = new StringBuffer();
                    if (afidWwnList.size() != 1) break block11;
                    afidVsanSwitches ob = (afidVsanSwitches)afidWwnList.get(0);
                    if (ob._afId == 1) break block12;
                    ArrayList ivrVsanSws = IvrResultsPanelActionsTable.getIvrEnabledSwitchesInVsan(vv, ivrEnabledSw);
                    for (int sws = 0; sws < ob._switchList.size(); ++sws) {
                        Object obSws = ob._switchList.get(sws);
                        if (!ivrVsanSws.contains(obSws)) continue;
                        ivrVsanSws.remove(obSws);
                    }
                    if (ivrVsanSws.size() <= 0) break block12;
                    buf.append("1, " + ob._afId);
                    break block12;
                }
                int oldAfid = -1;
                for (int k = 0; k < afidWwnList.size(); ++k) {
                    afidVsanSwitches ob = (afidVsanSwitches)afidWwnList.get(k);
                    if (k == 0) {
                        oldAfid = ob._afId;
                    } else if (oldAfid != ob._afId) {
                        if (buf.length() == 0) {
                            buf.append(oldAfid);
                        }
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(ob._afId);
                    }
                    Integer afidInt = new Integer(ob._afId);
                    ArrayList<Vsan> afidVsanLst = (ArrayList<Vsan>)afidVsansMap.get(afidInt);
                    if (afidVsanLst == null) {
                        afidVsanLst = new ArrayList<Vsan>();
                        afidVsansMap.put(afidInt, afidVsanLst);
                    }
                    if (afidVsanLst.contains(vv)) continue;
                    afidVsanLst.add(vv);
                }
            }
            if (buf.length() <= 0) continue;
            detailsBuf.append(vv + " AFID:" + buf.toString() + "\n");
        }
        if (detailsBuf.length() > 0) {
            errBuf.append("The following VSANs are configured with different AFIDs.\n");
            errBuf.append(detailsBuf);
            errBuf.append("\nPlease fix the problem from DCNM-SAN Topology tables and\n");
            errBuf.append("restart the wizard.");
        }
        return errBuf.length() <= 0;
    }

    static boolean validateActiveTopologyForAfid(VarBindList activeTopo, StringBuffer errBuf, ArrayList ivrEnabledSw) {
        if (activeTopo.size() == 0) {
            return true;
        }
        errBuf.setLength(0);
        HashMap map = new HashMap();
        CopyTopologyAction.buildVsanToAfidSwitchMap(activeTopo, map, 2);
        return IvrResultsPanelActionsTable.validateTopologyHashMap(map, errBuf, ivrEnabledSw);
    }

    static HashMap getAfidConflictingVsans(Array endPorts, HashMap map, ArrayList ivrSwitches) {
        HashMap conflictingVsans = new HashMap();
        ArrayList<Vsan> segVsans = new ArrayList<Vsan>();
        ArrayList<Integer> segVsansId = new ArrayList<Integer>();
        Fabric f = null;
        if (endPorts.size() > 0) {
            f = ((IvrEndPort)endPorts.elementAt(0)).getEndPort().getFabric();
        }
        for (int i = 0; i < endPorts.size(); ++i) {
            Vsan[] segVsanAr;
            Vsan v = ((IvrEndPort)endPorts.elementAt(i)).getVsan();
            if (v == null || !v.isSegmented() || (segVsanAr = v.getFabric().getVsansById(v.getId())) == null) continue;
            for (int seg = 0; seg < segVsanAr.length; ++seg) {
                for (int sw = 0; sw < ivrSwitches.size(); ++sw) {
                    Switch swVal = ((SmIvrZoneSwitch)ivrSwitches.get(sw)).getSwitch();
                    if (!swVal.isMemberOfVsan(segVsanAr[seg]) || segVsans.contains(segVsanAr[seg])) continue;
                    segVsans.add(segVsanAr[seg]);
                    Integer vsaIdVal = new Integer(segVsanAr[seg].getId());
                    segVsansId.add(vsaIdVal);
                }
            }
        }
        if (f == null) {
            return conflictingVsans;
        }
        for (int k = 0; k < segVsansId.size(); ++k) {
            int j;
            Vsan[] vv = f.getVsansById((Integer)segVsansId.get(k));
            HashMap<Vsan, Integer> vsanAfid = new HashMap<Vsan, Integer>();
            for (j = 0; j < vv.length; ++j) {
                ArrayList obb = (ArrayList)map.get(vv[j]);
                vsanAfid.put(vv[j], new Integer(obb != null ? ((afidVsanSwitches)obb.get((int)0))._afId : 1));
            }
            block5: for (j = 0; j < vv.length; ++j) {
                if (!segVsans.contains(vv[j])) continue;
                Integer refAfid = (Integer)vsanAfid.get(vv[j]);
                for (Map.Entry obEntry : vsanAfid.entrySet()) {
                    Integer compAfid;
                    Vsan vsanComp = (Vsan)obEntry.getKey();
                    if (vsanComp.equals(vv[j]) || !refAfid.equals(compAfid = (Integer)obEntry.getValue())) continue;
                    conflictingVsans.put(vv[j], vsanAfid);
                    continue block5;
                }
            }
        }
        return conflictingVsans;
    }

    class HistogramRenderer
    extends BorderCellRenderer {
        Histogram _histogram;
        int _cellWidth;

        HistogramRenderer() {
        }

        public void setCellWidth(int width) {
            this._cellWidth = width;
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                this.setIcon(null);
            } else {
                int n;
                if (this._histogram == null) {
                    this._histogram = new Histogram(Color.white, this._cellWidth, 12);
                }
                this._histogram.setAttr((n = ((Integer)value).intValue()) != 0 ? _PROGRESSBAR_CLR : Color.white, Integer.toString(n), n);
                this.setIcon(this._histogram);
            }
        }
    }
}

