/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.ZoneSetPanel;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrZoneWizardController;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardZoneAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IvrZoneSetPanel
extends ZoneSetPanel {
    private WizardZoneAction _zoneAction;

    public IvrZoneSetPanel() {
        this((JWizard)null);
    }

    public IvrZoneSetPanel(JWizard wiz) {
        super(wiz, "", IvrZoneWizardController.IMAGE_ZONE);
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(5) + " Select Zone ");
        this._zoneAction = (WizardZoneAction)this.getModelValue("ZONE_DATA");
    }

    @Override
    protected void populateZoneControls() throws SnmpException {
        this._zoneSetField.getField().setEditable(false);
        StringBuffer description = new StringBuffer();
        Switch sw = (Switch)this.getModelValue("IVR_ZONE_SWITCH");
        new Thread(new refreshZoneData(sw)).start();
        if (this._vsan == null) {
            description.append("Please specify the new zone name.\nThe IVR master switch " + sw + " will be used to create zone configuration.");
        } else {
            description.append("Please specify the new zone name.");
        }
        this.setDescription(description.toString());
    }

    @Override
    public void doNext() {
        if (!this.validateZoneFields()) {
            return;
        }
        if ((this._zoneAction.isActiveLocalZonesetModified() || this._zoneAction.getActiveLocalZoneSet() == null && this._zoneAction.getActiveZoneSet() != null) && JOptionPane.showConfirmDialog(this.getWizard(), "The Active zoneset and local zoneset on switch " + this._zoneAction.getSwitch() + " differ.\nContinue activation?", this.getWizard().getTitle(), 0, 3) != 0) {
            return;
        }
        String zoneset = (String)this.getModelValue("ZONESET");
        String zone = (String)this.getModelValue("ZONE");
        if (zoneset == null || !this._zoneSetField.getText().equals(zoneset) || zone == null || !this._zoneField.getText().equals(zone)) {
            this.setDataValid(false);
        }
        if (this._zoneSetField.getText().length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify valid zoneset name.");
            return;
        }
        if (this._zoneField.getText().length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify valid zone name.");
            return;
        }
        this.setModelValue("ZONESET", this._zoneSetField.getText());
        this.setModelValue("ZONE", this._zoneField.getText());
        this.setModelValue("ZONE_MODE", this._readOnlyChkBox.isSelected());
        Array memberPorts = (Array)this.getModelValue("NXPORTS");
        ZoneSet zs = this._zoneAction.findZoneSet(this._zoneSetField.getText());
        if (zs == null) {
            zs = new ZoneSet(this._zoneAction.getVsan() != null ? (int)this._zoneAction.getVsan().getId() : -1, 1, this._zoneSetField.getText(), new byte[0], -1L);
        }
        ArrayList zoneList = new ArrayList();
        zoneList = this._zoneAction.getDetailedZones(zoneList, zs);
        zoneList.add(0, zs);
        try {
            this._zoneAction.addNewZoneToZoneList(zoneList, this._readOnlyChkBox.isSelected(), this._zoneField.getText(), memberPorts, null);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
        }
        this.setDataValid(false);
        super.doNext();
    }

    class refreshZoneData
    implements Runnable {
        Switch sww;
        ArrayList pendingSwitches;

        refreshZoneData(Switch sw) {
            this.sww = sw;
        }

        @Override
        public void run() {
            try {
                Cursor oldcursor = IvrZoneSetPanel.this.getWizard().getCursor();
                IvrZoneSetPanel.this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
                IvrZoneSetPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(false);
                IvrZoneSetPanel.this.getWizard().getNavigator().getBackBtn().setEnabled(false);
                if (IvrZoneSetPanel.this.getModelValue("IVR_OPER_MODE") == IvrZoneWizardController.IVR_2_MODE) {
                    IvrZoneSetPanel.this.getWizard().setStatus("Checking CFS State...");
                    this.validateCfsPending();
                }
                IvrZoneSetPanel.this.getWizard().setStatus("Start Zone Discovery...");
                if (IvrZoneSetPanel.this.getWizard().isVisible()) {
                    this.refreshZones(this.sww);
                    IvrZoneSetPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    IvrZoneSetPanel.this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                }
                IvrZoneSetPanel.this.getWizard().setCursor(Cursor.getDefaultCursor());
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)IvrZoneSetPanel.this.getWizard(), ex);
                IvrZoneSetPanel.this.setDataValid(false);
            }
        }

        private void validateCfsPending() throws SnmpException {
            ArrayList swLst = (ArrayList)IvrZoneSetPanel.this.getModelValue("IVR2_ZONE_SWITCH_OBJECT_LIST");
            ArrayList sws = SmZoneUtil.buildSwitchLFromVerPeerList(IvrZoneSwitch.getIvrSwitches(swLst, true));
            ArrayList cfsSw = new ArrayList();
            this.pendingSwitches = new ArrayList();
            ArrayList nonCfsSw = new ArrayList();
            if (!((ZoneMemWizard)IvrZoneSetPanel.this.getWizard()).validateCFSPending(sws, cfsSw, nonCfsSw, this.pendingSwitches)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Util.errorMessage((Component)IvrZoneSetPanel.this.getWizard(), "There are pending commits on follwing IVR enabled switches\n" + refreshZoneData.this.pendingSwitches);
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return;
        }

        private void refreshZones(Switch sw) throws SnmpException {
            IvrZoneSetPanel.this._zoneAction.setVsanSwitch(sw, null);
            IvrZoneSetPanel.this._zoneAction.refresh();
            IvrZoneSetPanel.this._readOnlyChkBox.setEnabled(false);
            IvrZoneSetPanel.this._readOnlyChkBox.setVisible(false);
            IvrZoneSetPanel.this._zoneField.setText(IvrZoneSetPanel.this._zoneAction.getNewZoneName());
            IvrZoneSetPanel.this._zoneSetField.setFont(ChangedCellRenderer.getNormalFont());
            ZoneSet enforcedZoneset = IvrZoneSetPanel.this._zoneAction.getActiveZoneSet();
            if (enforcedZoneset != null && ((Object)enforcedZoneset).toString().length() > 0) {
                IvrZoneSetPanel.this._zoneSetField.setText(((Object)enforcedZoneset).toString());
                IvrZoneSetPanel.this._zoneSetField.setFont(IvrZoneSetPanel.this._zoneAction.isActiveLocalZonesetModified() ? DialogSeparator.getItalicBoldFont() : ChangedCellRenderer.getItalicFont());
            } else {
                ArrayList zonesets = IvrZoneSetPanel.this._zoneAction.getAvailableZoneSets();
                Object[] zs = zonesets.toArray();
                Arrays.sort(zs);
                IvrZoneSetPanel.this._zoneSetBtn.buildMenu(zs);
                if (zonesets.size() == 0) {
                    IvrZoneSetPanel.this._zoneSetField.setText("IVR_Zoneset1");
                    IvrZoneSetPanel.this._zoneSetField.getField().setEditable(true);
                } else {
                    IvrZoneSetPanel.this._zoneSetField.setText(zs[0].toString());
                }
            }
            IvrZoneSetPanel.this._zoneSetBtn.setVisible(enforcedZoneset == null);
        }
    }
}

