/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.dto;

import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SwitchAssignedLicenseInfo
implements Serializable {
    static Logger _Logger = LogManager.getLogger((String)"licmgr.license");
    public static final int SAN_LICENSE_TYPE = 1;
    public static final int LAN_LICENSE_TYPE = 2;
    public static final String NO_LICENSE_SUPPORT = "Not Applicable";
    public static final String NO_LICENSE_SUPPORT_UNKNOWN_DEVICE = "Switch Model Unknown";
    public static final String[] NO_LICENSE_SUPPORT_STRS = new String[]{"Not Applicable", "Switch Model Unknown"};
    int _productType;
    long _swDbID;
    FabricPK _fabOrLanPK;
    String _sys_name;
    String _key;
    String _ipAddress;
    boolean _isManaged;
    int _switchType;
    String _switchModel;
    SwitchLicenseDetails licDetails = null;
    boolean _isVDC = false;
    boolean _isFex = false;
    boolean _isLicenseable = false;

    public SwitchAssignedLicenseInfo(int productType, long swDbID, String sys_name, String key, FabricPK fabOrLanPK, String ipAddress, int switchType, String switchModelStr, int licenseId, String sign, Calendar expDate, boolean isManaged, boolean isVDC, boolean isFex, boolean isLicenseable) {
        this._productType = productType;
        this._swDbID = swDbID;
        this._fabOrLanPK = fabOrLanPK;
        this._sys_name = sys_name != null && sys_name.trim().length() > 0 ? sys_name : ipAddress;
        this._key = key;
        this._switchType = switchType;
        this._ipAddress = ipAddress;
        this.licDetails = new SwitchLicenseDetails(licenseId, sign, expDate);
        this._isManaged = isManaged;
        this._switchModel = switchModelStr;
        this._isVDC = isVDC;
        this._isFex = isFex;
        this._isLicenseable = isLicenseable;
    }

    public boolean isLicensed() {
        return this.licDetails.isLicensed();
    }

    public boolean isEval() {
        return this.licDetails.isEval();
    }

    public long timeLeft() {
        return this.licDetails.timeLeft();
    }

    public String getLicenseType() {
        return this.licDetails.getLicenseType();
    }

    public int getProductType() {
        return this._productType;
    }

    public boolean isLicenseFileType() {
        return this.licDetails.isLicenseFileType();
    }

    public boolean isExpiredFileEval() {
        return this.licDetails.isExpiredFileEval();
    }

    public String getLicenseState() {
        if (this._isLicenseable) {
            return this.licDetails.getLicenseState();
        }
        if (this._switchType == -1) {
            return NO_LICENSE_SUPPORT_UNKNOWN_DEVICE;
        }
        return NO_LICENSE_SUPPORT;
    }

    public long getDbID() {
        return this._swDbID;
    }

    public Date getExpireDate() {
        return this.licDetails.getExpireDate() == null ? null : this.licDetails.getExpireDate().getTime();
    }

    public String getExpireDateStr() {
        return this.licDetails.getExpireDate() == null ? null : this.licDetails.getExpireDate().getTime().toString();
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public FabricPK getFabOrLanPK() {
        return this._fabOrLanPK;
    }

    public String getFabricOrLanName() {
        return this._fabOrLanPK.getName();
    }

    public long getFabOrLanDbId() {
        if (this._fabOrLanPK instanceof LanPK) {
            return ((LanPK)this._fabOrLanPK)._dbid;
        }
        return this._fabOrLanPK.id;
    }

    public int getFabOrLanId() {
        return this._fabOrLanPK.get_fid();
    }

    public Boolean isManaged() {
        return this._isManaged;
    }

    public int getLicenseId() {
        return this.licDetails.getLicenseId();
    }

    public String getSign() {
        return this.licDetails.getSign();
    }

    public String getSysName() {
        return this._sys_name;
    }

    public String getSwitchKey() {
        return this._key;
    }

    public int getSwitchType() {
        return this._switchType;
    }

    public String getSwitchModel() {
        return this._switchModel;
    }

    public boolean isVDC() {
        return this._isVDC;
    }

    public boolean isFex() {
        return this._isFex;
    }

    public boolean isLicenseable() {
        return this._isLicenseable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SwitchAssignedLicenseInfo) {
            SwitchAssignedLicenseInfo swlObj = (SwitchAssignedLicenseInfo)obj;
            if (this._key.equals(swlObj._key) && this._fabOrLanPK == swlObj._fabOrLanPK && this._swDbID == swlObj._swDbID) {
                return true;
            }
        }
        return false;
    }
}

