/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.SysUpTimeIf;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.type.IpKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class EthSwitchBase<E extends PKIf>
extends AbstractSwitchBase<E>
implements SysUpTimeIf,
DumpIf {
    private static final long serialVersionUID = 1L;
    protected int _numEthPorts;
    protected int _numSlot = 0;
    protected String _globalDeviceId;
    protected String _deviceId;
    protected byte[] _vtpMgmtDomain;
    protected boolean _isChassis;
    protected final Map<String, String> _ifMappingTable = Collections.synchronizedMap(new HashMap());
    protected final HashSet<Short> _activeVlanIds = new HashSet();
    protected HashSet<SerialNumKey> _fexPKs = new HashSet();
    protected String _trimmedVersion;
    protected IpKey _nodeKey = null;
    protected long _sysLastBootTime;
    protected long _switchLastBootTime;
    protected int _num1gPorts;
    protected int _num2gPorts;
    protected int _num4gPorts;
    protected int _num8gPorts;
    protected int _num10gPorts;
    protected int _num16gPorts;
    protected int _num40gPorts;
    protected int _num100gPorts;

    public EthSwitchBase(E swPK, InetAddress swIP) {
        super(swPK);
        if (swPK instanceof SerialNumKey) {
            this._chassisKey = (SerialNumKey)swPK;
        } else if (swPK instanceof VdcPK) {
            this._chassisKey = ((VdcPK)swPK)._chassisKey;
        }
        if (swIP != null) {
            this._mgmtAddrs = new InetAddress[]{swIP};
            this._mgmtAddrInUse = swIP;
            this._mgmtAddrSet.add(swIP);
        }
    }

    @Override
    public void sync(EthSwitchBase<E> sw) {
        super.sync(sw);
        this._numEthPorts = sw._numEthPorts;
        this._globalDeviceId = sw._globalDeviceId;
        this._deviceId = sw._deviceId;
        this._vtpMgmtDomain = sw._vtpMgmtDomain;
        this._ifMappingTable.clear();
        this._ifMappingTable.putAll(sw.getIfMappingTable());
        this._activeVlanIds.clear();
        this._activeVlanIds.addAll(sw._activeVlanIds);
        this._trimmedVersion = sw._trimmedVersion;
    }

    @Override
    public String getIpAddress() {
        String ipStr = super.getIpAddress();
        if (ipStr == null && this.getManagementAddresses() != null && this.getManagementAddresses().length > 0) {
            ipStr = this.getManagementAddresses()[0].getHostAddress();
        }
        return ipStr;
    }

    @Override
    public InetAddress getInetAddress() {
        InetAddress ip = super.getInetAddress();
        if (ip == null && this.getManagementAddresses() != null && this.getManagementAddresses().length > 0) {
            ip = this.getManagementAddresses()[0];
        }
        return ip;
    }

    public IpKey getNodeKey() {
        InetAddress ip = this.getInetAddress();
        if (ip == null) {
            return null;
        }
        if (this._nodeKey == null || !this._nodeKey._addr.equals(ip)) {
            this._nodeKey = new IpKey(ip);
        }
        return this._nodeKey;
    }

    @Override
    public void setSerialNumber(String serialNum) {
        if (serialNum != null && serialNum.indexOf(46) >= 0) {
            return;
        }
        SerialNumKey oldKey = this.getChassisKey();
        if (oldKey == null || !oldKey._serialNum.equals(serialNum)) {
            this.setChassisKey(new SerialNumKey(serialNum));
        }
    }

    @Override
    public String getSerialNumber() {
        SerialNumKey chassisKey = this.getChassisKey();
        if (chassisKey == null || chassisKey._serialNum.indexOf(46) >= 0) {
            return "n/a";
        }
        return chassisKey._serialNum;
    }

    public SerialNumKey getSerialNumKey() {
        return this.getChassisKey();
    }

    public boolean hasSerialNumber() {
        SerialNumKey chassisKey = this.getChassisKey();
        return chassisKey != null && chassisKey._serialNum.indexOf(46) < 0;
    }

    @Override
    public long getSysUpTime() {
        return this._sysUpTime == 0L ? 0L : (System.currentTimeMillis() - this._sysLastBootTime) / 10L;
    }

    @Override
    public long getSwitchUpTime() {
        return this._switchLastBootTime == 0L ? 0L : (System.currentTimeMillis() - this._switchLastBootTime) / 10L;
    }

    public long getSysLastBootTime() {
        return this._sysLastBootTime;
    }

    public void setSysLastBootTime(long time) {
        this._sysLastBootTime = time;
    }

    public long getSwitchLastBootTime() {
        return this._switchLastBootTime;
    }

    public void setSwitchLastBootTime(long time) {
        this._switchLastBootTime = time;
    }

    @Override
    public void setVersion(String newVersion) {
        super.setVersion(newVersion);
        if (newVersion != null) {
            String searchStr = "Version ";
            int idx = newVersion.indexOf(searchStr);
            String temp = idx >= 0 ? newVersion.substring(idx + searchStr.length()) : newVersion;
            StringTokenizer strTok = new StringTokenizer(temp, ", ");
            this._trimmedVersion = strTok.nextToken();
        }
    }

    @Override
    public String getDeviceId() {
        return this._deviceId;
    }

    @Override
    public void setDeviceId(String id) {
        this._deviceId = id;
    }

    @Override
    public String getGlobalDeviceId() {
        return this._globalDeviceId;
    }

    @Override
    public void setGlobalDeviceId(String deviceId) {
        this._globalDeviceId = deviceId;
    }

    @Override
    public boolean isChassis() {
        return this._isChassis;
    }

    public void setChassis(boolean chassis) {
        this._isChassis = chassis;
    }

    @Override
    public byte[] getVtpMgmtDomain() {
        return this._vtpMgmtDomain;
    }

    @Override
    public void setVtpMgmtDomain(byte[] mgmtDomain) {
        this._vtpMgmtDomain = mgmtDomain;
    }

    @Override
    public String getName() {
        if (this._name != null && this._name.length() > 0) {
            return this._name;
        }
        if (this._deviceId != null && this._deviceId.length() > 0) {
            return this._deviceId;
        }
        if (this._sysName != null && this._sysName.length() > 0) {
            return this._sysName;
        }
        return this.getIpAddress();
    }

    @Override
    public int getNumFcPorts() {
        return 0;
    }

    @Override
    public int getNumPorts() {
        return this.getNumEthPorts();
    }

    @Override
    public int getNumSlots() {
        if (this._numSlot != 0) {
            return this._numSlot;
        }
        if (!this.isCAT()) {
            return FRUConstants.getNumSlots(this._type);
        }
        return 0;
    }

    public void setNumSlot(int slot) {
        this._numSlot = slot;
    }

    public void setNum1gPorts(int num1gPorts) {
        this._num1gPorts = num1gPorts;
    }

    public int getNum1gPorts() {
        return this._num1gPorts;
    }

    public void setNum2gPorts(int num2gPorts) {
        this._num2gPorts = num2gPorts;
    }

    public int getNum2gPorts() {
        return this._num2gPorts;
    }

    public void setNum4gPorts(int num4gPorts) {
        this._num4gPorts = num4gPorts;
    }

    public int getNum4gPorts() {
        return this._num4gPorts;
    }

    public void setNum8gPorts(int num8gPorts) {
        this._num8gPorts = num8gPorts;
    }

    public int getNum8gPorts() {
        return this._num8gPorts;
    }

    public void setNum10gPorts(int num10gPorts) {
        this._num10gPorts = num10gPorts;
    }

    public int getNum10gPorts() {
        return this._num10gPorts;
    }

    public void setNum16gPorts(int num16gPorts) {
        this._num16gPorts = num16gPorts;
    }

    public int getNum16gPorts() {
        return this._num16gPorts;
    }

    public void setNum40gPorts(int num40gPorts) {
        this._num40gPorts = num40gPorts;
    }

    public int getNum40gPorts() {
        return this._num40gPorts;
    }

    public void setNum100gPorts(int num100gPorts) {
        this._num100gPorts = num100gPorts;
    }

    public int getNum100gPorts() {
        return this._num100gPorts;
    }

    @Override
    public boolean isBrocade() {
        int vendorOid = -1;
        if (this._sysObjectId != null && this._sysObjectId.length >= 7) {
            return this._sysObjectId[6] == 1588;
        }
        return false;
    }

    @Override
    public boolean isCisco() {
        int vendorOid = -1;
        if (this._sysObjectId != null && this._sysObjectId.length >= 7) {
            return this._sysObjectId[6] == 9;
        }
        return false;
    }

    @Override
    public boolean isEthObject() {
        return true;
    }

    @Override
    public boolean isFcObject() {
        return false;
    }

    @Override
    public boolean isMdsDirector() {
        return this._type == 375 || this._type == 376 || this._type == 377;
    }

    @Override
    public boolean isParadise() {
        return false;
    }

    @Override
    public boolean isSabre() {
        return false;
    }

    @Override
    public boolean isQuail() {
        return false;
    }

    @Override
    public boolean isNuovaFamily() {
        return this.isN5K() || this.isN6K() || this.isUCS();
    }

    @Override
    public boolean isN4K() {
        return this._platformType == PlatformType.N4K;
    }

    @Override
    public boolean isN5K() {
        return this._platformType == PlatformType.N5K;
    }

    @Override
    public boolean isN6K() {
        return this._platformType == PlatformType.N6K;
    }

    @Override
    public boolean isUCS() {
        return this._platformType == PlatformType.UCS6K;
    }

    @Override
    public boolean isN7K() {
        return this._platformType == PlatformType.N7K;
    }

    @Override
    public boolean isN9K() {
        return this._platformType == PlatformType.N9K;
    }

    @Override
    public boolean isCAT() {
        return PlatformType.isTypeOf(this._platformType, PlatformType.CAT);
    }

    @Override
    public boolean isMDS() {
        return PlatformType.isMdsSwitch(this._platformType);
    }

    @Override
    public void setMDS(boolean mds) {
    }

    public boolean isN1K() {
        return this._platformType == PlatformType.N1K;
    }

    public boolean isN1K1() {
        return this._platformType == PlatformType.N1K1;
    }

    public boolean isN1KV() {
        return this._platformType == PlatformType.N1KV;
    }

    public boolean isN3K() {
        return this._platformType == PlatformType.N3K;
    }

    public boolean isFwsm() {
        return this._platformType == PlatformType.FWSM;
    }

    public boolean isVdcObject() {
        return false;
    }

    @Override
    public boolean allowDiscoverMoreOnFC() {
        return this.isMDS() || this.isNuovaFamily() || this._platformType == PlatformType.UCS6K || this.isN7K() && this.isFcoeEnabled();
    }

    @Override
    public boolean allowDiscoverMoreOnCDP() {
        return false;
    }

    @Override
    public String getModel() {
        String modelName = super.getModelName();
        if (modelName != null) {
            return modelName;
        }
        return this.getPlatformName();
    }

    @Override
    public boolean isVersion1_0() {
        return this._trimmedVersion != null && this._trimmedVersion.startsWith("1.0");
    }

    @Override
    public boolean isVersionGreaterThan(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._trimmedVersion);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._trimmedVersion != null && devVersion.compareTo(targetVersion) > 0;
    }

    @Override
    public boolean isVersionGreaterThanEqual(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._trimmedVersion);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._trimmedVersion != null && devVersion.compareTo(targetVersion) >= 0;
    }

    @Override
    public boolean isVersionLessThan(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._trimmedVersion);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._trimmedVersion != null && devVersion.lessThan(targetVersion);
    }

    @Override
    public boolean isVersionLessThanEqual(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._trimmedVersion);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._trimmedVersion != null && devVersion.lessThanEqual(targetVersion);
    }

    public boolean isVersionEqual(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._trimmedVersion);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._trimmedVersion != null && devVersion.equals(targetVersion);
    }

    public boolean isFcoeEnabled() {
        return this.isFeatureEnabled(AbstractSwitchBase.Feature.FCOE);
    }

    public void setFcoeEnabled(boolean enabled) {
        this.setFeatureFlag(AbstractSwitchBase.Feature.FCOE, enabled);
    }

    @Override
    public int getNumEthPorts() {
        return this._numEthPorts;
    }

    @Override
    public void setNumEthPorts(int ethPorts) {
        this._numEthPorts = ethPorts;
    }

    public HashMap<String, String> getIfMappingTable() {
        return new HashMap<String, String>(this._ifMappingTable);
    }

    protected String getIfMapping(int ifindex) {
        return this._ifMappingTable.get(String.valueOf(ifindex));
    }

    protected int getIfMapping(String ifname) {
        String idxStr = this._ifMappingTable.get(ifname);
        if (idxStr == null) {
            return -1;
        }
        try {
            return Integer.parseInt(idxStr);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public boolean haveIfMapping(String ifname) {
        if (this.isCAT()) {
            ifname = IfIndexUtil.formatIfName(ifname, true);
        }
        return this._ifMappingTable.get(ifname) != null;
    }

    public boolean haveIfMapping(int ifindex) {
        return this._ifMappingTable.get(String.valueOf(ifindex)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIfMapping(int ifindex, String ifname) {
        boolean changed = true;
        if (ifindex >= 0 && ifname != null && ifname.length() > 0 && Character.isLetter(ifname.charAt(0))) {
            Map<String, String> map = this._ifMappingTable;
            synchronized (map) {
                String v = this._ifMappingTable.put(String.valueOf(ifindex), ifname);
                if (v == null || !v.equals(ifname)) {
                    changed = true;
                }
                if ((v = this._ifMappingTable.put(ifname, String.valueOf(ifindex))) == null || !v.equals(String.valueOf(ifname))) {
                    changed = true;
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIfMappingTable(HashMap<String, String> ifMappingTable) {
        boolean changed = false;
        if (ifMappingTable != null && ifMappingTable.size() > 0) {
            Map<String, String> map = this._ifMappingTable;
            synchronized (map) {
                for (Map.Entry<String, String> ent : ifMappingTable.entrySet()) {
                    String v = this._ifMappingTable.put(ent.getKey(), ent.getValue());
                    if (v != null && v.equals(ent.getValue())) continue;
                    changed = true;
                }
            }
        }
        return changed;
    }

    public void clearIfMappingTable() {
        this._ifMappingTable.clear();
    }

    @Override
    public int ifIndex2Card(int ifIndex) {
        String ifname;
        if (this.isCAT() && (ifname = this.getIfMapping(ifIndex)) != null) {
            return IfIndexUtil.fmIfName2Card(ifname);
        }
        if (IfIndexUtil.isFmIfIndex(ifIndex)) {
            return IfIndexUtil.fmIfIndexToNameSat(ifIndex)[1];
        }
        return IfIndexUtil.ifIndex2Card(ifIndex);
    }

    @Override
    public int ifIndex2Port(int ifIndex) {
        String ifname;
        if (this.isCAT() && (ifname = this.getIfMapping(ifIndex)) != null) {
            return IfIndexUtil.fmIfName2Port(ifname);
        }
        if (IfIndexUtil.isFmIfIndex(ifIndex)) {
            return IfIndexUtil.fmIfIndexToNameSat(ifIndex)[2];
        }
        return IfIndexUtil.ifIndex2Port(ifIndex);
    }

    @Override
    public String ifIndexToName(int ifIndex) {
        try {
            String ifname = null;
            ifname = this.getIfMapping(ifIndex);
            if (ifname != null) {
                return ifname;
            }
            if (IfIndexUtil.isFmIfIndex(ifIndex)) {
                ifname = IfIndexUtil.fmIfIndex2IfName(ifIndex);
                return ifname;
            }
            if (this.isN5KVerLT503()) {
                return IfIndexUtil.ifIndexToNameForN5KLT503(ifIndex);
            }
            if (this.isN5K() || this.isN6K()) {
                return IfIndexUtil.ifIndexToNameForN5K(ifIndex, this.getSysObjectId()[this.getSysObjectId().length - 1]);
            }
            if (this.isMDS()) {
                switch (this._type) {
                    case 601: {
                        return IfIndexUtil.ifIndexToNameInagua(ifIndex);
                    }
                    case 606: 
                    case 773: {
                        return IfIndexUtil.ifIndexToNameChester(ifIndex);
                    }
                    case 843: {
                        return IfIndexUtil.ifIndexToNameCassino(ifIndex);
                    }
                    case 514: {
                        String ifName = IfIndexUtil.ifIndexToName(ifIndex);
                        if (ifName != null && ifName.equals(Integer.toString(ifIndex))) {
                            return "fc1/" + ifName;
                        }
                        return ifName;
                    }
                    case 529: {
                        if (ifIndex == 0 || ifIndex == 15) {
                            return "fcip" + ifIndex;
                        }
                        return "fc" + ifIndex;
                    }
                }
            }
            return IfIndexUtil.ifIndexToName(ifIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.toString(ifIndex);
        }
    }

    @Override
    public String ifTypeToifName(int ifType) {
        if (IfIndexUtil.isFmIfType(ifType)) {
            return IfIndexUtil.fmIfType2IfName(ifType);
        }
        return IfIndexUtil.ifTypeToifName(ifType);
    }

    @Override
    public int getType(int ifIndex) {
        if (this.isCAT()) {
            if (IfIndexUtil.isFmIfIndex(ifIndex)) {
                return IfIndexUtil.getType(ifIndex);
            }
            return -1;
        }
        if (this.isN5KVerLT503()) {
            return IfIndexUtil.getTypeForN5kLT503(ifIndex);
        }
        return IfIndexUtil.getType(ifIndex);
    }

    @Override
    public int getActualType(int type) {
        if (this.isN5KVerLT503()) {
            return IfIndexUtil.getActualN5KType(type);
        }
        return type;
    }

    @Override
    public int ifWwn2IfIndex(byte[] fWwn, IfIndexIf.FwwnInfo info) {
        throw new UnsupportedOperationException("EthSwitch does not use fwwn for ports");
    }

    @Override
    public String ifWwn2IfName(byte[] fWwn, IfIndexIf.FwwnInfo info) {
        throw new UnsupportedOperationException("EthSwitch does not use fwwn for ports");
    }

    @Override
    public byte[] ifIndex2wwn(int ifIndex, byte[] swWwn) {
        throw new UnsupportedOperationException("EthSwitch does not use fwwn for ports");
    }

    public boolean isN5KVerLT503() {
        return this.isN5K() && this.isVersionLessThan("5.0(3)");
    }

    public boolean isN5KVerLT521() {
        return this.isN5K() && this.isVersionLessThan("5.2(1)");
    }

    @Override
    public boolean isPortRangeSupport() {
        return true;
    }

    @Override
    public int nameToIfIndex(int card, int port, int type, int cardType) {
        if (FRUConstants.isAutodromoCard(cardType)) {
            String ifName = "Ethernet" + card + '/' + port;
            if (FRUConstants.isAuto100(cardType)) {
                return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 10);
            }
            return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 4);
        }
        return IfIndexUtil.nameToIfIndex(card, port, type);
    }

    @Override
    public int nameToIfIndex(int card, int port, int type) {
        return IfIndexUtil.nameToIfIndex(card, port, type);
    }

    @Override
    public int nameToIfIndex(String ifName) {
        if (ifName == null || ifName.length() == 0) {
            return -1;
        }
        try {
            ifName = IfIndexUtil.formatIfName(ifName, this.isCAT());
            int ifindex = this.getIfMapping(ifName);
            if (ifindex != -1) {
                return ifindex;
            }
            if (this.isCAT()) {
                return IfIndexUtil.fmIfName2IfIndex(ifName);
            }
            if (this.isN7K()) {
                String tmpifName = ifName.toLowerCase();
                if (tmpifName.startsWith("eth")) {
                    int tmpIfIndex = IfIndexUtil.nameToIfIndex(ifName);
                    int slot = IfIndexUtil.getIfIndexCard(tmpIfIndex);
                    Card card = InventoryManager.getInstance().findCard((PKIf)this.getSwitchPK(), slot);
                    if (card != null && card.isAutodromoCard()) {
                        if (card.isAuto100()) {
                            return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 10);
                        }
                        return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 4);
                    }
                    return IfIndexUtil.nameToIfIndex(ifName);
                }
                return IfIndexUtil.nameToIfIndex(ifName);
            }
            if (this.isN5KVerLT503()) {
                return IfIndexUtil.nameToIfIndexForN5KLT503(ifName);
            }
            if (this.isN1K()) {
                return IfIndexUtil.fmIfName2IfIndex(ifName);
            }
            if (this.isN1KV()) {
                return IfIndexUtil.nameToIfIndexN1KV(ifName);
            }
            if (this.isN5K() || this.isN6K()) {
                return IfIndexUtil.nameToIfIndexForN5K(ifName, this._cardTypes);
            }
            return IfIndexUtil.nameToIfIndex(ifName);
        }
        catch (Throwable e) {
            new Exception(this.print(false, true) + " cannot get ifindex from name:" + ifName, e).printStackTrace();
            return -1;
        }
    }

    public boolean isIfPhysical(int ifindex) {
        int type = this.getType(ifindex);
        return type == 1 || type == 2 || type == 5 || type == 26 || type == 31 || type == 0 || type == 0 || type == 153 || type == 152 || type == 56 || type == 57 || type == 58;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVlan(short vlanId) {
        if (vlanId < 0 || vlanId > 4096) {
            return false;
        }
        HashSet<Short> hashSet = this._activeVlanIds;
        synchronized (hashSet) {
            if (!this._activeVlanIds.contains(vlanId)) {
                this._activeVlanIds.add(vlanId);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVlan(short vlanId) {
        if (vlanId < 0 || vlanId > 4096) {
            return false;
        }
        HashSet<Short> hashSet = this._activeVlanIds;
        synchronized (hashSet) {
            if (this._activeVlanIds.contains(vlanId)) {
                this._activeVlanIds.remove(vlanId);
                return true;
            }
        }
        return false;
    }

    public boolean containVlan(short vlanId) {
        if (vlanId < 0 || vlanId > 4096) {
            return false;
        }
        return this._activeVlanIds.contains(vlanId);
    }

    public int getNumVlans() {
        return this._activeVlanIds.size();
    }

    public List<Short> getVlans() {
        ArrayList<Short> list = new ArrayList<Short>(this._activeVlanIds);
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVlans(List<Short> vlanIds) {
        HashSet<Short> hashSet = this._activeVlanIds;
        synchronized (hashSet) {
            this._activeVlanIds.clear();
            this._activeVlanIds.addAll(vlanIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVlans() {
        HashSet<Short> hashSet = this._activeVlanIds;
        synchronized (hashSet) {
            this._activeVlanIds.clear();
        }
    }

    public String getVlanIdsAsString() {
        return StringUtil.getRangeString(this.getVlans());
    }

    public int getNumOfFex() {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        return this._fexPKs.size();
    }

    public boolean haveFex() {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        return this._fexPKs.size() > 0;
    }

    public void addFex(SerialNumKey fexPK) {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        if (fexPK == null) {
            return;
        }
        this._fexPKs.add(fexPK);
    }

    public void removeFex(SerialNumKey fexPK) {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        if (fexPK == null) {
            return;
        }
        this._fexPKs.remove(fexPK);
    }

    public boolean containsFex(SerialNumKey fexPK) {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        if (fexPK == null) {
            return false;
        }
        return this._fexPKs.contains(fexPK);
    }

    public void clearFexes() {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        this._fexPKs.clear();
    }

    public void setFexes(List<SerialNumKey> fexPKs) {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        this._fexPKs.clear();
        this._fexPKs.addAll(fexPKs);
    }

    public List<SerialNumKey> getFexes() {
        if (this.isFex()) {
            throw new UnsupportedOperationException("Fex does not support this switch operation");
        }
        return new ArrayList<SerialNumKey>(this._fexPKs);
    }

    public boolean allowDeepDiscovery() {
        return this._platformType == PlatformType.N7K || this._platformType == PlatformType.N6K || this._platformType == PlatformType.N5K || this._platformType == PlatformType.UCS6K || this._platformType == PlatformType.CAT6K || this._platformType == PlatformType.N4K || this._platformType == PlatformType.N3K || this._platformType == PlatformType.N1K;
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(level)).append(this.isVdcObject() ? "Vdc: " : "Switch: ").append(this.getPK()).append(this.indent(level + 1)).append("Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime=" + new Date(this.getLastScanTime())).append(this.indent(level + 1)).append("Management Addresses: ");
        InetAddress[] addrs = this.getManagementAddresses();
        if (addrs != null) {
            for (int i = 0; i < addrs.length; ++i) {
                sb.append(addrs[i].getHostAddress()).append(addrs[i].equals(this.getInetAddress()) ? "(in use) " : " ");
            }
        } else {
            sb.append("n/a");
        }
        sb.append(this.indent(level + 1)).append("Manageable: ").append(this.isManageable()).append(this.isManageable() ? "" : " Reason: " + this.getUnmanageableCause()).append(this.indent(level + 1)).append("Device Id: ").append(this.getDeviceId() == null ? "n/a" : this.getDeviceId()).append(this.indent(level + 1)).append("Model: ").append(this.getModel() == null ? this.getVendor() : this.getModel()).append(this.indent(level + 1)).append("Version: ").append(this.getVersion() == null ? "n/a" : this.getVersion()).append(this.indent(level + 1)).append("SerialNo: ").append(this.getSerialNumber() == null ? "n/a" : this.getSerialNumber()).append(this.indent(level + 1)).append("Enabled Feature(s): ").append(this.getFeatureString());
        if (inDetail) {
            if (this.isMDS() || this.isN7K() || this.isN5K() || this.isN6K()) {
                sb.append(this.indent(level + 1)).append("Telnet Enabled: ").append(this.isTelnetEnabled()).append(this.indent(level + 1)).append("Ssh Enabled: ").append(this.isSSHEnabled());
            }
            sb.append(this.indent(level + 1)).append("SysUpTime: ").append(SnmpTimeticks.formatTimeElapsed(this.getSysUpTime())).append(this.indent(level + 1)).append("SysName: ").append(this.getSysName() == null ? "n/a" : this.getSysName()).append(this.indent(level + 1)).append("SysDescription: ").append(this.getSysDescr() == null ? "n/a" : this.getSysDescr()).append(this.indent(level + 1)).append("SysContact: ").append(this.getSysContact() == null ? "n/a" : this.getSysContact()).append(this.indent(level + 1)).append("SysLocation: ").append(this.getSysLocation() == null ? "n/a" : this.getSysLocation()).append(this.indent(level + 1)).append("VTP MgmtDomain: ").append(this.getVtpMgmtDomain() == null ? "n/a" : Arrays.toString(this.getVtpMgmtDomain()));
        }
        if (inDetail) {
            sb.append(this.indent(level + 1)).append("Num of Slots: ").append(FRUConstants.getNumSlots(this.getModelType())).append(this.indent(level + 1)).append("Num of Cards: ");
            List<Card> cards = InventoryManager.getInstance().findCards(this.getPK());
            if (cards.size() == 0) {
                sb.append("n/a");
            } else {
                sb.append(cards.size());
                Collections.sort(cards);
                for (Card card : cards) {
                    sb.append(this.indent(level + 2)).append("Slot: ").append(card.getSlotId()).append(", Type: ").append(card.getModelName()).append(", ").append(card.getType()).append(", Name: ").append(card.getName()).append(", Descr: ").append(card.getPhysicalDescr()).append(", HwRev: ").append(card.getHardwareRevision()).append(", SwRev: ").append(card.getSoftwareRevision()).append(", SerialNo: ").append(card.getSerialNumber()).append(", AssetID: ").append(card.getAssetId()).append(", Power OperStatus: ").append(card.getPowerOperStatus()).append(", OperStatus: ").append(card.getOperStatus() == 2 ? "up" : String.valueOf(card.getOperStatus())).append(card.isSupervisor() && card.isActive() ? " (active)" : "");
                }
            }
            if (!this.isVdcObject() && (this.isMDS() || this.isCAT() || this.isN5K() || this.isN6K() || this.isN7K())) {
                sb.append(this.indent(level + 1)).append("ActiveSupSlot: ");
                if (this.getActiveSupSlot() == -1) {
                    sb.append("n/a");
                } else {
                    sb.append(this.getActiveSupSlot());
                }
                sb.append(this.indent(level + 1)).append("StandbySupSlot: ");
                int slot = this.getStandbySupSlot();
                if (slot == -1) {
                    sb.append("n/a");
                } else {
                    sb.append(slot);
                }
                sb.append(this.indent(level + 1)).append("StandbySupState: ");
                if (this.getStandbySupState() == 0 || slot == -1) {
                    sb.append("n/a");
                } else {
                    sb.append(this.getStandbySupState());
                }
            }
        }
        return sb.toString();
    }

    public void printDetails(StringBuilder sb) {
        sb.append(", deviceId=").append(this._deviceId).append(", Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime=").append(new Date(this.getLastScanTime())).append(", Manageable=").append(this.isManageable()).append(" ").append(this.getUnmanageableCause()).append(", globalDeviceId=").append(this._globalDeviceId).append(", serialNum=").append(this.getChassisKey()).append(", cdpEnabled=").append(this._isCdpEnabled).append(", fcoeCapable=").append(this.isFCoECapable()).append(", versionFCoE=").append(this.isFCoECapableVersion()).append(", featureSetFCoE=").append((Object)this.getFCoFeatureSetStatus()).append(", fcoeEnabled=").append(this.isFcoeEnabled()).append(", modelName=").append(this._modelName).append(", platforme=").append(this._platformName).append(", platformType=").append((Object)this._platformType);
        if (this.isMDS() || this.isN7K() || this.isN5K() || this.isN6K()) {
            sb.append(", telnetEnabled=").append(this.isTelnetEnabled()).append(", sshEnabled=").append(this.isSSHEnabled());
        }
        sb.append(", vlan=").append(this._activeVlanIds);
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        if (withDecor) {
            sb.append("EthSwitch").append("@").append(this.getIpAddress());
        } else {
            sb.append(this.getIpAddress());
        }
        if (inDetail) {
            sb.append("[PK=" + this.getPK());
            this.printDetails(sb);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

