/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.GroupMemberPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;

@NamedQueries(value={@NamedQuery(name="findGroupMemberByKey", query="select m FROM GroupMemberBase m WHERE m.key= :key")})
@Entity
@Table(name="GROUP_MEMBER_INFO")
public class GroupMemberBase {
    @Transient
    PKIf pk;
    @EmbeddedId
    GroupMemberPK key;
    @Column(name="TYPE")
    int type;
    @Column(name="LAST_UPDATE_TIME")
    Timestamp last_update_time;

    public GroupMemberBase() {
        this(0L, 0L);
    }

    public GroupMemberBase(long groupId, long memberId) {
        this.key = new GroupMemberPK(groupId, memberId);
    }

    public long getGroup_id() {
        return this.key.getGroup_id();
    }

    public void setGroup_id(long group_id) {
        this.key.setGroup_id(group_id);
    }

    @PreUpdate
    @PrePersist
    public void onUpdateTimeStamp() {
        this.setLast_update_time(new Timestamp(System.currentTimeMillis()));
    }

    public Timestamp getLast_update_time() {
        return this.last_update_time;
    }

    public void setLast_update_time(Timestamp last_update_time) {
        this.last_update_time = last_update_time;
    }

    public long getMember_id() {
        return this.key.member_id;
    }

    public void setMember_id(long member_id) {
        this.key.member_id = member_id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

