/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.SwitchSnIntKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.VdcSnIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import java.util.Arrays;

public class HwInventoryComponent<E extends PKIf>
extends InventoryComponent {
    static final long serialVersionUID = 1L;
    protected E _swPK;
    protected int _physicalIndex;
    protected String _name;
    protected int[] _vendorType;
    protected HwInventoryType _hardwareType = HwInventoryType.UNKNOWN;
    protected int _relativePosition;
    protected String _hardwareRevision;
    protected String _firmwareRevision;
    protected String _softwareRevision;
    protected String _serialNumber;
    protected String _secSerialNumber;
    protected String _manufacturer;
    protected String _modelName;
    protected String _assetId;
    protected String _statusDescr;

    public HwInventoryComponent(E swPK, int phyIndex, String name, int[] vendorType, int hwType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String manufacturer, String modelName, String assetId, String status, String secSerialNum) {
        this._swPK = swPK;
        this._physicalIndex = phyIndex;
        this._name = name;
        this._vendorType = vendorType;
        this._hardwareType = HwInventoryType.getType(hwType);
        if (this._hardwareType == null) {
            this._hardwareType = HwInventoryType.UNKNOWN;
        }
        this._relativePosition = relPos;
        this._hardwareRevision = hwRev;
        this._firmwareRevision = fwRev;
        this._softwareRevision = swRev;
        this._serialNumber = serialNum;
        this._secSerialNumber = secSerialNum;
        this._manufacturer = manufacturer;
        this._modelName = modelName;
        this._assetId = assetId;
        this._statusDescr = status;
        this.updateLastScanTime();
        this._changeFlags = (byte)(this._changeFlags | 2);
    }

    public void update(int phyIndex, String name, int[] vendorType, int hwType, String hwRev, String fwRev, String swRev, String serialNum, String manufacturer, String modelName, String assetId, String status, String secSerialNum) {
        if (this._physicalIndex != phyIndex) {
            this._physicalIndex = phyIndex;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._name, name)) {
            this._name = name;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!Arrays.equals(this._vendorType, vendorType)) {
            this._vendorType = vendorType;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (this._hardwareType.value() != hwType) {
            this._hardwareType = HwInventoryType.getType(hwType);
            if (this._hardwareType == null) {
                this._hardwareType = HwInventoryType.UNKNOWN;
            }
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._hardwareRevision, hwRev)) {
            this._hardwareRevision = hwRev;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._firmwareRevision, fwRev)) {
            this._firmwareRevision = fwRev;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._softwareRevision, swRev)) {
            this._softwareRevision = swRev;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._serialNumber, serialNum)) {
            this._serialNumber = serialNum;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._secSerialNumber, secSerialNum)) {
            this._secSerialNumber = secSerialNum;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._manufacturer, manufacturer)) {
            this._manufacturer = manufacturer;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._modelName, modelName)) {
            this._modelName = modelName;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._assetId, assetId)) {
            this._assetId = assetId;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (!GenUtil.equals(this._statusDescr, status)) {
            this._statusDescr = status;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        this.updateLastScanTime();
    }

    public void update(String status) {
        if (!GenUtil.equals(this._statusDescr, status)) {
            this._statusDescr = status;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        this.updateLastScanTime();
    }

    public void updateSwitch() {
        this._changeFlags = (byte)(this._changeFlags | 3);
    }

    @Override
    public PKIf getPK() {
        if (this._swPK instanceof WwnKey) {
            return new SwitchIntKey((WwnKey)this._swPK, this._physicalIndex);
        }
        if (this._swPK instanceof SerialNumKey) {
            return new SwitchSnIntKey((SerialNumKey)this._swPK, this._physicalIndex);
        }
        if (this._swPK instanceof VdcPK) {
            return new VdcSnIntKey((VdcPK)this._swPK, this._physicalIndex);
        }
        InventoryManager._Logger.warn((Object)("Cannot get PK for HwInventoryComponent:" + this));
        return null;
    }

    public E getSwitchPK() {
        return this._swPK;
    }

    public String getSoftwareRevision() {
        return this._softwareRevision;
    }

    public String getModelName() {
        return this._modelName;
    }

    public HwInventoryType getHardwareType() {
        return this._hardwareType;
    }

    public String getAssetId() {
        return this._assetId;
    }

    public String getHardwareRevision() {
        return this._hardwareRevision;
    }

    public String getFirmwareRevision() {
        return this._firmwareRevision;
    }

    public String getName() {
        return this._name;
    }

    public int getPhysicalIndex() {
        return this._physicalIndex;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public int getSlotId() {
        return this._relativePosition;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public String getSecSerialNumber() {
        return this._secSerialNumber;
    }

    public int[] getVendorType() {
        return this._vendorType;
    }

    public String getStatusDescr() {
        return this._statusDescr;
    }

    public int hashCode() {
        return this._swPK.hashCode() ^ this._hardwareType.value() ^ this._relativePosition;
    }

    @Override
    public boolean equals(Object o) {
        HwInventoryComponent comp = (HwInventoryComponent)o;
        return this._swPK.equals(comp._swPK) && this._physicalIndex == comp._physicalIndex && this._hardwareType == comp._hardwareType && this._relativePosition == comp._relativePosition;
    }

    @Override
    public int compare(Object o1, Object o2) {
        HwInventoryComponent comp1 = (HwInventoryComponent)o1;
        HwInventoryComponent comp2 = (HwInventoryComponent)o2;
        int c = 0;
        c = !comp1._swPK.getClass().equals(comp2._swPK.getClass()) ? comp1._swPK.compare(comp1._swPK, comp2._swPK) : String.valueOf(comp1._swPK).compareTo(String.valueOf(comp2._swPK));
        if (c == 0) {
            c = comp1._relativePosition - comp2._relativePosition;
        }
        return c;
    }

    public String toString() {
        return "Hardware[swPK=" + this._swPK + "phyIndex=" + this._physicalIndex + "name=" + this.getName() + "]";
    }

    public boolean isFex() {
        return NexusEntityMibHelper.isFexPhyIndex(this._physicalIndex);
    }

    public int getFexId() {
        return NexusEntityMibHelper.getFexIdByPhyIndex(this._physicalIndex);
    }
}

