/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NameValuePair
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int value;
    private String description;
    private String serverIP = null;

    public NameValuePair(String name, int value) {
        this.name = name;
        this.value = value;
        this.description = null;
    }

    public NameValuePair(String name, String description, String serverIP) {
        this.name = name;
        this.description = description;
        this.serverIP = serverIP;
        this.value = 0;
    }

    public NameValuePair(String name, String description) {
        this.name = name;
        this.description = description;
        this.value = 0;
    }

    public NameValuePair(String name, int value, String description) {
        this.name = name;
        this.value = value;
        this.description = description;
    }

    public String getName() {
        String serverIp = this.getServerIP();
        return serverIp == null ? this.name : this.name + "-" + serverIp;
    }

    public int getValue() {
        return this.value;
    }

    public String getServerIP() {
        String localIP = null;
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "localhost";
        }
        return localIP.equalsIgnoreCase(this.serverIP) ? "localhost" : this.serverIP;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof NameValuePair)) {
            return 0;
        }
        return this.getName().compareTo(((NameValuePair)o).getName());
    }
}

