/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.se;

import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.se.SEDppVi;
import com.cisco.dcbu.sm.common.model.se.SESession;
import com.cisco.dcbu.sm.common.model.se.SESwitch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SEJob
implements Serializable {
    static final long serialVersionUID = 1L;
    private int _id;
    private String _ssmIp;
    private SESwitch _ssm;
    private String _log;
    private SESession[] _sessions;
    private List<SEDppVi> _dppVis = new ArrayList<SEDppVi>();
    private String _startTime;
    private List<EndPortBase> _targetPorts = new ArrayList<EndPortBase>();
    private EnclosureBase _target = null;
    private Card _module = null;
    private String _jobName = null;
    private byte _status = 1;
    private static String[] STATUS = new String[]{"Unknown", "In progress", "Failed", "Completed", "Stopped", "Ready", "Reset"};
    public static byte UNKNOWN = 0;
    public static byte IN_PROGRESS = 1;
    public static byte FAILED = (byte)2;
    public static byte COMPLETED = (byte)3;
    public static byte STOPPED = (byte)4;
    public static byte READY = (byte)5;
    public static byte RESET = (byte)6;

    public SEJob() {
    }

    public SEJob(int jobId, String name, byte status, String startTime) {
        this._id = jobId;
        this._jobName = name;
        this._status = status;
        this._startTime = startTime;
    }

    public List<SEDppVi> getDppVis() {
        return this._dppVis;
    }

    public void setDppVis(List<SEDppVi> dppVis) {
        this._dppVis = dppVis;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public SESession[] getSessions() {
        return this._sessions;
    }

    public void setSessions(SESession[] sessions) {
        this._sessions = sessions;
    }

    public SESwitch getSsm() {
        return this._ssm;
    }

    public void setSsm(SESwitch ssm) {
        this._ssm = ssm;
    }

    public byte getStatus() {
        return this._status;
    }

    public void setStatus(byte status) {
        this._status = status;
    }

    public String getSsmIp() {
        return this._ssmIp;
    }

    public void setSsmIp(String ssmIp) {
        this._ssmIp = ssmIp;
    }

    public String getLog() {
        return this._log;
    }

    public void setLog(String log) {
        this._log = log;
    }

    public Card getModule() {
        return this._module;
    }

    public void setModule(Card m) {
        this._module = m;
    }

    public List<EndPortBase> getTargetPorts() {
        return this._targetPorts;
    }

    public void setTargetPorts(List<EndPortBase> ports) {
        this._targetPorts = ports;
    }

    public EnclosureBase getTarget() {
        return this._target;
    }

    public void setTarget(EnclosureBase t) {
        this._target = t;
    }

    public void setJobName(String name) {
        this._jobName = name;
    }

    public String getJobName() {
        return this._jobName;
    }

    public String getStatusString() {
        return STATUS[this._status];
    }

    public String toString() {
        return this.getJobName();
    }

    public String getStartTime() {
        return this._startTime;
    }

    public void setStartTime(String time) {
        this._startTime = time;
    }
}

