/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.dto;

import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.topology.dto.TopoNodeDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoNxPortDto;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class TopoEnclosureDto
extends TopoNodeDto {
    static final long serialVersionUID = 1L;
    protected List endPortDtoList = new ArrayList();

    public TopoEnclosureDto(EnclosureBase enclosureBase) {
        super(enclosureBase);
        if (enclosureBase != null) {
            this.setName(enclosureBase.getName());
            this.setIconName("16x16-AdapterCard.gif");
        }
    }

    public void addEndPort(TopoNxPortDto endPortDto) {
        if (endPortDto != null) {
            this.endPortDtoList.add(endPortDto);
        }
    }

    public TopoNxPortDto getFirstEndPort() {
        if (this.endPortDtoList == null || this.endPortDtoList.size() == 0) {
            return null;
        }
        return (TopoNxPortDto)this.endPortDtoList.get(0);
    }

    public boolean isVirtualized() {
        TopoNxPortDto endPortDto = null;
        ListIterator it = this.endPortDtoList.listIterator();
        while (it.hasNext()) {
            endPortDto = (TopoNxPortDto)it.next();
            if (!endPortDto.isVirtualized()) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfGroup(GroupBase group) {
        if (group == null) {
            return false;
        }
        TopoNxPortDto endPortDto = null;
        ListIterator it = this.endPortDtoList.listIterator();
        while (it.hasNext()) {
            endPortDto = (TopoNxPortDto)it.next();
            if (group.hasMember(endPortDto.getSwitchPK())) {
                return true;
            }
            if (!group.hasMember(endPortDto.getPK())) continue;
            return true;
        }
        return false;
    }
}

