/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import javax.xml.bind.annotation.XmlType;

@XmlType(name="DiscStateType")
public enum DiscStateType {
    UNMANAGE(0, "Unmanaged"),
    CDPMANAGE(1, "Cdp-Manage"),
    DEEPMANAGE(2, "Deep-Manage"),
    FULLMANAGE(3, "Full-Manage"),
    FAILED(4, "Manage Failed");

    public static DiscStateType[] AllTypes;
    private int value;
    private String name;
    private String[] displayString = new String[]{"InProgress", "Inventory-discovered", "Deep-discovered", "fully-discovered", "Manage Failed"};

    private DiscStateType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public String toDisplayString() {
        for (DiscStateType t : AllTypes) {
            if (t.value != this.value) continue;
            return this.displayString[this.value];
        }
        System.err.println("DiscStateType cannot get type from:" + this.value);
        return this.displayString[0];
    }

    public static DiscStateType getType(int value) {
        for (DiscStateType t : AllTypes) {
            if (t.value != value) continue;
            return t;
        }
        System.err.println("DiscStateType cannot get type from:" + value);
        return UNMANAGE;
    }

    public static DiscStateType getType(String name) {
        for (DiscStateType t : AllTypes) {
            if (!t.name.equalsIgnoreCase(name)) continue;
            return t;
        }
        System.err.println("DiscStateType cannot get type from:" + name);
        return UNMANAGE;
    }

    static {
        AllTypes = DiscStateType.values();
    }
}

