/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

public enum DiscTaskType {
    UNKNOWN(0, "Unknown", "Unknown discovery task type"),
    LAN_MAXHOP(1, "LAN-MaxHop", "Max hop based LAN discovery task"),
    LAN_IPLIST(2, "LAN-IpList", "IP list based LAN discovery task"),
    LAN_FCIMPORT(3, "LAN_FcImport", "FC import based LAN discovery task"),
    LAN_DEEP(4, "LAN_Deep", "Deep discovery in DCNM LAN");

    public static DiscTaskType[] AllTypes;
    private int _value;
    private String _name;
    private String _descr;

    private DiscTaskType(int value, String name, String descr) {
        this._value = value;
        this._name = name;
        this._descr = descr;
    }

    public int value() {
        return this._value;
    }

    public String toString() {
        return this._name;
    }

    public String getDescr() {
        return this._descr;
    }

    public static DiscTaskType getType(int value) {
        for (DiscTaskType t : AllTypes) {
            if (t._value != value) continue;
            return t;
        }
        System.err.println("DiscTaskType cannot get type from:" + value);
        return UNKNOWN;
    }

    public static DiscTaskType getType(String name) {
        for (DiscTaskType t : AllTypes) {
            if (!t._name.equalsIgnoreCase(name)) continue;
            return t;
        }
        System.err.println("DiscTaskType cannot get type from:" + name);
        return UNKNOWN;
    }

    static {
        AllTypes = DiscTaskType.values();
    }
}

