/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import java.util.HashSet;
import java.util.Set;

public enum PlatformType {
    MDS9000("MDS9000", "DS_C90", "Cisco MDS9000 Switch"),
    MDS9100("MDS9100", "DS_C91,DS_X91", "Cisco MDS 9100 Switch"),
    MDS9200("MDS9200", "DS_C92,DS_X92", "Cisco MDS 9200 Switch"),
    MDS9500("MDS9500", "DS-C95", "Cisco MDS 9500 Switch"),
    N1KV("N1KV", "NEXUS1000V", "Cisco Nexus 1000v Switch"),
    N1K("N1K", "NEXUS1010", "Cisco Nexus 1K Switch"),
    N1K1("N1K1", "NEXUS1110,VSA", "Cisco Nexus 1110 Switch"),
    N2K("N2K", "N2K-C", "Cisco Nexus 2K Fabric Extender"),
    N3K("N3K", "N3K-", "Cisco Nexus 3K Switch"),
    N4K("N4K", "N4K-", "Cisco Nexus 4K Switch"),
    N5K("N5K", "N5K-C", "Cisco Nexus 5K Switch"),
    N6K("N6K", "N6K-C,N6001-,N6004-", "Cisco Nexus 6K Switch"),
    N7K("N7K", "N7K-C,N7F-C,N77-C", "Cisco Nexus 7K Switch"),
    N9K("N9K", "N9K-C", "Cisco Nexus 9K Switch"),
    UCS6K("UCS6K", "N10-,NEXUS1000,UCS-", "Cisco UCS 6K Switch"),
    CAT4K("CAT4K", "WS-C4", "Cisco Catalyst 4K Switch"),
    CAT5K("CAT5K", "WS-C5", "Cisco Catalyst 5K Switch"),
    CAT6K("CAT6K", "WS-C6", "Cisco Catalyst 6K Switch"),
    MDS("MDS", "DS-C,DS-X", "Cisco MDS Switch"),
    CAT("CAT", "WS-C", "Cisco Catalyst Switch"),
    NEXUS("NEXUS", "<<NEXUS>>", "Cisco Nexus Switch"),
    CDP("CDP", "<<CDP>>", "Cdp Device"),
    FCOE("FCOE", "<<FCOE>>", "FCoE Capable Switch"),
    FEX("FEX", "<<FEX>>", "FEX Capable Switch"),
    FWSM("FWSM", "<<FWSM>>", "Firewall Service Module"),
    IPPHONE("PHONE", "PHONE", "Cisco IP Phone"),
    SWITCH("SWITCH", "<SWITCH>>", "Switch"),
    UNKNOWN("UNKNOWN", "<<UNKNOWN>>", "Unknown Device"),
    ANY("ANY", "<<ANY>>", "Any Device");

    public static final PlatformType[] _types;
    private static final PlatformType[] _mdsSwitchTypes;
    private static final PlatformType[] _nexusSwitchTypes;
    private static final PlatformType[] _ucsSwitchTypes;
    private static final PlatformType[] _catSwitchTypes;
    private static final PlatformType[] _fcoeSwitchTypes;
    private static final PlatformType[] _fexSwitchTypes;
    private static final HashSet<PlatformType> _cdpSwitchTypes;
    private String _defKey;
    private String _deviceKey;
    private String _name;

    private PlatformType(String defKey, String deviceKey, String name) {
        this._defKey = defKey;
        this._deviceKey = deviceKey;
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public int getValue() {
        return this.ordinal();
    }

    public String getDefineKey() {
        return this._defKey;
    }

    public String getDeviceKey() {
        return this._deviceKey;
    }

    public final String toString() {
        return this.getName();
    }

    public static boolean isTypeOf(PlatformType childType, PlatformType parentType) {
        if (childType == null || parentType == null) {
            return false;
        }
        if (childType == parentType) {
            return true;
        }
        switch (parentType) {
            case ANY: {
                return childType != UNKNOWN;
            }
            case MDS: {
                return PlatformType.isMdsSwitch(childType);
            }
            case CAT: {
                return PlatformType.isCATSwitch(childType);
            }
            case NEXUS: {
                return PlatformType.isNexusSwitch(childType) || childType == N2K;
            }
            case FCOE: {
                return PlatformType.isFCoESwitch(childType);
            }
            case CDP: {
                return PlatformType.isCdpSwitch(childType);
            }
            case SWITCH: {
                return PlatformType.isMdsSwitch(childType) || PlatformType.isNexusSwitch(childType) || PlatformType.isCATSwitch(childType);
            }
        }
        return false;
    }

    public static boolean isMdsSwitch(PlatformType type) {
        if (type == MDS) {
            return true;
        }
        for (PlatformType p : _mdsSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isNexusSwitch(PlatformType type) {
        if (type == NEXUS) {
            return true;
        }
        for (PlatformType p : _ucsSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        for (PlatformType p : _nexusSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isCATSwitch(PlatformType type) {
        if (type == CAT) {
            return true;
        }
        for (PlatformType p : _catSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isUCS(PlatformType type) {
        return type == UCS6K;
    }

    public static boolean isFCoESwitch(PlatformType type) {
        for (PlatformType p : _fcoeSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isCdpSwitch(PlatformType type) {
        for (PlatformType p : _cdpSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isFEXSwitch(PlatformType type) {
        for (PlatformType p : _fexSwitchTypes) {
            if (p != type) continue;
            return true;
        }
        return false;
    }

    public static PlatformType getTypeByDeviceKey(String deviceKey) {
        if (deviceKey == null || deviceKey.length() == 0) {
            return UNKNOWN;
        }
        String upperKey = deviceKey.toUpperCase();
        for (PlatformType type : _types) {
            String[] subKeys;
            boolean onlyOne;
            boolean bl = onlyOne = type._deviceKey.indexOf(44) < 0;
            if (onlyOne) {
                if (upperKey.indexOf(type._deviceKey) < 0) continue;
                return type;
            }
            for (String key : subKeys = type._deviceKey.split(",")) {
                if (upperKey.indexOf(key) < 0) continue;
                return type;
            }
        }
        return UNKNOWN;
    }

    public static PlatformType getTypeByDefineKey(String defKey) {
        if (defKey == null || defKey.length() == 0) {
            return UNKNOWN;
        }
        for (PlatformType type : _types) {
            if (!defKey.trim().equalsIgnoreCase(type._defKey)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static PlatformType getTypeByValue(int value) {
        if (value < 0 || value >= _types.length) {
            return UNKNOWN;
        }
        return _types[value];
    }

    public static Exception parsePlatforms(String keyStr, Set<PlatformType> retSet) {
        if (keyStr == null || keyStr.length() == 0) {
            return new IllegalArgumentException("Invalid platform string:" + keyStr);
        }
        if (retSet == null) {
            return new IllegalArgumentException("Invalid ret platform set:" + retSet);
        }
        String[] splits = keyStr.split(",");
        StringBuilder sb = new StringBuilder();
        for (String s : splits) {
            PlatformType t = PlatformType.getTypeByDefineKey(s = s.trim());
            if (t != UNKNOWN) {
                retSet.add(t);
                continue;
            }
            sb.append(s).append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length() - 1);
            sb.insert(0, "Invalid platform string ");
            return new Exception(sb.toString());
        }
        return null;
    }

    static {
        _types = PlatformType.values();
        _mdsSwitchTypes = new PlatformType[]{MDS9500, MDS9200, MDS9100, MDS9000, MDS};
        _nexusSwitchTypes = new PlatformType[]{N9K, N7K, N6K, N5K, N4K, N3K, N1K, N1KV, N1K1};
        _ucsSwitchTypes = new PlatformType[]{UCS6K};
        _catSwitchTypes = new PlatformType[]{CAT6K, CAT5K, CAT4K};
        _fcoeSwitchTypes = new PlatformType[]{MDS, N5K, N6K, N7K, UCS6K, MDS9500};
        _fexSwitchTypes = new PlatformType[]{N5K, N6K, N7K, N9K, UCS6K};
        _cdpSwitchTypes = new HashSet();
        for (PlatformType p : _mdsSwitchTypes) {
            _cdpSwitchTypes.add(p);
        }
        for (PlatformType p : _nexusSwitchTypes) {
            _cdpSwitchTypes.add(p);
        }
        for (PlatformType p : _ucsSwitchTypes) {
            _cdpSwitchTypes.add(p);
        }
        for (PlatformType p : _catSwitchTypes) {
            _cdpSwitchTypes.add(p);
        }
    }
}

