/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VsanPK;
import java.util.Arrays;
import java.util.Comparator;

public final class VsanFcIdKey
implements PKIf,
Comparator,
Comparable {
    static final long serialVersionUID = 1L;
    public final VsanPK _vsanPK;
    public final int _fcId;

    public VsanFcIdKey(VsanPK vsanPK, int fcId) {
        if (vsanPK == null) {
            throw new IllegalArgumentException("VSAN PK cannot be null");
        }
        this._vsanPK = vsanPK;
        this._fcId = fcId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VsanFcIdKey)) {
            return false;
        }
        VsanFcIdKey key = (VsanFcIdKey)o;
        return this._fcId == key._fcId && this._vsanPK.equals(key._vsanPK);
    }

    @Override
    public int hashCode() {
        return this._vsanPK.hashCode() ^ this._fcId;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        VsanFcIdKey key1 = (VsanFcIdKey)o1;
        VsanFcIdKey key2 = (VsanFcIdKey)o2;
        int c = key1._vsanPK.compareTo(key2._vsanPK);
        return c == 0 ? key1._fcId - key2._fcId : c;
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    @Override
    public String toString() {
        return "VSAN " + this._vsanPK._id + " / 0x" + Integer.toHexString(this._fcId);
    }

    public static boolean equals(VsanFcIdKey[] keys1, VsanFcIdKey[] keys2) {
        if (keys1 == keys2) {
            return true;
        }
        if (keys1 == null || keys2 == null || keys1.length != keys2.length) {
            return false;
        }
        if (keys1.length == 1) {
            return keys1[0].equals(keys2[0]);
        }
        Arrays.sort(keys1);
        Arrays.sort(keys2);
        return Arrays.equals(keys1, keys2);
    }
}

