/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.visio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class VisioExporter2 {
    public static Class _Class = VisioExporter2.class;
    private Logger logger = Logger.getLogger(VisioExporter2.class);
    private FileOutputStream _fileOutputStream;

    public VisioExporter2(File file, char sepCharacter, String title) throws Exception {
        this._fileOutputStream = new FileOutputStream(file);
    }

    public void exportComment(String comment) {
        this.exportString("\n<!-- " + comment + " -->\n");
    }

    public void close() {
        if (this._fileOutputStream != null) {
            try {
                this._fileOutputStream.close();
            }
            catch (IOException ex) {
                this.logger.error((Object)"Error in closing Visio file - ", (Throwable)ex);
            }
        }
    }

    public void exportString(String text) {
        if (this._fileOutputStream != null) {
            try {
                this._fileOutputStream.write(text.getBytes());
            }
            catch (IOException ex) {
                this.logger.error((Object)"Error in exporting Visio string - ", (Throwable)ex);
            }
        }
    }

    public FileOutputStream getPrintWriter() {
        return this._fileOutputStream;
    }

    public void exportFile(String file) throws Exception {
        InputStream is = VisioExporter2.class.getResourceAsStream("/" + file);
        BufferedInputStream bis = new BufferedInputStream(is);
        int length = (((InputStream)bis).available() + 131) / 132;
        byte[] b = new byte[132];
        int c = 0;
        try {
            for (int i = 0; i < length && (c = ((InputStream)bis).read(b)) > 0; ++i) {
                this._fileOutputStream.write(b, 0, c);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error in reading/writing file=" + file + " - "), (Throwable)ex);
        }
        try {
            ((InputStream)bis).close();
        }
        catch (IOException ex1) {
            this.logger.error((Object)("Error in closing file=" + file + " - "), (Throwable)ex1);
        }
    }
}

