/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.visio;

import com.cisco.dcbu.sm.common.visio.VisioGraphIntf;
import com.cisco.dcbu.sm.common.visio.VisioLink;
import com.cisco.dcbu.sm.common.visio.VisioLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioNode;
import com.cisco.dcbu.sm.common.visio.VisioNodeIntf;
import java.util.ArrayList;
import java.util.HashMap;

public class VisioGraph
implements VisioGraphIntf {
    private boolean _multiEdgeCollapsed = false;
    static final String EMPTY_STRING = "";
    static final String SEPARATOR_STRING = "|";
    ArrayList nodes = new ArrayList();
    ArrayList links = new ArrayList();
    HashMap _edgesByNode = new HashMap();
    HashMap _dummyEdgesByNode = new HashMap();
    double width = 800.0;
    double height = 600.0;
    String title = "no title";
    Object userObject = null;
    private int iconCenterY = 0;
    private int iconCenterX = 0;

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public VisioLinkIntf getDummyEdge(VisioLinkIntf link) {
        return this.getDummyEdge(link.getFromNode(), link.getToNode());
    }

    public VisioLinkIntf getDummyEdge(VisioNodeIntf node1, VisioNodeIntf node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        VisioLinkIntf dummyLink = null;
        dummyLink = (VisioLinkIntf)this._dummyEdgesByNode.get(EMPTY_STRING + node1.hashCode() + SEPARATOR_STRING + node2.hashCode());
        if (dummyLink == null) {
            dummyLink = (VisioLinkIntf)this._dummyEdgesByNode.get(EMPTY_STRING + node2.hashCode() + SEPARATOR_STRING + node1.hashCode());
        }
        return dummyLink;
    }

    @Override
    public boolean isGridEnabled() {
        return true;
    }

    @Override
    public ArrayList getLinks(VisioNodeIntf n1, VisioNodeIntf n2) {
        ArrayList eList = (ArrayList)this._edgesByNode.get(EMPTY_STRING + n1.hashCode() + SEPARATOR_STRING + n2.hashCode());
        if (eList == null) {
            eList = (ArrayList)this._edgesByNode.get(EMPTY_STRING + n2.hashCode() + SEPARATOR_STRING + n1.hashCode());
        }
        return eList;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public ArrayList getSelectedNodes() {
        return this.getNodes();
    }

    @Override
    public ArrayList getSelectedEdges(ArrayList list) {
        return this.getEdges();
    }

    @Override
    public ArrayList getNodes() {
        return (ArrayList)this.nodes.clone();
    }

    @Override
    public ArrayList getEdges() {
        return (ArrayList)this.links.clone();
    }

    @Override
    public VisioNodeIntf addNode(VisioNodeIntf node) {
        if (node != null) {
            this.nodes.add(node);
            if (node.getIconCenterX() > this.width) {
                this.width = node.getIconCenterX();
            }
            if (node.getIconCenterY() > this.height) {
                this.height = node.getIconCenterY();
            }
        }
        return node;
    }

    @Override
    public VisioLinkIntf addLink(VisioLinkIntf link) {
        if (link != null) {
            this.links.add(link);
            this.insert(link);
        }
        return link;
    }

    public VisioLinkIntf insert(VisioLinkIntf edge) {
        VisioNodeIntf n1 = edge.getFromNode();
        VisioNodeIntf n2 = edge.getToNode();
        if (n1 == null || n2 == null) {
            return edge;
        }
        ArrayList eList = (ArrayList)this._edgesByNode.get(EMPTY_STRING + n1.hashCode() + SEPARATOR_STRING + n2.hashCode());
        VisioLinkIntf dLink = null;
        if (eList == null) {
            eList = (ArrayList)this._edgesByNode.get(EMPTY_STRING + n2.hashCode() + SEPARATOR_STRING + n1.hashCode());
            if (eList != null) {
                dLink = (VisioLinkIntf)this._dummyEdgesByNode.get(EMPTY_STRING + n2.hashCode() + SEPARATOR_STRING + n1.hashCode());
            }
        } else {
            dLink = (VisioLinkIntf)this._dummyEdgesByNode.get(EMPTY_STRING + n1.hashCode() + SEPARATOR_STRING + n2.hashCode());
        }
        if (eList == null) {
            eList = new ArrayList();
            eList.add(edge);
            this._edgesByNode.put(EMPTY_STRING + n1.hashCode() + SEPARATOR_STRING + n2.hashCode(), eList);
        } else if (!eList.contains(edge)) {
            if (eList.size() == 1 && dLink == null) {
                dLink = new VisioLink();
                dLink.setFromNode(n1);
                dLink.setToNode(n2);
                dLink.setIsDummyLink(true);
                this.links.add(dLink);
                this._dummyEdgesByNode.put(EMPTY_STRING + n1.hashCode() + SEPARATOR_STRING + n2.hashCode(), dLink);
                ((VisioLinkIntf)eList.get(0)).setHasDummyLink(true);
                if (this._multiEdgeCollapsed && !n1.isLinksExpanded() && !n2.isLinksExpanded()) {
                    dLink.setVisible(true);
                    ((VisioLinkIntf)eList.get(0)).setVisible(false);
                } else {
                    dLink.setVisible(false);
                    n1.setLinksExpanded(true);
                    n2.setLinksExpanded(true);
                }
            }
            eList.add(edge);
            if (dLink != null) {
                edge.setHasDummyLink(true);
                if (this._multiEdgeCollapsed && !n1.isLinksExpanded() && !n2.isLinksExpanded()) {
                    edge.setVisible(false);
                    dLink.setVisible(true);
                    edge.getFromNode().setLinksExpanded(false);
                    edge.getToNode().setLinksExpanded(false);
                } else {
                    edge.getFromNode().setLinksExpanded(true);
                    edge.getToNode().setLinksExpanded(true);
                    dLink.setVisible(false);
                    edge.setVisible(true);
                }
            }
        }
        return edge;
    }

    @Override
    public void compactBounds() {
        VisioNode node = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            node = (VisioNode)this.nodes.get(i);
            if (node.getIconCenterX() > this.width) {
                this.width = node.getIconCenterX();
            }
            if (!(node.getIconCenterY() > this.height)) continue;
            this.height = node.getIconCenterY();
        }
    }

    @Override
    public ArrayList edges() {
        return this.getEdges();
    }

    @Override
    public void setCenter(double iconCenterX, double iconCenterY) {
        this.iconCenterX = (int)iconCenterX;
        this.iconCenterY = (int)iconCenterY;
    }

    @Override
    public ArrayList nodes() {
        return this.getNodes();
    }

    @Override
    public ArrayList graphs() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isExpanded() {
        return true;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setExpandeMultipleLinks(boolean expandMultiLinks) {
        this._multiEdgeCollapsed = !expandMultiLinks;
    }
}

