/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import com.cisco.dcbu.lib.net.AbstractNetService;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.event.ServerEvent;
import com.cisco.dcbu.sm.server.CliSession;
import com.cisco.dcbu.sm.server.event.EventForwarder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.LogManager;

public final class CliService
extends AbstractNetService {
    private CliSession _cli;
    final String DEBUG_SERVER_PORT = "debug.server";

    public CliService() {
        this.setName("Remote Debug Server");
        this._threadGroup.setMaxPriority(1);
    }

    @Override
    protected void initImpl(Object[] params) throws Exception {
        if (params != null) {
            this.setConfiguration("bindAddr", (String)params[0]);
            this.setConfiguration("bindPort", (String)params[1]);
            this.setConfiguration("maxConn", String.valueOf(1));
        } else {
            this.setConfiguration("bindPort", System.getProperty("debug.server"));
        }
        super.initImpl(params);
    }

    @Override
    public void serve(Socket client) throws IOException {
        client.setTcpNoDelay(true);
        client.setSoLinger(false, 0);
        client.setKeepAlive(false);
        client.setSoTimeout(300000);
        this._cli = CliSession.createRemote(client);
        ServerEvent e = new ServerEvent(3, "remote console started at " + client.getRemoteSocketAddress());
        EventForwarder.getInstance().queue(e);
        this._cli.run();
    }

    @Override
    protected void connectionEstablished(InetAddress addr, int port) {
        super.connectionEstablished(addr, port);
        String msg = "remote console started on " + addr;
        LogManager.getLogger((String)"fms").warn((Object)msg);
        EventForwarder.getInstance().queue(new ServerEvent(3, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handshake(Socket s) {
        PrintWriter out;
        InetAddress clientHost = s.getInetAddress();
        try {
            out = new PrintWriter(s.getOutputStream(), true);
        }
        catch (IOException ioe) {
            return false;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            File file = new File(ClientCache.getInstallLocation() + "debug.properties");
            if (!file.exists() || !file.canRead()) {
                out.println("debug.properties does not exist");
                boolean bl = false;
                return bl;
            }
            fis = new FileInputStream(file);
            if (fis == null) {
                out.println("cannot read debug.properties");
                boolean bl = false;
                return bl;
            }
            properties.load(fis);
        }
        catch (IOException e) {
            out.println("reading debug.properties error");
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {}
            }
        }
        String allowedHost = properties.getProperty("allowed");
        try {
            if (allowedHost != null && InetAddress.getByName(allowedHost).equals(clientHost)) {
                return true;
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        out.println("permission denied");
        return false;
    }
}

