/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.modules.Main;

public class JBoss_4_2Wrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadPropertyFile(String configFile, Properties properties) throws IOException {
        FileInputStream fis = null;
        try {
            File file = new File(configFile);
            if (!file.exists()) {
                throw new IOException("file not found: " + configFile);
            }
            if (!file.canRead()) {
                throw new IOException("cannot read file: " + configFile);
            }
            fis = new FileInputStream(file);
            if (fis == null) {
                throw new IOException("file not found: " + configFile);
            }
            properties.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String decrypt(String encryptedKey) throws Exception {
        BigInteger bInt = new BigInteger(encryptedKey, 16);
        Cipher blowFishCipher = Cipher.getInstance("Blowfish");
        blowFishCipher.init(2, new SecretKeySpec("jaas is the way".getBytes(), "Blowfish"));
        return new String(blowFishCipher.doFinal(bInt.toByteArray()));
    }

    private static String getJBossHomeDir() {
        try {
            String jbossDir = URLDecoder.decode(JBoss_4_2Wrapper.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
            return new File(jbossDir).getParentFile().getParentFile().getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String jboss_home = System.getProperty("jboss.home");
        if (jboss_home == null) {
            jboss_home = JBoss_4_2Wrapper.getJBossHomeDir();
        }
        String source = jboss_home + "/server/fm/conf/props/ssl.properties";
        Properties sslProperties = new Properties();
        try {
            JBoss_4_2Wrapper.loadPropertyFile(source, sslProperties);
        }
        catch (IOException e1) {
            System.out.println("Failed to load ssl property file");
            e1.printStackTrace();
        }
        String trustStrPwd = null;
        String keyStrPwd = null;
        try {
            trustStrPwd = JBoss_4_2Wrapper.decrypt(sslProperties.getProperty("trustStorePassword"));
            keyStrPwd = JBoss_4_2Wrapper.decrypt(sslProperties.getProperty("keyStorePassword"));
        }
        catch (Exception e1) {
            System.err.println("Fail to retrieve ssl property");
            e1.printStackTrace();
        }
        if (trustStrPwd != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStrPwd);
        }
        if (keyStrPwd != null) {
            System.setProperty("javax.net.ssl.keyStorePassword", keyStrPwd);
        }
        try {
            Main.main((String[])args);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

