/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.rif.PmServiceRif;
import com.cisco.dcbu.sm.server.bean.PmServiceMBeanMBean;
import com.cisco.dcbu.sm.server.pm.PmServiceMgr;
import com.cisco.dcbu.sm.server.scheduler.SchedulerManagerImpl;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

@Remote(value={PmServiceRif.class})
@Singleton
@Startup
@DependsOn(value={"user:service=QuartzService,name=QuartzService"})
public class PmServiceMBean
extends PmServiceMgr
implements PmServiceMBeanMBean {
    static Logger _Logger = Logger.getLogger((String)"PM.n3k");
    public static final int SCHEDULE_SUCCESS = 0;
    public static final int PM_SERVICE_JOB = 11;
    public static final int LAYTENT = 1800000;
    String _JobName = null;
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;

    public void launch() throws Exception {
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        GenUtil.loadServerProperties(_Logger);
        String n3k_buf_collect = System.getProperty("pm.n3k_buffer_count", "false");
        if (!Boolean.parseBoolean(n3k_buf_collect)) {
            return;
        }
        _Logger.info((Object)"PM service bean starting....");
        this.registerInJMX();
        try {
            JobDataMap jobStatesMap = new JobDataMap();
            this._JobName = "pm_service_job_" + InetAddress.getLocalHost().getHostName();
            Date startDate = new Date(System.currentTimeMillis() + 1800000L);
            int scheduleResultCode = SchedulerManagerImpl.getInstance().scheduleJob(6, 11, this._JobName, jobStatesMap, startDate, null, true);
            if (scheduleResultCode != 0) {
                _Logger.warn((Object)("Error: Job " + this._JobName + " scheduling failed"));
            } else {
                _Logger.info((Object)("Sucessfully scheduled job " + this._JobName + "."));
            }
        }
        catch (SchedulerException e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
        catch (Exception e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        _Logger.info((Object)"PM service bean stopping....");
        this.unregisterFromJMX();
        try {
            SchedulerManagerImpl.getInstance().deleteJob(this._JobName);
        }
        catch (Exception e) {
            _Logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void registerInJMX() {
        try {
            _Logger.warn((Object)"********* Registering dcm:service=PmServiceMBean");
            this.objectName = new ObjectName("dcm:service=PmServiceMBean");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }
}

