/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.WebServiceRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.Remote;
import javax.ejb.Stateless;

@Remote(value={WebServiceRif.class})
@Stateless
public class WebServiceBean
implements WebServiceRif {
    private static final long serialVersionUID = 1L;
    private static WebServiceBean _Instance;
    private SanManager _sanManager = SanManager.getInstance();

    @Override
    public SwitchBase[] findAllSwitches() throws RemoteException {
        SwitchImpl[] sws = this._sanManager.getSwitches();
        SwitchBase[] ret = new SwitchBase[sws.length];
        for (int i = 0; i < sws.length; ++i) {
            ret[i] = (SwitchBase)sws[i].getBaseObject();
        }
        return ret;
    }

    @Override
    public EnclosureBase[] findAllEnclosures() throws RemoteException {
        EnclosureImpl[] encls = this._sanManager.getEnclosures();
        EnclosureBase[] ret = new EnclosureBase[encls.length];
        for (int i = 0; i < encls.length; ++i) {
            ret[i] = (EnclosureBase)encls[i].getBaseObject();
        }
        return ret;
    }

    @Override
    public FabricBase getFabric(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        return fabric.getFabricBase(new short[0]);
    }

    @Override
    public VsanBase[] getVsans() throws RemoteException {
        FabricImpl[] fabrics = this._sanManager.getFabrics();
        ArrayList<VsanBase> vsans = new ArrayList<VsanBase>();
        for (int i = 0; i < fabrics.length; ++i) {
            VsanImpl[] v = fabrics[i].getVsans();
            for (int j = 0; j < v.length; ++j) {
                vsans.add((VsanBase)v[i].getBaseObject());
            }
        }
        return vsans.toArray(new VsanBase[0]);
    }

    @Override
    public FabricBase[] getFabrics() throws RemoteException {
        FabricImpl[] fabs = this._sanManager.getFabrics();
        if (fabs == null) {
            return null;
        }
        FabricBase[] retFabrics = new FabricBase[fabs.length];
        for (int i = 0; i < fabs.length; ++i) {
            retFabrics[i] = fabs[i].getFabricBase(new short[0]);
        }
        return retFabrics;
    }

    @Override
    public VsanBase[] getVsans(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        VsanImpl[] vsans = fabric.getVsans();
        if (vsans == null) {
            return null;
        }
        VsanBase[] retVsans = new VsanBase[vsans.length];
        for (int i = 0; i < vsans.length; ++i) {
            retVsans[i] = (VsanBase)vsans[i].getBaseObject();
        }
        return retVsans;
    }

    @Override
    public EnclosureBase getEnclosureByName(String name) throws RemoteException {
        EnclosureImpl e = this._sanManager.findEnclosureByName(name);
        if (e == null) {
            return null;
        }
        return (EnclosureBase)e.getBaseObject();
    }

    @Override
    public EnclosureBase getEnclosureByPortWwn(Wwn wwn) throws RemoteException {
        EnclosureImpl e = this._sanManager.findEnclosureByPortWwn(wwn);
        if (e == null) {
            return null;
        }
        return (EnclosureBase)e.getBaseObject();
    }

    @Override
    public EnclosureBase[] getEnclosures() throws RemoteException {
        EnclosureImpl[] e = this._sanManager.getEnclosures();
        if (e == null) {
            return null;
        }
        EnclosureBase[] retE = new EnclosureBase[e.length];
        for (int i = 0; i < e.length; ++i) {
            retE[i] = (EnclosureBase)e[i].getBaseObject();
        }
        return retE;
    }

    @Override
    public boolean addSource(String username, int authProtocol, String authPasswd, String targetAdd) throws RemoteException {
        boolean ret = false;
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (this.authenticate(username, authProtocol, authPasswd, inet.getHostAddress())) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            ret = em.addSource(inet);
        }
        return ret;
    }

    @Override
    public boolean addSource(String communityUser, String targetAdd) throws RemoteException {
        boolean ret = false;
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (this.authenticate(communityUser, inet.getHostAddress())) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            ret = em.addSource(inet);
        }
        return ret;
    }

    @Override
    public boolean addSource(String username, int authProtocol, String authPassword, int privacyProtocol, String privacyPassword, String targetAdd) throws RemoteException {
        boolean ret = false;
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (WebServiceBean.authenticate(username, authProtocol, authPassword, privacyProtocol, privacyPassword, targetAdd)) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            ret = em.addSource(inet);
        }
        return ret;
    }

    @Override
    public String getSyslogAddress(String userName, int authProtocol, String authPassword, String targetAdd) throws RemoteException {
        String addr = null;
        if (this.authenticate(userName, authProtocol, authPassword, targetAdd)) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            InetAddress syslogAddr = em.getSyslogAddress();
            if (syslogAddr == null) {
                return null;
            }
            addr = syslogAddr.getHostAddress();
        }
        return addr;
    }

    @Override
    public String getSyslogAddress(String communityUser, String targetAdd) throws RemoteException {
        String addr = null;
        if (this.authenticate(communityUser, targetAdd)) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            InetAddress syslogAddr = em.getSyslogAddress();
            if (syslogAddr == null) {
                return null;
            }
            addr = syslogAddr.getHostAddress();
        }
        return addr;
    }

    @Override
    public String getSyslogAddress(String userName, int authProtocol, String authPassword, int privacyProtocol, String privacyPassword, String targetAdd) throws RemoteException {
        String addr = null;
        if (WebServiceBean.authenticate(userName, authProtocol, authPassword, privacyProtocol, privacyPassword, targetAdd)) {
            EventManagerService em = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
            InetAddress syslogAddr = em.getSyslogAddress();
            if (syslogAddr == null) {
                return null;
            }
            addr = syslogAddr.getHostAddress();
        }
        return addr;
    }

    private boolean authenticate(String username, int authProtocol, String authPassword, String targetAdd) throws RemoteException {
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (!SecurityManager.authenticate(username, authProtocol, authPassword, inet)) {
            throw new RemoteException("Authentication failed.");
        }
        return true;
    }

    private boolean authenticate(String communityUser, String targetAdd) throws RemoteException {
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (!SecurityManager.authenticate(communityUser, inet)) {
            throw new RemoteException("Authentication failed.");
        }
        return true;
    }

    public static boolean authenticate(String userName, int authProtocol, String authPassword, int privacyProtocol, String privacyPassword, String targetAdd) throws RemoteException {
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(targetAdd);
        }
        catch (UnknownHostException uhe) {
            throw new RemoteException(uhe.getCause() + ":" + uhe.getMessage());
        }
        if (!SecurityManager.authenticate(userName, authProtocol, authPassword, privacyProtocol, privacyPassword, inet)) {
            throw new RemoteException("Authentication failed.");
        }
        return true;
    }
}

