/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.cat;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.dto.SmHealthAnalysisDetail;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.cat.SmHAIndex;
import com.cisco.dcbu.sm.server.cat.SwitchHealthCheckLogic;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.ArrayList;
import java.util.HashMap;

public class HealthCheckMethods {
    public static final String SHA_VSAN_SUSPENDED = "VSAN Suspended";
    public static final int CFS_MERGE_STATUS_FAILURE = 3;
    public static final int FEATURE_ENABLED = 2;
    public static final int FEATURE_DISABLED = 3;
    public static final int FEATURE_NA = 0;
    public static final int CFS_GLOBAL_DISABLED = 2;
    public static final int FcIfOperStatusReason_linkFailure = 7;
    public static final int FcIfOperStatusReason_zoneMergeFailureIsolation = 24;
    public static final int FcIfOperStatusReason_vsanMismatchIsolation = 25;
    public static final int FcIfOperStatusReason_errorDisabled = 5;
    public static final int FcIfOperStatusReason_parentDown = 26;
    public static final int FcIfOperStatusReason_swFailure = 6;
    public static final int FcIfOperStatusReason_hwFailure = 3;
    public static final int FcIfOperStatusReason_initializing = 10;
    public static final int FcIfOperStatusReason_portBlocked = 63;
    public static final int[] _cfsMergeStatusValueOid = MibNode.get("cfsMergeStatusValue").getOid();
    public static final int CiscoCFSScopeType_VSAN = 2;

    static Object[][] addrowChassis(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        long cpuUtil = vbl.longValue(0);
        long MemUtil = vbl.longValue(1);
        if (cpuUtil >= 90L || MemUtil >= 90L) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "Processor";
            StringBuffer sb = new StringBuffer();
            if (cpuUtil >= 90L) {
                sb.append("CPU > 90%");
            }
            if (MemUtil >= 90L) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("Memory > 90%");
            }
            int[] indices = new int[]{index.getValue()[0]};
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "utilization", null, sb.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowCardMember(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        ArrayList<Object[]> outData = new ArrayList<Object[]>();
        HashMap<SwitchImpl, Array> _peers2CardInfo = new HashMap<SwitchImpl, Array>();
        SwitchBase swBase = (SwitchBase)node.getBaseObject();
        for (int v = 0; v < vbl.size(); ++v) {
            Array cardInfo;
            int operStatus = vbl.intValue(v);
            if (operStatus == 2) continue;
            if (!_peers2CardInfo.containsKey(node)) {
                cardInfo = new Array();
                _peers2CardInfo.put(node, cardInfo);
            } else {
                cardInfo = (Array)_peers2CardInfo.get(node);
            }
            SnmpOID oid = vbl.getVb(v).getOid();
            cardInfo.addElement(oid);
        }
        Array cardInfo = (Array)_peers2CardInfo.get(node);
        if (cardInfo != null) {
            int[] indices = new int[cardInfo.size()];
            int[] iList = new int[cardInfo.size()];
            for (int i = 0; i < cardInfo.size(); ++i) {
                int[] indexOid = ((SnmpOID)cardInfo.elementAt(i)).getValue();
                indices[i] = indexOid[indexOid.length - 1];
                iList[i] = indexOid[indexOid.length - 1] - 21;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Slot(s) ");
            sb.append(SnmpIntList.toString(iList, (IfIndexIf)swBase));
            Object[] row = new Object[]{node.toString(), "Module Failures", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "moduleTab", "cardStatus", sb.toString())};
            outData.add(row);
        }
        if (node.isMdsDirector() && !node.isHotStandby()) {
            Object[] row = new Object[]{node.toString(), "No Hot Standby", new SmHealthAnalysisDetail(node.getInetAddress(), node.getBase(), "moduleTab", "cardStatus")};
            outData.add(row);
        }
        if (outData.size() > 0) {
            return (Object[][])outData.toArray((T[])new Object[outData.size()][]);
        }
        return null;
    }

    static Object[][] addrowSensorMember(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Object[][] rowTh;
        ArrayList<Object> resultRows = new ArrayList<Object>();
        HashMap<SwitchImpl, HashMap> _peers2SensorIndexName = new HashMap<SwitchImpl, HashMap>();
        HashMap<SwitchImpl, Array> _peers2SensorInfo = new HashMap<SwitchImpl, Array>();
        for (int v = 0; v < vbl.size(); v += 3) {
            Array sensorInfo;
            HashMap sensorIndex2Name;
            SnmpString name = (SnmpString)vbl.getVb(v).getVar();
            int status = vbl.intValue(v + 1);
            int[] oid = vbl.getVb(v).getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            if (!_peers2SensorIndexName.containsKey(node)) {
                sensorIndex2Name = new HashMap();
                _peers2SensorIndexName.put(node, sensorIndex2Name);
            } else {
                sensorIndex2Name = (HashMap)_peers2SensorIndexName.get(node);
            }
            sensorIndex2Name.put(new Integer(ifIndex), name);
            if (status == 3) {
                if (!_peers2SensorInfo.containsKey(node)) {
                    sensorInfo = new Array();
                    _peers2SensorInfo.put(node, sensorInfo);
                } else {
                    sensorInfo = (Array)_peers2SensorInfo.get(node);
                }
                sensorInfo.addElement(new Object[]{name.toString(), new Integer(ifIndex)});
            }
            if ((sensorInfo = (Array)_peers2SensorInfo.get(node)) == null) continue;
            StringBuffer sensorCol = new StringBuffer();
            int[] indices = new int[sensorInfo.size()];
            for (int i = 0; i < sensorInfo.size(); ++i) {
                if (sensorCol.length() != 0) {
                    sensorCol.append(",");
                }
                Object[] attri = (Object[])sensorInfo.elementAt(i);
                sensorCol.append(attri[0]);
                indices[i] = (Integer)attri[1];
            }
            Object[] row = new Object[]{node.toString(), "Temperature Sensor Failures", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "moduleTab", "sensors", sensorCol.toString())};
            resultRows.add(row);
        }
        if (vbl.size() > 0 && (rowTh = HealthCheckMethods.addrowSensorThresholdMember(vbl, node, index, new Object[]{_peers2SensorIndexName})) != null && rowTh.length > 0) {
            resultRows.add(rowTh);
        }
        if (resultRows.size() > 0) {
            return (Object[][])resultRows.toArray((T[])new Object[resultRows.size()][]);
        }
        return null;
    }

    static Object[][] addrowSensorThresholdMember(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array sensorThreshold;
        HashMap _peers2SensorIndexName = (HashMap)param[0];
        HashMap<SwitchImpl, Array> _peers2SensorThreshold = new HashMap<SwitchImpl, Array>();
        int thresholdEval = vbl.intValue(0);
        int[] oid = vbl.getVb(0).getOid().getValue();
        int ifIndex = oid[oid.length - 2];
        if (thresholdEval == 1) {
            Integer ifIndexKey;
            HashMap sensorIndex2Name;
            if (!_peers2SensorThreshold.containsKey(node)) {
                sensorThreshold = new Array();
                _peers2SensorThreshold.put(node, sensorThreshold);
            } else {
                sensorThreshold = (Array)_peers2SensorThreshold.get(node);
            }
            if (_peers2SensorIndexName.containsKey(node) && (sensorIndex2Name = (HashMap)_peers2SensorIndexName.get(node)).containsKey(ifIndexKey = new Integer(ifIndex))) {
                SnmpString name = (SnmpString)sensorIndex2Name.get(ifIndexKey);
                sensorThreshold.addElement(new Object[]{name.toString(), new Integer(ifIndex)});
            }
        }
        if ((sensorThreshold = (Array)_peers2SensorThreshold.get(node)) != null) {
            StringBuffer sensorThresholdCol = new StringBuffer();
            int[] indices = new int[sensorThreshold.size()];
            for (int i = 0; i < sensorThreshold.size(); ++i) {
                if (sensorThresholdCol.length() != 0) {
                    sensorThresholdCol.append(",");
                }
                Object[] attri = (Object[])sensorThreshold.elementAt(i);
                sensorThresholdCol.append(attri[0]);
                indices[i] = (Integer)attri[1];
            }
            Object[] row = new Object[]{node.toString(), "Temperature Alarms", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "moduleTab", "sensors", sensorThresholdCol.toString())};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowPowerSupplyMember(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        HashMap<SwitchImpl, Array> _peers2PowerSupplyInfo = new HashMap<SwitchImpl, Array>();
        for (int v = 0; v < vbl.size(); v += 2) {
            Array powersupplyInfo;
            int operStatus = vbl.intValue(v);
            int[] oid = vbl.getVb(v).getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            if (operStatus == 2) continue;
            if (!_peers2PowerSupplyInfo.containsKey(node)) {
                powersupplyInfo = new Array();
                _peers2PowerSupplyInfo.put(node, powersupplyInfo);
            } else {
                powersupplyInfo = (Array)_peers2PowerSupplyInfo.get(node);
            }
            String name = vbl.stringValue(v + 1);
            powersupplyInfo.addElement(new Object[]{name, new Integer(ifIndex)});
        }
        Array powersupplyInfo = (Array)_peers2PowerSupplyInfo.get(node);
        if (powersupplyInfo != null) {
            StringBuffer col = new StringBuffer();
            int[] indices = new int[powersupplyInfo.size()];
            for (int i = 0; i < powersupplyInfo.size(); ++i) {
                if (col.length() != 0) {
                    col.append(",");
                }
                Object[] attri = (Object[])powersupplyInfo.elementAt(i);
                col.append(attri[0]);
                indices[i] = (Integer)attri[1];
            }
            Object[] row = new Object[]{node.toString(), "PowerSupply Failures", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "moduleTab", "powerSupply", col.toString())};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowFanMember(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        HashMap<SwitchImpl, Array> _peers2FanInfo = new HashMap<SwitchImpl, Array>();
        for (int v = 0; v < vbl.size(); v += 2) {
            Array fanInfo;
            int operStatus = vbl.intValue(v);
            int[] oid = vbl.getVb(v).getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            if (operStatus == 2) continue;
            if (!_peers2FanInfo.containsKey(node)) {
                fanInfo = new Array();
                _peers2FanInfo.put(node, fanInfo);
            } else {
                fanInfo = (Array)_peers2FanInfo.get(node);
            }
            String name = vbl.stringValue(v + 1);
            fanInfo.addElement(new Object[]{name, new Integer(ifIndex)});
        }
        Array fanInfo = (Array)_peers2FanInfo.get(node);
        if (fanInfo != null) {
            StringBuffer col = new StringBuffer();
            int[] indices = new int[fanInfo.size()];
            for (int i = 0; i < fanInfo.size(); ++i) {
                if (col.length() != 0) {
                    col.append(",");
                }
                Object[] attri = (Object[])fanInfo.elementAt(i);
                col.append(attri[0]);
                indices[i] = (Integer)attri[1];
            }
            Object[] row = new Object[]{node.toString(), "Fan Failures", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "fan", null, col.toString())};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowInterface(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Object[] row;
        SnmpOID indexOid;
        int portType = (Integer)param[0];
        boolean checkIfLink = (Boolean)param[1];
        ArrayList<Object[]> responseData = new ArrayList<Object[]>();
        String[] _InterfaceMibs = new String[]{"fcIfOperStatusCause"};
        int[] _firstOid = MibNode.get(_InterfaceMibs[0]).getOid();
        int mibLen = _InterfaceMibs.length;
        Array<SnmpOID> errIndices = new Array<SnmpOID>();
        Array<SnmpOID> errLinkFailtureIndices = new Array<SnmpOID>();
        Array<SnmpOID> zoneMergeFailtureIndices = new Array<SnmpOID>();
        Array<SnmpOID> errorDisabledFailureIndices = new Array<SnmpOID>();
        Array<SnmpOID> parentDownFailureIndices = new Array<SnmpOID>();
        Array<SnmpOID> swFailFailureIndices = new Array<SnmpOID>();
        Array<SnmpOID> hwFailFailureIndices = new Array<SnmpOID>();
        Array<SnmpOID> portBlockedFailureIndices = new Array<SnmpOID>();
        Array<SnmpOID> initializingFailureIndices = new Array<SnmpOID>();
        for (int i = 0; i < vbl.size(); i += mibLen) {
            SnmpVarBind vb;
            int[] oid;
            int operCause = vbl.intValue(i);
            if (operCause == 0 || operCause == 2 || operCause == 12 || operCause == 29 || (oid = (vb = vbl.getVb(i)).getOid().getValue()).length < _firstOid.length) continue;
            SnmpOID indexErr = new SnmpOID(oid, _firstOid.length, oid.length - _firstOid.length);
            if (operCause == 7) {
                errLinkFailtureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 24) {
                zoneMergeFailtureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 5) {
                errorDisabledFailureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 26) {
                parentDownFailureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 6) {
                swFailFailureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 3) {
                hwFailFailureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 10) {
                initializingFailureIndices.addElement(indexErr);
                continue;
            }
            if (operCause == 63) {
                portBlockedFailureIndices.addElement(indexErr);
                continue;
            }
            errIndices.addElement(indexErr);
        }
        if (errLinkFailtureIndices.size() != 0 && checkIfLink) {
            HealthCheckMethods.processInterfaceFailureType(errLinkFailtureIndices, node, portType, "Link Failures", responseData);
        }
        if (zoneMergeFailtureIndices.size() != 0) {
            int[] indices = new int[zoneMergeFailtureIndices.size()];
            int[] iList = new int[zoneMergeFailtureIndices.size()];
            for (int i = 0; i < zoneMergeFailtureIndices.size(); ++i) {
                indexOid = (SnmpOID)zoneMergeFailtureIndices.elementAt(i);
                indices[i] = indexOid.getValue()[0];
                iList[i] = indexOid.getValue()[0];
            }
            String strErrs = SnmpIntList.toString(iList, (SwitchBase)node.getBaseObject(), false);
            row = new Object[3];
            row[0] = node.toString();
            switch (portType) {
                case 8: {
                    row[1] = "PortChannel Link Zone Merge Failure";
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfacePC", null, strErrs);
                    break;
                }
                default: {
                    row[1] = "Interface Link zoneMergeFailureIsolation Failure";
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfaceISL", null, strErrs);
                }
            }
            responseData.add(row);
        }
        HealthCheckMethods.processInterfaceFailureType(errorDisabledFailureIndices, node, portType, "Error Disabled Failure", responseData);
        HealthCheckMethods.processInterfaceFailureType(parentDownFailureIndices, node, portType, "Parent Down Failure", responseData);
        HealthCheckMethods.processInterfaceFailureType(swFailFailureIndices, node, portType, "Switch Failure", responseData);
        HealthCheckMethods.processInterfaceFailureType(hwFailFailureIndices, node, portType, "Hardware Failure", responseData);
        HealthCheckMethods.processInterfaceFailureType(initializingFailureIndices, node, portType, "Initializing Failure", responseData);
        HealthCheckMethods.processInterfaceFailureType(portBlockedFailureIndices, node, portType, "Port Blocked Failure", responseData);
        if (errIndices.size() != 0) {
            int[] indices = new int[errIndices.size()];
            int[] iList = new int[errIndices.size()];
            for (int i = 0; i < errIndices.size(); ++i) {
                indexOid = (SnmpOID)errIndices.elementAt(i);
                indices[i] = indexOid.getValue()[0];
                iList[i] = indexOid.getValue()[0];
            }
            String strErrs = SnmpIntList.toString(iList, (SwitchBase)node.getBaseObject(), false);
            row = new Object[3];
            row[0] = node.toString();
            switch (portType) {
                case 8: {
                    row[1] = "Other PortChannel Failures";
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfacePC", null, strErrs);
                    break;
                }
                default: {
                    row[1] = "Other Interface Failures";
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfaceISL", null, strErrs);
                }
            }
            responseData.add(row);
        }
        if (responseData.size() > 0) {
            return (Object[][])responseData.toArray((T[])new Object[responseData.size()][]);
        }
        return null;
    }

    private static void processInterfaceFailureType(Array<SnmpOID> failureIndices, SwitchImpl node, int portType, String rowString, ArrayList responseData) {
        if (failureIndices.size() != 0) {
            int[] indices = new int[failureIndices.size()];
            int[] iList = new int[failureIndices.size()];
            for (int i = 0; i < failureIndices.size(); ++i) {
                SnmpOID indexOid = failureIndices.elementAt(i);
                indices[i] = indexOid.getValue()[0];
                iList[i] = indexOid.getValue()[0];
            }
            String strErrs = SnmpIntList.toString(iList, (SwitchBase)node.getBaseObject(), false);
            Object[] row = new Object[3];
            row[0] = node.toString();
            switch (portType) {
                case 8: {
                    row[1] = "PortChannel " + rowString;
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfacePC", null, strErrs);
                    break;
                }
                default: {
                    row[1] = "Interface " + rowString;
                    row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), indices, "InterfaceISL", null, strErrs);
                }
            }
            responseData.add(row);
        }
    }

    static Object[][] addrowTrunkStatus(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        ArrayList<Object[]> reportList = new ArrayList<Object[]>();
        StringBuffer sb = new StringBuffer();
        Array<int[]> arrayindices = new Array<int[]>();
        Array<int[]> arrayVsanIndices = new Array<int[]>();
        Array<int[]> arrayZoneIndices = new Array<int[]>();
        StringBuffer sbVsan = new StringBuffer();
        StringBuffer sbZone = new StringBuffer();
        int type = (Integer)param[0];
        boolean checkTrunkVsanMatchIsolation = (Boolean)param[2];
        for (int i = 0; i < vbl.size(); ++i) {
            int[] indices;
            int[] oid;
            int ifIndex;
            int OperStatusCause = vbl.intValue(i);
            SnmpVarBind vb = vbl.getVb(i);
            if (OperStatusCause == 2 || OperStatusCause == 12 || OperStatusCause == 29 || (ifIndex = (oid = vb.getOid().getValue())[oid.length - 1]) == 4094) continue;
            if (OperStatusCause == 25) {
                if (!checkTrunkVsanMatchIsolation) continue;
                if (sbVsan.length() != 0) {
                    sbVsan.append(",");
                }
                sbVsan.append(node.ifIndexToName(oid[oid.length - 2]));
                sbVsan.append(".VSAN");
                sbVsan.append(oid[oid.length - 1]);
                indices = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
                arrayVsanIndices.addElement(indices);
                continue;
            }
            if (OperStatusCause == 24) {
                if (sbZone.length() != 0) {
                    sbZone.append(",");
                }
                sbZone.append(node.ifIndexToName(oid[oid.length - 2]));
                sbZone.append(".VSAN");
                sbZone.append(oid[oid.length - 1]);
                indices = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
                arrayZoneIndices.addElement(indices);
                continue;
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(node.ifIndexToName(oid[oid.length - 2]));
            sb.append(".VSAN");
            sb.append(oid[oid.length - 1]);
            indices = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
            arrayindices.addElement(indices);
        }
        if (arrayindices.size() != 0) {
            Object[] row = new Object[]{node.toString(), type == 1 ? "Physical Trunk Failure" : "Logical Trunk Failure", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), (int[][])arrayindices.toArray((E[])new int[arrayindices.size()][]), type == 1 ? "InterfaceISLTrunkStatus" : "InterfacePCTrunkStatus", null, sb.toString())};
            reportList.add(row);
        }
        if (arrayVsanIndices.size() != 0) {
            Object[] row = new Object[]{node.toString(), type == 1 ? "Physical vsanMatchIsolation Trunk Failure" : "Logical vsanMatchIsolation Trunk Failure", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), (int[][])arrayVsanIndices.toArray((E[])new int[arrayVsanIndices.size()][]), type == 1 ? "InterfaceISLTrunkStatus" : "InterfacePCTrunkStatus", null, sbVsan.toString())};
            reportList.add(row);
        }
        if (arrayZoneIndices.size() != 0) {
            Object[] row = new Object[]{node.toString(), type == 1 ? "Physical Zone Merge Trunk Failure" : "Logical Zone Merge Trunk Failure", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), (int[][])arrayVsanIndices.toArray((E[])new int[arrayVsanIndices.size()][]), type == 1 ? "InterfaceISLTrunkStatus" : "InterfacePCTrunkStatus", null, sbZone.toString())};
            reportList.add(row);
        }
        return (Object[][])reportList.toArray((T[])new Object[reportList.size()][]);
    }

    static Object[][] addrowVsan(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        Array<Integer> vsanIndices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid;
            int ifIndex;
            SnmpVarBind vb = vbl.getVb(i);
            int adminState = vbl.intValue(i);
            if (adminState != 2 || (ifIndex = (oid = vb.getOid().getValue())[oid.length - 1]) == 4094) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(ifIndex);
            vsanIndices.addElement(new Integer(ifIndex));
        }
        if (sb.length() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = SHA_VSAN_SUSPENDED;
            int[][] theIndices = new int[vsanIndices.size()][1];
            for (int i = 0; i < vsanIndices.size(); ++i) {
                theIndices[i][0] = (Integer)vsanIndices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "physicalVsanTab", "vsan", null);
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowDmState(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        Array<Integer> arrayindices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid;
            int vsan;
            SnmpVarBind vb = vbl.getVb(i);
            int state = vbl.intValue(i);
            if (state != 11 && state != 12 || (vsan = (oid = vb.getOid().getValue())[oid.length - 1]) == 4094) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("VSAN" + vsan);
            arrayindices.addElement(new Integer(vsan));
        }
        if (sb.length() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "Domain Mgr Down";
            int[][] theIndices = new int[arrayindices.size()][1];
            for (int i = 0; i < arrayindices.size(); ++i) {
                theIndices[i][0] = (Integer)arrayindices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "dmTab", "dmRunning", sb.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowDmRole(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        Array<int[]> arrayindices = new Array<int[]>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int role = vbl.intValue(i);
            if (role != 4 && role != 5) continue;
            int[] oid = vb.getOid().getValue();
            int vsan = oid[oid.length - 2];
            int ifIndex = oid[oid.length - 1];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("VSAN" + vsan + ".");
            sb.append(((SwitchBase)node.getBaseObject()).ifIndexToName(ifIndex));
            int[] indices = new int[]{oid[oid.length - 2], oid[oid.length - 1]};
            arrayindices.addElement(indices);
        }
        if (sb.length() != 0) {
            Object[] row = new Object[]{node.toString(), "Domain Mgr I/f down or isolated", new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), (int[][])arrayindices.toArray((E[])new int[arrayindices.size()][]), "InterfaceISLDmIf", null, sb.toString())};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowNameServer(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            long rejs = vbl.longValue(i);
            if (rejs <= 0L) continue;
            int[] oid = vb.getOid().getValue();
            int vsan = oid[oid.length - 1];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("VSAN" + vsan);
        }
        if (sb.length() != 0) {
            Object[] row = new Object[]{node.toString(), "Name Server Rejects > 0", sb};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowRSCN(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        Array<Integer> arrayIndices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); i += 3) {
            long rscnReqRej = vbl.longValue(i);
            long swRscnReqRej = vbl.longValue(i + 1);
            long scrRej = vbl.longValue(i + 2);
            if (rscnReqRej <= 0L && swRscnReqRej <= 0L && scrRej <= 0L) continue;
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            int vsan = oid[oid.length - 1];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("VSAN" + vsan);
            arrayIndices.addElement(new Integer(vsan));
        }
        if (sb.length() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "RSCN Rejects > 0";
            int[][] theIndices = new int[arrayIndices.size()][1];
            for (int i = 0; i < arrayIndices.size(); ++i) {
                theIndices[i][0] = (Integer)arrayIndices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "fcAdvTab", "rscn", sb.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowWwn(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        long availWwnsType1 = vbl.longValue(0);
        long availWwnsTypeOther = vbl.longValue(1);
        if (availWwnsType1 == 0L || availWwnsTypeOther == 0L) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "WWN Mgr Empty";
            StringBuffer sb = new StringBuffer();
            if (availWwnsType1 == 0L) {
                sb.append("Type1,");
            }
            if (availWwnsTypeOther == 0L) {
                sb.append("Type2&5");
            }
            int[] indices = new int[]{index.getValue()[0]};
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), new int[][]{indices}, "wwnMgr", null, sb.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowZoneRej(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        StringBuffer sb = new StringBuffer();
        Array<Integer> arrayIndices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            long rejs = vbl.longValue(i);
            if (rejs <= 0L) continue;
            int[] oid = vb.getOid().getValue();
            int vsan = oid[oid.length - 1];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("VSAN" + vsan);
            arrayIndices.addElement(new Integer(vsan));
        }
        if (sb.length() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "Zone Server Rejects > 0";
            int[][] theIndices = new int[arrayIndices.size()][1];
            for (int i = 0; i < arrayIndices.size(); ++i) {
                theIndices[i][0] = (Integer)arrayIndices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "zoneStats", null, sb.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowFlashFreeSpace(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        int flashsize = vbl.intValue(0);
        long freeSpace = vbl.longValue(1);
        int freePercent = (int)((double)freeSpace * 100.0 / (double)flashsize);
        if (freePercent < 10) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "BootFlash Free Space";
            String err = "< 10%";
            int[][] flashIndex = new int[][]{{1, 1}};
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), flashIndex, "utilization", null, err);
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowLicenseViolate(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        if (vbl.intValue(0) == 1) {
            Object[] row = new Object[]{node.toString(), "License Warning", new SmHealthAnalysisDetail(node.getInetAddress(), node.getBase(), "licenseMgrTab", "lmFeatureUsage", "Violation or Grace Period < 30 days")};
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowFccViolation(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array<Integer> ifIndices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int congStates = vbl.intValue(i);
            if (congStates == 1) continue;
            int[] oid = vb.getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            ifIndices.addElement(new Integer(ifIndex));
        }
        if (ifIndices.size() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "FCC Congestion";
            int[] iList = new int[ifIndices.size()];
            for (int i = 0; i < ifIndices.size(); ++i) {
                iList[i] = (Integer)ifIndices.elementAt(i);
            }
            String strErrs = SnmpIntList.toString(iList, (IfIndexIf)((Object)node.getBaseObject()), true);
            int[][] theIndices = new int[ifIndices.size()][1];
            for (int i = 0; i < ifIndices.size(); ++i) {
                theIndices[i][0] = (Integer)ifIndices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "fccTab", "fccStats", strErrs);
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowPsmPort(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array<SmHAIndex> arrayIndices = new Array<SmHAIndex>();
        StringBuffer vsans = new StringBuffer();
        int curVsan = 0;
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int denialCnt = vbl.intValue(i);
            if (denialCnt == 0) continue;
            int[] oid = vb.getOid().getValue();
            int[] indices = new int[]{oid[oid.length - 3], oid[oid.length - 2], oid[oid.length - 1]};
            SmHAIndex haindex = new SmHAIndex(indices);
            arrayIndices.addElement(haindex);
            if (curVsan == indices[1]) continue;
            curVsan = indices[1];
            if (vsans.length() != 0) {
                vsans.append(",");
            }
            vsans.append("VSAN" + indices[1]);
        }
        if (arrayIndices.size() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "Port Security Violation Count > 0";
            SmHAIndex haindex = (SmHAIndex)arrayIndices.elementAt(0);
            int indexLen = haindex._index.length;
            int[][] theIndices = new int[arrayIndices.size()][indexLen];
            for (int i = 0; i < arrayIndices.size(); ++i) {
                haindex = (SmHAIndex)arrayIndices.elementAt(i);
                for (int j = 0; j < indexLen; ++j) {
                    theIndices[i][j] = haindex._index[j];
                }
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "portSecurityManagerTab", "psmPortViolations", vsans.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowPsmFabric(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array<SmHAIndex> arrayIndices = new Array<SmHAIndex>();
        StringBuffer vsans = new StringBuffer();
        int curVsan = 0;
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int denialCnt = vbl.intValue(i);
            if (denialCnt == 0) continue;
            int[] oid = vb.getOid().getValue();
            int[] indices = new int[]{oid[oid.length - 3], oid[oid.length - 2], oid[oid.length - 1]};
            SmHAIndex haindex = new SmHAIndex(indices);
            arrayIndices.addElement(haindex);
            if (curVsan == indices[1]) continue;
            curVsan = indices[1];
            if (vsans.length() != 0) {
                vsans.append(",");
            }
            vsans.append("VSAN" + indices[1]);
        }
        if (arrayIndices.size() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "Port Security Violation Count > 0";
            SmHAIndex haindex = (SmHAIndex)arrayIndices.elementAt(0);
            int indexLen = haindex._index.length;
            int[][] theIndices = new int[arrayIndices.size()][indexLen];
            for (int i = 0; i < arrayIndices.size(); ++i) {
                haindex = (SmHAIndex)arrayIndices.elementAt(i);
                for (int j = 0; j < indexLen; ++j) {
                    theIndices[i][j] = haindex._index[j];
                }
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "portSecurityManagerTab", "psmPortViolations", vsans.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowFcspAuthFailure(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array<Integer> ifIndices = new Array<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int authFailCnt = vbl.intValue(i);
            if (authFailCnt == 0) continue;
            int[] oid = vb.getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            ifIndices.addElement(new Integer(ifIndex));
        }
        if (ifIndices.size() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "FC-SP AuthFailed Count > 0";
            int[] iList = new int[ifIndices.size()];
            for (int i = 0; i < ifIndices.size(); ++i) {
                iList[i] = (Integer)ifIndices.elementAt(i);
            }
            String strErrs = SnmpIntList.toString(iList, (IfIndexIf)((Object)node.getBaseObject()), true);
            int[][] theIndices = new int[ifIndices.size()][1];
            for (int i = 0; i < ifIndices.size(); ++i) {
                theIndices[i][0] = (Integer)ifIndices.elementAt(i);
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "InterfaceFcsp", null, strErrs);
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowCfsMergeFailure(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        ArrayList<Object[]> responseData = new ArrayList<Object[]>();
        HashMap<String, String> physicalFeatureNames = new HashMap<String, String>();
        HashMap<String, StringBuffer> logicalFeatureNames2VsanIds = new HashMap<String, StringBuffer>();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int mergeStatus = vbl.intValue(i);
            if (mergeStatus != 3) continue;
            int[] oid = vb.getOid().getValue();
            String featureName = SnmpString.toString(oid, _cfsMergeStatusValueOid.length + 1, oid.length - 1);
            int cfsScope = oid[_cfsMergeStatusValueOid.length + 1 + oid[_cfsMergeStatusValueOid.length]];
            if (cfsScope == 2) {
                featureName = SnmpString.toString(oid, _cfsMergeStatusValueOid.length + 1, _cfsMergeStatusValueOid.length + 1 + oid[_cfsMergeStatusValueOid.length]);
                StringBuffer vsanIds = null;
                if (logicalFeatureNames2VsanIds.get(featureName) == null) {
                    vsanIds = new StringBuffer();
                    logicalFeatureNames2VsanIds.put(featureName, vsanIds);
                }
                if (vsanIds == null) continue;
                int vsanId = ((oid[oid.length - 4] & 0xFF) << 24) + ((oid[oid.length - 3] & 0xFF) << 16) + ((oid[oid.length - 2] & 0xFF) << 8) + (oid[oid.length - 1] & 0xFF);
                if (vsanIds.length() != 0) {
                    vsanIds.append(",");
                }
                vsanIds.append("VSAN" + vsanIds);
                continue;
            }
            if (physicalFeatureNames.get(featureName) != null) continue;
            physicalFeatureNames.put(featureName, featureName);
        }
        if (physicalFeatureNames.size() != 0) {
            for (String physicalFeatureName : physicalFeatureNames.keySet()) {
                Object[] row = new Object[]{node.toString(), "CFS Merge Failure", new SmHealthAnalysisDetail(node.getInetAddress(), node.getBase(), "deviceAliasTab", null, physicalFeatureName)};
                responseData.add(row);
            }
        }
        if (logicalFeatureNames2VsanIds.size() != 0) {
            for (String logicalFeatureName : logicalFeatureNames2VsanIds.keySet()) {
                StringBuffer vsanIds = (StringBuffer)logicalFeatureNames2VsanIds.get(logicalFeatureName);
                Object[] row = new Object[3];
                row[0] = node.toString();
                row[1] = "CFS Merge Failure";
                String descr = logicalFeatureName + ":" + vsanIds.toString();
                row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), node.getBase(), "deviceAliasTab", null, descr);
                responseData.add(row);
            }
        }
        if (responseData.size() > 0) {
            return (Object[][])responseData.toArray((T[])new Object[responseData.size()][]);
        }
        return null;
    }

    static Object[][] addrowZoneSetStatus(VarBindList vbl, SwitchImpl node, SnmpOID index, Object[] param) {
        Array<int[]> arrayIndices = new Array<int[]>();
        StringBuffer vsans = new StringBuffer();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int zonesetActivateStatus = vbl.intValue(i);
            if (zonesetActivateStatus != 2 && zonesetActivateStatus != 4) continue;
            int[] oid = vb.getOid().getValue();
            int[] indices = new int[]{oid[oid.length - 1]};
            arrayIndices.addElement(indices);
            if (vsans.length() != 0) {
                vsans.append(",");
            }
            vsans.append("VSAN" + indices[0]);
        }
        if (arrayIndices.size() != 0) {
            Object[] row = new Object[3];
            row[0] = node.toString();
            row[1] = "ZoneSet Activate Failure";
            int[][] theIndices = new int[arrayIndices.size()][1];
            for (int i = 0; i < arrayIndices.size(); ++i) {
                theIndices[i][0] = ((int[])arrayIndices.elementAt(i))[0];
            }
            row[2] = new SmHealthAnalysisDetail(node.getInetAddress(), (IfIndexIf)node.getBase(), theIndices, "zonesetMemberReport", "zoneActStatus", vsans.toString());
            return new Object[][]{row};
        }
        return null;
    }

    static Object[][] addrowCfsFeatureStatus(VarBindList[] vbl, SwitchImpl[] node, SnmpOID index, Object[] param) {
        ArrayList<Object[]> responseData = new ArrayList<Object[]>();
        int[] globalCfsOid = SwitchHealthCheckLogic.CFS_GLOBAL_OID;
        Object[][] cfsFeatureListQueried = SwitchHealthCheckLogic.CfsFeatureList;
        HashMap cfsFeatureStatus = new HashMap();
        Boolean hasGlobalFlagBeenChecked = false;
        for (int featureIndex = 0; featureIndex < cfsFeatureListQueried.length; ++featureIndex) {
            String descr;
            Object[] row;
            SnmpVarBind vb;
            SwitchImpl nextNode2;
            ArrayList<SwitchImpl> switchesWithCFSDisabledFeature = new ArrayList<SwitchImpl>();
            ArrayList<SwitchImpl> switchesFeatureDisabled = new ArrayList<SwitchImpl>();
            ArrayList<SwitchImpl> switchesWithCFSEnabledFeature = new ArrayList<SwitchImpl>();
            ArrayList<SwitchImpl> npvSwitchesSkippedAsFeatureNotSupported = new ArrayList<SwitchImpl>();
            for (int i = 0; i < node.length; ++i) {
                nextNode2 = node[i];
                vb = vbl[i].getVb(featureIndex);
                int value = vb.intValue();
                if (value == 3) {
                    switchesWithCFSDisabledFeature.add(nextNode2);
                    continue;
                }
                if (value == 0) {
                    if (nextNode2.isNpvEnabled() && !((Boolean)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_NPV_SUPPORTED]).booleanValue()) {
                        npvSwitchesSkippedAsFeatureNotSupported.add(nextNode2);
                        continue;
                    }
                    switchesFeatureDisabled.add(nextNode2);
                    continue;
                }
                if (value != 2) continue;
                switchesWithCFSEnabledFeature.add(nextNode2);
            }
            if (switchesWithCFSEnabledFeature.size() == 0 || switchesWithCFSEnabledFeature.size() + npvSwitchesSkippedAsFeatureNotSupported.size() >= node.length) continue;
            for (SwitchImpl nextNode2 : switchesWithCFSDisabledFeature) {
                row = new Object[3];
                row[0] = nextNode2;
                row[1] = cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_NAME] + " CFS";
                String descr2 = "Disabled, but at least one other switch in the fabric has this enabled.";
                String tabName = (String)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_DETAIL_TAB];
                String subCommand = (String)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_CFS_COMMAND];
                row[2] = new SmHealthAnalysisDetail(nextNode2.getInetAddress(), nextNode2.getBase(), tabName, subCommand, descr2);
                responseData.add(row);
            }
            for (SwitchImpl nextNode2 : switchesFeatureDisabled) {
                row = new Object[3];
                row[0] = nextNode2;
                row[1] = cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_NAME];
                String tabName = (String)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_DETAIL_TAB];
                String subCommand = (String)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_CTRL_COMMAND];
                descr = "Feature disabled, but at least one other switch in the fabric has the CFS enabled.";
                row[2] = new SmHealthAnalysisDetail(nextNode2.getInetAddress(), nextNode2.getBase(), tabName, subCommand, descr);
                responseData.add(row);
            }
            if (hasGlobalFlagBeenChecked.booleanValue()) continue;
            for (int i = 0; i < node.length; ++i) {
                nextNode2 = node[i];
                vb = vbl[i].getVb(cfsFeatureListQueried.length);
                int value = vb.intValue();
                if (value != 2) continue;
                Object[] row2 = new Object[3];
                row2[0] = nextNode2;
                row2[1] = "Global CFS";
                descr = "Disabled, but at least one switch in the fabric is using CFS for a feature.";
                String tabName = (String)cfsFeatureListQueried[featureIndex][SwitchHealthCheckLogic.CFS_FEATURE_LIST_DETAIL_TAB];
                row2[2] = new SmHealthAnalysisDetail(nextNode2.getInetAddress(), nextNode2.getBase(), "CFSTab", null, descr);
                responseData.add(row2);
            }
            hasGlobalFlagBeenChecked = true;
        }
        if (responseData.size() > 0) {
            return (Object[][])responseData.toArray((T[])new Object[responseData.size()][]);
        }
        return null;
    }
}

