/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.discovery.AbstractWorker;
import com.cisco.dcbu.sm.server.discovery.CdpDiscvHelper;
import com.cisco.dcbu.sm.server.discovery.DiscProc;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.HttpPeer;
import com.cisco.dcbu.sm.server.discovery.SyncedCdp;
import com.cisco.dcbu.sm.server.discovery.UcsManager;
import com.cisco.dcbu.sm.server.discovery.WorkerCallbackIf;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.CdpLink;
import com.cisco.dcbu.sm.server.model.CdpNode;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthNodeIf;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import java.util.HashSet;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;

public class EthNodeWorker
extends AbstractWorker {
    static final TraceLogger _Tracer = new TraceLogger(LogManager.getLogger((String)"fms.disc"), false, false, false, false);
    private static int _maxWait = 60;
    static final byte SYS_INFO = 1;
    static final byte SW_INFO = 2;
    static final byte CDP_NODE = 3;
    static final byte CDP_CACHE = 4;
    static final byte PORT_IFNAME = 5;
    static final byte PORT_INFO = 6;
    static final byte CDP_PORT = 7;
    static final byte PORT_CHANNEL = 8;
    static final byte PORT_VLAN = 9;
    static final byte FEATURES = 10;
    static final byte FABRICEXTENDER = 11;
    static final byte PORT_MODE = 12;
    static final byte VIRTUAL_PORT_CHANNEL = 13;
    static final String[] _DescrTable = new String[]{"systemInfo", "switchInfo", "nodeInfo", "cdpCache", "ifname", "ethPortInfo", "cdpPort", "ethPortChannel", "ethPortVlan", "features", "fex", "ethPortMode", "virtualPortChannel"};
    private EthNodeIf _workingNode;
    private SyncedCdp _syncedCdp;
    private DiscoveryType _discType;
    private NodeDiscProc[] _Procs = new NodeDiscProc[]{new NodeDiscProc(1, PlatformType.ANY, 1), new NodeDiscProc(2, PlatformType.ANY, 2), new NodeDiscProc(10, PlatformType.ANY, 512), new NodeDiscProc(3, PlatformType.ANY, 8), new NodeDiscProc(4, PlatformType.CDP, 4), new NodeDiscProc(7, PlatformType.CDP, 64), new NodeDiscProc(8, PlatformType.SWITCH, 128), new NodeDiscProc(5, PlatformType.CAT, 16), new NodeDiscProc(6, PlatformType.SWITCH, 32), new NodeDiscProc(11, PlatformType.ANY, 1024), new NodeDiscProc(9, PlatformType.SWITCH, 256), new NodeDiscProc(12, PlatformType.SWITCH, 2048), new NodeDiscProc(13, PlatformType.NEXUS, 4096)};

    public EthNodeWorker(EthNodeIf workingNode, WorkerCallbackIf observer, SyncedCdp syncedCdp, DiscoveryType discType) {
        if (workingNode.getInetAddress() == null) {
            throw new IllegalArgumentException(workingNode + " does not have a valid IP address");
        }
        this._workingNode = workingNode;
        this._observer = observer;
        this._syncedCdp = syncedCdp;
        this._discType = discType;
    }

    public EthNodeIf getWorkingNode() {
        return this._workingNode;
    }

    @Override
    protected void exec() throws Exception {
        SnmpPeer peer = this._workingNode.getPeer();
        if (peer == null) {
            _Tracer.log(Level.INFO, this.prefix() + "Skip no-peer node: " + this._workingNode);
            this._workingNode.setReachable(false);
            if (this._workingNode instanceof EthSwitchImpl) {
                ((EthSwitchImpl)this._workingNode).setManageable(false, "Unreachable");
            }
            if (this._workingNode instanceof CdpNode) {
                this._syncedCdp.updatePublishNode((CdpNode)this._workingNode);
            }
            return;
        }
        if (!CdpDiscvHelper.isNodeReachable(this._workingNode)) {
            _Tracer.log(Level.INFO, this.prefix() + "Skip unreachable node: " + this._workingNode);
            this._workingNode.setReachable(false);
            if (this._workingNode instanceof EthSwitchImpl) {
                ((EthSwitchImpl)this._workingNode).setManageable(false, "Unreachable");
                ((EthSwitchImpl)this._workingNode).resetPeer();
            } else if (this._workingNode instanceof CdpNode) {
                this._syncedCdp.updatePublishNode((CdpNode)this._workingNode);
                ((CdpNode)this._workingNode).resetPeer();
            }
            return;
        }
        this._workingNode.setReachable(true);
        if (this._workingNode instanceof EthSwitchImpl) {
            ((EthSwitchImpl)this._workingNode).setManageable(true, "");
        }
        for (NodeDiscProc proc : this._Procs) {
            boolean execed = false;
            if (this._status.get() == 1) {
                long time = System.currentTimeMillis();
                execed = proc.discover(this._workingNode);
                if (_Tracer.isDebuggable()) {
                    long dur = System.currentTimeMillis() - time;
                    _Tracer.log(Level.DEBUG, this.prefix() + proc + (execed ? " done in " + dur + " ms" : " skipped/failed after " + dur + " ms from node: " + this._workingNode));
                }
            } else if (this._status.get() == 2) {
                _Tracer.log(Level.WARN, this.prefix() + proc + " interrupted abruptly");
                return;
            }
            if (this._workingNode instanceof EthSwitchImpl) {
                EthSwitchImpl ethSw = (EthSwitchImpl)this._workingNode;
                ethSw.resetDiscFlag(proc._flag);
                if (execed) {
                    ethSw.syncLastScanTime();
                }
            }
            this.sendUpdate(proc);
        }
        if (this._workingNode instanceof EthSwitchImpl) {
            EthSwitchImpl ethsw = (EthSwitchImpl)this._workingNode;
            LanPersistentManager.getInstance().persistLanEthSwitch(ethsw);
            LanImpl lan = ethsw.getLan();
            if (lan != null) {
                lan.createNavGroup(ethsw);
            }
            HttpPeer.discoverUCSBlades(ethsw);
        }
        if (this._workingNode instanceof CdpNode) {
            this._syncedCdp.updatePublishNode((CdpNode)this._workingNode);
        }
    }

    public String toString() {
        if (this._workingNode != null) {
            return this._workingNode + "--EthNodeWorker";
        }
        return "Unknown -- EthNodeWorker";
    }

    public String prefix() {
        return this.toString() + ": ";
    }

    class NodeDiscProc
    extends DiscProc {
        final PlatformType _platfType;

        NodeDiscProc(byte step, PlatformType type, int flag) {
            super(step, flag);
            this._platfType = type;
        }

        public String toString() {
            return "discover " + _DescrTable[this._step - 1];
        }

        boolean discover(EthNodeIf node) throws DiscoveryException {
            boolean b = false;
            if (this._flag != 0 && !node.isDiscFlagSet(this._flag) || node.getPlatformType() != null && node.getPlatformType() != PlatformType.UNKNOWN && !PlatformType.isTypeOf(node.getPlatformType(), this._platfType)) {
                _Tracer.log(Level.DEBUG, EthNodeWorker.this.prefix() + this + " does not meet precondition: flagset=" + node.getDiscFlagsInString() + ", platformCheck=" + PlatformType.isTypeOf(node.getPlatformType(), this._platfType) + ", " + (Object)((Object)node.getPlatformType()));
                return false;
            }
            try {
                switch (this._step) {
                    case 1: {
                        b = CdpDiscvHelper.discoverSysInfo(node);
                        break;
                    }
                    case 2: {
                        b = CdpDiscvHelper.discoverSwitchInfo(node);
                        if (!(node instanceof EthSwitchImpl)) break;
                        UcsManager.getInstance().setIpAddresses((EthSwitchImpl)node);
                        break;
                    }
                    case 10: {
                        b = CdpDiscvHelper.discoverFeatures(node);
                        if (!(node instanceof EthSwitchImpl)) break;
                        EthSwitchImpl sw = (EthSwitchImpl)node;
                        if (!sw.getBase().isN5KVerLT521() && !sw.isFexEnabled()) break;
                        if (EthNodeWorker.this._discType == DiscoveryType.LAN_POLL) {
                            if (CdpDiscvHelper.checkHwChanged(sw)) {
                                sw.setDiscFlag(1024);
                                PKIf swPK = sw.getSwitchPK();
                                if (swPK instanceof VdcPK) {
                                    InventoryManager.getInstance().poll((VdcPK)swPK);
                                    break;
                                }
                                if (swPK instanceof SerialNumKey) {
                                    InventoryManager.getInstance().poll((SerialNumKey)swPK);
                                    break;
                                }
                                _Tracer.log(Level.WARN, "InventoryManager got unknown swPK for lanOpened:" + swPK);
                            }
                            break;
                        }
                        sw.setDiscFlag(1024);
                        break;
                    }
                    case 3: {
                        b = CdpDiscvHelper.discoverCdpNode(node);
                        break;
                    }
                    case 7: {
                        if (node instanceof CdpNode) {
                            CdpNode cnode = (CdpNode)node;
                            b = CdpDiscvHelper.discoverCdpPorts(cnode);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid cdp node:" + node);
                    }
                    case 4: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            HashSet<EthSwitchImpl> changedIpSws = new HashSet<EthSwitchImpl>();
                            HashSet<CdpLink> neighborLinks = new HashSet<CdpLink>();
                            b = CdpDiscvHelper.checkSwitchConns(ethSw, changedIpSws, neighborLinks);
                            if (b) {
                                if (changedIpSws.size() > 0) {
                                    LanImpl lan = DCManager.getInstance().getLan();
                                    for (EthSwitchImpl cSw : changedIpSws) {
                                        lan.getWorker().startEthNodeWorker(cSw);
                                    }
                                }
                                EthNodeWorker.this._syncedCdp.updateNeighbors(null, neighborLinks);
                            }
                            break;
                        }
                        if (node instanceof CdpNode) {
                            CdpNode cnode = (CdpNode)node;
                            HashSet<CdpNode> neighborNodes = new HashSet<CdpNode>();
                            HashSet<CdpLink> neighborLinks = new HashSet<CdpLink>();
                            b = CdpDiscvHelper.discoverCdpConns(cnode, neighborNodes, neighborLinks);
                            if (b) {
                                EthNodeWorker.this._syncedCdp.updateNeighbors(neighborNodes, neighborLinks);
                            }
                            break;
                        }
                        throw new IllegalArgumentException("Invalid Ethernent node:" + node);
                    }
                    case 11: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            LanImpl lan = DCManager.getInstance().getLan();
                            if (lan.findCdpSeedFromNodePK(ethSw.getPK()) == null) break;
                            b = CdpDiscvHelper.discoverFexAndLink(ethSw);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 8: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            b = CdpDiscvHelper.discoverEthChannelPorts(ethSw);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 5: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            b = CdpDiscvHelper.discoverEthPortIfname(ethSw);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 6: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            int[] oldIfIndexes = ethSw.getIfindexes();
                            int[] ifIndexes = CdpDiscvHelper.discoverIfIndexes(ethSw);
                            CdpDiscvHelper.removeNonExistEthPorts(ethSw, oldIfIndexes, ifIndexes);
                            b = CdpDiscvHelper.discoverEthPortInfo(ethSw, ifIndexes);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 9: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            if (ethSw.supportPortVlans()) {
                                b = CdpDiscvHelper.discoverEthPortVlans(ethSw);
                                break;
                            }
                            _Tracer.log(Level.INFO, EthNodeWorker.this.prefix() + this + " does not support port vlan query");
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 13: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            if (!Boolean.parseBoolean(System.getProperty("cdp.discoverLanVpcInfo", "true"))) break;
                            b = CdpDiscvHelper.discoverVirtualEthChannelPorts(ethSw);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                    case 12: {
                        if (node instanceof EthSwitchImpl) {
                            EthSwitchImpl ethSw = (EthSwitchImpl)node;
                            if (!Boolean.parseBoolean(System.getProperty("cdp.discoverLanInterfaceInfo", "true"))) break;
                            b = CdpDiscvHelper.discoverEthPortInfoByNetConf(ethSw);
                            break;
                        }
                        throw new IllegalArgumentException("Invalid EthSwitchImpl:" + node);
                    }
                }
            }
            catch (SnmpException se) {
                if (se.isUnmanageableError()) {
                    if (node instanceof EthSwitchImpl) {
                        if (se.isTimeOut()) {
                            if (this._step == 1) {
                                ((EthSwitchImpl)node).setManageable(false, se.getMessage());
                            } else {
                                ((EthSwitchImpl)node).setManageable(true, se.getMessage());
                            }
                        } else {
                            ((EthSwitchImpl)node).setManageable(false, se.getMessage());
                        }
                    }
                    _Tracer.log(Level.WARN, EthNodeWorker.this.prefix() + this + " caught snmp" + (se.isTimeOut() ? " timeout" : "") + " exception from " + (_Tracer.isDebuggable() ? node.getPrintString(true, true) : node.getPrintString(false, true)), se);
                    throw new DiscoveryException(this + " error: " + se.getMessage(), se);
                }
                _Tracer.log(Level.INFO, EthNodeWorker.this.prefix() + this + " caught snmp exception: " + se.getMessage() + " " + (_Tracer.isDebuggable() ? node.getPrintString(true, true) : node.getPrintString(false, true)), se);
            }
            catch (Exception ex) {
                if (!node.hasPeer()) {
                    throw new DiscoveryException(EthNodeWorker.this.prefix() + "peer failure");
                }
                if (ex instanceof DiscoveryException && ((DiscoveryException)ex).isCausedBySnmp()) {
                    _Tracer.log(Level.WARN, EthNodeWorker.this.prefix() + this + " caught exception: " + ex.getMessage());
                }
                _Tracer.log(Level.WARN, EthNodeWorker.this.prefix() + this + " caught exception: " + ex.getMessage(), ex);
            }
            return b;
        }
    }
}

