/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.sm.server.model.NtopImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class NtopWorker {
    private static final int IPADDR_COL = 0;
    private static final int WWN_COL = 1;
    private static final int NAME_COL = 2;
    private static final int DESCRP_COL = 3;
    private static final int NTOP_PORT = 3000;
    private static final String NTOP_DISCOVER_URL = "getNtopInfo.html";
    private static final int DISCOVER_TIMEOUT = 30;
    private int _nReqs;
    static HashMap _ntopBySWwwnSDIndex = new HashMap();
    private Integer _lock = new Integer(0);
    private Vector _threadList = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap search(String search) throws Exception {
        Object subnet;
        long startTime = System.currentTimeMillis();
        if (search.trim().length() == 0) {
            throw new Exception("Please supply search string");
        }
        this._nReqs = 0;
        StringTokenizer st = new StringTokenizer(search, ", ");
        while (st.hasMoreTokens()) {
            subnet = st.nextToken();
            int pos = ((String)subnet).indexOf(91);
            if (pos == -1) {
                this.discoverNtop(NTOP_DISCOVER_URL, InetAddress.getByName((String)subnet));
                ++this._nReqs;
                continue;
            }
            int delim = ((String)subnet).indexOf(45);
            int start = Integer.parseInt(((String)subnet).substring(++pos, delim));
            int end = Integer.parseInt(((String)subnet).substring(delim + 1, ((String)subnet).length() - 1));
            if (start < 1 || end > 254 || start > end) {
                throw new Exception("bad search: " + (String)subnet);
            }
            subnet = ((String)subnet).substring(0, pos - 1);
            for (int i = start; i <= end; ++i) {
                this.discoverNtop(NTOP_DISCOVER_URL, InetAddress.getByName((String)subnet + i));
                ++this._nReqs;
            }
        }
        subnet = this._lock;
        synchronized (subnet) {
            while (this._nReqs > 0) {
                if ((System.currentTimeMillis() - startTime) / 1000L > 30L) {
                    System.out.println("Stop ntop discovery after 30 seconds, " + this._nReqs + ": no response.");
                    break;
                }
                this._lock.wait(3000L);
            }
        }
        for (int i = 0; i < this._threadList.size(); ++i) {
            Thread t = (Thread)this._threadList.get(i);
            t.stop();
        }
        return _ntopBySWwwnSDIndex;
    }

    private void discoverNtop(String urlPage, InetAddress addr) {
        Poller poller = new Poller(urlPage, addr);
        Thread t = new Thread(poller);
        this._threadList.add(t);
        t.start();
    }

    public static String getHtml(String urlToRead) throws Exception {
        String line;
        StringBuffer result = new StringBuffer();
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NtopImpl getNtopInfo(String url, InetAddress inetAddr, int port) throws Exception {
        String html = NtopWorker.getHtml("http://" + inetAddr.getHostAddress() + ":" + port + "/" + url);
        String[] htmls = html.split("<Entry>");
        NtopImpl ntop = new NtopImpl(inetAddr.getHostName(), port);
        for (int i = 0; i < htmls.length; ++i) {
            try {
                NtopWorker.parseSpanInfo(htmls[i], ntop);
                continue;
            }
            catch (Exception ex) {
                System.out.println(inetAddr.getHostAddress() + " Ntop error: " + ex.getMessage());
                HashMap hashMap = _ntopBySWwwnSDIndex;
                synchronized (hashMap) {
                    _ntopBySWwwnSDIndex.put(ntop, ntop);
                    continue;
                }
            }
        }
        System.out.println(inetAddr.getHostAddress() + " finish discovering " + url + ", this server monitors " + ntop.getSpanInfos().size() + " span ports");
        return ntop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parseSpanInfo(String ntopM, NtopImpl ntop) throws Exception {
        int start = ntopM.indexOf("<SwitchIP>") + 10;
        int end = ntopM.indexOf("</SwitchIP>");
        if (start == -1 || end == -1 || start == end || end >= ntopM.length()) {
            throw new Exception("switch not found");
        }
        String swIp = ntopM.substring(start, end).trim().toLowerCase();
        start = ntopM.indexOf("<SwitchName>") + 12;
        end = ntopM.indexOf("</SwitchName>");
        String swName = "";
        if (start != -1 && end != -1 && start != end && end < ntopM.length()) {
            swName = ntopM.substring(start, end).trim().toLowerCase();
        }
        start = ntopM.indexOf("<SwitchPort>") + 12;
        end = ntopM.indexOf("</SwitchPort>");
        if (start == -1 || end == -1 || start == end || end >= ntopM.length()) {
            throw new Exception("switch port not found");
        }
        String sd = ntopM.substring(start, end).trim();
        int spIndex = IfIndexUtil.nameToIfIndex(sd);
        start = ntopM.indexOf("<IfName>") + 8;
        end = ntopM.indexOf("</IfName>");
        if (start == -1 || end == -1 || start == end || end >= ntopM.length()) {
            throw new Exception("Ntop ethernet interface name not found");
        }
        String ethN = ntopM.substring(start, end).trim();
        ntop.addSpanInfo(swIp, swName, spIndex, ethN);
        HashMap hashMap = _ntopBySWwwnSDIndex;
        synchronized (hashMap) {
            _ntopBySWwwnSDIndex.put(swIp + spIndex, ntop);
        }
    }

    class Poller
    implements Runnable {
        String _urlPage;
        InetAddress _addr;

        Poller(String urlPage, InetAddress addr) {
            this._urlPage = urlPage;
            this._addr = addr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NtopWorker.getNtopInfo(this._urlPage, this._addr, 3000);
            }
            catch (Exception ex) {
                System.out.println(this._addr.getHostAddress() + " discover " + this._urlPage + " error. " + ex.getMessage());
            }
            Integer n = NtopWorker.this._lock;
            synchronized (n) {
                NtopWorker.this._nReqs--;
                NtopWorker.this._threadList.remove(Thread.currentThread());
                NtopWorker.this._lock.notifyAll();
            }
        }
    }
}

