/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.mds.ficon.FiconPortAddrList;
import com.cisco.dcbu.lib.mds.zm.DefaultZoneAttributes;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCommunity;
import com.cisco.dcbu.lib.snmp.SnmpCounter;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.dto.FcPortRNIDInfo;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.ClusterInterfBase;
import com.cisco.dcbu.sm.common.model.ClusterMemberBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.CfsRegionPK;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SwitchIfWwnKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.discovery.CdpSnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.PortChannelWorker;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.CfsRegionImpl;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SnmpAdapter {
    static Logger _Log;
    static TraceLogger _Tracer;
    static final boolean _EnableIPFC;
    static final boolean _EnableFV;
    public static boolean _DisplayIVRZones;
    public static boolean _RetainSETPorts;
    public static boolean _ReturnDownPort;
    public static final boolean TrimDomain;
    public static final boolean AutoCdpDiscv;
    static final boolean _EnableVIRT;
    static final int CISCO_ENTERPRISE_ID = 9;
    static final int[] CISCO_CHASSIS_OID;
    static final int EntTable_serialNum_idx = 7;
    static final SnmpOID[] _GenSysVars;
    static final SnmpOID[] _MdsSysVars;
    static final SnmpOID[] _LunCacheVars;
    static final SnmpOID[] _IvrVars;
    static final SnmpOID[] _IvrEnfZoneVars;
    static final SnmpOID[] _IvrEnfZoneMbrVars;
    static final SnmpOID[] _FiconPortVars;
    static final int[][] _VsanOids;
    static final int[][] _ConnUnitOids;
    static final int[][] _ConnUnitLinkOids;
    static final int[][] _ConnUnitSnsOids;
    static final int[][] _EntityOids;
    static final int[][] _FcsIeOids;
    static final int[][] _FspfLsdbOids;
    static final int[][] _FcnsOids;
    static final int[][] _EnfZonesetOids;
    static final int[][] _EnfZoneOids;
    static final int[][] _EnfZoneMbrOids;
    static final int[][] _TargetOids;
    static final int[][] _HbaOids;
    static final int[][] _HbaPortOids;
    static final int[][] _LicenseOids;
    static final int[][] _LicReqOids;
    static final int[][] _FcIfRNIDOids;
    static final int[][] _VfcBinding_Oids;
    static final int[][] _Flogi_Oids;
    static final int[][] _CiscoVdcOids;
    static final int[] _FcnsSymNodeNameOid;
    static final int[] _FcnsSymPortNameOid;
    static final int[] _FcnsNodeIpAddrOid;
    static final int[] _FeatureOid;
    static final int[] _FiconVsanOid;
    static final int[] _FcsMgmtAddrOid;
    static final int[] _ZoneMbrFmtOid;
    static final int[] _ZoneMbrIdOid;
    static final int[] _FeModuleNameOid;
    static final int[] _ConnUnitRevOid;
    static final int[] _VsanWwnOid;
    static final int[] _FeatureSetStatusOid;
    static final SnmpOID _LunDiscSpinLockVar;
    static final SnmpOID _LunDiscTypeVar;
    static final SnmpOID _LunDiscVsanVar;
    static final SnmpOID _LunDiscPortVar;
    static final SnmpOID _StartLunDiscVar;
    static final SnmpOID _LunDiscStatusVar;
    static final SnmpOID _FlogiCountVar;
    static final SnmpOID _FlogiPortVar;
    static final SnmpOID _VedmVeNameVar;
    static final SnmpOID _VedmVepPWwnVar;
    static final SnmpOID _TrapTargetVar;
    static final SnmpOID _SyslogTargetType;
    static final SnmpOID _SyslogTargetVar;
    static final SnmpOID _FiconPortMaxVar;
    static final SnmpOID _FiconPortMapVar;
    static final SnmpOID _CiscoNumLicOid;
    static final SnmpOID _DaChecksumVar;
    static final SnmpOID _SsmFeatureVar;
    static final SnmpOID _SsmSsnFeatureVar;
    static final SnmpOID _ClusterInterfaceVar;
    static final SnmpOID _SmeChgChkVar;
    static final SnmpOID _FcipLinkEthIfIndexVar;
    static final SnmpOID _FcipLinkIfIndexVar;
    static final SnmpOID _CfsFeatureOpShowCfgVar;
    static final SnmpOID _BaseSvcClusterInterfaceVar;
    static final SnmpOID _BaseSvcChgChkVar;
    static final SnmpOID _CfsRegionVar;
    static final SnmpOID _cfcoeVlanOperStateVar;
    static final SnmpOID _cficonLogicReservedPNVar;
    static final int[] _CiscoChassisOid;
    static final int[][] _CiscoCardOids;
    static final int[][] _CiscoPowerOids;
    static final int[] _CiscoFanOid;
    static final int[] _FcIfOperStatusOid;
    static final int[] _FcIfGigEPortChannIfOid;
    static final int[] _ClmPortLicensingOperOid;
    static final int[] _CfcoeVfcIfIndexOid;
    static final int[][] _FcIfOids;
    static final int[][] _FcGigEthernetIfOids;
    static final int[][] _ZoneAliasOids;
    static final int[][] _DefZoneOids;
    static final SnmpOID[] _EntChgChkVars;
    static final SnmpOID[] _ConnUnitZonesetVars;
    static final SnmpOID[] _ConnUnitZonesVars;
    static final int[][] _ConnUnitPortOids;
    static final SnmpOID[] _DeviceAliasCfgVars;
    static final SnmpOID[] _ConnUnitAliasVars;
    static final SnmpOID[] _QuailVars;
    static final SnmpOID[] _SMEClusterVars;
    static final SnmpOID[] _SMEInterfaceVars;
    static final SnmpOID[] _BaseSvcClusterVars;
    static final SnmpOID[] _BaseSvcInterfaceVars;
    static final int[][] _McDataConnUnitOids;
    public static final int[] VIGLESS_VETH_BINDING_IF_OID;
    static final int LUN_DISC_TIMEOUT = 15000;

    public static boolean isFVEnabled() {
        return _EnableFV;
    }

    public static boolean discoverSysInfo(SwitchImpl sw) throws SnmpException {
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_GenSysVars.length));
        for (int i = 0; i < _GenSysVars.length; ++i) {
            reqPdu.addNull(_GenSysVars[i]);
        }
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        SnmpVar var = rspPdu.getVar(0);
        if (var.getType() != 6) {
            throw new SnmpException(sw + " returned bad sysObjectID");
        }
        int[] sysObjectID = ((SnmpOID)rspPdu.getVar(0)).getValue();
        sw.setSysObjectID(sysObjectID);
        sw.setMDS(false);
        if (sysObjectID.length >= 7) {
            int vendorOid = sysObjectID[6];
            if (vendorOid == 9) {
                sw.setVendor("Cisco");
                int type = sysObjectID[sysObjectID.length - 1];
                if (SnmpOID.startsWith(sysObjectID, CISCO_CHASSIS_OID)) {
                    sw.setModelType(type);
                    sw.setModelName(FRUConstants.getMDSModelName(type));
                    sw.setMDS(type != 514);
                } else {
                    sw.setModelType(type);
                }
            } else if (vendorOid == 289) {
                sw.setVendor("McData");
            } else if (vendorOid == 1588) {
                sw.setVendor("Brocade");
            } else if (vendorOid == 5808) {
                sw.setVendor("InRange");
            } else if (vendorOid == 1663 || vendorOid == 3873) {
                sw.setVendor("QLogic");
            } else {
                _Log.debug((Object)(sw.getIpAddress() + " has unknown sysOid=" + Arrays.toString(sysObjectID)));
            }
        }
        sw.setSysDescr(vbl.stringValue(1));
        sw.setSysUpTime(vbl.longValue(2));
        sw.setContact(vbl.stringValue(3));
        sw.setSysName(vbl.stringValue(4));
        sw.setLocation(vbl.stringValue(5));
        sw.setManageable(true, null);
        sw.resetDiscFlag(1);
        return true;
    }

    public static boolean discoverSwitchInfo(SwitchImpl sw) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverMdsInfo(sw);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverQuailInfo(sw);
        }
        SnmpOID verOid = null;
        String vendor = sw.getVendor();
        if (vendor == null) {
            return false;
        }
        if (vendor.equals("Brocade") || vendor.equals("InRange")) {
            int[] oid = new int[]{1, 3, 6, 1, 3, 94, 1, 7, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
            if (sw.getWwn() == null) {
                return false;
            }
            byte[] wwn = sw.getWwn().getValue();
            for (int i = 0; i < 8; ++i) {
                oid[i + 10] = wwn[i] & 0xFF;
            }
            verOid = new SnmpOID(oid);
        } else if (vendor.equals("QLogic") && sw.getWwn() != null) {
            int[] indices = new int[17];
            GenUtil.arraycopy(sw.getWwn().getValue(), 0, indices, 0, 8);
            indices[16] = 1;
            verOid = new SnmpOID(_ConnUnitRevOid, indices);
        } else if (vendor.equals("Cisco")) {
            verOid = new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 2);
        } else {
            return false;
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addNull(verOid);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        sw.setVersion(rspPdu.getVariables().stringValue(0));
        sw.resetDiscFlag(2);
        return true;
    }

    public static boolean discoverVpnInfo(SwitchImpl sw) {
        if (sw == null) {
            return false;
        }
        if (SnmpSession.getInstance().getLocalVPNAddress() == null) {
            String localSvrIp = NetUtil.getLocalServerHostAddress();
            SnmpSession.getInstance().setLocalHost(localSvrIp);
            if (localSvrIp != null && !NetUtil.isLocalHost(localSvrIp)) {
                SanManager.getSnmpSession().setLocalVPNAddress(localSvrIp);
            }
        }
        sw.resetDiscFlag(65536);
        return true;
    }

    public static boolean discoverMdsInfo(SwitchImpl sw) throws SnmpException {
        SnmpVar var;
        int max;
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_MdsSysVars.length));
        int n = max = sw.getWwn() == null ? _MdsSysVars.length : _MdsSysVars.length - 1;
        for (int i = 0; i < max; ++i) {
            reqPdu.addNull(_MdsSysVars[i]);
        }
        reqPdu.setTimeout(sw.createPeer().getTimeout() * 2);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        if (vbl.get(0).getVar().getType() == 66) {
            sw.setSwitchLastBootTime(System.currentTimeMillis() - vbl.longValue(0) * 1000L);
        }
        sw.setFcnsTableLastChange(vbl.longValue(1));
        sw.setNumVsanConfigured(vbl.intValue(2) - 1);
        sw.setVsanLastChange(vbl.longValue(3));
        sw.setIsLicenseViolation(vbl.intValue(4) == 1);
        sw.setTelnetEnabled(vbl.intValue(5) == 1);
        sw.setDeviceAliasMode(vbl.intValue(6));
        sw.setIvrShowCfg(vbl.intValue(7));
        sw.setDeviceAliasShowCfg(vbl.intValue(8));
        sw.setSSHEnabled(vbl.intValue(9) == 1);
        sw.setCfsFeatureOpStatus(vbl.intValue(10));
        sw.setSysCpuUsage(vbl.intValue(11));
        sw.setSysMemoryUsage(vbl.intValue(12));
        sw.setDelayLinkEnabled(vbl.intValue(13) == 1);
        sw.setSysLastBootTime(System.currentTimeMillis() - vbl.longValue(14) * 10L);
        sw.setManageable(true, null);
        if (vbl.size() == _MdsSysVars.length && (var = vbl.getVb(_MdsSysVars.length - 1).getVar()).getType() == 4) {
            sw.setWwn(new Wwn(((SnmpString)var).getValue()));
        }
        if (sw.isN7K()) {
            SnmpAdapter.discoverVdcInfo(sw);
        }
        SnmpAdapter.discoverDefaultZoneAttrs(sw);
        sw.resetDiscFlag(2);
        return true;
    }

    public static boolean discoverDefaultZoneAttrs(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(_DefZoneOids.length);
        for (int i = 0; i < _DefZoneOids.length; ++i) {
            vbl.add(_DefZoneOids[i]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Log.isTraceEnabled()) {
            _Log.trace((Object)(sw + " discoverDefaultZoneAttrs response=" + rspVbl));
        }
        HashMap<Short, DefaultZoneAttributes> zoneAttrs = new HashMap<Short, DefaultZoneAttributes>(5);
        int k = 0;
        while (k < rspVbl.size()) {
            SnmpVarBind vb = rspVbl.getVb(k);
            if (vb == null || vb.getVar() == null) continue;
            int[] oid = vb.getOid().getValue();
            short vsanId = (short)oid[oid.length - 1];
            DefaultZoneAttributes defZone = new DefaultZoneAttributes();
            defZone._defaultZonePolicy = rspVbl.intValue(k++);
            defZone._readOnly = rspVbl.intValue(k++) == 1;
            defZone._qos = rspVbl.intValue(k++) == 1;
            defZone._qosPriority = rspVbl.intValue(k++);
            defZone._broadcast = rspVbl.intValue(k++) == 1;
            defZone._zonePropagation = rspVbl.intValue(k++);
            zoneAttrs.put(vsanId, defZone);
        }
        sw.setVsanZoneAttrs(zoneAttrs);
        return true;
    }

    public static boolean discoverVdcInfo(SwitchImpl sw) throws SnmpException {
        if (!sw.getBase().isVdcCapableVersion()) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw + " skip vdc info discovery and set as non-vdc"));
            }
            sw.setVdc(false);
            sw.setVdcId(-1);
            sw.setVdcFCoECapability((short)-1);
            sw.setVdcMacAddress(null);
            return false;
        }
        VarBindList vbl = new VarBindList(_CiscoVdcOids.length);
        for (int i = 0; i < _CiscoVdcOids.length; ++i) {
            vbl.add(_CiscoVdcOids[i]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Log.isTraceEnabled()) {
            _Log.trace((Object)(sw + " discoverVdcInfo response=" + rspVbl));
        }
        try {
            if (rspVbl.size() < _CiscoVdcOids.length || rspVbl.getVb(0) == null || rspVbl.getVb(0).getVar() == null || rspVbl.getVb(0).getVar().isNullType()) {
                if (_Tracer.isDebuggable()) {
                    _Tracer.log(Level.DEBUG, sw.getIpAddress() + " cannot get vdcInfo from snmp query");
                }
                return false;
            }
            int[] oid = rspVbl.getVb(0).getOid().getValue();
            int vdcId = oid[oid.length - 1];
            int k = 0;
            String vdcName = rspVbl.stringValue(k++);
            int state = rspVbl.intValue(k++);
            short fcoeCapable = (short)rspVbl.intValue(k++);
            String vdcMacStr = rspVbl.stringValue(k++);
            MacAddress vdcMac = new MacAddress(vdcMacStr);
            String parentMacStr = rspVbl.stringValue(k++);
            MacAddress parentVdcMac = new MacAddress(parentMacStr);
            sw.getBase().setVdc(true);
            sw.setVdcId(vdcId);
            sw.setVdcFCoECapability(fcoeCapable);
            sw.setVdcMacAddress(vdcMac);
        }
        catch (Exception e) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw + " discoverVdcInfo: did not return valid data, cannot discover vdc"), (Throwable)e);
            } else {
                _Log.warn((Object)(sw + " discoverVdcInfo: did not return valid data, cannot discover vdc"));
            }
            sw.setVdc(false);
            sw.setVdcId(-1);
            sw.setVdcFCoECapability((short)-1);
            return false;
        }
        return true;
    }

    public static boolean discoverQuailInfo(SwitchImpl sw) throws SnmpException {
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_QuailVars.length));
        for (int i = 0; i < _QuailVars.length - 1; ++i) {
            reqPdu.addNull(_QuailVars[i]);
        }
        if (sw.getWwn() == null) {
            reqPdu.addNull(_QuailVars[_QuailVars.length - 1]);
        } else {
            int[] indices = new int[17];
            byte[] b = sw.getWwn().getValue();
            GenUtil.arraycopy(b, 0, indices, 0, 8);
            indices[16] = 1;
            reqPdu.addNull(new SnmpOID(_ConnUnitRevOid, indices));
        }
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        sw.setNumConnUnits(vbl.intValue(0));
        sw.setStatusChangeTime(vbl.longValue(1));
        sw.setConfigChangeTime(vbl.longValue(2));
        sw.setConnUnitTableChangeTime(vbl.longValue(3));
        sw.setNumSnsEntries(vbl.intValue(4));
        sw.setNumFeModules(vbl.intValue(5));
        if (vbl.getVb(6).getOid().startsWith(_ConnUnitRevOid)) {
            sw.setVersion(vbl.stringValue(6));
        } else {
            sw.setWwn(new Wwn(vbl.byteValue(6)));
        }
        sw.setManageable(true, null);
        sw.resetDiscFlag(2);
        return true;
    }

    public static boolean discoverMdsFeatures(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(AbstractSwitchBase.NUM_FEATURES);
        for (int i = 1; i <= AbstractSwitchBase.NUM_FEATURES; ++i) {
            vbl.add(_FeatureOid, i);
        }
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = sw.createPeer().send(pdu);
        vbl = pdu.getVariables();
        boolean[] flags = new boolean[AbstractSwitchBase.NUM_FEATURES];
        for (SnmpVarBind vb : vbl) {
            int featureIndex = vb.getOid().getIndexFromEnd(0) - 1;
            SnmpVar var = vb.getVar();
            if (var == null || var.isNullType()) {
                flags[featureIndex] = false;
                continue;
            }
            flags[featureIndex] = ((SnmpInt)var).getValue() == 2;
        }
        if (!sw.isN5K() && sw.getBase().isFCoECapableVersion()) {
            int fcoeFeatureSetOpStatus = SnmpAdapter.discoverFCoEFeatureSet(sw);
            if (fcoeFeatureSetOpStatus != -1) {
                sw.setFCoEFeatureSetStatus(fcoeFeatureSetOpStatus);
                if (fcoeFeatureSetOpStatus == AbstractSwitchBase.FeatureStatus.enabled.value()) {
                    flags[AbstractSwitchBase.Feature.FCOE.flag()] = true;
                }
            } else {
                sw.setFCoEFeatureSetStatus(AbstractSwitchBase.FeatureStatus.uninstalled.value());
            }
        }
        sw.setFeatureFlags(flags);
        if (_Log.isTraceEnabled()) {
            _Log.trace((Object)(sw + " switchFeatures=" + sw.getBase().getFeatureString()));
        }
        sw.resetDiscFlag(8);
        if (sw.getBase().isFCoEEnabled()) {
            sw.setDiscFlag(32768);
            SnmpAdapter.discoverFCoEVlans(sw);
        }
        return true;
    }

    public static int discoverFCoEFeatureSet(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FeatureSetStatusOid, AbstractSwitchBase.FeatureSet.FCOE.mibIndex());
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        try {
            pdu = sw.getPeer().send(pdu);
        }
        catch (Exception ex) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, sw.getIpAddress() + " failed to discoverFCoEFeatureSet: featureSet mib not supported", ex);
            }
            return -1;
        }
        vbl = pdu.getVariables();
        if (vbl.size() < 1 || vbl.get(0).getVar() == null || vbl.get(0).getVar().isNullType()) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, sw.getIpAddress() + " failed to discoverFCoEFeatureSet: featureSet mib not supported:" + vbl);
            }
            return -1;
        }
        int index = vbl.getVb(0).getOid().getIndexFromEnd(0);
        if (index != AbstractSwitchBase.FeatureSet.FCOE.mibIndex()) {
            return -1;
        }
        return ((SnmpInt)vbl.get(0).getVar()).getValue();
    }

    public static void discoverFCoEVlans(SwitchImpl sw) throws SnmpException {
        SnmpVarBind vb;
        SnmpOID oid;
        if (!sw.getBase().isFCoEEnabled()) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(1));
        pdu.addNull(_cfcoeVlanOperStateVar);
        pdu.setMaxRptr(12);
        SnmpPDU rspPdu = sw.createPeer().send(pdu);
        VarBindList rspVbl = rspPdu.getVariables();
        HashMap<Short, Short> vlanByVsanMap = new HashMap<Short, Short>(rspVbl.size());
        for (int i = 0; i < rspVbl.size() && (oid = (vb = rspVbl.getVb(i)).getOid()).startsWith(_cfcoeVlanOperStateVar); ++i) {
            short vsanId = (short)oid.getIndexFromEnd(0);
            short vlanId = (short)oid.getIndexFromEnd(1);
            boolean isUp = vb.intValue() == 1;
            vlanByVsanMap.put(vsanId, vlanId);
        }
        sw.setVlanByVsanMap(vlanByVsanMap);
    }

    public static boolean discoverConnUnitInfo(SwitchImpl sw) throws SnmpException {
        SnmpPDU rspPdu;
        int i;
        int[] indices = new int[16];
        Wwn wwn = sw.getWwn();
        if (wwn != null) {
            byte[] b = wwn.getValue();
            for (int i2 = 0; i2 < 8; ++i2) {
                indices[i2] = b[i2] & 0xFF;
            }
        }
        Object oids = sw.getVendor().equals("McData") ? _McDataConnUnitOids : (Object)new int[][]{_ConnUnitOids[0], _ConnUnitOids[1], _ConnUnitOids[2]};
        VarBindList vbl = new VarBindList(_ConnUnitOids.length);
        SnmpPDU reqPdu = new SnmpPDU(vbl);
        if (wwn != null) {
            reqPdu.setCommand((byte)-96);
            for (i = 0; i < ((int[][])oids).length; ++i) {
                vbl.add(oids[i], indices);
            }
        } else {
            reqPdu.setCommand((byte)-95);
            for (i = 0; i < ((int[][])oids).length; ++i) {
                vbl.add(oids[i]);
            }
        }
        if ((vbl = (rspPdu = sw.createPeer().send(reqPdu)).getVariables()).getVb(0).getOid().startsWith(reqPdu.getOid(0))) {
            sw.setConnUnitStatus(vbl.intValue(0));
            if (wwn == null) {
                byte[] b = new byte[8];
                int[] oid = vbl.getVb(0).getOid().getValue();
                GenUtil.arraycopy(oid, oid.length - 16, b, 0, 8);
                sw.setWwn(new Wwn(b));
            }
        }
        if (vbl.getVb(1).getOid().startsWith(reqPdu.getOid(1))) {
            sw.setNumFcPorts(vbl.intValue(1));
        }
        if (vbl.getVb(2).getOid().startsWith(reqPdu.getOid(2))) {
            sw.setSerialNumber(vbl.stringValue(2));
        }
        sw.resetDiscFlag(4);
        return true;
    }

    public static boolean discoverVsans(SwitchImpl sw) throws SnmpException {
        int i;
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), SnmpAdapter.buildVbl(_VsanOids, 0), sw.getNumVsanConfigured());
        VarBindList rspVbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        HashMap<Short, VsanImpl> vsansToQuery = new HashMap<Short, VsanImpl>();
        HashSet<VsanPK> oldVids = new HashSet<VsanPK>();
        VsanDomain[] domainIds = sw.getVsanDomains();
        if (domainIds != null && domainIds.length > 0) {
            for (int i2 = 0; i2 < domainIds.length; ++i2) {
                oldVids.add(domainIds[i2]._vsanPK);
            }
        }
        VarBindList vwwnVbl = new VarBindList();
        String inVsanStr = fabric.getIncludedVsanList();
        String exVsanStr = fabric.getExcludedVsanList();
        long[] inVsans = inVsanStr == null ? null : SnmpLongList.parse(inVsanStr);
        long[] exVsans = exVsanStr == null ? null : SnmpLongList.parse(exVsanStr);
        ArrayList<Integer> inVids = new ArrayList<Integer>();
        ArrayList<Integer> exVids = new ArrayList<Integer>();
        for (i = 0; inVsans != null && i < inVsans.length; ++i) {
            inVids.add(new Integer((int)inVsans[i]));
        }
        for (i = 0; exVsans != null && i < exVsans.length; ++i) {
            exVids.add(new Integer((int)exVsans[i]));
        }
        for (i = 0; i < rspVbl.size(); i += _VsanOids.length) {
            SnmpVarBind vb = rspVbl.getVb(i);
            short vid = (short)vb.getOid().getIndexFromEnd(0);
            if (inVids.size() > 0 && !inVids.contains(new Integer(vid)) || exVids.size() > 0 && exVids.contains(new Integer(vid))) continue;
            byte operState = (byte)rspVbl.intValue(i + 4);
            byte[] vwwn = rspVbl.byteValue(i + 2);
            byte[] prinwwn = rspVbl.byteValue(i + 3);
            SwitchVersion requiredVersion = new SwitchVersion("5.0(1a)");
            SwitchVersion thisVersion = new SwitchVersion(sw.getVersion());
            if (GenUtil.isValueFilled(prinwwn, (byte)0) || vid == 4094 || prinwwn.length != 8 || vid == 4079 && !thisVersion.lessThan(requiredVersion)) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " --- toss the isolated or suspended vsan with vid:" + vid + ", prinwwn=" + SnmpString.toHexString(prinwwn) + ", opState=" + operState));
                continue;
            }
            String vsanName = vb.getVar().toString();
            if (vsanName == null || vsanName.length() == 0) {
                vsanName = "VSAN" + vid;
            }
            short domainId = (short)rspVbl.intValue(i + 1);
            byte adminState = (byte)rspVbl.intValue(i + 5);
            byte interop = (byte)rspVbl.intValue(i + 6);
            int mtu = rspVbl.intValue(i + 7);
            byte lbType = (byte)rspVbl.intValue(i + 8);
            boolean ioDelivery = rspVbl.intValue(i + 9) == 1;
            int latency = rspVbl.intValue(i + 10);
            VsanPK vkey = new VsanPK(vid, new Wwn(prinwwn));
            VsanImpl vsan = fabric.createVsan(vkey, vsanName, adminState, operState, interop, mtu, lbType, ioDelivery, latency);
            vsan.addSwitch(sw, domainId, new Wwn(vwwn));
            oldVids.remove(vkey);
            if (interop == 4) {
                vwwnVbl.add(_VsanWwnOid, vid);
            }
            if (vsan.getSeed() == null) {
                vsan.setSeed(sw);
            }
            if (vsan.getSeed() == sw) {
                vsansToQuery.put(vid, vsan);
            }
            vsan.syncLastScanTime();
            SnmpVar var = rspVbl.getVb(i + 11).getVar();
            if (var.getType() != 66 || !vsan.setFspfCheckSum(((SnmpUnsignedInt)var).getValue())) continue;
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vid + " FSPF checkSum differ"));
        }
        for (VsanPK vpk : oldVids) {
            VsanImpl v = fabric.findVsan(vpk);
            if (v == null) continue;
            v.removeSwitch(sw);
            if (!_Log.isDebugEnabled()) continue;
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vpk._id + "," + vpk._prinSwwn + " disappeared"));
        }
        if (vwwnVbl.size() != 0) {
            rspPdu = sw.createPeer().send(new SnmpPDU(-96, vwwnVbl));
            rspVbl = rspPdu.getVariables();
            for (SnmpVarBind vb : rspVbl) {
                SnmpVar var = vb.getVar();
                short vid = (short)vb.getOid().getIndexFromEnd(0);
                VsanDomain vdk = sw.getVsanDomain(vid);
                if (var.getType() != 4 || vdk == null) continue;
                Wwn vwwn = new Wwn(((SnmpString)var).getValue());
                vdk.setVsanWwn(vwwn);
            }
        }
        if (vsansToQuery.size() != 0) {
            if (fabric.isDiscovering()) {
                fabric.getWorker().startVsanWorker(sw, vsansToQuery);
            } else {
                DiscoveryManager.getInstance().discoverVsans(vsansToQuery.values());
            }
        }
        sw.resetDiscFlag(16);
        return true;
    }

    public static boolean discoverFiconPorts(SwitchImpl sw) throws SnmpException {
        if (!sw.isFeatureEnabled(AbstractSwitchBase.Feature.FICON.flag()) || !sw.hasFiconVsan()) {
            sw.resetDiscFlag(128);
            sw.setFiconPortRange(null);
            return false;
        }
        if (sw.isVersionGreaterThanEqual("3.0")) {
            SnmpAdapter.discoverFiconPorts30(sw);
        } else {
            SnmpAdapter.discoverFiconPorts20(sw);
        }
        sw.resetDiscFlag(128);
        return SnmpAdapter.discoverFiconPortRange(sw);
    }

    public static void discoverFiconPorts30(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(_FiconPortMaxVar);
        pdu = sw.createPeer().send(pdu);
        SnmpVar var = pdu.getVar(0);
        int max = 0;
        if (var.getType() == 65) {
            max = (int)((SnmpCounter)var).getValue();
        } else if (var.getType() == 2) {
            max = ((SnmpInt)var).getValue();
        }
        if (max == 0) {
            return;
        }
        vbl.clear();
        vbl.add(new SnmpVarBind(_FiconPortMapVar));
        pdu = SnmpFetch.getBulk(sw.createPeer(), vbl, max);
        vbl = pdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        HashMap<Long, EndPortImpl> portByVif = new HashMap<Long, EndPortImpl>();
        int imax = vbl.size();
        for (int i = 0; i < imax; ++i) {
            byte[] bmap = vbl.byteValue(i);
            int jmax = bmap.length / 7 * 7;
            for (int j = 0; j < jmax; j += 7) {
                IslImpl isl;
                int unitType = bmap[j] & 0xFF;
                int ifIndex = SnmpIntList.bytesToInt(bmap, j + 2);
                if (ifIndex == 0) continue;
                FcPortBase fport = sw.findPort(ifIndex);
                if (fport == null) {
                    _Log.warn((Object)(sw.getIpAddress() + " -- can not find ficon port " + ifIndex));
                    continue;
                }
                short ficonAddr = (short)(bmap[j + 1] & 0xFF);
                fport.setFiconAddress(ficonAddr);
                if (fport.getIfOperMode() == 2 || fport.getIfOperMode() == 3 || fport.getIfOperMode() == 6 || fport.getIfOperMode() == 13) {
                    ArrayList<EndPortImpl> eps = fabric.findEndPortsBySwitchIfIndex(sw, ifIndex);
                    if (eps == null) continue;
                    for (EndPortImpl ep : eps) {
                        ep.setFiconAddress(ficonAddr);
                        portByVif.put(((long)ep.getVsan() << 32) + (long)ifIndex, ep);
                    }
                    continue;
                }
                if (fport.getIfOperMode() != 4 && fport.getIfOperMode() != 12 || (isl = fabric.findIsl(sw, ifIndex)) == null) continue;
                isl.setFiconAddress(ifIndex, ficonAddr);
            }
        }
        if (portByVif.size() != 0) {
            SnmpAdapter.discoverFiconRNIDInfo(sw, portByVif);
        }
    }

    public static void discoverFiconPorts20(SwitchImpl sw) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(_FiconPortVars.length));
        for (int i = 0; i < _FiconPortVars.length; ++i) {
            pdu.addNull(_FiconPortVars[i]);
        }
        pdu = sw.createPeer().send(pdu);
        VarBindList vbl = pdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        HashMap<Long, EndPortImpl> portByVif = new HashMap<Long, EndPortImpl>();
        for (int i = 0; i < vbl.size(); ++i) {
            byte[] bmap = vbl.byteValue(i);
            int max = bmap.length / 6 * 6;
            for (int j = 0; j < max; j += 6) {
                IslImpl isl;
                int ifIndex;
                if ((bmap[j] & 0xFF) == 0 || (ifIndex = ((bmap[j + 5] & 0xFF) << 24) + ((bmap[j + 4] & 0xFF) << 16) + ((bmap[j + 3] & 0xFF) << 8) + (bmap[j + 2] & 0xFF)) == 0) continue;
                short ficonAddr = (short)(bmap[j + 1] & 0xFF);
                FcPortBase fport = sw.findPort(ifIndex);
                fport.setFiconAddress(ficonAddr);
                if (fport.getIfOperMode() == 2 || fport.getIfOperMode() == 3 || fport.getIfOperMode() == 6 || fport.getIfOperMode() == 13) {
                    ArrayList<EndPortImpl> eps = fabric.findEndPortsBySwitchIfIndex(sw, ifIndex);
                    if (eps == null) continue;
                    for (EndPortImpl ep : eps) {
                        ep.setFiconAddress(ficonAddr);
                        portByVif.put(((long)ep.getVsan() << 32) + (long)ifIndex, ep);
                    }
                    continue;
                }
                if (fport.getIfOperMode() != 4 && fport.getIfOperMode() != 12 || (isl = fabric.findIsl(sw, ifIndex)) == null) continue;
                isl.setFiconAddress(ifIndex, ficonAddr);
            }
        }
        if (portByVif.size() != 0) {
            SnmpAdapter.discoverFiconRNIDInfo(sw, portByVif);
        }
    }

    public static void discoverFiconRNIDInfo(SwitchImpl sw, HashMap<Long, EndPortImpl> portByVif) throws SnmpException {
        VarBindList vbl = new VarBindList(_FcIfRNIDOids.length * portByVif.size());
        for (long vif : portByVif.keySet()) {
            int[] index = new int[]{(int)(vif & 0xFFFFFFFFFFFFFFFFL), (int)(vif >> 32)};
            for (int i = 0; i < _FcIfRNIDOids.length; ++i) {
                vbl.add(_FcIfRNIDOids[i], index);
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        for (int i = 0; i < rspVbl.size(); i += _FcIfRNIDOids.length) {
            SnmpOID oid = rspVbl.getVb(i).getOid();
            long vif = ((long)oid.getIndexFromEnd(0) << 32) + (long)oid.getIndexFromEnd(1);
            EndPortImpl ep = portByVif.get(vif);
            if (ep == null) continue;
            ep.setFiconRNIDInfo(new FcPortRNIDInfo((byte)rspVbl.intValue(i), rspVbl.stringValue(i + 1), rspVbl.stringValue(i + 2), rspVbl.stringValue(i + 3), rspVbl.stringValue(i + 4), rspVbl.stringValue(i + 5), (byte)rspVbl.intValue(i + 6), rspVbl.intValue(i + 7)));
        }
    }

    public static boolean isHardwareInventoryChanged(SwitchImpl sw) throws SnmpException {
        boolean changed = false;
        VarBindList vbl = new VarBindList(_EntChgChkVars.length);
        for (int i = 0; i < _EntChgChkVars.length; ++i) {
            vbl.add(new SnmpVarBind(_EntChgChkVars[i]));
        }
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = sw.createPeer().send(pdu);
        vbl = pdu.getVariables();
        long chgTime = vbl.longValue(0);
        if (sw._entLastChangeTime != chgTime) {
            sw._entLastChangeTime = chgTime;
            changed = true;
        }
        if (sw.setActiveSupPhysicalIndex(vbl.intValue(1))) {
            changed = true;
        }
        sw.setStandbySupState(vbl.intValue(2));
        return changed;
    }

    public static void updateHardwareInventoryStatus(SwitchImpl sw) throws SnmpException {
        int i;
        int phyIndex;
        InventoryManager im = InventoryManager.getInstance();
        VarBindList vbl = new VarBindList(10);
        for (Card card : im.findCards(sw.getSwitchPK())) {
            phyIndex = card.getPhysicalIndex();
            for (i = 0; i < _CiscoCardOids.length; ++i) {
                vbl.add(_CiscoCardOids[i], phyIndex);
            }
        }
        for (PowerSupply ps : im.findPowerSupplies(sw.getSwitchPK())) {
            phyIndex = ps.getPhysicalIndex();
            for (i = 0; i < _CiscoPowerOids.length; ++i) {
                vbl.add(_CiscoPowerOids[i], phyIndex);
            }
        }
        for (HwInventoryComponent fan : im.findFans(sw.getSwitchPK())) {
            phyIndex = fan.getPhysicalIndex();
            vbl.add(_CiscoFanOid, phyIndex);
        }
        if (vbl.size() == 0) {
            return;
        }
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        for (i = 0; i < vbl.size(); ++i) {
            SnmpOID oid = vbl.getVb(i).getOid();
            phyIndex = oid.getIndexFromEnd(0);
            if (oid.startsWith(_CiscoCardOids[0])) {
                int adminStatus = vbl.intValue(i);
                int operStatus = vbl.intValue(++i);
                String statusDescr = vbl.enumValue(i);
                String resetReason = vbl.stringValue(++i);
                long chgTime = vbl.longValue(++i);
                int powerAdminStatus = vbl.intValue(++i);
                int powerOperStatus = vbl.intValue(++i);
                int current = vbl.intValue(++i);
                im.updateCardStatus(sw.getSwitchPK(), phyIndex, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                continue;
            }
            if (oid.startsWith(_CiscoPowerOids[0])) {
                String statusDescr = vbl.enumValue(i);
                int mode = vbl.intValue(++i);
                int availCur = vbl.intValue(++i);
                int drawnCur = vbl.intValue(++i);
                String units = vbl.stringValue(++i);
                im.updatePowerSupplyStatus(sw.getSwitchPK(), phyIndex, statusDescr, mode, availCur, drawnCur, units);
                continue;
            }
            if (!oid.startsWith(_CiscoFanOid)) continue;
            String statusDescr = vbl.enumValue(i);
            im.updateStatus(sw.getSwitchPK(), phyIndex, statusDescr);
        }
    }

    public static boolean discoverHardwareInventory(SwitchImpl sw) throws SnmpException {
        SnmpPDU rspPdu;
        int phyIndex;
        SnmpVarBind vb;
        int i;
        int chassisIndex = 0;
        IntArray cardPhyIndices = new IntArray(15);
        IntArray powerPhyIndices = new IntArray(4);
        IntArray fanPhyIndices = new IntArray(4);
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(1));
        pdu.addNull(new SnmpOID(_EntityOids[0]));
        if (sw.isN7K()) {
            pdu.setMaxRptr(64);
        } else {
            pdu.setMaxRptr(46);
        }
        pdu = sw.createPeer().send(pdu);
        VarBindList vbl = pdu.getVariables();
        int max = vbl.size();
        for (i = 0; i < max && (vb = vbl.getVb(i)).getOid().startsWith(_EntityOids[0]); ++i) {
            phyIndex = vb.getOid().getIndexFromEnd(0);
            if (vb.getVar() == null || vb.getVar() instanceof SnmpNull) continue;
            int type = ((SnmpInt)vb.getVar()).getValue();
            if (type == HwInventoryType.CHASSIS.value()) {
                chassisIndex = phyIndex;
                continue;
            }
            if (type == HwInventoryType.POWERSUPPLY.value()) {
                powerPhyIndices.add(phyIndex);
                continue;
            }
            if (type == HwInventoryType.FAN.value()) {
                fanPhyIndices.add(phyIndex);
                continue;
            }
            if (type == HwInventoryType.MODULE.value()) {
                cardPhyIndices.add(vb.getOid().getIndexFromEnd(0));
                continue;
            }
            if (type == HwInventoryType.PORT.value()) break;
        }
        vbl = new VarBindList(cardPhyIndices.size() * _EntityOids.length + 4);
        if (chassisIndex != 0) {
            for (int j = 0; j < _EntityOids.length; ++j) {
                vbl.add(_EntityOids[j], chassisIndex);
            }
            vbl.add(_CiscoChassisOid, chassisIndex);
        }
        if (cardPhyIndices.size() != 0) {
            max = cardPhyIndices.size();
            for (i = 0; i < max; ++i) {
                int j;
                phyIndex = cardPhyIndices.get(i);
                for (j = 0; j < _EntityOids.length; ++j) {
                    vbl.add(_EntityOids[j], phyIndex);
                }
                for (j = 0; j < _CiscoCardOids.length; ++j) {
                    vbl.add(_CiscoCardOids[j], phyIndex);
                }
            }
        }
        if (powerPhyIndices.size() != 0) {
            max = powerPhyIndices.size();
            for (i = 0; i < max; ++i) {
                int j;
                phyIndex = powerPhyIndices.get(i);
                for (j = 0; j < _EntityOids.length; ++j) {
                    vbl.add(_EntityOids[j], phyIndex);
                }
                for (j = 0; j < _CiscoPowerOids.length; ++j) {
                    vbl.add(_CiscoPowerOids[j], phyIndex);
                }
            }
        }
        if (fanPhyIndices.size() != 0) {
            max = fanPhyIndices.size();
            for (i = 0; i < max; ++i) {
                int phyIndex2 = fanPhyIndices.get(i);
                for (int j = 0; j < _EntityOids.length; ++j) {
                    vbl.add(_EntityOids[j], phyIndex2);
                }
                vbl.add(_CiscoFanOid, phyIndex2);
            }
        }
        if ((rspPdu = SnmpFetch.get(sw.createPeer(), vbl)) == null) {
            return true;
        }
        VarBindList rspVbl = rspPdu.getVariables();
        InventoryManager im = InventoryManager.getInstance();
        Set<Integer> preCardSlots = im.findCardSlotIds(sw.getSwitchPK());
        Set<Integer> preFanSlots = im.findFanSlotIds(sw.getSwitchPK());
        Set<Integer> prePowerPhyIndexes = im.findPowerSupplyPhyIndexes(sw.getSwitchPK());
        int standbySup = -1;
        boolean hasModuleChange = false;
        for (int i2 = 0; i2 < rspVbl.size(); ++i2) {
            int[] oid;
            int phyIndex3 = rspVbl.getVb(i2).getOid().getIndexFromEnd(0);
            int classType = rspVbl.intValue(i2);
            int relPos = rspVbl.intValue(++i2);
            int[] vendorType = null;
            if ((oid = ((SnmpOID)rspVbl.getVb(++i2).getVar()).getValue()) != null && oid.length > 6) {
                vendorType = new int[oid.length - 6];
                System.arraycopy(oid, 6, vendorType, 0, vendorType.length);
            }
            String name = rspVbl.stringValue(++i2);
            String hwVer = rspVbl.stringValue(++i2);
            String fwVer = rspVbl.stringValue(++i2);
            String swVer = rspVbl.stringValue(++i2);
            String serialNo = ((SnmpString)rspVbl.get(++i2).getVar()).toString();
            String mfg = rspVbl.stringValue(++i2);
            String model = ((SnmpString)rspVbl.get(++i2).getVar()).toString();
            String assetId = rspVbl.stringValue(++i2);
            String statusDescr = "n/a";
            String secSerialNum = "n/a";
            if (classType == HwInventoryType.MODULE.value()) {
                int adminStatus = rspVbl.intValue(++i2);
                int operStatus = rspVbl.intValue(++i2);
                statusDescr = rspVbl.enumValue(i2);
                String resetReason = rspVbl.stringValue(++i2);
                long chgTime = rspVbl.longValue(++i2);
                int powerAdminStatus = rspVbl.intValue(++i2);
                int powerOperStatus = rspVbl.intValue(++i2);
                int current = rspVbl.intValue(++i2);
                int fexId = NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex3);
                if (fexId != -1) {
                    relPos = fexId;
                }
                Card card = im.createCard(sw.getSwitchPK(), relPos, phyIndex3, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                hasModuleChange = true;
                preCardSlots.remove(relPos);
                if (!card.hasSup()) continue;
                if (phyIndex3 == sw.getActiveSupPhysicalIndex()) {
                    sw.setVersion(card.getSoftwareRevision());
                    continue;
                }
                standbySup = relPos;
                continue;
            }
            if (classType == HwInventoryType.POWERSUPPLY.value()) {
                statusDescr = rspVbl.enumValue(++i2);
                int mode = rspVbl.intValue(++i2);
                int availCur = rspVbl.intValue(++i2);
                int drawnCur = rspVbl.intValue(++i2);
                String units = rspVbl.stringValue(++i2);
                int fexId = NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex3);
                im.createPowerSupply(sw.getSwitchPK(), relPos, phyIndex3, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, statusDescr, mode, drawnCur, availCur, units);
                prePowerPhyIndexes.remove(phyIndex3);
                continue;
            }
            if (classType == HwInventoryType.FAN.value()) {
                statusDescr = rspVbl.enumValue(++i2);
                preFanSlots.remove(relPos);
            } else if (classType == HwInventoryType.CHASSIS.value()) {
                PlatformType platform;
                secSerialNum = rspVbl.stringValue(++i2);
                if (serialNo != null) {
                    sw.setSerialNumber(serialNo);
                }
                if (model != null && model.length() > 0 && (platform = PlatformType.getTypeByDeviceKey(model)) != PlatformType.UNKNOWN) {
                    sw.setPlatform(platform);
                }
            }
            im.createHwComponent(sw.getSwitchPK(), phyIndex3, name, vendorType, classType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, statusDescr, secSerialNum);
        }
        sw.setStandbySupSlot(standbySup);
        for (int slotId : preCardSlots) {
            im.deleteCard(sw.getSwitchPK(), slotId);
            hasModuleChange = true;
        }
        for (int slotId : preFanSlots) {
            im.deleteFan(sw.getSwitchPK(), slotId);
        }
        for (int slotId : prePowerPhyIndexes) {
            im.deletePowerSupply(sw.getSwitchPK(), slotId);
        }
        if (hasModuleChange) {
            sw.checkCards();
        }
        SnmpAdapter.discoverFexHwEntities(sw);
        return true;
    }

    public static boolean discoverFexHwEntities(SwitchImpl sw) throws SnmpException {
        if (sw == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        if (sw.getPeer() == null) {
            return false;
        }
        SwitchVersion swRev = new SwitchVersion(sw.getVersion());
        Map<Integer, String> chassisMap = null;
        if (sw.isN5K() || sw.isN6K() || sw.isN7K() || sw.isUCS()) {
            chassisMap = SnmpAdapter.getFexChassisIndex(sw.getPeer(), swRev);
        }
        int[] fexIds = null;
        if (chassisMap != null) {
            fexIds = new int[chassisMap.entrySet().size()];
            int i = 0;
            for (Map.Entry<Integer, String> ent : chassisMap.entrySet()) {
                fexIds[i++] = ent.getKey();
            }
        }
        if (fexIds == null) {
            return false;
        }
        InventoryManager im = InventoryManager.getInstance();
        Map<Integer, HwInventoryComponent> oldChassisMap = im.findFexChassisInMap(sw.getSwitchPK());
        Map<Integer, Card> oldCardMap = im.findFexCardInMap(sw.getSwitchPK());
        Map<Integer, HwInventoryComponent> oldFanMap = im.findFexFanInMap(sw.getSwitchPK());
        Map<Integer, PowerSupply> oldPowerMap = im.findFexPowerInMap(sw.getSwitchPK());
        Map<HwInventoryType, List<Integer>> indexMap = CdpSnmpAdapter.getFexEntityIndexMap(sw.getPeer(), fexIds, new HwInventoryType[]{HwInventoryType.CHASSIS, HwInventoryType.MODULE, HwInventoryType.POWERSUPPLY, HwInventoryType.FAN}, sw.getPlatformType(), swRev);
        if (indexMap == null || indexMap.size() == 0) {
            for (int phyIndex : oldChassisMap.keySet()) {
                im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldCardMap.keySet()) {
                im.deleteFexCard(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldFanMap.keySet()) {
                im.deleteFexFan(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldPowerMap.keySet()) {
                im.deleteFexPower(sw.getSwitchPK(), phyIndex);
            }
            return false;
        }
        Map<HwInventoryType, List<Map>> hwMap = CdpSnmpAdapter.getEntityFullInfo(sw.getPeer(), indexMap);
        if (hwMap == null || hwMap.size() == 0) {
            for (int phyIndex : oldChassisMap.keySet()) {
                im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldCardMap.keySet()) {
                im.deleteFexCard(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldFanMap.keySet()) {
                im.deleteFexFan(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldPowerMap.keySet()) {
                im.deleteFexPower(sw.getSwitchPK(), phyIndex);
            }
            return false;
        }
        List<Map> entList = hwMap.get((Object)HwInventoryType.CHASSIS);
        HwInventoryComponent chassis = null;
        if (entList != null && entList.size() > 0) {
            for (Map entMap : entList) {
                chassis = SnmpAdapter.parseHwComponent(sw, HwInventoryType.CHASSIS, null, entMap, true, true, true);
                if (chassis == null) continue;
                oldChassisMap.remove(chassis.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.MODULE)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                Card card = (Card)SnmpAdapter.parseHwComponent(sw, HwInventoryType.MODULE, null, entMap, true, true, true);
                if (card == null) continue;
                oldCardMap.remove(card.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.POWERSUPPLY)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                PowerSupply ps = (PowerSupply)SnmpAdapter.parseHwComponent(sw, HwInventoryType.POWERSUPPLY, null, entMap, true, true, true);
                if (ps == null) continue;
                oldPowerMap.remove(ps.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.FAN)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                HwInventoryComponent fan = SnmpAdapter.parseHwComponent(sw, HwInventoryType.FAN, null, entMap, true, true, true);
                if (fan == null) continue;
                oldFanMap.remove(fan.getPhysicalIndex());
            }
        }
        Iterator<Object> i$ = oldChassisMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldCardMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexCard(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldFanMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexFan(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldPowerMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexPower(sw.getSwitchPK(), phyIndex);
        }
        return true;
    }

    private static HwInventoryComponent parseHwComponent(SwitchImpl sw, HwInventoryType entType, HwInventoryComponent hwComp, Map entMap, boolean detailed, boolean hasCommon, boolean isFex) {
        if (entMap == null || entMap.size() < 1) {
            return null;
        }
        InventoryManager im = InventoryManager.getInstance();
        PlatformType swType = sw.getBase().getPlatformType();
        boolean isNxOS = PlatformType.isMdsSwitch(swType) || PlatformType.isNexusSwitch(swType) && swType != PlatformType.UCS6K;
        boolean isIOS = PlatformType.isTypeOf(swType, PlatformType.CAT);
        try {
            int phyIndex = (Integer)entMap.get("entPhysicalIndex");
            String name = null;
            String hwVer = null;
            String fwVer = null;
            String swVer = null;
            String serialNo = null;
            String mfg = null;
            String model = null;
            String assetId = null;
            int[] vendorType = null;
            int relPos = -1;
            int classType = -1;
            int containedPos = -1;
            if (hasCommon) {
                name = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[3]);
                hwVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[4]);
                fwVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[5]);
                swVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[6]);
                serialNo = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[7]);
                mfg = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[8]);
                model = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[9]);
                assetId = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[10]);
                vendorType = (int[])entMap.get(CdpSnmpAdapter.EntTable_MibCmds[2]);
                containedPos = (Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[11]);
                relPos = (Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[1]);
                if (relPos < 0) {
                    relPos = 0;
                }
                if ((classType = ((Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[0])).intValue()) != entType.value()) {
                    throw new Exception("HW class type does not match");
                }
            }
            if (entType == HwInventoryType.MODULE) {
                Card card = (Card)hwComp;
                if (detailed) {
                    int adminStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[0]);
                    int operStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[1]);
                    String statusDescr = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[1] + "_strValue");
                    if (statusDescr == null || statusDescr.length() == 0) {
                        statusDescr = "n/a";
                    }
                    String resetReason = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[2]);
                    long chgTime = (Long)entMap.get(CdpSnmpAdapter.Module_MibCmds[3]);
                    int powerAdminStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[4]);
                    int powerOperStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[5]);
                    int current = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[6]);
                    String descr = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[7]);
                    int slotId = -1;
                    if (isNxOS) {
                        slotId = relPos;
                    } else if (isIOS) {
                        slotId = containedPos - relPos;
                    }
                    if (slotId == -1 || slotId > 24 && swType == PlatformType.N7K || slotId > 20 && swType != PlatformType.N7K && swType != PlatformType.N9K && swType != PlatformType.N1KV) {
                        return null;
                    }
                    if (card == null && hasCommon) {
                        card = isFex ? im.createFexCard(sw.getSwitchPK(), phyIndex, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current) : im.createCard(sw.getSwitchPK(), slotId, phyIndex, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                    } else {
                        im.updateCardStatus(sw.getSwitchPK(), phyIndex, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                    }
                    if (descr != null) {
                        card.setPhysicalDescr(descr);
                    }
                    if (sw.getDBID() == 0L && card.getDBID() != 0L) {
                        card.updateSwitch();
                    }
                }
                return card;
            }
            if (entType == HwInventoryType.POWERSUPPLY) {
                PowerSupply ps = (PowerSupply)hwComp;
                if (detailed) {
                    String operStatus = (String)entMap.get(CdpSnmpAdapter.Power_MibCmds[0]);
                    String powerUnit = (String)entMap.get(CdpSnmpAdapter.Power_MibCmds[4]);
                    int rdMode = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[1]);
                    int availCur = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[2]);
                    int drawnCur = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[3]);
                    if (ps == null && hasCommon) {
                        ps = isFex ? im.createFexPower(sw.getSwitchPK(), relPos, phyIndex, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus, rdMode, drawnCur, availCur, powerUnit) : im.createPowerSupply(sw.getSwitchPK(), relPos, phyIndex, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus, rdMode, drawnCur, availCur, powerUnit);
                    } else {
                        im.updatePowerSupplyStatus(sw.getSwitchPK(), phyIndex, operStatus, rdMode, drawnCur, availCur, powerUnit);
                    }
                }
                if (sw.getDBID() == 0L && ps.getDBID() != 0L) {
                    ps.updateSwitch();
                }
                return ps;
            }
            if (entType == HwInventoryType.FAN) {
                HwInventoryComponent fan = hwComp;
                if (detailed) {
                    String operStatus = (String)entMap.get(CdpSnmpAdapter.Fan_MibCmds[0]);
                    if (fan == null && hasCommon) {
                        fan = isFex ? im.createFexFan(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus) : im.createFan(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus);
                    } else {
                        im.updateStatus(sw.getSwitchPK(), phyIndex, operStatus);
                    }
                }
                if (sw.getDBID() == 0L && fan.getDBID() != 0L) {
                    fan.updateSwitch();
                }
                return fan;
            }
            if (entType == HwInventoryType.CHASSIS) {
                HwInventoryComponent chassis = hwComp;
                if (detailed) {
                    String secSerialNum = (String)entMap.get("ceEntPhysicalSecondSerialNum");
                    if (secSerialNum == null || secSerialNum.length() == 0) {
                        secSerialNum = "n/a";
                    }
                    if (chassis == null && hasCommon) {
                        chassis = isFex ? im.createFexChassis(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", secSerialNum) : im.createChassis(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", secSerialNum);
                    }
                }
                if (sw.getDBID() == 0L && chassis.getDBID() != 0L) {
                    chassis.updateSwitch();
                }
                return chassis;
            }
            HwInventoryComponent hw = hwComp;
            if (hwComp == null && hasCommon) {
                hw = im.createHwComponent(sw.getSwitchPK(), phyIndex, name, vendorType, entType.value(), relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", "n/a");
            }
            if (sw.getDBID() == 0L && hw.getDBID() != 0L) {
                hw.updateSwitch();
            }
            return hw;
        }
        catch (Exception e) {
            _Tracer.log(Level.WARN, "Got error from create hw entity for " + entMap, e);
            return null;
        }
    }

    public static boolean discoverFeModules(SwitchImpl sw) throws SnmpException {
        InventoryManager im = InventoryManager.getInstance();
        if (im.getNumCards(sw.getSwitchPK()) == 0) {
            im.createCard(sw.getSwitchPK(), 1, 1, new int[]{9, 12, 3, 1, 9, 53, 254}, FRUConstants.getCardTypeName(254), "1.0", "1.0", sw.getVersion(), sw.getSerialNumber(), FRUConstants.getCardTypeName(254), "Cisco", "74-3811-01", 1, 1, "up", null, sw.getConfigChangeTime(), 0, 0, 0);
        }
        if (sw.getNumFeModules() < 2) {
            sw.setNumFeModules(1);
        } else {
            VarBindList vbl = new VarBindList(sw.getNumFeModules());
            int max = sw.getNumFeModules();
            for (int i = 0; i < max; ++i) {
                vbl.add(_FeModuleNameOid, i + 1);
            }
            SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            SanManager sm = SanManager.getInstance();
            vbl = rspPdu.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                SnmpVarBind vb = vbl.getVb(i);
                if (vb.getError() != 0) continue;
                int moduleId = vb.getOid().getIndexFromEnd(0);
                Wwn wwn = SnmpAdapter.vsanWwnToSwitchWwn(((SnmpString)vb.getVar()).getValue());
                SwitchImpl sw0 = sm.findSwitch(wwn, sw.getFabricPK());
                if (sw0 == null) continue;
                sw0.setFcFeModuleId(moduleId);
            }
        }
        return true;
    }

    public static boolean discoverSsmFeatures(SwitchImpl sw) throws SnmpException {
        int[] oid;
        int[] oid2;
        InventoryManager im = InventoryManager.getInstance();
        if (!im.hasILC(sw.getSwitchPK())) {
            return false;
        }
        List<Card> smeCapableCards = im.findSMECapableCards(sw.getSwitchPK());
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_SsmFeatureVar));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        int oidOffset = _SsmFeatureVar.getValue().length;
        for (int i = 0; i < vbl.size() && oidOffset + 3 < (oid2 = vbl.getVb(i).getOid().getValue()).length; ++i) {
            int ifStartPort = oid2[oidOffset];
            int slot = IfIndexUtil.ifIndex2Card(ifStartPort);
            Card card = im.findCard(sw.getSwitchPK(), slot + 1);
            String featureName = SnmpString.toString(oid2, oidOffset + 3, oid2.length);
            if ("dmm".equals(featureName)) {
                if (card == null) continue;
                im.updateCardDmmState(card, vbl.intValue(i) == 1 ? 1 : 2);
                smeCapableCards.remove(card);
                continue;
            }
            if ("santap".equals(featureName)) {
                if (card == null) continue;
                im.updateCardSantapState(card, vbl.intValue(i) == 1 ? 1 : 2);
                smeCapableCards.remove(card);
                continue;
            }
            if ("se".equals(featureName)) {
                if (card == null) continue;
                im.updateCardSeState(card, vbl.intValue(i) == 1 ? 1 : 2);
                smeCapableCards.remove(card);
                continue;
            }
            if (!"ioa".equals(featureName) || card == null) continue;
            im.updateCardIoaState(card, vbl.intValue(i) == 1 ? 1 : 2);
            smeCapableCards.remove(card);
        }
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_SsmSsnFeatureVar));
        rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, 24);
        vbl = rspPdu.getVariables();
        oidOffset = _SsmSsnFeatureVar.getValue().length;
        int[] lastOid = null;
        for (int i = 0; i < vbl.size() && !Arrays.equals(oid = vbl.getVb(i).getOid().getValue(), lastOid) && oidOffset + 4 < oid.length; ++i) {
            int physicalIndex = oid[oidOffset];
            int slot = physicalIndex - 21;
            Card card = im.findCard(sw.getSwitchPK(), slot);
            String featureName = SnmpString.toString(oid, oidOffset + 4, oid.length);
            if ("dmm".equals(featureName)) {
                if (card != null) {
                    im.updateCardDmmState(card, vbl.intValue(i) == 1 ? 1 : 2);
                    smeCapableCards.remove(card);
                }
            } else if ("santap".equals(featureName)) {
                if (card != null) {
                    im.updateCardSantapState(card, vbl.intValue(i) == 1 ? 1 : 2);
                    smeCapableCards.remove(card);
                }
            } else if ("se".equals(featureName)) {
                if (card != null) {
                    im.updateCardSeState(card, vbl.intValue(i) == 1 ? 1 : 2);
                    smeCapableCards.remove(card);
                }
            } else if ("ioa".equals(featureName) && card != null) {
                im.updateCardIoaState(card, vbl.intValue(i) == 1 ? 1 : 2);
                smeCapableCards.remove(card);
            }
            lastOid = oid;
        }
        for (Card card : smeCapableCards) {
            im.updateCardDmmState(card, 0);
            im.updateCardIoaState(card, 0);
            im.updateCardSeState(card, 0);
            im.updateCardSantapState(card, 0);
        }
        return true;
    }

    public static boolean discoverTargets(SwitchImpl sw) throws SnmpException {
        SnmpPDU rspPdu;
        short[] vids = sw.getVsanIds();
        if (vids == null || vids.length == 0) {
            EndPortImpl[] eps = sw.getTargetPortsToQuery();
            if (eps != null) {
                for (int i = 0; i < eps.length; ++i) {
                    SnmpAdapter.discoverTarget(sw, eps[i]);
                }
                return true;
            }
            return false;
        }
        Arrays.sort(vids);
        SnmpInt spinlock = null;
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- getting LunDiscSpinLock"));
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(3));
        reqPdu.setRetries(2);
        reqPdu.addNull(_LunDiscSpinLockVar);
        for (int i = 0; i < 3; ++i) {
            try {
                rspPdu = sw.createPeer().send(reqPdu);
                SnmpVar var = rspPdu.getVar(0);
                if (var.getType() == 2) {
                    spinlock = (SnmpInt)var;
                    break;
                }
            }
            catch (SnmpException se) {
                _Log.log((Priority)Level.ERROR, (Object)(sw.getIpAddress() + " -- getting LunDiscSpinLock error"), (Throwable)se);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (spinlock == null) {
            if (!sw.isNpvEnabled()) {
                _Log.error((Object)(sw.getIpAddress() + " -- target discovery failed in getting LunDiscSpinLock"));
            }
            return true;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- start target discovery"));
        reqPdu.reset();
        reqPdu.setCommand((byte)-93);
        reqPdu.addVar(_LunDiscSpinLockVar, spinlock);
        if (sw.isVersionGreaterThanEqual("2.0(0)")) {
            reqPdu.addVar(_LunDiscTypeVar, new SnmpInt(1));
        }
        reqPdu.addVar(_StartLunDiscVar, new SnmpInt(1));
        rspPdu = sw.createPeer().send(reqPdu);
        _Log.debug((Object)(sw.getIpAddress() + " -- poll target discovery status"));
        reqPdu.reset();
        reqPdu.setCommand((byte)-96);
        reqPdu.addNull(_LunDiscStatusVar);
        long startTime = System.currentTimeMillis();
        int status = 0;
        int max = 15;
        for (int i = 0; i < max; ++i) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                rspPdu = sw.createPeer().send(reqPdu);
                if (rspPdu.getVar(0).getType() != 2 || (status = rspPdu.getVariables().intValue(0)) == 1) continue;
                break;
            }
            catch (SnmpException se) {
                _Log.log((Priority)Level.ERROR, (Object)(sw.getIpAddress() + " -- polling LunDiscStatus"), (Throwable)se);
            }
        }
        if (status == 2) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " -- target discovery completed in " + (System.currentTimeMillis() - startTime) + " ms"));
            }
        } else {
            if (status == 3) {
                _Log.error((Object)(sw.getIpAddress() + " -- target discovery failed"));
            } else if (status == 1) {
                _Log.warn((Object)(sw.getIpAddress() + " -- target discovery timed out in " + (System.currentTimeMillis() - startTime) + " ms"));
            } else {
                _Log.warn((Object)(sw.getIpAddress() + " -- polling target discovery status failed"));
            }
            return true;
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- target discovery succeeded in " + (System.currentTimeMillis() - startTime) + " ms, fetch targets"));
        }
        VarBindList vbl = new VarBindList(_TargetOids.length);
        for (int i = 0; i < _TargetOids.length; ++i) {
            vbl.add(_TargetOids[i]);
        }
        reqPdu.setVariables(vbl);
        rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        int numTgts = vbl.size() / _TargetOids.length;
        _Log.debug((Object)(sw.getIpAddress() + " -- targets fetched: " + numTgts));
        SanManager sm = SanManager.getInstance();
        InventoryManager im = InventoryManager.getInstance();
        for (int i = 0; i < vbl.size(); i += _TargetOids.length) {
            EnclosureImpl enc;
            SnmpVarBind vb = vbl.getVb(i);
            Wwn pwwn = new Wwn((SnmpString)vb.getVar());
            ScsiTarget sTgt = im.createScsiTarget(pwwn, vbl.intValue(i + 1), vbl.stringValue(i + 2).trim(), vbl.stringValue(i + 3).trim(), vbl.stringValue(i + 4).trim(), vbl.byteValue(i + 5));
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " -- ScsiTarget: " + pwwn.toString() + ", " + sTgt.toString()));
            }
            if ((enc = sm.findEnclosureByPortWwn(pwwn)) == null) continue;
            enc.setScsiTarget(sTgt);
        }
        return true;
    }

    public static boolean isSMEChanged(SwitchImpl sw) throws SnmpException {
        boolean changed = false;
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_SmeChgChkVar));
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = sw.createPeer().send(pdu);
        vbl = pdu.getVariables();
        long chgTime = vbl.longValue(0);
        if (sw._smeLastChangeTime != chgTime || chgTime == 0L) {
            sw._smeLastChangeTime = chgTime;
            changed = true;
        }
        return changed;
    }

    public static boolean discoverSMEs(SwitchImpl sw) throws SnmpException {
        if (!sw.isMDS() || !sw.isFeatureEnabled(AbstractSwitchBase.Feature.SME.flag())) {
            sw.resetDiscFlag(2048);
            return false;
        }
        return SnmpAdapter.discoverMdsClusters(sw) && SnmpAdapter.discoverMdsClusterPorts(sw) && SnmpAdapter.discoverMdsSMEPorts(sw);
    }

    public static boolean discoverMdsClusters(SwitchImpl sw) throws SnmpException {
        _Log.debug((Object)(sw.getIpAddress() + " -- discover SME cluster"));
        VarBindList vbl = new VarBindList(_SMEClusterVars.length);
        for (int i = 0; i < _SMEClusterVars.length; ++i) {
            vbl.add(new SnmpVarBind(_SMEClusterVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        ArrayList<ClusterImpl> preClusters = fabric.getPreClusters();
        int offset = _SMEClusterVars[0].getValue().length + 1;
        for (int i = 0; i < vbl.size(); i += _SMEClusterVars.length) {
            int index = i;
            int[] oid = vbl.getVb(i).getOid().getValue();
            String clusterId = SnmpString.toString(oid, offset, oid.length);
            String name = vbl.stringValue(i);
            short type = 1;
            short status = (short)vbl.intValue(++index);
            short masterInetAddrType = (short)vbl.intValue(++index);
            String masterInetAddr = null;
            if (masterInetAddrType == 1 || masterInetAddrType == 2) {
                byte[] addr = vbl.byteValue(++index);
                for (int j = 0; j < addr.length; ++j) {
                    addr[j] = (byte)(addr[j] & 0xFF);
                }
                masterInetAddr = SnmpIpAddress.toString(addr);
            } else {
                masterInetAddr = vbl.stringValue(++index);
            }
            ClusterPK cpk = new ClusterPK(clusterId, name, type);
            ClusterImpl cluster = fabric.findCluster(cpk);
            if (cluster == null) {
                cluster = fabric.createCluster(cpk, type, status, masterInetAddrType, masterInetAddr, sw);
                continue;
            }
            if (status == 5) {
                cluster.setState(status);
                cluster.setMasterInetAddrType(masterInetAddrType);
                cluster.setMasterInetAddr(masterInetAddr);
            }
            preClusters.remove(cluster);
        }
        sw.resetDiscFlag(2048);
        return true;
    }

    public static boolean discoverMdsClusterPorts(SwitchImpl sw) throws SnmpException {
        ArrayList<ClusterMemberBase> mlist;
        ArrayList list;
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_ClusterInterfaceVar));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        ArrayList<ClusterImpl> clusterList = fabric.getClusterList();
        IdentityHashMap portsByCluster = new IdentityHashMap(clusterList.size());
        IdentityHashMap membersByCluster = new IdentityHashMap(clusterList.size());
        int cIdOffset = _SMEClusterVars[0].getValue().length + 1;
        for (int i = 0; i < vbl.size(); ++i) {
            ClusterMemberBase clusterMember;
            ClusterInterfBase clusterPort;
            int[] oid = vbl.getVb(i).getOid().getValue();
            int cIdLength = oid[cIdOffset - 1];
            String clusterId = SnmpString.toString(oid, cIdOffset, cIdOffset + cIdLength);
            String swInetAddr = null;
            int addrTypeOffset = cIdOffset + cIdLength + 1;
            int type = oid[addrTypeOffset - 1];
            if (type == 1 || type == 2) {
                int addrLength = oid.length - 1 - (addrTypeOffset + 1);
                byte[] addr = new byte[addrLength];
                int j = addrTypeOffset + 1;
                int bCount = 0;
                while (j < oid.length - 1) {
                    addr[bCount] = (byte)(oid[j] & 0xFF);
                    ++j;
                    ++bCount;
                }
                swInetAddr = SnmpIpAddress.toString(addr);
            } else {
                swInetAddr = SnmpString.toString(oid, addrTypeOffset + 1, oid.length - 1);
            }
            int ifIndex = oid[oid.length - 1];
            short status = (short)vbl.intValue(i);
            String cName = fabric.findClusterName(clusterId);
            if (cName == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- CLUSTER: cluster name not found for id " + clusterId));
                continue;
            }
            ClusterPK cpk = new ClusterPK(clusterId, cName, 1);
            ClusterImpl cl = fabric.findCluster(cpk);
            list = (ArrayList)portsByCluster.get(cl);
            if (list == null) {
                list = new ArrayList(2);
                portsByCluster.put(cl, list);
            }
            if (!list.contains(clusterPort = new ClusterInterfBase(ifIndex, swInetAddr, status))) {
                list.add(clusterPort);
            }
            if ((mlist = (ArrayList)membersByCluster.get(cl)) == null) {
                mlist = new ArrayList<ClusterMemberBase>(2);
                membersByCluster.put(cl, mlist);
            }
            if (mlist.contains(clusterMember = new ClusterMemberBase(swInetAddr))) continue;
            mlist.add(clusterMember);
        }
        for (Map.Entry entry : portsByCluster.entrySet()) {
            list = (ArrayList)entry.getValue();
            ClusterImpl cluster = (ClusterImpl)entry.getKey();
            ClusterInterfBase[] clusterPorts = list.toArray(new ClusterInterfBase[list.size()]);
            cluster.setClusterInterfs(clusterPorts);
        }
        for (Map.Entry entry : membersByCluster.entrySet()) {
            mlist = (ArrayList<ClusterMemberBase>)entry.getValue();
            ClusterImpl cluster = (ClusterImpl)entry.getKey();
            ClusterMemberBase[] clusterMembers = mlist.toArray(new ClusterMemberBase[mlist.size()]);
            cluster.setClusterMembers(clusterMembers);
        }
        return true;
    }

    public static boolean discoverMdsSMEPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(_SMEInterfaceVars.length);
        for (int i = 0; i < _SMEInterfaceVars.length; ++i) {
            vbl.add(new SnmpVarBind(_SMEInterfaceVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        List<FcPortBase> preSMEPorts = sw.findSMEPorts();
        for (int i = 0; i < vbl.size(); i += _SMEInterfaceVars.length) {
            int ifIndex = vbl.getVb(i).getOid().getIndexFromEnd(0);
            short state = (short)vbl.intValue(i);
            String clusterId = null;
            try {
                clusterId = vbl.stringValue(i + 1);
            }
            catch (Exception se) {
                // empty catch block
            }
            FcPortBase port = sw.createPort(ifIndex);
            port.setSMEState(state);
            port.setClusterId(clusterId);
            preSMEPorts.remove(port);
        }
        for (FcPortBase smePort : preSMEPorts) {
            sw.removePort(smePort.getIfIndex());
        }
        return true;
    }

    public static boolean isBaseSvcChanged(SwitchImpl sw) throws SnmpException {
        boolean changed = false;
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_BaseSvcChgChkVar));
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = sw.createPeer().send(pdu);
        vbl = pdu.getVariables();
        long chgTime = vbl.longValue(0);
        if (sw._smeLastChangeTime != chgTime || chgTime == 0L) {
            sw._smeLastChangeTime = chgTime;
            changed = true;
        }
        return changed;
    }

    public static boolean discoverMdsBaseSvcClusters(SwitchImpl sw) throws SnmpException {
        _Log.debug((Object)(sw.getIpAddress() + " -- discover BaseSvc cluster"));
        VarBindList vbl = new VarBindList(_BaseSvcClusterVars.length);
        for (int i = 0; i < _BaseSvcClusterVars.length; ++i) {
            vbl.add(new SnmpVarBind(_BaseSvcClusterVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        ArrayList<ClusterImpl> preClusters = fabric.getPreClusters();
        int offset = _BaseSvcClusterVars[0].getValue().length + 1;
        for (int i = 0; i < vbl.size(); i += _BaseSvcClusterVars.length) {
            int index = i;
            int[] oid = vbl.getVb(i).getOid().getValue();
            String clusterId = SnmpString.toString(oid, offset, oid.length);
            String name = vbl.stringValue(i);
            short type = 2;
            short status = (short)vbl.intValue(++index);
            short masterInetAddrType = (short)vbl.intValue(++index);
            String masterInetAddr = null;
            if (masterInetAddrType == 1 || masterInetAddrType == 2) {
                byte[] addr = vbl.byteValue(++index);
                for (int j = 0; j < addr.length; ++j) {
                    addr[j] = (byte)(addr[j] & 0xFF);
                }
                masterInetAddr = SnmpIpAddress.toString(addr);
            } else {
                masterInetAddr = vbl.stringValue(++index);
            }
            ClusterPK cpk = new ClusterPK(clusterId, name, type);
            ClusterImpl cluster = fabric.findCluster(cpk);
            if (cluster == null) {
                cluster = fabric.createCluster(cpk, type, status, masterInetAddrType, masterInetAddr, sw);
                continue;
            }
            if (status == 5) {
                cluster.setState(status);
                cluster.setMasterInetAddrType(masterInetAddrType);
                cluster.setMasterInetAddr(masterInetAddr);
            } else if ((cluster.getMasterInetAddr() == null || cluster.getMasterInetAddr().length() == 0) && masterInetAddr != null && masterInetAddr.length() > 0) {
                cluster.setState(status);
                cluster.setMasterInetAddrType(masterInetAddrType);
                cluster.setMasterInetAddr(masterInetAddr);
            }
            preClusters.remove(cluster);
        }
        sw.resetDiscFlag(4096);
        return true;
    }

    public static boolean discoverIAS(SwitchImpl sw) throws SnmpException {
        if (!sw.isMDS() || !sw.isFeatureEnabled(AbstractSwitchBase.Feature.IOA.flag())) {
            sw.resetDiscFlag(4096);
            List<FcPortBase> preIOAPorts = sw.findIOAPorts();
            if (preIOAPorts != null) {
                for (FcPortBase ioaPort : preIOAPorts) {
                    sw.removePort(ioaPort.getIfIndex());
                }
            }
            return false;
        }
        return SnmpAdapter.discoverMdsBaseSvcClusters(sw) && SnmpAdapter.discoverMdsBaseSvcClusterPorts(sw) && SnmpAdapter.discoverMdsBaseSvcPorts(sw);
    }

    public static boolean discoverMdsBaseSvcPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(_BaseSvcInterfaceVars.length);
        for (int i = 0; i < _BaseSvcInterfaceVars.length; ++i) {
            vbl.add(new SnmpVarBind(_BaseSvcInterfaceVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        List<FcPortBase> preIOAPorts = sw.findIOAPorts();
        for (int i = 0; i < vbl.size(); i += _BaseSvcInterfaceVars.length) {
            int ifIndex = vbl.getVb(i).getOid().getIndexFromEnd(0);
            short state = (short)vbl.intValue(i);
            String clusterId = null;
            try {
                clusterId = vbl.stringValue(i + 1);
            }
            catch (Exception se) {
                // empty catch block
            }
            FcPortBase port = sw.createPort(ifIndex);
            port.setIOAState(state);
            port.setClusterId(clusterId);
            preIOAPorts.remove(port);
        }
        for (FcPortBase ioaPort : preIOAPorts) {
            sw.removePort(ioaPort.getIfIndex());
        }
        return true;
    }

    public static boolean discoverMdsBaseSvcClusterPorts(SwitchImpl sw) throws SnmpException {
        ArrayList<ClusterMemberBase> mlist;
        ArrayList list;
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_BaseSvcClusterInterfaceVar));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        ArrayList<ClusterImpl> clusterList = fabric.getClusterList();
        IdentityHashMap portsByCluster = new IdentityHashMap(clusterList.size());
        IdentityHashMap membersByCluster = new IdentityHashMap(clusterList.size());
        int cIdOffset = _BaseSvcClusterVars[0].getValue().length + 1;
        for (int i = 0; i < vbl.size(); ++i) {
            ClusterMemberBase clusterMember;
            ClusterInterfBase clusterPort;
            int[] nArray = vbl.getVb(i).getOid().getValue();
            int cIdLength = nArray[cIdOffset - 1];
            String clusterId = SnmpString.toString(nArray, cIdOffset, cIdOffset + cIdLength);
            String swInetAddr = null;
            int addrTypeOffset = cIdOffset + cIdLength + 1;
            int type = nArray[addrTypeOffset - 1];
            if (type == 1 || type == 2) {
                int addrLength = nArray.length - 1 - (addrTypeOffset + 1);
                byte[] addr = new byte[addrLength];
                int j = addrTypeOffset + 1;
                int bCount = 0;
                while (j < nArray.length - 1) {
                    addr[bCount] = (byte)(nArray[j] & 0xFF);
                    ++j;
                    ++bCount;
                }
                swInetAddr = SnmpIpAddress.toString(addr);
            } else {
                swInetAddr = SnmpString.toString(nArray, addrTypeOffset + 1, nArray.length - 1);
            }
            int ifIndex = nArray[nArray.length - 1];
            short status = (short)vbl.intValue(i);
            String cName = fabric.findClusterName(clusterId);
            if (cName == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- CLUSTER: cluster name not found for id " + clusterId));
                continue;
            }
            ClusterPK cpk = new ClusterPK(clusterId, cName, 2);
            ClusterImpl cl = fabric.findCluster(cpk);
            list = (ArrayList)portsByCluster.get(cl);
            if (list == null) {
                list = new ArrayList(2);
                portsByCluster.put(cl, list);
            }
            if (!list.contains(clusterPort = new ClusterInterfBase(ifIndex, swInetAddr, status))) {
                list.add(clusterPort);
            }
            if ((mlist = (ArrayList)membersByCluster.get(cl)) == null) {
                mlist = new ArrayList<ClusterMemberBase>(2);
                membersByCluster.put(cl, mlist);
            }
            if (mlist.contains(clusterMember = new ClusterMemberBase(swInetAddr))) continue;
            mlist.add(clusterMember);
        }
        for (ClusterImpl clusterImpl : clusterList) {
            if (clusterImpl.getType() != 2) continue;
            if (sw.getIpAddress().equals(clusterImpl.getMasterInetAddr())) {
                clusterImpl.setClusterInterfs(null);
                clusterImpl.setClusterMembers(null);
                continue;
            }
            if (!sw.getName().equals(clusterImpl.getMasterInetAddr())) continue;
            clusterImpl.setClusterInterfs(null);
            clusterImpl.setClusterMembers(null);
        }
        for (Map.Entry entry : portsByCluster.entrySet()) {
            list = (ArrayList)entry.getValue();
            ClusterImpl cluster = (ClusterImpl)entry.getKey();
            ClusterInterfBase[] clusterPorts = list.toArray(new ClusterInterfBase[list.size()]);
            cluster.setClusterInterfs(clusterPorts);
        }
        for (Map.Entry entry : membersByCluster.entrySet()) {
            mlist = (ArrayList<ClusterMemberBase>)entry.getValue();
            ClusterImpl cluster = (ClusterImpl)entry.getKey();
            ClusterMemberBase[] clusterMembers = mlist.toArray(new ClusterMemberBase[mlist.size()]);
            cluster.setClusterMembers(clusterMembers);
        }
        return true;
    }

    public static void discoverTarget(SwitchImpl sw, EndPortImpl ep) throws SnmpException {
        EnclosureImpl enc;
        SnmpPDU rspPdu;
        VsanFcIdKey[] fcid = ep.getVsanFcIds();
        if (fcid == null) {
            return;
        }
        SnmpInt spinlock = null;
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(6));
        reqPdu.setRetries(2);
        reqPdu.addNull(_LunDiscSpinLockVar);
        for (int i = 0; i < 3; ++i) {
            try {
                rspPdu = sw.createPeer().send(reqPdu);
                SnmpVar var = rspPdu.getVar(0);
                if (var.getType() == 2) {
                    spinlock = (SnmpInt)var;
                    break;
                }
            }
            catch (SnmpException se) {
                _Log.log((Priority)Level.ERROR, (Object)(sw.getIpAddress() + " -- getting LunDiscSpinLock " + ep.getPortWwn() + " error"), (Throwable)se);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (spinlock == null) {
            _Log.error((Object)(sw.getIpAddress() + " -- getting LunDiscSpinLock failed " + ep.getPortWwn()));
            return;
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- start " + ep.getPortWwn() + " target discovery"));
        }
        reqPdu.setCommand((byte)-93);
        reqPdu.reset();
        reqPdu.addVar(_LunDiscSpinLockVar, spinlock);
        reqPdu.addVar(_LunDiscVsanVar, new SnmpInt(fcid[0]._vsanPK._id));
        if (sw.isVersionGreaterThanEqual("2.0(0)")) {
            reqPdu.addVar(_LunDiscTypeVar, new SnmpInt(1));
        }
        byte[] b = new byte[]{(byte)(fcid[0]._fcId >> 16 & 0xFF), (byte)(fcid[0]._fcId >> 8 & 0xFF), (byte)(fcid[0]._fcId & 0xFF)};
        reqPdu.addVar(_LunDiscPortVar, new SnmpString(b));
        reqPdu.addVar(_StartLunDiscVar, new SnmpInt(6));
        rspPdu = sw.createPeer().send(reqPdu);
        reqPdu.reset();
        reqPdu.setCommand((byte)-96);
        reqPdu.addNull(_LunDiscStatusVar);
        for (int i = 0; i < _LunCacheVars.length; ++i) {
            reqPdu.addNull(_LunCacheVars[i]);
        }
        int status = 0;
        for (int i = 0; i < 2; ++i) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            rspPdu = sw.createPeer().send(reqPdu);
            status = rspPdu.getVariables().intValue(0);
            if (status == 3 || status == 2) break;
        }
        if (status != 2) {
            _Log.error((Object)(sw.getIpAddress() + " -- target discovery failed: " + ep.getPortWwn()));
            return;
        }
        VarBindList vbl = rspPdu.getVariables();
        int[] index = new int[]{vbl.intValue(1), vbl.intValue(2), vbl.intValue(3), vbl.intValue(4)};
        vbl.clear();
        for (int i = 0; i < _TargetOids.length; ++i) {
            vbl.add(_TargetOids[i], index);
        }
        reqPdu.setVariables(vbl);
        rspPdu = sw.createPeer().send(reqPdu);
        vbl = rspPdu.getVariables();
        if (vbl.getVb(0).getVar().getType() == 5 || vbl.size() != _TargetOids.length) {
            return;
        }
        Wwn pwwn = new Wwn(vbl.byteValue(0));
        ScsiTarget target = InventoryManager.getInstance().createScsiTarget(pwwn, vbl.intValue(1), vbl.stringValue(2).trim(), vbl.stringValue(3).trim(), vbl.stringValue(4).trim(), vbl.byteValue(5));
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- ScsiTarget: " + pwwn.toString() + ", " + target.toString()));
        }
        if ((enc = SanManager.getInstance().findEnclosureByPortWwn(pwwn)) != null) {
            enc.setScsiTarget(target);
        }
    }

    public static boolean discoverSymNodeName(SwitchImpl sw) throws SnmpException {
        VsanFcIdKey[] fcids = sw.getHostPortsToQuery();
        if (fcids == null) {
            return false;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover symbolic node name"));
        VarBindList vbl = new VarBindList(fcids.length);
        for (int i = 0; i < fcids.length; ++i) {
            int[] symNodeIndex = new int[]{fcids[i]._vsanPK._id, fcids[i]._fcId >> 16 & 0xFF, fcids[i]._fcId >> 8 & 0xFF, fcids[i]._fcId & 0xFF};
            vbl.add(_FcnsSymNodeNameOid, symNodeIndex);
        }
        SnmpPDU pdu = SnmpFetch.get(sw.createPeer(), vbl);
        vbl = pdu.getVariables();
        InventoryManager im = InventoryManager.getInstance();
        for (int i = 0; i < vbl.size(); ++i) {
            int fcIdNum;
            EndPortImpl ep;
            int[] oid;
            short vid;
            VsanImpl vsan;
            SnmpVarBind vb = vbl.getVb(i);
            String symName = vb.getVar().toString();
            if (symName.length() == 0 || (vsan = sw.getVsan(vid = (short)(oid = vb.getOid().getValue())[oid.length - 4])) == null || (ep = vsan.findEndPort(fcIdNum = (oid[oid.length - 3] << 16) + (oid[oid.length - 2] << 8) + oid[oid.length - 1])) == null) continue;
            ep.setSymNodeName(symName);
            Hba hba = im.createHba(ep.getPortWwn(), ep.getNodeWwn(), symName);
            if (hba == null || ep.getEnclosure() == null) continue;
            ep.getEnclosure().addHba(hba);
        }
        return true;
    }

    public static boolean discoverFcPorts(SwitchImpl sw) throws SnmpException {
        if (sw.isMDS()) {
            boolean b;
            boolean bl = b = SnmpAdapter.discoverMdsFcPorts(sw) && SnmpAdapter.discoverMdsGigaEthernetPorts(sw) && SnmpAdapter.discoverMdsFcipPorts(sw) && SnmpAdapter.discoverMdsMgmtPorts(sw) && SnmpAdapter.discoverNonIPSEthernetPorts(sw) && SnmpAdapter.discoverNonIPSEthernetPortChannels(sw);
            if (sw.isN5K() || sw.isN7K() || sw.isUCS()) {
                b = b && SnmpAdapter.discoverSatEthPorts(sw);
            }
            return b;
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitPorts(sw);
        }
        return false;
    }

    public static boolean discoverMdsFcPorts(SwitchImpl sw) throws SnmpException {
        HashSet<FcPortBase> oldFcPorts = new HashSet<FcPortBase>(sw.findFcPortsIncFcip());
        FabricImpl fabric = sw.getFabric();
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FcIfOperStatusOid);
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        vbl = new VarBindList();
        for (SnmpVarBind vb : rspVbl) {
            int i;
            short operStatusCause = (short)((SnmpInt)vb.getVar()).getValue();
            if ((operStatusCause == 8 || operStatusCause == 29) && !_ReturnDownPort) continue;
            int ifIndex = vb.getOid().getIndexFromEnd(0);
            for (i = 0; i < _FcIfOids.length - 2; ++i) {
                vbl.add(_FcIfOids[i], ifIndex);
            }
            vbl.add(_ClmPortLicensingOperOid, new int[]{ifIndex, 1});
            if (!sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag())) continue;
            for (i = _FcIfOids.length - 2; i < _FcIfOids.length; ++i) {
                vbl.add(_FcIfOids[i], ifIndex);
            }
        }
        if (vbl.size() != 0) {
            int step;
            rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            int n = step = sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag()) ? _FcIfOids.length + 1 : _FcIfOids.length - 1;
            for (int i = 0; i < max; i += step) {
                FcPortBase port;
                FcPortImpl portImpl;
                String operStatusCauseDesc;
                short operStatusCause;
                String ifAlias;
                short fcifAdminMode;
                long fcIfAdminSpeed;
                short ifOperStatus;
                short ifAdminStatus;
                VsanImpl vsan;
                String ifDescr;
                short fcConnectorType;
                int fcIfPortType;
                int ifType;
                long ifSpeed;
                short operMode;
                Wwn fwwn;
                String ifName;
                int ifindexType;
                int ifIndex;
                block28: {
                    ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    ifindexType = sw.getType(ifIndex);
                    ifName = rspVbl.stringValue(i);
                    byte[] bwwn = rspVbl.byteValue(i + 1);
                    fwwn = null;
                    if (bwwn != null && (bwwn.length == 8 || bwwn.length == 16)) {
                        fwwn = new Wwn(bwwn);
                    }
                    operMode = (short)rspVbl.intValue(i + 2);
                    ifSpeed = rspVbl.longValue(i + 3) * 1000000L;
                    ifType = rspVbl.intValue(i + 4);
                    fcIfPortType = rspVbl.intValue(i + 5);
                    fcConnectorType = (short)rspVbl.intValue(i + 6);
                    ifDescr = rspVbl.stringValue(i + 7);
                    short vsanId = (short)rspVbl.intValue(i + 8);
                    vsan = sw.getVsan(vsanId);
                    ifAdminStatus = (short)rspVbl.intValue(i + 9);
                    ifOperStatus = (short)rspVbl.intValue(i + 10);
                    fcIfAdminSpeed = rspVbl.longValue(i + 11) * 1000000L;
                    fcifAdminMode = (short)rspVbl.intValue(i + 12);
                    ifAlias = rspVbl.stringValue(i + 13);
                    operStatusCause = (short)rspVbl.intValue(i + 14);
                    operStatusCauseDesc = null;
                    try {
                        operStatusCauseDesc = MibVariableFormat.fcIfOperStatusCause(rspVbl.getVb(i + 14).getVar()).toString();
                    }
                    catch (Exception ex) {
                        if (!_Log.isDebugEnabled()) break block28;
                        _Log.debug((Object)"Caught exception:", (Throwable)ex);
                    }
                }
                byte[] v2k = rspVbl.byteValue(i + 15);
                byte[] v4k = rspVbl.byteValue(i + 16);
                byte[] b = new byte[512];
                System.arraycopy(v2k, 0, b, 0, v2k.length);
                System.arraycopy(v4k, 0, b, 256, v4k.length);
                int[] vsanList = SnmpBitmap.valueOf(b, false);
                int portLicense = rspVbl.intValue(i + 17);
                int fcspMode = -1;
                int fcspEspMode = -1;
                if (sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag())) {
                    fcspMode = rspVbl.intValue(i + 18);
                    fcspEspMode = rspVbl.intValue(i + 19);
                }
                WwnKey fwwnKey = null;
                if (fwwn != null) {
                    fwwnKey = new WwnKey(fwwn);
                }
                if ((portImpl = fabric.findSwitchPortByKey((SwitchIntKey)(port = sw.createPort(fwwnKey, ifIndex)).getSwitchPortPK())) == null) {
                    portImpl = new FcPortImpl(sw, port, ifindexType == 4);
                    port.setIfname(ifName);
                    if (fwwn != null) {
                        port.setFWwn(fwwn);
                    }
                    port.setIfOperMode(operMode);
                    port.setIfSpeed(ifSpeed);
                    port.setIfType(ifType);
                    port.setFcIfPortType(fcIfPortType);
                    port.setFcConnectorType(fcConnectorType);
                    port.setIfDescr(ifDescr);
                    if (vsan != null) {
                        port.setVsans(new ArrayList<VsanPK>());
                        port.addVsan(vsan.getVsanPK());
                    }
                    if (vsanList.length > 1) {
                        port.setVsans(new ArrayList<VsanPK>());
                        for (int j = 0; j < vsanList.length; ++j) {
                            vsan = sw.getVsan((short)vsanList[j]);
                            if (vsan == null) continue;
                            port.addVsan(vsan.getVsanPK());
                        }
                    }
                    port.setIfAdminStatus(ifAdminStatus);
                    port.setIfOperStatus(ifOperStatus);
                    port.setFcIfAdminSpeed(fcIfAdminSpeed);
                    port.setFcifAdminMode(fcifAdminMode);
                    port.setIfAlias(ifAlias);
                    port.setOperStatusCause(operStatusCause);
                    port.setOperStatusCauseDescription(operStatusCauseDesc);
                    port.setPortLicense(rspVbl.intValue(i + 15));
                    if (sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag())) {
                        port.setFcspMode(fcspMode);
                        port.setFcspEspMode(fcspEspMode);
                    }
                    fabric.addSwitchPort(portImpl);
                } else {
                    if (port != portImpl.getBase()) {
                        port = portImpl.getBase();
                        sw.addPort(port);
                    }
                    portImpl.setIfname(rspVbl.stringValue(i));
                    if (fwwn != null) {
                        portImpl.setFWwn(fwwn);
                    }
                    portImpl.setIfOperMode(operMode);
                    portImpl.setIfSpeed(ifSpeed);
                    portImpl.setIfType(ifType);
                    portImpl.setFcIfPortType(fcIfPortType);
                    portImpl.setFcConnectorType(fcConnectorType);
                    portImpl.setIfDescr(ifDescr);
                    if (vsan != null) {
                        portImpl.getBase().setVsans(new ArrayList<VsanPK>());
                        portImpl.getBase().addVsan(vsan.getVsanPK());
                    }
                    if (vsanList.length > 1) {
                        port.setVsans(new ArrayList<VsanPK>());
                        for (int j = 0; j < vsanList.length; ++j) {
                            vsan = sw.getVsan((short)vsanList[j]);
                            if (vsan == null) continue;
                            port.addVsan(vsan.getVsanPK());
                        }
                    }
                    portImpl.getBase().setIfAdminStatus(ifAdminStatus);
                    portImpl.setIfOperStatus(ifOperStatus);
                    portImpl.getBase().setFcIfAdminSpeed(fcIfAdminSpeed);
                    portImpl.getBase().setFcifAdminMode(fcifAdminMode);
                    portImpl.setIfAlias(ifAlias);
                    portImpl.setOperStatusCause(operStatusCause);
                    portImpl.getBase().setOperStatusCauseDescription(operStatusCauseDesc);
                    portImpl.getBase().setPortLicense(portLicense);
                    if (sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag())) {
                        portImpl.getBase().setFcspMode(fcspMode);
                        portImpl.getBase().setFcspEspMode(fcspEspMode);
                    }
                }
                oldFcPorts.remove(port);
                if (fwwn != null && operMode != 14) {
                    sw.addFwwn2IfIndex(fwwn, ifIndex);
                }
                if (operMode == 4 || operMode == 12) {
                    IslImpl isl = fabric.findIsl(sw, ifIndex);
                    if (isl == null) continue;
                    isl.setOperMode(operMode);
                    isl.setOperStatusCause(port.getOperStatusCause());
                    isl.setSpeed(port.getIfSpeed());
                    isl.setFcConnectorType(port.getFcConnectorType());
                    continue;
                }
                if (operMode == 2 || operMode == 17) {
                    NpvLinkImpl npvl = fabric.findNpvLink(sw, ifIndex);
                    if (npvl != null) {
                        npvl.setOperMode(operMode);
                        npvl.setOperStatusCause(port.getOperStatusCause());
                        npvl.setSpeed(port.getIfSpeed());
                        npvl.setFcConnectorType(port.getFcConnectorType());
                        continue;
                    }
                    SnmpAdapter.updateEndPortsByPort(sw, fabric, ifIndex, operMode, port);
                    continue;
                }
                if (operMode != 3 && operMode != 6 && operMode != 13 && operMode != 8 && operMode != 10 && operMode != 9 && operMode != 1) continue;
                SnmpAdapter.updateEndPortsByPort(sw, fabric, ifIndex, operMode, port);
            }
        }
        for (FcPortBase port : oldFcPorts) {
            if (fabric.findIsl(port.getSwitchPK()) != null || fabric.findNpvLink((SwitchIntKey)port.getSwitchPortPK()) != null) continue;
            sw.removePort(port.getIfIndex());
            fabric.removeSwitchPort((SwitchIntKey)port.getSwitchPortPK(), true);
        }
        sw.resetDiscFlag(64);
        return true;
    }

    public static boolean discoverMdsMgmtPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        int ifIndex = 0x5000000;
        for (int i = 0; i < _FcGigEthernetIfOids.length; ++i) {
            vbl.add(_FcGigEthernetIfOids[i], ifIndex);
        }
        if (vbl.size() != 0) {
            SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            VarBindList rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            for (int i = 0; i < max; i += _FcGigEthernetIfOids.length) {
                MacAddress macAddr;
                FcPortBase port;
                int operStatus;
                block5: {
                    operStatus = rspVbl.intValue(i + 3);
                    ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    port = sw.createPort(ifIndex);
                    port.setIfname(rspVbl.stringValue(i));
                    port.setIfSpeed(rspVbl.longValue(i + 1) * 1000000L);
                    port.setIfType(rspVbl.intValue(i + 2));
                    port.setIfDescr(rspVbl.stringValue(i + 4));
                    byte[] b = rspVbl.byteValue(i + 5);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    macAddr = null;
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        if (!_Log.isDebugEnabled()) break block5;
                        _Log.warn((Object)(sw + " cannot recognized mac address:" + Arrays.toString(nb)));
                    }
                }
                port.setIfPhysicalAddress(macAddr);
                port.setIfAdminStatus((short)rspVbl.intValue(i + 6));
                port.setIfOperStatus((short)operStatus);
                port.setFcIfAdminSpeed(rspVbl.longValue(i + 7) * 1000000L);
                port.setFcifAdminMode((short)rspVbl.intValue(i + 8));
                port.setIfAlias(rspVbl.stringValue(i + 9));
            }
        }
        return true;
    }

    private static void updateEndPortsByPort(SwitchImpl sw, FabricImpl fabric, int ifIndex, int operMode, FcPortBase port) {
        ArrayList<EndPortImpl> eps = SanManager.getInstance().findEndPortByFWwn(port.getFWwn());
        Set<EndPortImpl> pendingEps = sw.findPendingEp(port.getFWwn());
        if (eps == null || eps.isEmpty()) {
            return;
        }
        for (EndPortImpl ep : eps) {
            if (!_EnableFV && operMode == 13) {
                if (_Log.isDebugEnabled()) {
                    _Log.debug((Object)(sw + " toss FV endport device:" + ep + " at port:" + port.getDisplayName()));
                }
                SanManager.getInstance().deleteEndPort(ep, fabric);
                continue;
            }
            if (pendingEps != null && pendingEps.contains(ep)) {
                ep.setFPort(sw, port.getIfIndex());
                ep.setVsanFport(ep.getSwitchIntKey(), port.getFWwn());
            }
            ep.setLoop(operMode == 3);
            ep.setSpeed(port.getIfSpeed());
            ep.setFxInterface(port.getIfIndex(), port.getDisplayName());
            if (ep.isFiconCup() || !ep.isPresent()) continue;
            ep.setOperStatusCause(port.getOperStatusCause());
        }
        sw.removePendingEp(port.getFWwn());
    }

    public static boolean discoverSatEthPorts(SwitchImpl sw) throws SnmpException {
        SwitchVersion swRev = new SwitchVersion(sw.getVersion());
        List<FcPortBase> oldFexEthPorts = sw.findFexEthPorts();
        if (!(sw.isN5K() || sw.isN6K() || sw.isN7K() || sw.isUCS())) {
            return true;
        }
        Map<Integer, String> chassisMap = SnmpAdapter.getFexChassisIndex(sw.getPeer(), swRev);
        ArrayList<Integer> satIfindexList = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> ent : chassisMap.entrySet()) {
            int fexId = ent.getKey();
            String serialNum = ent.getValue();
            if (!GenUtil.isCiscoSerialNumber(serialNum)) {
                _Tracer.debug(sw + " got invalid fex chassis entity:" + ent);
                continue;
            }
            if (fexId <= 0) {
                _Tracer.debug(sw + " got invalid fex chassis entity:" + ent);
                continue;
            }
            int numHifPort = 48;
            int ifindexStart = IfIndexUtil.nameToIfIndexFex(fexId, 1, 1);
            int ifindexEnd = IfIndexUtil.nameToIfIndexFex(fexId, 1, numHifPort);
            for (int i = ifindexStart; i <= ifindexEnd; ++i) {
                satIfindexList.add(i);
            }
        }
        Collections.sort(satIfindexList);
        int[] satIfindexes = new int[satIfindexList.size()];
        for (int i = 0; i < satIfindexes.length; ++i) {
            satIfindexes[i] = (Integer)satIfindexList.get(i);
        }
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < satIfindexes.length; ++i) {
            for (int j = 0; j < _FcGigEthernetIfOids.length; ++j) {
                vbl.add(_FcGigEthernetIfOids[j], satIfindexes[i]);
            }
        }
        SnmpPDU rspPdu = null;
        VarBindList rspVbl = null;
        if (vbl.size() != 0) {
            rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            for (int i = 0; i < max; i += _FcGigEthernetIfOids.length) {
                MacAddress macAddr;
                FcPortBase port;
                int operStatus;
                block14: {
                    operStatus = rspVbl.intValue(i + 3);
                    int ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    port = sw.createPort(ifIndex);
                    port.setIfname(rspVbl.stringValue(i));
                    port.setIfSpeed(rspVbl.longValue(i + 1) * 1000000L);
                    port.setIfType(rspVbl.intValue(i + 2));
                    port.setIfDescr(rspVbl.stringValue(i + 4));
                    oldFexEthPorts.remove(port);
                    byte[] b = rspVbl.byteValue(i + 5);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    macAddr = null;
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        if (!_Log.isDebugEnabled()) break block14;
                        _Log.warn((Object)(sw + " cannot recognized mac address:" + Arrays.toString(nb)));
                    }
                }
                port.setIfPhysicalAddress(macAddr);
                port.setIfAdminStatus((short)rspVbl.intValue(i + 6));
                port.setIfOperStatus((short)operStatus);
                port.setFcIfAdminSpeed(rspVbl.longValue(i + 7) * 1000000L);
                port.setFcifAdminMode((short)rspVbl.intValue(i + 8));
                port.setIfAlias(rspVbl.stringValue(i + 9));
                SnmpVarBind vb = rspVbl.getVb(i + 10);
                int[] oid = _FcGigEthernetIfOids[10];
                int[] index = SnmpAdapter.getIndexForVb(vb, oid);
                int indexPos = 1;
                if (index.length <= 2 || index[indexPos] != 1) continue;
                int n = ++indexPos;
                ++indexPos;
                int length = index[n];
                byte[] ipAddr = new byte[length];
                for (int k = 0; k < length; ++k) {
                    ipAddr[k] = new Integer(index[indexPos++]).byteValue();
                }
                port.setIpAddress(SnmpIpAddress.toString(ipAddr));
            }
        }
        for (FcPortBase port : oldFexEthPorts) {
            sw.removePort(port.getIfIndex());
        }
        return true;
    }

    public static boolean discoverNonIPSEthernetPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FcGigEthernetIfOids[0]);
        IfIndexIf ifIndexIf = (IfIndexIf)((Object)sw.getBaseObject());
        int ethType = ifIndexIf.getActualType(26);
        SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(sw.createPeer(), vbl, 0, new int[]{IfIndexUtil.getFirstValidIfIndexFor(ethType) - 1}, new int[]{IfIndexUtil.getLastValidIfIndexFor(ethType) + 1});
        VarBindList rspVbl = rspPdu.getVariables();
        vbl = new VarBindList();
        for (SnmpVarBind vb : rspVbl) {
            int ifIndex = vb.getOid().getIndexFromEnd(0);
            for (int i = 0; i < _FcGigEthernetIfOids.length; ++i) {
                vbl.add(_FcGigEthernetIfOids[i], ifIndex);
            }
        }
        List<FcPortBase> oldNonIPSEthPorts = sw.findNonIPSEthPorts();
        if (vbl.size() != 0) {
            rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            for (int i = 0; i < max; i += _FcGigEthernetIfOids.length) {
                MacAddress macAddr;
                FcPortBase port;
                int operStatus;
                block8: {
                    operStatus = rspVbl.intValue(i + 3);
                    int ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    port = sw.createPort(ifIndex);
                    port.setIfname(rspVbl.stringValue(i));
                    port.setIfSpeed(rspVbl.longValue(i + 1) * 1000000L);
                    port.setIfType(rspVbl.intValue(i + 2));
                    port.setIfDescr(rspVbl.stringValue(i + 4));
                    oldNonIPSEthPorts.remove(port);
                    byte[] b = rspVbl.byteValue(i + 5);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    macAddr = null;
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        if (!_Log.isDebugEnabled()) break block8;
                        _Log.warn((Object)(sw + " cannot recognized mac address:" + Arrays.toString(nb)));
                    }
                }
                port.setIfPhysicalAddress(macAddr);
                port.setIfAdminStatus((short)rspVbl.intValue(i + 6));
                port.setIfOperStatus((short)operStatus);
                port.setFcIfAdminSpeed(rspVbl.longValue(i + 7) * 1000000L);
                port.setFcifAdminMode((short)rspVbl.intValue(i + 8));
                port.setIfAlias(rspVbl.stringValue(i + 9));
                SnmpVarBind vb = rspVbl.getVb(i + 10);
                int[] oid = _FcGigEthernetIfOids[10];
                int[] index = SnmpAdapter.getIndexForVb(vb, oid);
                int indexPos = 1;
                if (index.length <= 2 || index[indexPos] != 1) continue;
                int n = ++indexPos;
                ++indexPos;
                int length = index[n];
                byte[] ipAddr = new byte[length];
                for (int k = 0; k < length; ++k) {
                    ipAddr[k] = new Integer(index[indexPos++]).byteValue();
                }
                port.setIpAddress(SnmpIpAddress.toString(ipAddr));
            }
        }
        for (FcPortBase port : oldNonIPSEthPorts) {
            sw.removePort(port.getIfIndex());
        }
        return true;
    }

    public static boolean discoverNonIPSEthernetPortChannels(SwitchImpl sw) throws SnmpException {
        HashSet<FcPortBase> oldNonIPSEthPortChannels = new HashSet<FcPortBase>(sw.findNonIPSEthPortChannels());
        FabricImpl fabric = sw.getFabric();
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FcGigEthernetIfOids[0]);
        IfIndexIf ifIndexIf = (IfIndexIf)((Object)sw.getBaseObject());
        int ethType = ifIndexIf.getActualType(22);
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw + " Snmp getBulk for Eth Port Channel, startIfIndex:" + (IfIndexUtil.getFirstValidIfIndexFor(ethType) - 1)));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(sw.createPeer(), vbl, 0, new int[]{IfIndexUtil.getFirstValidIfIndexFor(ethType) - 1}, new int[]{IfIndexUtil.getLastValidIfIndexFor(ethType) + 1});
        VarBindList rspVbl = rspPdu.getVariables();
        vbl = new VarBindList();
        for (SnmpVarBind vb : rspVbl) {
            int ifIndex = vb.getOid().getIndexFromEnd(0);
            for (int i = 0; i < _FcGigEthernetIfOids.length; ++i) {
                vbl.add(_FcGigEthernetIfOids[i], ifIndex);
            }
        }
        if (vbl.size() != 0) {
            rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            for (int i = 0; i < max; i += _FcGigEthernetIfOids.length) {
                FcPortBase port;
                FcPortImpl portImpl;
                MacAddress macAddr;
                String ifDescr;
                int ifType;
                long ifSpeed;
                String ifName;
                int ifIndex;
                int operStatus;
                block14: {
                    operStatus = rspVbl.intValue(i + 3);
                    if (operStatus != 1 && !_ReturnDownPort) continue;
                    ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    ifName = rspVbl.stringValue(i);
                    ifSpeed = rspVbl.longValue(i + 1) * 1000000L;
                    ifType = rspVbl.intValue(i + 2);
                    ifDescr = rspVbl.stringValue(i + 4);
                    macAddr = null;
                    byte[] b = rspVbl.byteValue(i + 5);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        if (!_Log.isDebugEnabled()) break block14;
                        _Log.warn((Object)(sw + " cannot recognized mac address:" + Arrays.toString(nb)));
                    }
                }
                short ifAdminStatus = (short)rspVbl.intValue(i + 6);
                short ifOperStatus = (short)operStatus;
                long fcIfAdminSpeed = rspVbl.longValue(i + 7) * 1000000L;
                short fcifAdminMode = (short)rspVbl.intValue(i + 8);
                String ifAlias = rspVbl.stringValue(i + 9);
                byte[] ipAddr = null;
                SnmpVarBind vb = rspVbl.getVb(i + 10);
                int[] oid = _FcGigEthernetIfOids[10];
                int[] index = SnmpAdapter.getIndexForVb(vb, oid);
                int indexPos = 1;
                if (index.length > 2 && index[indexPos] == 1) {
                    int n = ++indexPos;
                    ++indexPos;
                    int length = index[n];
                    ipAddr = new byte[length];
                    for (int k = 0; k < length; ++k) {
                        ipAddr[k] = new Integer(index[indexPos++]).byteValue();
                    }
                }
                if ((portImpl = fabric.findSwitchPortByKey((SwitchIntKey)(port = sw.createPort(ifIndex)).getSwitchPortPK())) == null) {
                    portImpl = new FcPortImpl(sw, port, false);
                    port.setIfname(ifName);
                    port.setIfSpeed(ifSpeed);
                    port.setIfType(ifType);
                    port.setIfDescr(ifDescr);
                    port.setIfPhysicalAddress(macAddr);
                    port.setIfAdminStatus(ifAdminStatus);
                    port.setIfOperStatus(ifOperStatus);
                    port.setFcIfAdminSpeed(fcIfAdminSpeed);
                    port.setFcifAdminMode(fcifAdminMode);
                    port.setIfAlias(ifAlias);
                    if (ipAddr != null) {
                        port.setIpAddress(SnmpIpAddress.toString(ipAddr));
                    }
                    fabric.addSwitchPort(portImpl);
                } else {
                    portImpl.setIfname(ifName);
                    portImpl.setIfSpeed(ifSpeed);
                    portImpl.setIfType(ifType);
                    portImpl.setIfDescr(ifDescr);
                    portImpl.setIfPhysicalAddress(macAddr);
                    portImpl.getBase().setIfAdminStatus(ifAdminStatus);
                    portImpl.setIfOperStatus(ifOperStatus);
                    portImpl.getBase().setFcIfAdminSpeed(fcIfAdminSpeed);
                    portImpl.getBase().setFcifAdminMode(fcifAdminMode);
                    portImpl.setIfAlias(ifAlias);
                    if (ipAddr != null) {
                        portImpl.setIpAddress(SnmpIpAddress.toString(ipAddr));
                    }
                }
                oldNonIPSEthPortChannels.remove(port);
            }
        }
        for (FcPortBase port : oldNonIPSEthPortChannels) {
            sw.removePort(port.getIfIndex());
            fabric.removeSwitchPort((SwitchIntKey)port.getSwitchPortPK(), true);
        }
        return true;
    }

    public static boolean discoverMdsGigaEthernetPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FcIfGigEPortChannIfOid);
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        vbl = new VarBindList();
        for (SnmpVarBind vb : rspVbl) {
            int ifIndex = vb.getOid().getIndexFromEnd(0);
            for (int i = 0; i < _FcGigEthernetIfOids.length; ++i) {
                vbl.add(_FcGigEthernetIfOids[i], ifIndex);
            }
        }
        List<FcPortBase> oldGigEthPorts = sw.findGigEthPorts();
        if (vbl.size() != 0) {
            rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
            rspVbl = rspPdu.getVariables();
            int max = rspVbl.size();
            for (int i = 0; i < max; i += _FcGigEthernetIfOids.length) {
                MacAddress macAddr;
                FcPortBase port;
                int operStatus;
                block8: {
                    operStatus = rspVbl.intValue(i + 3);
                    if (operStatus != 1 && !_ReturnDownPort) continue;
                    int ifIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
                    port = sw.createPort(ifIndex);
                    port.setIfname(rspVbl.stringValue(i));
                    port.setIfSpeed(rspVbl.longValue(i + 1) * 1000000L);
                    port.setIfType(rspVbl.intValue(i + 2));
                    port.setIfDescr(rspVbl.stringValue(i + 4));
                    oldGigEthPorts.remove(port);
                    byte[] b = rspVbl.byteValue(i + 5);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    macAddr = null;
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        if (!_Log.isDebugEnabled()) break block8;
                        _Log.warn((Object)(sw + " cannot recognized mac address:" + Arrays.toString(nb)));
                    }
                }
                port.setIfPhysicalAddress(macAddr);
                port.setIfAdminStatus((short)rspVbl.intValue(i + 6));
                port.setIfOperStatus((short)operStatus);
                port.setFcIfAdminSpeed(rspVbl.longValue(i + 7) * 1000000L);
                port.setFcifAdminMode((short)rspVbl.intValue(i + 8));
                port.setIfAlias(rspVbl.stringValue(i + 9));
                SnmpVarBind vb = rspVbl.getVb(i + 10);
                int[] oid = _FcGigEthernetIfOids[10];
                int[] index = SnmpAdapter.getIndexForVb(vb, oid);
                int indexPos = 1;
                if (index.length <= 2 || index[indexPos] != 1) continue;
                int n = ++indexPos;
                ++indexPos;
                int length = index[n];
                byte[] ipAddr = new byte[length];
                for (int k = 0; k < length; ++k) {
                    ipAddr[k] = new Integer(index[indexPos++]).byteValue();
                }
                port.setIpAddress(SnmpIpAddress.toString(ipAddr));
            }
        }
        for (FcPortBase port : oldGigEthPorts) {
            sw.removePort(port.getIfIndex());
        }
        return true;
    }

    public static boolean discoverMdsFcipPorts(SwitchImpl sw) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(_FcipLinkEthIfIndexVar));
        vbl.add(new SnmpVarBind(_FcipLinkIfIndexVar));
        SnmpPDU resp = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return true;
        }
        int gigEInterface = 0;
        int fcipInterface = 0;
        for (int i = 0; i < vbl.size(); i += 2) {
            gigEInterface = vbl.intValue(i);
            fcipInterface = vbl.intValue(i + 1);
            FcPortBase port = sw.findPort(fcipInterface);
            if (port == null) continue;
            port.setParent(gigEInterface);
        }
        return true;
    }

    public static boolean discoverConnUnitPorts(SwitchImpl sw) throws SnmpException {
        int i;
        int[] ifIndices = sw.findIfIndices();
        if (ifIndices == null) {
            return false;
        }
        int[] index = new int[17];
        if (sw.getWwn() != null) {
            byte[] wwn = sw.getWwn().getValue();
            for (i = 0; i < 8; ++i) {
                index[i] = wwn[i] & 0xFF;
            }
        }
        VarBindList vbl = new VarBindList(ifIndices.length * _ConnUnitPortOids.length);
        for (i = 0; i < ifIndices.length; ++i) {
            index[16] = IfIndexUtil.ifIndex2Port(ifIndices[i]) + 1;
            for (int j = 0; j < _ConnUnitPortOids.length; ++j) {
                vbl.add(_ConnUnitPortOids[j], index);
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        for (int i2 = 0; i2 < vbl.size(); i2 += _ConnUnitPortOids.length) {
            SnmpVarBind vb = vbl.get(i2);
            if (vb.getVar().getType() != 2) continue;
            int portIndex = vb.getOid().getIndexFromEnd(0);
            int ifIndex = sw.isQuail() ? IfIndexUtil.nameToIfIndex(1, portIndex, 1) : portIndex;
            short mode = (short)vbl.intValue(i2);
            long speed = Math.round((double)((float)(vbl.intValue(i2 + 1) * 8) / 1000000.0f) + 0.5) * 1000000000L;
            if (mode == 9) {
                IslImpl isl = fabric.findIsl(sw, ifIndex);
                if (isl == null) continue;
                isl.setOperMode((short)4);
                isl.setSpeed(speed);
                continue;
            }
            if (mode != 7 && mode != 8) continue;
            ArrayList<EndPortImpl> eps = fabric.findEndPortsBySwitchIfIndex(sw, ifIndex);
            for (EndPortImpl ep : eps) {
                ep.setLoop(mode == 7);
                ep.setSpeed(speed);
            }
        }
        return true;
    }

    public static boolean discoverPCPorts(SwitchImpl sw) throws SnmpException {
        List<FcPortBase> pcports = sw.findPortChannelPorts();
        if (pcports.size() == 0) {
            sw.resetDiscFlag(1024);
            return false;
        }
        HashMap<Integer, FcPortBase> pcPortsByIndex = new HashMap<Integer, FcPortBase>(pcports.size());
        VarBindList vbl = new VarBindList(pcports.size() * 2);
        for (FcPortBase pcPort : pcports) {
            int pcIndex = (pcPort.getIfIndex() & 0xFF) + 1;
            pcPortsByIndex.put(pcIndex, pcPort);
            vbl.add(new SnmpVarBind(new SnmpOID(PortChannelWorker._PCMbrListOid, pcIndex)));
            vbl.add(new SnmpVarBind(new SnmpOID(PortChannelWorker._PCAutoCreateOid, pcIndex)));
        }
        SnmpPDU pdu = SnmpFetch.get(sw.createPeer(), vbl);
        vbl = pdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        for (int i = 0; i < vbl.size(); i += 2) {
            int ifIndex;
            IslImpl pcIsl;
            int[] members;
            int[] oid;
            int pcIndex;
            FcPortBase pcPort;
            SnmpVarBind vb = vbl.getVb(i);
            SnmpVar v = vb.getVar();
            if (v.getType() != 4 || (pcPort = (FcPortBase)pcPortsByIndex.get(pcIndex = (oid = vb.getOid().getValue())[oid.length - 1])) == null || (members = SnmpIntList.valueOf(((SnmpString)vb.getVar()).getValue())).length == 0 || (pcIsl = fabric.findIsl(sw, ifIndex = pcPort.getIfIndex())) == null) continue;
            pcIsl.setConfigChildCount((short)members.length);
            pcIsl.setPortChannelAutoCreated(vbl.intValue(i + 1) == 1);
        }
        sw.resetDiscFlag(1024);
        return true;
    }

    public static boolean discoverVsanFiconState(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (!sw.isFeatureEnabled(AbstractSwitchBase.Feature.FICON.flag())) {
            for (VsanImpl vsan : vsanById.values()) {
                vsan.setFiconState((byte)0);
                vsan.resetDiscFlag(256);
            }
            return false;
        }
        VarBindList vbl = new VarBindList(vsanById.size());
        for (short vid : vsanById.keySet()) {
            vbl.add(_FiconVsanOid, vid);
        }
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        for (SnmpVarBind vb : vbl) {
            short vid = (short)vb.getOid().getIndexFromEnd(0);
            VsanImpl vsan = sw.getVsan(vid);
            SnmpVar var = vb.getVar();
            if (vsan == null) continue;
            vsan.setFiconState(var.getType() == 2 ? (byte)((SnmpInt)var).getValue() : (byte)0);
            vsan.resetDiscFlag(256);
        }
        return true;
    }

    public static boolean discoverVsanSwitches(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverFcsIes(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnits(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverFcsIes(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        HashMap<Short, List<SwitchImpl>> oldSwsByVid = new HashMap<Short, List<SwitchImpl>>(vsanById.size());
        for (Map.Entry<Short, VsanImpl> ent : vsanById.entrySet()) {
            oldSwsByVid.put(ent.getKey(), ent.getValue().getSwitches());
        }
        SnmpPDU reqPdu = SnmpFetch.getBulk(sw.createPeer(), _FcsIeOids, GenUtil.shortListToIntArray(vsanById.keySet()));
        VarBindList rspVbl = reqPdu.getVariables();
        HashMap<Integer, SwitchImpl> swByMgmtIndex = new HashMap<Integer, SwitchImpl>(rspVbl.size() / _FcsIeOids.length);
        HashMap<Integer, VsanDomain> vdomainByMgmtIndex = new HashMap<Integer, VsanDomain>(swByMgmtIndex.size());
        ArrayList<SwitchImpl> mergedSw = new ArrayList<SwitchImpl>();
        FabricImpl fabric = sw.getFabric();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < rspVbl.size(); i += _FcsIeOids.length) {
            List oldSws;
            int mgmtIndex;
            String logicalName;
            SnmpVarBind vb = rspVbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            short vid = (short)oid[oid.length - 9];
            VsanImpl vsan = sw.getVsan(vid);
            if (vsan == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- VSAN " + vid + " missing"));
                continue;
            }
            short domainId = (short)rspVbl.intValue(i);
            if (domainId == 0) continue;
            byte[] bvwwn = new byte[8];
            GenUtil.arraycopy(oid, oid.length - 8, bvwwn, 0, 8);
            Wwn vwwn = new Wwn(bvwwn);
            Wwn swwn = null;
            SwitchImpl ie = null;
            if (vsan.getInterOperMode() != 4) {
                int vendorId = WwnDictionary.getVendorId(bvwwn);
                if (WwnDictionary.isCisco(vendorId)) {
                    if (!WwnDictionary.isQuailWwn(bvwwn)) {
                        byte[] bswwn = new byte[8];
                        System.arraycopy(bvwwn, 0, bswwn, 0, 8);
                        WwnDictionary.vsanWwnToSwwn(bswwn);
                        swwn = new Wwn(bswwn);
                    } else {
                        swwn = vwwn;
                    }
                } else {
                    WwnVendor v = WwnDictionary.findWwnVendor(vendorId);
                    if (v == null) {
                        v = WwnDictionary.addDiscoveredOUI(vendorId, "Cisco", 32);
                        if (v != null) {
                            _Log.info((Object)("***** Add new discovered OUI to WwnDictionary:" + WwnVendor.format(v) + "; please add the new OUI to server.properties->newOUIs as permanent one."));
                            sw.addNewOUI(v);
                        }
                        byte[] bswwn = new byte[8];
                        System.arraycopy(bvwwn, 0, bswwn, 0, 8);
                        WwnDictionary.vsanWwnToSwwn(bswwn);
                        swwn = new Wwn(bswwn);
                    } else {
                        swwn = vwwn;
                    }
                }
                if (bvwwn[0] >> 4 == 5 && WwnDictionary.isMDSWwn(bvwwn)) {
                    if (!_Log.isDebugEnabled()) continue;
                    _Log.debug((Object)(sw.getIpAddress() + " -- ignore IVR RDI " + SnmpString.toHexString(bvwwn) + " in VSAN " + vid + " domain ID=" + domainId));
                    continue;
                }
                int derivedVid = ((bvwwn[0] & 0xF) << 8) + (bvwwn[1] & 0xFF);
                if (WwnDictionary.isMDSWwn(bvwwn) && vid != derivedVid) {
                    if (!_Log.isDebugEnabled()) continue;
                    _Log.debug((Object)(sw.getIpAddress() + " -- ignore virtual switch " + SnmpString.toHexString(bvwwn) + " in VSAN " + vid + " domain Id " + domainId));
                    continue;
                }
            } else {
                domainId = (short)(domainId - 96);
                String ieInfoList = MibVariableFormat.fcsIeInfoList(rspVbl.getVb(i + 3).getVar()).toString();
                if (ieInfoList != null && ieInfoList.indexOf("Cisco") != -1) {
                    ie = vsan.findSwitchByVwwn(bvwwn);
                    if (ie != null) {
                        swwn = ie.getWwn();
                    } else {
                        byte[] bswwn = SnmpAdapter.parseWwn(ieInfoList);
                        if (bswwn != null) {
                            swwn = new Wwn(bswwn);
                        } else {
                            _Log.warn((Object)(sw.getIpAddress() + " -- MDS canonical WWN not found in fcsIeInfoList (" + ieInfoList + ") in interop-4 VSAN " + vid));
                            continue;
                        }
                    }
                    vwwn = new Wwn(bvwwn);
                    SwitchImpl mds = sm.findSwitch(vwwn, fabric.getPK());
                    if (mds != null && mds.isMDS()) {
                        sm.removeSwitch(mds);
                    }
                } else {
                    swwn = vwwn;
                }
            }
            WwnKey swKey = new WwnKey(swwn);
            ie = sm.findSwitchByPK(swKey, fabric);
            if (ie == null) {
                ie = sm.createSwitch(swwn, null, fabric);
            } else if (ie.getFabric() == null) {
                ie.setFabric(fabric);
            } else if (ie.getFabric() != fabric) {
                ie = sm.mergeSwitch(ie, fabric);
                mergedSw.add(ie);
            }
            vsan.addSwitch(ie, domainId, vwwn);
            if (ie.getLastScanTime() < fabric.getLastScanTime()) {
                ie.syncLastScanTime();
            }
            if (ie.getSysName() == null && (logicalName = rspVbl.stringValue(i + 2)) != null && logicalName.length() != 0) {
                ie.setSysName(logicalName);
            }
            if ((mgmtIndex = rspVbl.intValue(i + 1)) != 0) {
                swByMgmtIndex.put(mgmtIndex, ie);
                VsanDomain vdk = ie.getVsanDomain(vid);
                if (vdk != null) {
                    vdomainByMgmtIndex.put(mgmtIndex, vdk);
                }
            }
            if ((oldSws = (List)oldSwsByVid.get(vid)) == null) continue;
            oldSws.remove(ie);
        }
        Iterator i$ = oldSwsByVid.keySet().iterator();
        while (i$.hasNext()) {
            short vid = (Short)i$.next();
            VsanImpl v = sw.getVsan(vid);
            if (v == null) continue;
            v.resetDiscFlag(1);
            for (SwitchImpl oldsw : (List)oldSwsByVid.get(vid)) {
                if (oldsw == null || oldsw.isNpvEnabled() || !v.isUp() && oldsw == sw) continue;
                v.removeSwitch(oldsw);
            }
        }
        if (swByMgmtIndex.size() == 0) {
            return true;
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FcsMgmtAddrOid);
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        rspVbl = rspPdu.getVariables();
        IdentityHashMap addrsBySw = new IdentityHashMap(swByMgmtIndex.size());
        for (int i = 0; i < rspVbl.size(); ++i) {
            ArrayList<InetAddress> list;
            VsanDomain vdk;
            InetAddress inetAddr;
            int mgmtIndex;
            SwitchImpl ie;
            String addr = rspVbl.stringValue(i);
            if (!addr.startsWith("snmp") || addr.indexOf("0.0.0.0") != -1 || addr.indexOf("255.255.255.255") != -1 || (ie = (SwitchImpl)swByMgmtIndex.get(mgmtIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(1))) == null || (inetAddr = NetUtil.parseIpAddress(addr)) == null) continue;
            if (addr.endsWith("vsan-ip") && (vdk = (VsanDomain)vdomainByMgmtIndex.get(mgmtIndex)) != null && !inetAddr.isLinkLocalAddress() && !inetAddr.isMulticastAddress()) {
                ie.setVsanIp(vdk._vsanPK._id, inetAddr);
            }
            if ((list = (ArrayList<InetAddress>)addrsBySw.get(ie)) == null) {
                list = new ArrayList<InetAddress>(2);
                addrsBySw.put(ie, list);
            }
            if (list.contains(inetAddr) || addr.endsWith("vsan-ip")) continue;
            if (list.size() == 1 && WwnDictionary.isMcDataWwn(ie.getWwn().getValue())) {
                list.remove(0);
            }
            list.add(inetAddr);
        }
        for (Map.Entry entry : addrsBySw.entrySet()) {
            ArrayList list = (ArrayList)entry.getValue();
            SwitchImpl ie = (SwitchImpl)entry.getKey();
            InetAddress[] addrs = null;
            addrs = list.size() == 0 ? ie.getVsanIps() : list.toArray(new InetAddress[list.size()]);
            InetAddress curAddr = ie.getInetAddress();
            if (Boolean.parseBoolean(System.getProperty("fabric.managementIpOverwrite")) || ie.getManagementAddresses() == null || ie.getManagementAddresses() != null && ie.getManagementAddresses().length == 0) {
                ie.setManagementAddresses(addrs);
            } else if (_Log.isDebugEnabled()) {
                _Log.debug((Object)("discoverFcsIes: won't update management IP of switch '" + ie.getName() + "' with '" + Arrays.asList(addrs) + "'"));
            }
            SwitchImpl seed = fabric.getSeed();
            if (seed.getWwn() == null && GenUtil.equals(seed.getInetAddress(), ie.getInetAddress())) {
                seed.setWwn(ie.getWwn());
                seed.setSysName(ie.getSysName());
                Map<Short, VsanImpl> vsanByvid = ie.getVsans();
                for (Map.Entry<Short, VsanImpl> entry1 : vsanByvid.entrySet()) {
                    VsanImpl vsan = entry1.getValue();
                    VsanDomain vd = ie.getVsanDomain(entry1.getKey());
                    vsan.removeSwitch(ie);
                    vsan.addSwitch(seed, vd._domainId, vd.getVsanWwn());
                }
                ie.setFabric(null);
                sm.addSwitchByPK(seed);
                continue;
            }
            if (GenUtil.equals(curAddr, ie.getInetAddress()) && !mergedSw.contains(ie)) continue;
            try {
                ie.getFabric().getWorker().startSwitchWorker(ie);
            }
            catch (DiscoveryException dex) {
                _Log.warn((Object)("starting switch worker failed: " + dex.getMessage()));
            }
        }
        return true;
    }

    public static boolean discoverConnUnits(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        SnmpOID oid;
        short vid = 0;
        VsanImpl vsan = null;
        List<SwitchImpl> oldSws = null;
        if (vsanById == null || vsanById.size() == 0) {
            if (!sw.isFabricSeed()) {
                return false;
            }
        } else {
            vid = vsanById.keySet().iterator().next();
            vsan = sw.getVsan(vid);
            if (vsan != null) {
                oldSws = vsan.getSwitches();
            }
        }
        if (sw.getNumConnUnits() == 0) {
            return true;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover ConnUnits in VSAN " + vid));
        VarBindList vbl = new VarBindList(_ConnUnitOids.length);
        for (int i = 0; i < _ConnUnitOids.length; ++i) {
            vbl.add(_ConnUnitOids[i]);
        }
        SnmpPDU reqPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, sw.getNumConnUnits());
        vbl = reqPdu.getVariables();
        HashMap<Short, SwitchImpl> swByDid = new HashMap<Short, SwitchImpl>(vbl.size() / _ConnUnitOids.length);
        HashMap<Short, Wwn> vwwnByDid = new HashMap<Short, Wwn>(vbl.size() / _ConnUnitOids.length);
        ArrayList<SwitchImpl> newSwitches = new ArrayList<SwitchImpl>(swByDid.size());
        FabricImpl fabric = sw.getFabric();
        Wwn prinwwn = null;
        for (int i = 0; i < vbl.size() && (oid = vbl.getVb(i).getOid()).startsWith(_ConnUnitOids[0]); i += _ConnUnitOids.length) {
            byte[] bvwwn = new byte[8];
            GenUtil.arraycopy(oid.getValue(), oid.getValue().length - 16, bvwwn, 0, 8);
            Wwn vwwn = new Wwn(bvwwn);
            if (WwnDictionary.isMDSWwn(bvwwn) && vid == 0) {
                vid = (short)(((bvwwn[0] & 0xF) << 8) + (bvwwn[1] & 0xFF));
            }
            bvwwn = new byte[8];
            GenUtil.arraycopy(oid.getValue(), oid.getValue().length - 16, bvwwn, 0, 8);
            SwitchImpl sw0 = SnmpAdapter.createSwitchFromVsanWwn(bvwwn, fabric);
            String url = vbl.stringValue(i + 5);
            InetAddress addr = NetUtil.parseIpAddress(url);
            if (addr != null && !addr.equals(sw0.getInetAddress())) {
                sw0.setManagementAddresses(new InetAddress[]{addr});
                newSwitches.add(sw0);
            }
            sw0.setConnUnitStatus(vbl.intValue(i));
            sw0.setNumFcPorts(vbl.intValue(i + 1));
            sw0.setSerialNumber(vbl.stringValue(i + 2));
            sw0.setSysDescr(vbl.stringValue(i + 3));
            sw0.setSysUpTime(vbl.longValue(i + 4));
            sw0.setSysName(vbl.stringValue(i + 6));
            sw0.setContact(vbl.stringValue(i + 7));
            sw0.setLocation(vbl.stringValue(i + 8));
            short domainId = (short)(vbl.byteValue(i + 9)[2] & 0xFF);
            swByDid.put(domainId, sw0);
            vwwnByDid.put(domainId, vwwn);
            if (oldSws != null) {
                oldSws.remove(sw0);
            }
            byte[] bv = vbl.byteValue(i + 10);
            byte[] fb = new byte[8];
            System.arraycopy(bv, 0, fb, 0, 8);
            prinwwn = new Wwn(fb);
            sw0.setNumConnLinks(vbl.intValue(i + 11));
            String vendor = vbl.stringValue(i + 12);
            int pos = vendor.indexOf(32);
            if (pos == -1) {
                sw0.setVendor(vendor);
            } else {
                sw0.setVendor(vendor.substring(0, pos));
            }
            sw0.resetDiscFlag(4);
            if (sw0.getLastScanTime() >= fabric.getLastScanTime()) continue;
            sw0.syncLastScanTime();
        }
        if (vid == 0) {
            vid = 1;
        }
        if (vsan == null) {
            vsan = fabric.createVsan(vid, prinwwn);
            vsan.setName("VSAN" + vid);
        } else if (prinwwn != null && !prinwwn.equals(vsan.getPrincipalSwitchWwn())) {
            vsan.removeSwitch(sw);
            vsan = fabric.createVsan(vid, prinwwn);
        }
        vsan.setOperState((byte)1);
        vsan.syncLastScanTime();
        for (SwitchImpl sw1 : swByDid.values()) {
            if (!sw1.isManageableMDS() || vsan.getSeed() != null && !vsan.getSeed().isQuail()) continue;
            vsan.setSeed(sw1);
        }
        if (vsan.getSeed() == null) {
            vsan.setSeed(sw);
        }
        Iterator<Object> i$ = swByDid.keySet().iterator();
        while (i$.hasNext()) {
            short did = (Short)i$.next();
            SwitchImpl sw2 = (SwitchImpl)swByDid.get(did);
            vsan.addSwitch(sw2, did, (Wwn)vwwnByDid.get(did));
        }
        for (SwitchImpl sw3 : newSwitches) {
            if (sw3.getInetAddress() == null) continue;
            try {
                fabric.getWorker().startSwitchWorker(sw3);
            }
            catch (DiscoveryException dex) {
                _Log.warn((Object)("starting switch worker failed: " + dex.getMessage()));
            }
        }
        if (oldSws != null) {
            for (SwitchImpl oldsw : oldSws) {
                if (oldsw.isNpvEnabled()) continue;
                vsan.removeSwitch(oldsw);
            }
        }
        vsan.resetDiscFlag(1);
        return true;
    }

    public static boolean discoverVsanEndPorts(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverFcns(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitSns(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverFcns(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        int fcId;
        int[] fc4Type;
        byte[] btype;
        int i;
        HashMap<Short, List<EndPortImpl>> oldEpsByVid = new HashMap<Short, List<EndPortImpl>>(vsanById.size());
        HashMap<Short, List<NpvLinkImpl>> oldNpvlsByVid = new HashMap<Short, List<NpvLinkImpl>>(vsanById.size());
        HashMap<Short, List<SwitchImpl>> oldNpvsByVid = new HashMap<Short, List<SwitchImpl>>(vsanById.size());
        for (Map.Entry<Short, VsanImpl> ent : vsanById.entrySet()) {
            short vid = ent.getKey();
            VsanImpl vsan = ent.getValue();
            oldEpsByVid.put(vid, vsan.getEndPorts());
            oldNpvlsByVid.put(vid, vsan.getNpvLinks());
            oldNpvsByVid.put(vid, vsan.getNpvEdgeSwitches());
        }
        _Log.trace((Object)(sw.getIpAddress() + " start snmp query fcns database for vsans " + vsanById.values()));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), _FcnsOids, GenUtil.shortListToIntArray(vsanById.keySet()));
        _Log.trace((Object)(sw.getIpAddress() + " done snmp query fcns database for vsans " + vsanById.values()));
        VarBindList rspVbl = rspPdu.getVariables();
        _Log.trace((Object)(sw.getIpAddress() + " fcns database returned total endports " + rspVbl.size() / 6 + " for vsans " + vsanById.values()));
        FabricImpl fabric = sw.getFabric();
        SanManager sm = SanManager.getInstance();
        VarBindList symNameVbl = new VarBindList();
        int[] fcnsIndex = new int[4];
        HashMap<Wwn, SwitchImpl> npvSwByFwwn = new HashMap<Wwn, SwitchImpl>();
        HashMap<Long, SwitchImpl> npvSwByVsanFcid = new HashMap<Long, SwitchImpl>();
        HashMap<Wwn, SwitchImpl> newNpvSwBySwwn = new HashMap<Wwn, SwitchImpl>();
        for (i = 0; i < rspVbl.size(); i += _FcnsOids.length) {
            SwitchImpl coreSw;
            SwitchImpl oldnpvSw;
            Wwn swwn;
            int[] oid = rspVbl.getVb(i).getOid().getValue();
            short vsanId = (short)oid[oid.length - 4];
            byte[] bnwwn = rspVbl.byteValue(i + 1);
            byte[] bvwwn = new byte[8];
            System.arraycopy(bnwwn, 0, bvwwn, 0, 8);
            btype = null;
            fc4Type = null;
            if (!rspVbl.getVb(i + 4).isNull()) {
                btype = rspVbl.byteValue(i + 4);
                fc4Type = SnmpIntList.valueOf(btype);
                if (!Fc4Decoder.isFc4TypeSet(fc4Type, 229)) {
                    continue;
                }
            } else if (!WwnDictionary.isBrocadeWwn(bnwwn)) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " fcns entry does not have fc4type, skip npv check with nwwn:" + Arrays.toString(bnwwn)));
                continue;
            }
            if (!WwnDictionary.isCiscoWwn((swwn = SnmpAdapter.vsanWwnToSwitchWwn(bvwwn)).getValue()) && !WwnDictionary.isBrocadeWwn(swwn.getValue())) {
                _Log.info((Object)(sw.getIpAddress() + " fcns entry cannot be identified as NPV device because of the unknown wwn:" + swwn + "; please add the new OUI to server.properties->newOUIs as permanent one."));
                continue;
            }
            WwnKey swKey = new WwnKey(swwn);
            SwitchImpl npvSw = SanManager.getInstance().findSwitchByPK(swKey, fabric);
            if (npvSw == null) {
                npvSw = SanManager.getInstance().createSwitch(swwn, null, fabric);
                newNpvSwBySwwn.put(npvSw.getSwitchPK()._wwn, npvSw);
            } else if (npvSw.getFabric() == null) {
                npvSw.setFabric(fabric);
            } else if (npvSw.getFabric() != fabric && (oldnpvSw = npvSw) != (npvSw = SanManager.getInstance().mergeSwitch(npvSw, fabric))) {
                newNpvSwBySwwn.put(npvSw.getSwitchPK()._wwn, npvSw);
            }
            npvSw.setFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag(), true);
            ((List)oldNpvsByVid.get(vsanId)).remove(npvSw);
            int domainId = oid[oid.length - 3];
            VsanImpl vsan = sw.getVsan(vsanId);
            if (vsan == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- finding VSAN " + vsanId + " failed on the switch, cannot create NP link for npv node:" + npvSw));
                continue;
            }
            vsan.addSwitch(npvSw, domainId, new Wwn(bnwwn));
            System.arraycopy(oid, oid.length - 4, fcnsIndex, 0, 4);
            symNameVbl.add(_FcnsSymNodeNameOid, fcnsIndex);
            symNameVbl.add(_FcnsSymPortNameOid, fcnsIndex);
            symNameVbl.add(_FcnsNodeIpAddrOid, fcnsIndex);
            fcId = ((oid[oid.length - 3] & 0xFF) << 16) + ((oid[oid.length - 2] & 0xFF) << 8) + (oid[oid.length - 1] & 0xFF);
            VsanFcIdKey vsanFcidKey = new VsanFcIdKey(vsan.getVsanPK(), fcId);
            long vsanFcid = WwnDictionary.composeVsanFcid(vsanId, fcId);
            npvSwByVsanFcid.put(vsanFcid, npvSw);
            byte[] bfwwn = rspVbl.byteValue(i + 2);
            npvSwByFwwn.put(new Wwn(bfwwn), npvSw);
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " -- NPV device discovered " + npvSw.getWwn() + " registered in fcns-VSAN " + vsanId + " FCID=" + fcId + " vsanFcId=" + vsanFcid));
            }
            if ((coreSw = vsan.findSwitchByDomainId(domainId)) == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- finding NPV core failed with domain ID=" + domainId + " in VSAN " + vsanId + ", cannot create NP link and associate NPV end devices for npv node:" + npvSw + " coreDomainId=" + domainId));
                continue;
            }
            byte[] bnpwwn = ((SnmpString)rspVbl.getVb(i).getVar()).getValue();
            int fpIfindex = coreSw.getBase().ifWwn2IfIndex(bfwwn, IfIndexIf.FwwnInfo.NPV);
            int npIfindex = -1;
            int fpIfType = IfIndexUtil.getType(fpIfindex);
            npIfindex = fpIfType == 1 ? npvSw.getBase().ifWwn2IfIndex(bnpwwn, IfIndexIf.FwwnInfo.FC_Port) : (fpIfType == 30 ? npvSw.getBase().ifWwn2IfIndex(bnpwwn, IfIndexIf.FwwnInfo.VFC) : (fpIfType == 4 ? npvSw.getBase().ifWwn2IfIndex(bnpwwn, IfIndexIf.FwwnInfo.FC_Channel) : npvSw.getBase().ifWwn2IfIndex(bnpwwn, IfIndexIf.FwwnInfo.NPV)));
            Wwn fwwn = new Wwn(bfwwn);
            Wwn npwwn = new Wwn(bnpwwn);
            NpvLinkImpl npvl = fabric.createNpvLink(coreSw, npvSw, fpIfindex, npIfindex, bfwwn, bnpwwn);
            vsan.addNpvLink(npvl);
            ((List)oldNpvlsByVid.get(vsanId)).remove(npvl);
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " -- NP link discovered " + npvl + " " + coreSw.getWwn() + "/" + SnmpString.toHexString(bfwwn) + " <-> " + npvSw.getWwn() + "/" + SnmpString.toHexString(bnpwwn) + " registered in fcns-VSAN " + vsanId + " FCID=" + fcId + " vsanFcId=" + vsanFcid));
            }
            SwitchBase swBase = coreSw.getBase();
            if (coreSw.getBase().isVfcIfIndex(fpIfindex)) {
                coreSw.setFeatureEnabled(AbstractSwitchBase.Feature.FCOE.flag(), true);
                coreSw.setDiscFlag(32768);
                npvSw.setFeatureEnabled(AbstractSwitchBase.Feature.FCOE.flag(), true);
                npvSw.setDiscFlag(32768);
            } else if (coreSw.getBase().isPCIfIndex(fpIfindex)) {
                coreSw.setDiscFlag(1024);
                npvSw.setDiscFlag(1024);
                vsan.setDiscFlag(128);
            } else if ((swBase.getModelType() > 0 || swBase.isCisco() && !swBase.isQuail()) && !swBase.isN5K() && swBase.isFCoEEnabled() || IfIndexUtil.isFmWwnPidIdx(fpIfindex)) {
                fabric.addPendingLink(new SwitchIfWwnKey(coreSw.getSwitchPK(), fwwn), npvl);
            }
            if (!IfIndexUtil.isFmIfIndex(npIfindex)) continue;
            fabric.addPendingLink(new SwitchIfWwnKey(npvSw.getSwitchPK(), npwwn), npvl);
        }
        for (i = 0; i < rspVbl.size(); i += _FcnsOids.length) {
            boolean swportChanged;
            SwitchImpl flogiSw;
            int feature;
            SnmpVarBind vb = rspVbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            short vsanId = (short)oid[oid.length - 4];
            Wwn pwwn = new Wwn(((SnmpString)vb.getVar()).getValue());
            btype = null;
            if (!rspVbl.getVb(i + 4).isNull()) {
                btype = rspVbl.byteValue(i + 4);
            }
            fc4Type = btype != null ? SnmpIntList.valueOf(btype) : null;
            byte[] bnwwn = rspVbl.byteValue(i + 1);
            if (fc4Type == null || Fc4Decoder.isFc4TypeSet(fc4Type, 229)) {
                byte[] bvwwn = new byte[8];
                System.arraycopy(bnwwn, 0, bvwwn, 0, 8);
                Wwn swwn = SnmpAdapter.vsanWwnToSwitchWwn(bvwwn);
                if (WwnDictionary.isBrocadeWwn(swwn.getValue()) || WwnDictionary.isCiscoWwn(swwn.getValue()) && Fc4Decoder.isFc4TypeSet(fc4Type, 229)) continue;
            }
            if (Fc4Decoder.isFc4TypeSet(fc4Type, 227) && !_RetainSETPorts) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore SAN_EXT_TUNER port " + pwwn + " in VSAN " + vsanId));
                continue;
            }
            byte[] fc4Features = rspVbl.byteValue(i + 5);
            if (!_EnableVIRT && Fc4Decoder.isFc4TypeSet(fc4Type, 224) && ((feature = Fc4Decoder.getFc4TypeFeature(224, fc4Features)) == 6 || feature == 5 || feature == 7)) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore virtual internal port " + pwwn + " in VSAN " + vsanId));
                continue;
            }
            if ((Fc4Decoder.isFc4FeatureSet(fc4Features, 224, 4) || WwnDictionary.isCiscoWwn(pwwn.getValue()) && pwwn.getValue()[0] >> 4 == 1) && !_EnableIPFC) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore virtual IPFC port " + pwwn + " in VSAN " + vsanId));
                continue;
            }
            if (WwnDictionary.isVRRP(pwwn.getValue())) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore VRRP IPFC port " + pwwn + " in VSAN " + vsanId));
                continue;
            }
            byte[] bfwwn = rspVbl.byteValue(i + 2);
            if (bfwwn.length == 0 || bfwwn[0] == 0) {
                _Log.warn((Object)(sw.getIpAddress() + " -- ignore end port device with no valid FWWN in VSAN " + vsanId + "," + SnmpString.toHexString(bfwwn) + ", " + SnmpString.toHexString(bnwwn) + "," + pwwn));
                continue;
            }
            VsanImpl vsan = sw.getVsan(vsanId);
            if (vsan == null) {
                _Log.warn((Object)(sw.getIpAddress() + " -- cannot find VSAN " + vsanId + " on the switch"));
                continue;
            }
            Wwn nwwn = new Wwn(bnwwn);
            int domainId = oid[oid.length - 3];
            if (vsan.getInterOperMode() == 4) {
                domainId -= 96;
            }
            if ((flogiSw = vsan.findSwitchByDomainId(domainId)) == null) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore NxPort " + pwwn + " in VSAN " + vsanId + " attached to unknown FxPort " + WwnDictionary.get(bfwwn) + " on domain " + domainId));
                continue;
            }
            EndPortImpl ep = sm.findEndPort(pwwn, fabric.getPK());
            if (ep == null) {
                ep = sm.createEndPort(pwwn, nwwn, fc4Type, fc4Features, fabric);
            } else {
                ep.setFc4Type(fc4Type);
                ep.setFc4Feature(fc4Features);
                ep.setFabric(fabric);
                ep.setNodeWwn(nwwn);
                if (EndPortImpl.getAutoAliasFlag()) {
                    ep.setAutoAlias(ep.createAutoAlias());
                }
            }
            boolean bl = swportChanged = !Arrays.equals(ep.getfWwn(), bfwwn);
            if (swportChanged) {
                ep.setfWwn(bfwwn);
            }
            int vendorId = WwnDictionary.getVendorId(pwwn.getValue());
            if (ep.isISCSI() || ep.isSET() || vendorId == 201 || vendorId == 37114 || vendorId == 57483 || vendorId == 3614 || vendorId == 49373 || vendorId == 3424 || vendorId == 4362 || vendorId == 24648 || vendorId == 151 || vendorId == 24598) {
                System.arraycopy(oid, oid.length - 4, fcnsIndex, 0, 4);
                symNameVbl.add(_FcnsSymNodeNameOid, fcnsIndex);
                symNameVbl.add(_FcnsSymPortNameOid, fcnsIndex);
                symNameVbl.add(_FcnsNodeIpAddrOid, fcnsIndex);
            }
            if (ep.getLastScanTime() < fabric.getLastScanTime()) {
                ep.syncLastScanTime();
            }
            if (((List)oldEpsByVid.get(vsanId)).remove(ep) && ((List)oldEpsByVid.get(vsanId)).remove(ep) && _Log.isDebugEnabled()) {
                _Log.debug((Object)("Redundant EndPort found " + ep.getPortWwn()));
            }
            int fcId2 = ((oid[oid.length - 3] & 0xFF) << 16) + ((oid[oid.length - 2] & 0xFF) << 8) + (oid[oid.length - 1] & 0xFF);
            Wwn fwwn = new Wwn(bfwwn);
            SwitchImpl npvSw = (SwitchImpl)npvSwByFwwn.get(fwwn);
            int fpIfIndex = flogiSw.getBase().ifWwn2IfIndex(bfwwn, IfIndexIf.FwwnInfo.EP);
            if (npvSw == null) {
                if (WwnDictionary.isQuailWwn(bfwwn)) {
                    fpIfIndex = ((bfwwn[0] & 0xF) << 8) + (bfwwn[1] & 0xFF) + 1;
                } else if (flogiSw.isMDS()) {
                    if (ep.isISCSI()) {
                        int slot = IfIndexUtil.ifWwn2Card(bfwwn);
                        Card card = InventoryManager.getInstance().findCard(flogiSw.getSwitchPK(), slot + 1);
                        fpIfIndex = card != null && card.getType() == 22 ? IfIndexUtil.fWwn2IscsiIfIndex14K9(bfwwn) : (card != null && card.getType() == 39 ? IfIndexUtil.fWwn2IscsiIfIndex18K9(bfwwn) : IfIndexUtil.fWwn2IscsiIfIndex(bfwwn));
                    } else if (ep.isSVC()) {
                        fpIfIndex = IfIndexUtil.fWwn2SvcIfIndex(bfwwn);
                    } else if (ep.isIPFC()) {
                        fpIfIndex = IfIndexUtil.getVsanIfIndex(vsanId);
                    } else {
                        ep.setSymNodeName(Fc4Decoder.getVirtualized(fc4Type, fc4Features));
                        int ifindex = flogiSw.getBase().getIfIndexByFwwnInMap(fwwn);
                        if (ifindex != -1) {
                            fpIfIndex = ifindex;
                            if (flogiSw.getBase().isVfcIfIndex(fpIfIndex)) {
                                flogiSw.setFeatureEnabled(AbstractSwitchBase.Feature.FCOE.flag(), true);
                                flogiSw.setDiscFlag(32768);
                            }
                        }
                    }
                } else {
                    fpIfIndex = IfIndexUtil.nonMdsIfWwn2Port(bfwwn);
                }
                if (!_EnableFV && IfIndexUtil.isFvIfIndex(fpIfIndex)) {
                    if (_Log.isDebugEnabled()) {
                        _Log.debug((Object)(sw + " fcns toss FV endport device:" + ep + " from " + IfIndexUtil.ifIndexToName(fpIfIndex)));
                    }
                    SanManager.getInstance().deleteEndPort(ep, fabric);
                    continue;
                }
                ep.setFPort(flogiSw, fpIfIndex);
                ep.addVsanFport(vsan, new SwitchIntKey(flogiSw.getSwitchPK(), fpIfIndex), fc4Type, fwwn);
                if (IfIndexUtil.isFmIfIndex(fpIfIndex)) {
                    flogiSw.addPendingEP(fwwn, ep);
                }
            } else {
                if (ep.getBase().getFPortPK() == null || !Arrays.equals(ep.getfWwn(), bfwwn)) {
                    fpIfIndex = IfIndexUtil.fmFwwn2IfIndex(pwwn.getValue());
                    ep.setFPort(npvSw, fpIfIndex);
                    ep.addVsanFport(vsan, new SwitchIntKey(npvSw.getSwitchPK(), fpIfIndex), fc4Type, fwwn);
                } else {
                    fpIfIndex = ep.getBase().getFPortPK()._index;
                    ep.addVsanFport(vsan, new SwitchIntKey(npvSw.getSwitchPK(), fpIfIndex), fc4Type, fwwn);
                }
                if (IfIndexUtil.isFmIfIndex(fpIfIndex)) {
                    VsanFcIdKey vsanFcidKey = new VsanFcIdKey(vsan.getVsanPK(), fcId2);
                    npvSw.addFlogiQuery(vsanFcidKey, nwwn, pwwn);
                }
            }
            ep.setLoop(rspVbl.intValue(i + 3) == 3);
            vsan.addEndPort(ep, fcId2);
            if (ep.getOperStatusCause() == 108) continue;
            ep.setOperStatusCause((short)2);
        }
        _Log.trace((Object)(sw.getIpAddress() + " done processing fcns database query for vsans " + vsanById.values()));
        for (VsanImpl vsan : vsanById.values()) {
            vsan.resetDiscFlag(2);
            for (EndPortImpl rep : (List)oldEpsByVid.get(vsan.getId())) {
                vsan.removeEndPort(rep);
            }
            for (NpvLinkImpl npvl : (List)oldNpvlsByVid.get(vsan.getId())) {
                vsan.removeNpvLink(npvl);
            }
        }
        if (symNameVbl.size() > 0) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " -- query SymbolicNodeName in VSAN " + StringUtil.getRangeString(vsanById.keySet())));
            }
            SnmpPDU pdu = SnmpFetch.get(sw.createPeer(), symNameVbl);
            VarBindList vbl = pdu.getVariables();
            InventoryManager im = InventoryManager.getInstance();
            for (int i2 = 0; i2 < vbl.size(); i2 += 3) {
                int ifindex;
                long vsanFcid;
                SwitchImpl npvSw;
                SnmpVarBind vb = vbl.getVb(i2);
                int[] oid = vb.getOid().getValue();
                short vsanId = (short)oid[oid.length - 4];
                VsanImpl vsan = sw.getVsan(vsanId);
                if (vsan == null) {
                    _Log.warn((Object)(sw.getIpAddress() + " -- finding VSAN " + vsanId + " failed on the switch, skip process symbolic name:" + vb));
                    continue;
                }
                String symNodeName = vb.getVar().toString();
                String symPortName = vbl.stringValue(i2 + 1);
                InetAddress nodeIp = null;
                byte[] b = vbl.byteValue(i2 + 2);
                if (b != null && !GenUtil.isValueFilled(b, (byte)0)) {
                    try {
                        nodeIp = GenUtil.startsWith(b, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}) ? Inet4Address.getByAddress(new byte[]{b[12], b[13], b[14], b[15]}) : Inet6Address.getByAddress(b);
                    }
                    catch (UnknownHostException uhe) {
                        _Log.error((Object)(sw.getIpAddress() + " -- returns invalid node IP address: " + SnmpString.toHexString(b)));
                    }
                }
                if ((npvSw = (SwitchImpl)npvSwByVsanFcid.get(vsanFcid = WwnDictionary.composeVsanFcid(vsanId, fcId = ((oid[oid.length - 3] & 0xFF) << 16) + ((oid[oid.length - 2] & 0xFF) << 8) + (oid[oid.length - 1] & 0xFF)))) != null) {
                    SwitchImpl[] nsws = SanManager.getInstance().findSwitches(npvSw.getSwitchPK());
                    if (nsws == null) continue;
                    for (SwitchImpl nsw : nsws) {
                        if (_Log.isTraceEnabled()) {
                            _Log.trace((Object)(nsw.getFabricPK().getIdName() + " npv switch:" + nsw.getSwitchPK() + " set ip:" + nodeIp));
                        }
                        nsw.setFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag(), true);
                        if (nodeIp != null && !GenUtil.equals(nsw.getInetAddress(), nodeIp)) {
                            if (Boolean.parseBoolean(System.getProperty("fabric.managementIpOverwrite")) || nsw.getManagementAddresses() == null || nsw.getManagementAddresses() != null && nsw.getManagementAddresses().length == 0) {
                                nsw.setManagementAddresses(new InetAddress[]{nodeIp});
                            } else if (_Log.isDebugEnabled()) {
                                _Log.debug((Object)("discoverFcns: won't update management IP of switch '" + nsw.getName() + "' with '" + nodeIp + "'"));
                            }
                        }
                        if (nsw.getBase().getSysName() != null || symNodeName == null) continue;
                        nsw.getBase().setSysName(symNodeName);
                    }
                    if (nodeIp == null || IpUtil.isAllZeros(nodeIp)) continue;
                    npvSwByVsanFcid.remove(vsanFcid);
                    continue;
                }
                EndPortImpl ep = vsan.findEndPort(fcId);
                if (ep == null) {
                    if (!_Log.isDebugEnabled()) continue;
                    _Log.debug((Object)(sw.getFabricPK().getIdName() + sw.getIpAddress() + " -- ignore entry" + vb + " for " + vsanFcid));
                    continue;
                }
                if (symPortName != null && symPortName.length() != 0) {
                    ep.setSymPortName(symPortName);
                }
                if (symNodeName != null && symNodeName.length() != 0) {
                    Hba hba;
                    ep.setSymNodeName(symNodeName);
                    int vendorId = WwnDictionary.getVendorId(ep.getPortWwn().getValue());
                    if (ep.isIntiator() && vendorId != 24648 && vendorId != 151 && vendorId != 24598 && (hba = im.createHba(ep.getPortWwn(), ep.getNodeWwn(), symNodeName)) != null && ep.getEnclosure() != null) {
                        ep.getEnclosure().addHba(hba);
                    }
                }
                if ((ep.isISCSI() || ep.isSET()) && symPortName.length() != 0 && symPortName.startsWith("iscsi") && (ifindex = IfIndexUtil.name2IfIndex(symPortName)) != 0) {
                    ep.setFxInterface(ifindex, symPortName);
                }
                if (nodeIp == null) continue;
                ep.setNodeIpAddress(nodeIp.getHostAddress());
            }
            for (SwitchImpl npvsw : newNpvSwBySwwn.values()) {
                try {
                    fabric.getWorker().startSwitchWorker(npvsw);
                }
                catch (DiscoveryException dex) {
                    _Log.warn((Object)("starting switch worker failed: " + dex.getMessage()));
                }
            }
        }
        return true;
    }

    public static boolean discoverConnUnitSns(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        SnmpOID oid;
        short vid = vsanById == null || vsanById.size() == 0 ? (short)1 : vsanById.keySet().iterator().next();
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null || vsan.getSeed() != sw) {
            return false;
        }
        if (sw.getNumSnsEntries() == 0) {
            return true;
        }
        List<EndPortImpl> oldEps = vsan.getEndPorts();
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- discover ConnUnitSns in VSAN " + vid));
        }
        VarBindList vbl = new VarBindList(_ConnUnitSnsOids.length);
        for (int i = 0; i < _ConnUnitSnsOids.length; ++i) {
            vbl.add(_ConnUnitSnsOids[i]);
        }
        SnmpPDU reqPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = reqPdu.getVariables();
        SanManager sm = SanManager.getInstance();
        InventoryManager im = InventoryManager.getInstance();
        FabricImpl fabric = sw.getFabric();
        for (int i = 0; i < vbl.size() && (oid = vbl.getVb(i).getOid()).startsWith(_ConnUnitSnsOids[0]); i += _ConnUnitSnsOids.length) {
            byte[] b;
            int[] ioid = oid.getValue();
            byte[] sb = new byte[8];
            GenUtil.arraycopy(ioid, ioid.length - 27, sb, 0, 8);
            byte[] pb = new byte[8];
            GenUtil.arraycopy(ioid, ioid.length - 11, pb, 0, 8);
            int fcId = ((ioid[ioid.length - 3] & 0xFF) << 16) + ((ioid[ioid.length - 2] & 0xFF) << 8) + (ioid[ioid.length - 1] & 0xFF);
            SwitchImpl sw0 = SnmpAdapter.createSwitchFromVsanWwn(sb, fabric);
            int portIndex = vbl.intValue(i);
            int ifindex = sw0.isQuail() ? IfIndexUtil.nameToIfIndex(1, portIndex + 1, 1) : portIndex;
            Wwn pwwn = new Wwn(pb);
            Wwn nwwn = new Wwn(vbl.byteValue(i + 1));
            EndPortImpl ep = SanManager.getInstance().findEndPort(pwwn, fabric.getPK());
            if (ep == null) {
                byte[] btype = vbl.byteValue(i + 2);
                int[] fc4Type = btype != null ? SnmpIntList.valueOf(btype) : null;
                ep = SanManager.getInstance().createEndPort(pwwn, nwwn, fc4Type, null, fabric);
                ep.setFPort(sw0, ifindex);
                ep.syncLastScanTime();
            } else {
                ep.setFPort(sw0, ifindex);
                if (ep.getLastScanTime() < fabric.getLastScanTime()) {
                    ep.syncLastScanTime();
                }
            }
            ep.setLoop(vbl.byteValue(i + 3)[0] == 2);
            ep.setfWwn(vbl.byteValue(i + 4));
            String symName = vbl.stringValue(i + 5);
            if (symName.length() != 0) {
                ep.setSymNodeName(symName);
                Hba hba = im.createHba(ep.getPortWwn(), ep.getNodeWwn(), symName);
                if (hba != null && ep.getEnclosure() != null) {
                    ep.getEnclosure().addHba(hba);
                }
            }
            if ((b = vbl.byteValue(i + 6)).length == 16) {
                ep.setNodeIpAddress(SnmpIpAddress.toString(b, 12, 16));
            }
            vsan.addEndPort(ep, fcId);
            oldEps.remove(ep);
        }
        Iterator<EndPortImpl> it = oldEps.iterator();
        while (it.hasNext()) {
            vsan.removeEndPort(it.next());
        }
        vsan.resetDiscFlag(2);
        return true;
    }

    public static boolean discoverVsanIsls(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverFspf(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitLinks(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverFspf(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        HashMap<Short, List<IslImpl>> oldIslsByVid = new HashMap<Short, List<IslImpl>>(vsanById.size());
        for (Map.Entry<Short, VsanImpl> ent : vsanById.entrySet()) {
            oldIslsByVid.put(ent.getKey(), ent.getValue().getIsls());
        }
        SnmpPDU reqPdu = SnmpFetch.getBulk(sw.createPeer(), _FspfLsdbOids, GenUtil.shortListToIntArray(vsanById.keySet()));
        VarBindList rspVbl = reqPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        for (int i = 0; i < rspVbl.size(); i += _FspfLsdbOids.length) {
            Wwn nbrPrinWwn;
            SnmpVarBind vb = rspVbl.getVb(i);
            int fspfIndex = rspVbl.intValue(i + 1);
            int nbrFspfIndex = rspVbl.intValue(i + 2);
            int[] oid = vb.getOid().getValue();
            short vsanId = (short)oid[oid.length - 4];
            if (IfIndexUtil.isIvrFspfPort(fspfIndex)) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore ISL in ivr fspfIndex " + fspfIndex + " from vsan " + vsanId));
                continue;
            }
            int domainId = oid[oid.length - 3];
            int nbrDomainId = rspVbl.intValue(i);
            VsanImpl vsan = sw.getVsan(vsanId);
            SwitchImpl swx = null;
            SwitchImpl swy = null;
            if (vsan == null || (swx = vsan.findSwitchByDomainId(domainId)) == null || (swy = vsan.findSwitchByDomainId(nbrDomainId)) == null) {
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore ISL in VSAN " + vsanId + " between virtual/offline switches " + domainId + " and " + nbrDomainId));
                continue;
            }
            if (swx == swy) {
                _Log.debug((Object)(sw.getIpAddress() + " ignore local ISL on switch " + swx + " in VSAN " + vsanId));
                continue;
            }
            Wwn prinWwn = swx.getPrincipalSwitchWwn(vsanId);
            if (!GenUtil.equals(prinWwn, nbrPrinWwn = swy.getPrincipalSwitchWwn(vsanId))) {
                _Log.warn((Object)(sw.getIpAddress() + " -- VSAN " + vsanId + ": " + swx + "'s principal (" + prinWwn + ") != " + swy + "'s (" + nbrPrinWwn + ")"));
                continue;
            }
            int ifIndex = swx.fspfPortIndexToIfIndex(fspfIndex);
            int nbrIfIndex = swy.fspfPortIndexToIfIndex(nbrFspfIndex);
            IslImpl isl = fabric.findIsl(new SwitchIntKey(swx.getSwitchPK(), ifIndex));
            boolean reverseIsl = false;
            if (isl == null) {
                isl = fabric.findIsl(new SwitchIntKey(swy.getSwitchPK(), nbrIfIndex));
                reverseIsl = true;
            }
            if (isl == null) {
                isl = new IslImpl(swx, swy, ifIndex, nbrIfIndex);
                fabric.addIsl(isl);
                isl.initOperStatusCause();
                isl.syncLastScanTime();
            } else if (!reverseIsl && (!isl.getNbrSwitch(swx.getSwitchPK()).getSwitchPK().equals(swy.getSwitchPK()) || isl.getNbrIfIndex(swx.getSwitchPK()) != nbrIfIndex) || reverseIsl && (!isl.getNbrSwitch(swy.getSwitchPK()).getSwitchPK().equals(swx.getSwitchPK()) || isl.getNbrIfIndex(swy.getSwitchPK()) != ifIndex)) {
                System.err.println("====>RMISL:" + isl);
                vsan.removeIsl(isl);
                fabric.removeIsl(isl);
                isl = new IslImpl(swx, swy, ifIndex, nbrIfIndex);
                System.err.println("====>CRTISL:" + isl);
                fabric.addIsl(isl);
                isl.initOperStatusCause();
                isl.syncLastScanTime();
            } else if (isl.getLastScanTime() < fabric.getLastScanTime()) {
                isl.resetLsdbCount();
                isl.syncLastScanTime();
            }
            vsan.addIsl(isl);
            if (isl.isPortChannel()) {
                swx.setDiscFlag(1024);
                swy.setDiscFlag(1024);
            }
            ((List)oldIslsByVid.get(vsanId)).remove(isl);
            if (isl.isPortChannel()) {
                vsan.setDiscFlag(128);
            }
            isl.incrementLsdb(swx);
        }
        for (VsanImpl v : vsanById.values()) {
            v.resetDiscFlag(4);
            for (IslImpl isl : (List)oldIslsByVid.get(v.getId())) {
                v.removeIsl(isl);
            }
        }
        return true;
    }

    public static boolean discoverConnUnitLinks(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        SnmpOID oid;
        short vid = vsanById == null || vsanById.size() == 0 ? (short)1 : vsanById.keySet().iterator().next();
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null || vsan.getSeed() != sw) {
            return false;
        }
        List<IslImpl> oldIsls = vsan.getIsls();
        _Log.debug((Object)(sw.getIpAddress() + " -- discover ConnUnitLinks in VSAN " + vid));
        VarBindList vbl = new VarBindList(_ConnUnitLinkOids.length);
        for (int i = 0; i < _ConnUnitLinkOids.length; ++i) {
            vbl.add(_ConnUnitLinkOids[i]);
        }
        SnmpPDU reqPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = reqPdu.getVariables();
        FabricImpl fabric = sw.getFabric();
        for (int i = 0; i < vbl.size() && (oid = vbl.getVb(i).getOid()).startsWith(_ConnUnitLinkOids[0]); i += _ConnUnitLinkOids.length) {
            boolean isIsl;
            byte[] b1 = new byte[8];
            GenUtil.arraycopy(oid.getValue(), oid.getValue().length - 17, b1, 0, 8);
            SwitchImpl sw1 = SnmpAdapter.createSwitchFromVsanWwn(b1, fabric);
            int ifindex1 = vbl.intValue(i + 1);
            boolean bl = isIsl = vbl.intValue(i) == 4;
            if (!isIsl) continue;
            byte[] b2 = vbl.byteValue(i + 2);
            SwitchImpl sw2 = SnmpAdapter.createSwitchFromVsanWwn(b2, fabric);
            int ifindex2 = vbl.intValue(i + 3);
            IslImpl isl = fabric.findIsl(sw1, ifindex1);
            if (isl == null) {
                isl = new IslImpl(sw1, sw2, ifindex1, ifindex2);
                fabric.addIsl(isl);
                isl.initOperStatusCause();
                isl.syncLastScanTime();
            } else if (!isl.getNbrSwitch(sw1.getSwitchPK()).getSwitchPK().equals(sw2.getSwitchPK()) || isl.getNbrIfIndex(sw1.getSwitchPK()) != ifindex2) {
                vsan.removeIsl(isl);
                fabric.removeIsl(isl);
                isl = new IslImpl(sw1, sw2, ifindex1, ifindex2);
                fabric.addIsl(isl);
                isl.initOperStatusCause();
                isl.syncLastScanTime();
            } else if (isl.getLastScanTime() < fabric.getLastScanTime()) {
                isl.resetLsdbCount();
                isl.syncLastScanTime();
            }
            vsan.addIsl(isl);
            oldIsls.remove(isl);
        }
        Iterator<IslImpl> it = oldIsls.iterator();
        while (it.hasNext()) {
            vsan.removeIsl(it.next());
        }
        vsan.resetDiscFlag(4);
        return true;
    }

    public static boolean discoverVsanEnfZoneset(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverMdsEnfZoneset(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitZoneset(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverMdsEnfZoneset(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        VsanImpl vsan;
        int i;
        ArrayList<Short> avids = new ArrayList<Short>(vsanById.keySet());
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), SnmpAdapter.buildVbl(_EnfZonesetOids, GenUtil.shortListToIntArray(vsanById.keySet())));
        VarBindList vbl = rspPdu.getVariables();
        for (i = 0; i < vbl.size(); i += _EnfZonesetOids.length) {
            short vid = (short)vbl.getVb(i).getOid().getIndexFromEnd(0);
            vsan = sw.getVsan(vid);
            if (vsan == null || vbl.getVb(i).getVar().getType() != 4 || vbl.getVb(i + 1).getVar().getType() != 67) continue;
            String name = vbl.stringValue(i);
            if (!_DisplayIVRZones && name != null && name.equals("nozoneset")) continue;
            long actTime = sw.getSysLastBootTime() + vbl.longValue(i + 1) * 10L;
            vsan.setEnforcedZoneSetName(name);
            vsan.setEnforcedZoneSetActivateTime(sw, actTime);
            vsan.resetDiscFlag(8);
            avids.remove(new Short(vid));
            if (!_Log.isDebugEnabled()) continue;
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vid + " active zoneset \"" + name + "\" activated at " + new Date(actTime)));
        }
        for (i = 0; i < avids.size(); ++i) {
            vsan = sw.getVsan(avids.get(i));
            if (vsan == null) continue;
            vsan.setEnforcedZoneSetName(null);
            vsan.setEnforcedZoneSetActivateTime(sw, 0L);
            vsan.resetDiscFlag(8);
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vsan.getId() + " has no active zoneset"));
        }
        return true;
    }

    public static boolean discoverConnUnitZoneset(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        short vid = vsanById == null || vsanById.size() == 0 ? (short)1 : vsanById.keySet().iterator().next();
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null || vsan.getSeed() != sw) {
            return false;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover active zoneset in VSAN " + vid));
        SnmpPDU reqPdu = new SnmpPDU(-95, new VarBindList(2));
        reqPdu.addNull(_ConnUnitZonesetVars[0]);
        reqPdu.addNull(_ConnUnitZonesetVars[1]);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        SnmpVar var = rspPdu.getVar(0);
        if (rspPdu.getOid(0).startsWith(_ConnUnitZonesetVars[0]) && var.getType() == 4) {
            String name = ((SnmpString)var).toString();
            vsan.setEnforcedZoneSetName(name);
            int num = rspPdu.getVariables().intValue(1);
            vsan.setNumEnforcedZones(num);
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vid + " active zoneset \"" + name + "\" has " + num + " zones"));
        } else {
            vsan.setEnforcedZoneSetName(null);
            _Log.debug((Object)(sw.getIpAddress() + " -- VSAN " + vid + " has no active zoneset"));
        }
        vsan.resetDiscFlag(8);
        return true;
    }

    public static boolean discoverVsanEnfZones(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverMdsEnfZones(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitZones(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverMdsEnfZones(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        short vid;
        int i;
        int step;
        boolean supportQoS = sw.isVersionGreaterThanEqual("2.0(0)");
        Object oids = supportQoS ? _EnfZoneOids : (Object)new int[][]{_EnfZoneOids[0], _EnfZoneOids[1]};
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), oids, GenUtil.shortListToIntArray(vsanById.keySet()));
        VarBindList vbl = rspPdu.getVariables();
        ArrayList<ZoneBase> zoneList = new ArrayList<ZoneBase>();
        boolean ivrFiltered = false;
        HashMap<Short, ZoneBase[]> zonesByVid = new HashMap<Short, ZoneBase[]>(vsanById.size() == 0 ? 11 : vsanById.size() * 2);
        short curVid = 0;
        int maxi = vbl.size();
        int n = step = supportQoS ? _EnfZoneOids.length : 2;
        for (i = 0; i < maxi; i += step) {
            String name = vbl.stringValue(i);
            if (!_DisplayIVRZones && name.startsWith("IVRZ")) {
                ivrFiltered = true;
                continue;
            }
            short vsanId = (short)vbl.getVb(i).getOid().getIndexFromEnd(1);
            if (curVid != 0 && curVid != vsanId) {
                ZoneBase[] zones = zoneList.toArray(new ZoneBase[zoneList.size()]);
                zonesByVid.put(curVid, zones);
                zoneList.clear();
                curVid = 0;
            }
            if (curVid == 0) {
                curVid = vsanId;
            }
            if (supportQoS) {
                zoneList.add(new ZoneBase(vbl.getVb(i).getOid().getIndexFromEnd(0), name, vbl.intValue(i + 1) == 1, vbl.intValue(i + 2) == 1, vbl.intValue(i + 3), vbl.intValue(i + 4) == 1, -1));
                continue;
            }
            zoneList.add(new ZoneBase(vbl.getVb(i).getOid().getIndexFromEnd(0), name, vbl.intValue(i + 1) == 1));
        }
        if (curVid != 0 && !zoneList.isEmpty()) {
            ZoneBase[] zones = zoneList.toArray(new ZoneBase[zoneList.size()]);
            zonesByVid.put(curVid, zones);
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- discover enforced zone members of VSAN " + (vsanById.size() == 0 ? "all" : StringUtil.getRangeString(vsanById.keySet()))));
        }
        rspPdu = vsanById.size() == 0 ? SnmpFetch.getBulk(sw.createPeer(), _EnfZoneMbrOids, 0, 0) : SnmpFetch.getBulk(sw.createPeer(), _EnfZoneMbrOids, GenUtil.shortListToIntArray(vsanById.keySet()));
        vbl = rspPdu.getVariables();
        maxi = vbl.size();
        for (i = 0; i < maxi; i += _EnfZoneMbrOids.length) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            short vsanId = (short)oid[oid.length - 4];
            int znIndex = oid[oid.length - 2];
            ZoneBase[] enfZones = (ZoneBase[])zonesByVid.get(vsanId);
            if (enfZones == null) {
                _Log.debug((Object)(sw.getIpAddress() + " -- enforced zone member " + znIndex + " in unknown VSAN " + vsanId));
                continue;
            }
            ZoneBase parentZone = ZoneBase.findParent(enfZones, znIndex);
            if (parentZone != null) {
                parentZone.addMember(vbl.intValue(i), vbl.byteValue(i + 1), vbl.byteValue(i + 2));
                continue;
            }
            if (ivrFiltered) continue;
            _Log.warn((Object)(sw.getIpAddress() + " -- " + znIndex + ": unknown zone member " + vbl.byteValue(i + 1)));
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + ":discoverMdsEnfZones, " + " vsanById: " + StringUtil.getRangeString(vsanById.keySet()) + " zonesByVid: " + StringUtil.getRangeString(zonesByVid.keySet())));
        }
        Iterator<Object> i$ = zonesByVid.keySet().iterator();
        while (i$.hasNext()) {
            vid = (Short)i$.next();
            VsanImpl vsan = sw.getVsan(vid);
            if (vsan == null) {
                _Log.info((Object)(sw.getIpAddress() + " -- enforced zones in unknown VSAN " + vid));
                continue;
            }
            vsan.setEnforcedZones((ZoneBase[])zonesByVid.get(vid));
            vsan.resetDiscFlag(16);
        }
        i$ = vsanById.keySet().iterator();
        while (i$.hasNext()) {
            vid = (Short)i$.next();
            VsanImpl vsan = vsanById.get(vid);
            if (vsan == null) continue;
            vsan.resetDiscFlag(16);
        }
        return true;
    }

    public static boolean discoverConnUnitZones(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        SnmpOID oid;
        short vid = vsanById == null || vsanById.size() == 0 ? (short)1 : vsanById.keySet().iterator().next();
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null || vsan.getSeed() != sw || vsan.getNumEnforcedZones() == 0) {
            return false;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover active zones in VSAN " + vid));
        VarBindList vbl = new VarBindList(_ConnUnitZonesVars.length);
        for (int i = 0; i < _ConnUnitZonesVars.length; ++i) {
            vbl.add(new SnmpVarBind(_ConnUnitZonesVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        Hashtable<String, ZoneBase> zones = new Hashtable<String, ZoneBase>(vsan.getNumEnforcedZones());
        for (int i = 0; i < vbl.size() && (oid = vbl.getVb(i).getOid()).startsWith(_ConnUnitZonesVars[0]); i += _ConnUnitZonesVars.length) {
            String name = vbl.stringValue(i);
            ZoneBase zone = (ZoneBase)zones.get(name);
            if (zone == null) {
                zone = new ZoneBase(0, name, false, false, 0, false, -1);
                zones.put(name, zone);
            }
            int idtype = vbl.intValue(i + 1);
            byte[] id = null;
            if (idtype == 1 || idtype == 4) {
                id = new byte[8];
                System.arraycopy(vbl.byteValue(i + 2), 0, id, 0, 8);
            } else if (idtype != 2) {
                if (idtype == 3) {
                    id = new byte[3];
                    System.arraycopy(vbl.byteValue(i + 2), 0, id, 0, 3);
                } else if (idtype == 6) {
                    id = new byte[12];
                    System.arraycopy(vbl.byteValue(i + 2), 4, id, 0, id.length);
                } else if (idtype == 7) {
                    id = new byte[5];
                    System.arraycopy(vbl.byteValue(i + 2), 8, id, 0, 1);
                    System.arraycopy(vbl.byteValue(i + 2), 4, id, 1, id.length - 1);
                } else {
                    id = vbl.byteValue(i + 2);
                }
            }
            zone.addMember(idtype, id, null);
        }
        vsan.setEnforcedZones(zones.values().toArray(new ZoneBase[zones.size()]));
        _Log.debug((Object)(sw.getIpAddress() + ": discoverConnUnitZones(): reset discFlag DISC_ZONES for vsan " + vsan));
        vsan.resetDiscFlag(16);
        return true;
    }

    public static boolean discoverVsanAliases(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        if (sw.isMDS()) {
            return SnmpAdapter.discoverFcAliases(sw, vsanById);
        }
        if (sw.isQuail()) {
            return SnmpAdapter.discoverConnUnitZoneAliases(sw, vsanById);
        }
        return false;
    }

    public static boolean discoverCfsRegion(SwitchImpl sw) throws SnmpException {
        _Log.debug((Object)(sw.getIpAddress() + " -- discover cfs region Id"));
        FabricImpl fabric = sw.getFabric();
        HashSet<CfsRegionPK> oldRids = new HashSet<CfsRegionPK>();
        ArrayList<Integer> oldRegions = sw.getCfsRegionIds();
        for (int rId : oldRegions) {
            oldRids.add(new CfsRegionPK(fabric.getPK(), rId));
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_CfsRegionVar));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        int offset = _CfsRegionVar.getValue().length + 1;
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            int regionId = vbl.get(0).getVar().getType() == 5 ? -1 : vbl.intValue(0);
            String cfsfeature = SnmpString.toString(oid, offset, oid.length - 1);
            CfsRegionPK rkey = new CfsRegionPK(fabric.getPK(), regionId);
            CfsRegionImpl cfsR = fabric.createCfsRegion(regionId, null, null, null);
            oldRids.remove(rkey);
            if (cfsfeature == null) continue;
            sw.addCfsRegionId(cfsfeature, regionId);
        }
        for (CfsRegionPK rpk : oldRids) {
            if (rpk == null) continue;
            sw.removeCfsRegion(rpk);
            if (!_Log.isDebugEnabled()) continue;
            _Log.debug((Object)(sw.getIpAddress() + " -- Cfs Region " + rpk._id + " disappeared"));
        }
        sw.resetDiscFlag(8192);
        return true;
    }

    public static boolean discoverFcAliases(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        HashMap<Short, List<String>> oldAliasByVid = new HashMap<Short, List<String>>();
        for (Map.Entry<Short, VsanImpl> ent : vsanById.entrySet()) {
            oldAliasByVid.put(ent.getKey(), ent.getValue().getFcAliasNames());
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), _ZoneAliasOids, GenUtil.shortListToIntArray(vsanById.keySet()));
        VarBindList rspVbl = rspPdu.getVariables();
        if (rspVbl.size() != 0) {
            VarBindList membersVbl = new VarBindList();
            HashMap<Integer, String> aliasById = new HashMap<Integer, String>();
            for (int i = 0; i < rspVbl.size(); i += _ZoneAliasOids.length) {
                byte[] b = rspVbl.byteValue(i + 1);
                if (b.length == 0) continue;
                SnmpVarBind vb = rspVbl.getVb(i);
                int[] oid = vb.getOid().getValue();
                int vid = oid[oid.length - 2];
                int zaId = oid[oid.length - 1];
                aliasById.put((zaId << 12) + vid, vb.getVar().toString());
                int max = b.length * 8;
                for (int j = 0; j < max; ++j) {
                    if (!SnmpString.getBit(b, j)) continue;
                    int[] index = new int[]{vid, 2, zaId, j};
                    membersVbl.add(_ZoneMbrFmtOid, index);
                    membersVbl.add(_ZoneMbrIdOid, index);
                }
            }
            if (membersVbl.size() != 0) {
                SnmpPDU memberResp = SnmpFetch.get(sw.createPeer(), membersVbl);
                VarBindList vbl = memberResp.getVariables();
                for (int i = 0; i < vbl.size(); i += 2) {
                    SnmpVarBind vb;
                    byte[] b;
                    if (vbl.intValue(i) != 1 || (b = ((SnmpString)(vb = vbl.getVb(i + 1)).getVar()).getValue()).length != 8) continue;
                    int[] oid = vb.getOid().getValue();
                    short vsanId = (short)oid[oid.length - 4];
                    VsanImpl vsan = sw.getVsan(vsanId);
                    if (vsan == null) {
                        oldAliasByVid.remove(vsanId);
                        continue;
                    }
                    int zaId = oid[oid.length - 2];
                    String alias = (String)aliasById.get((zaId << 12) + vsanId);
                    if (alias == null) continue;
                    FcPortAlias fa = vsan.createFcAlias(new Wwn(b), alias);
                    ((List)oldAliasByVid.get(vsanId)).remove(alias);
                    if (!_Log.isTraceEnabled()) continue;
                    _Log.trace((Object)(sw.getIpAddress() + " -- fc alias: " + fa));
                }
            }
        }
        Iterator i$ = oldAliasByVid.keySet().iterator();
        while (i$.hasNext()) {
            short vid = (Short)i$.next();
            VsanImpl vsan = sw.getVsan(vid);
            if (vsan == null) continue;
            for (String aliasName : (List)oldAliasByVid.get(vid)) {
                vsan.removeFcAlias(aliasName);
            }
            vsan.resetDiscFlag(32);
        }
        return true;
    }

    public static boolean discoverHbas(SwitchImpl sw) throws SnmpException {
        short[] svids = sw.getVsanIds();
        if (svids == null || svids.length == 0) {
            return false;
        }
        Arrays.sort(svids);
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)(sw.getIpAddress() + " -- discover HBAs in VSAN " + StringUtil.getRangeString(svids)));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), _HbaOids, GenUtil.shortArrayToIntArray(svids));
        VarBindList vbl = rspPdu.getVariables();
        SanManager sm = SanManager.getInstance();
        InventoryManager im = InventoryManager.getInstance();
        int max = vbl.size();
        for (int i = 0; i < max; i += _HbaOids.length) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            byte[] ba = new byte[8];
            int len = oid.length;
            for (int j = 0; j < 8; ++j) {
                ba[j] = (byte)(oid[len - 8 + j] & 0xFF);
            }
            int vid = oid[oid.length - 9];
            Wwn pwwn = new Wwn(ba);
            Hba hba = im.createHba(pwwn, new Wwn(vbl.byteValue(i)), vbl.stringValue(i + 1), vbl.stringValue(i + 2), vbl.stringValue(i + 3), vbl.stringValue(i + 4), vbl.stringValue(i + 5), vbl.stringValue(i + 6), vbl.stringValue(i + 7), vbl.stringValue(i + 8));
            EnclosureImpl encl = sm.findEnclosureByPortWwn(pwwn);
            if (encl == null) continue;
            encl.addHba(hba);
            String osInfo = vbl.stringValue(i + 9);
            if (osInfo == null || osInfo.length() == 0) continue;
            encl.setOSInfo(osInfo);
        }
        return true;
    }

    static SwitchImpl createSwitchFromVsanWwn(byte[] wwn, FabricImpl fabric) {
        Wwn swwn = SnmpAdapter.vsanWwnToSwitchWwn(wwn);
        WwnKey swKey = new WwnKey(swwn);
        SwitchImpl sw = SanManager.getInstance().findSwitchByPK(swKey, fabric);
        if (sw == null) {
            sw = SanManager.getInstance().createSwitch(swwn, null, fabric);
        } else if (sw.getFabric() == null) {
            sw.setFabric(fabric);
        } else if (sw.getFabric() != fabric) {
            sw = SanManager.getInstance().mergeSwitch(sw, fabric);
        }
        return sw;
    }

    public static boolean discoverVirtualEnclosure(SwitchImpl sw) throws SnmpException {
        int index;
        int[] oid;
        int i;
        if (!InventoryManager.getInstance().hasILC(sw.getSwitchPK()) || sw.isVersionGreaterThanEqual("3.0")) {
            return false;
        }
        HashMap<Integer, EnclosureImpl> veByIndex = new HashMap<Integer, EnclosureImpl>();
        VarBindList reqVbl = new VarBindList();
        reqVbl.add(new SnmpVarBind(_VedmVeNameVar));
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), reqVbl);
        VarBindList rspVbl = rspPdu.getVariables();
        SanManager sm = SanManager.getInstance();
        for (i = 0; i < rspVbl.size(); ++i) {
            oid = rspVbl.getVb(i).getOid().getValue();
            index = (oid[oid.length - 2] << 16) + oid[oid.length - 1];
            EnclosureImpl encl = sm.createEnclosure(rspVbl.stringValue(i), null, true);
            veByIndex.put(index, encl);
        }
        reqVbl.clear();
        reqVbl.add(new SnmpVarBind(_VedmVepPWwnVar));
        rspPdu = SnmpFetch.getBulk(sw.createPeer(), reqVbl);
        rspVbl = rspPdu.getVariables();
        for (i = 0; i < rspVbl.size(); ++i) {
            oid = rspVbl.getVb(i).getOid().getValue();
            index = (oid[oid.length - 3] << 16) + oid[oid.length - 2];
            WwnKey epPK = new WwnKey(new Wwn(rspVbl.byteValue(i)));
            EndPortImpl ep = sm.findEndPort(epPK, sw.getFabricPK());
            EnclosureImpl encl = (EnclosureImpl)veByIndex.get(index);
            if (encl == null) continue;
            if (ep != null) {
                ep.setEnclosure(encl);
                continue;
            }
            encl.addEndPort(epPK);
        }
        return true;
    }

    public static boolean discoverFiconPortRange(SwitchImpl sw) throws SnmpException {
        if (sw.isVersionGreaterThanEqual("3.0(0)")) {
            byte[] ports = null;
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.addNull(_cficonLogicReservedPNVar);
            pdu = sw.createPeer().set(pdu);
            ports = pdu.getVariables().byteValue(0);
            sw.setFiconPortRange(ports);
        } else {
            int[] range = FRUConstants.getLogicalFiconPortRange(sw.getModelType());
            String portRange = range[0] + "-" + range[1];
            FiconPortAddrList rangeObj = new FiconPortAddrList(portRange);
            sw.setFiconPortRange(rangeObj.getValue());
        }
        return true;
    }

    public static int discoverNumLicense(SwitchImpl sw) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(_CiscoNumLicOid);
        pdu = sw.createPeer().send(pdu);
        return pdu.getVariables().intValue(0);
    }

    public static boolean discoverLicenses(SwitchImpl sw) throws SnmpException {
        int[] oid;
        VarBindList vbl = new VarBindList(_LicenseOids.length);
        for (int i = 0; i < _LicenseOids.length; ++i) {
            vbl.add(_LicenseOids[i]);
        }
        SnmpPDU reqPdu = new SnmpPDU(-91, vbl);
        reqPdu.setVariables(vbl);
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, sw.getNumLicensedFeatures());
        vbl = rspPdu.getVariables();
        int offset = _LicenseOids[0].length + 1;
        InventoryManager im = InventoryManager.getInstance();
        Set<String> preLicNames = im.findLicenseNames(sw.getSwitchPK());
        for (int i = 0; i < vbl.size() && SnmpOID.startsWith(oid = vbl.getVb(i).getOid().getValue(), _LicenseOids[0]); i += _LicenseOids.length) {
            String name = SnmpString.toString(oid, offset, oid.length);
            byte[] licFlag = vbl.byteValue(i);
            int curUsage = vbl.intValue(i + 1);
            int maxUsage = vbl.intValue(i + 2);
            int misUsage = vbl.intValue(i + 3);
            byte[] expDate = vbl.byteValue(i + 4);
            int gracePeriod = vbl.intValue(i + 5);
            int gracePeriodLeft = vbl.intValue(i + 6);
            LicenseInfo lic = im.createLicense(sw.getSwitchPK(), name, licFlag[0], curUsage, maxUsage, misUsage, expDate, gracePeriod);
            preLicNames.remove(name);
        }
        Iterator it = preLicNames.iterator();
        while (it.hasNext()) {
            im.deleteLicense(sw.getSwitchPK(), (String)it.next());
        }
        return true;
    }

    public static boolean discoverFMPermLicensed(SwitchImpl sw) throws SnmpException {
        LicenseInfo lic = SnmpAdapter.queryLicense(sw.createPeer(), sw, "FM_SERVER_PKG");
        sw.setFmServerPkgLicenseInfo(lic);
        return true;
    }

    public static LicenseInfo queryLicense(SnmpPeer peer, SwitchImpl sw, String license) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(5));
        pdu.addNull(new SnmpOID(_LicenseOids[0], license));
        pdu.addNull(new SnmpOID(_LicenseOids[1], license));
        pdu.addNull(new SnmpOID(_LicenseOids[4], license));
        pdu.addNull(new SnmpOID(_LicenseOids[5], license));
        pdu.addNull(new SnmpOID(_LicenseOids[6], license));
        try {
            VarBindList vbl = peer.send(pdu).getVariables();
            byte[] licFlag = vbl.byteValue(0);
            if (licFlag.length == 0) {
                return null;
            }
            int usage = vbl.intValue(1);
            byte[] expDate = vbl.byteValue(2);
            int gracePeriod = 0;
            gracePeriod = vbl.getVb(3).getVar().getType() != 5 ? vbl.intValue(3) : vbl.intValue(4);
            return new LicenseInfo(sw.getSwitchPK(), license, licFlag[0], usage, 0, 0, expDate, gracePeriod);
        }
        catch (SnmpException ex) {
            return null;
        }
    }

    public static LicenseInfo checkoutLicense(SwitchImpl sw) throws SnmpException {
        return SnmpAdapter.checkoutLicense(sw, null, "FM_SERVER_PKG");
    }

    public static LicenseInfo checkoutLicense(SwitchImpl sw, SnmpPeer peer, String license) throws SnmpException {
        if (sw == null) {
            throw new IllegalArgumentException("switch cannot be null");
        }
        if (peer == null) {
            peer = sw.createPeer();
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(2));
        pdu.addNull(new SnmpOID(_LicReqOids[0], 0));
        pdu.addNull(new SnmpOID(new int[]{1, 3, 6, 1, 2, 1, 1, 1, 0}));
        SnmpPDU resp = peer.send(pdu);
        SnmpVar nSpinLock = resp.getVar(0);
        if (nSpinLock.getType() != 2) {
            throw new SnmpException("getting SpinLock failed");
        }
        String sysDescription = resp.getVar(1).toString();
        int beginIdx = sysDescription.indexOf("Interim version");
        beginIdx = beginIdx != -1 ? (beginIdx += 16) : sysDescription.indexOf("Version") + 8;
        int endIdx = sysDescription.indexOf(44, beginIdx);
        sysDescription = sysDescription.substring(beginIdx, endIdx);
        if (sysDescription.compareTo("1.3") < 0) {
            return null;
        }
        pdu.reset();
        if (!peer.isV3()) {
            pdu.setCommunity(peer.getWriteCommunity());
        }
        pdu.setVariables(new VarBindList(3));
        pdu.addVar(new SnmpOID(_LicReqOids[0], 0), nSpinLock);
        pdu.addVar(new SnmpOID(_LicReqOids[1], 0), new SnmpString(license));
        pdu.addVar(new SnmpOID(_LicReqOids[2], 0), new SnmpInt(2));
        pdu.setCommand((byte)-93);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
        return SnmpAdapter.queryLicense(peer, sw, license);
    }

    public static boolean discoverEventRegistration(SwitchImpl sw) throws SnmpException {
        byte[] value;
        SnmpVarBind vb;
        int i;
        if (!sw.isMDS() || !sw.isDiscFlagSet(256)) {
            return false;
        }
        EventManagerService emService = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
        if (emService == null) {
            _Log.warn((Object)"There is no Event Manager Service found at FM server");
            return false;
        }
        InetAddress emTrapIPAddr = emService.getTrapRegAddress();
        if (emTrapIPAddr == null) {
            _Log.warn((Object)"There is no trap registration address found at FM server");
            return false;
        }
        int emTrapPort = emService.getTrapPort();
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)("discoverEMReg: trace receiver address: " + emTrapIPAddr + ":" + emTrapPort));
        }
        Object reachableHostIpSet = null;
        boolean registered = false;
        SnmpPDU reqPdu = new SnmpPDU(-91, new VarBindList(1));
        reqPdu.addNull(_TrapTargetVar);
        reqPdu.setMaxRptr(10);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        for (i = 0; i < vbl.size() && (vb = vbl.getVb(i)).getOid().startsWith(_TrapTargetVar) && (value = ((SnmpString)vb.getVar()).getValue()) != null && value.length == 6; ++i) {
            int trapPort = ((value[4] & 0xFF) << 8) + (value[5] & 0xFF);
            if (trapPort != emTrapPort) continue;
            byte[] ipbytes = new byte[4];
            System.arraycopy(value, 0, ipbytes, 0, 4);
            if (!sw.isHostReachable(ipbytes)) continue;
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)("discoverEMReg: found reachable host ip trap entry on switch" + value[0] + "." + value[1] + "." + value[2] + "." + value[3] + " on switch:" + sw));
            }
            registered = true;
            break;
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)("discoverEMReg: sw trap registered:" + registered + "@" + sw.getIpAddress()));
        }
        sw.setTrapRegistered(registered);
        registered = false;
        reqPdu = new SnmpPDU(-91, new VarBindList(2));
        reqPdu.addVar(_SyslogTargetType);
        reqPdu.addVar(_SyslogTargetVar);
        reqPdu.setMaxRptr(3);
        rspPdu = sw.createPeer().send(reqPdu);
        vbl = rspPdu.getVariables();
        for (i = 0; i < vbl.size() && (vb = vbl.getVb(i)).getOid().startsWith(_SyslogTargetType); i += 2) {
            int addrType = vb.intValue();
            vb = vbl.getVb(i + 1);
            if (!vb.getOid().startsWith(_SyslogTargetVar)) break;
            SnmpString addrStr = (SnmpString)vb.getVar();
            byte[] value2 = null;
            if (addrType == 16) {
                try {
                    value2 = InetAddress.getByName(addrStr.toString()).getAddress();
                }
                catch (Exception e) {
                    _Log.warn((Object)("Cannot get syslog address from " + addrStr));
                    value2 = null;
                }
            } else {
                value2 = addrStr.getValue();
            }
            if (value2 == null || value2.length != 4 || !sw.isHostReachable(value2)) continue;
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)("discoverEMReg: found reachable host ip syslog entry on switch" + value2[0] + "." + value2[1] + "." + value2[2] + "." + value2[3] + " on switch:" + sw));
            }
            registered = true;
            break;
        }
        if (_Log.isDebugEnabled()) {
            _Log.debug((Object)("discoverEMReg: sw syslog registered:" + registered + "@" + sw.getIpAddress()));
        }
        sw.setSyslogRegistered(registered);
        sw.resetDiscFlag(256);
        return true;
    }

    public static boolean discoverGlobalAliases(FabricImpl fabric, DiscoveryType discType) throws SnmpException {
        int[] cfsRegions = fabric.getCfsRegions("device-alias");
        if (cfsRegions != null && (cfsRegions.length > 1 || cfsRegions.length == 1 && cfsRegions[0] != -1)) {
            return SnmpAdapter.discoverRegionAliases(fabric, discType, cfsRegions);
        }
        return SnmpAdapter.discoverFabricAliases(fabric, discType);
    }

    public static boolean discoverRegionAliases(FabricImpl fabric, DiscoveryType discType, int[] cfsRegionIds) throws SnmpException {
        for (int i = 0; i < cfsRegionIds.length; ++i) {
            SnmpAdapter.discoverRegionAliases(fabric, discType, cfsRegionIds[i]);
        }
        return true;
    }

    public static boolean discoverRegionAliases(FabricImpl fabric, DiscoveryType discType, int cfsRegionId) throws SnmpException {
        SwitchImpl seed = fabric.getRegionAliasSeed(cfsRegionId);
        if (seed == null || !seed.isManageable() || seed.isNpvEnabled() || !seed.isCfsFeatureEnabled() || seed.getDeviceAliasShowCfg() != 1) {
            SwitchImpl prevSeed = seed;
            seed = fabric.selectRegionAliasSeed(cfsRegionId);
            CfsRegionImpl cfsRegion = fabric.findCfsRegion(new CfsRegionPK(fabric.getPK(), cfsRegionId));
            if (cfsRegion != null) {
                cfsRegion.setAliasSeed(seed);
            }
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(fabric + " reselect device alias seed to replace " + prevSeed + " with " + seed));
            }
        }
        if (seed != null && !seed.isNpvEnabled() && seed.getDeviceAliasShowCfg() != 1) {
            SnmpAdapter.setAliasRunningConfig(seed);
        }
        if (seed != null && !seed.isNpvEnabled() && seed.getDeviceAliasShowCfg() == 1) {
            if (seed.isMDS()) {
                return SnmpAdapter.discoverDeviceAliases(seed, discType, cfsRegionId);
            }
            if (seed.isQuail()) {
                return SnmpAdapter.discoverConnUnitZoneAliases(seed, null);
            }
        }
        _Log.warn((Object)(fabric + " cannot find valid device alias seed, the current one is " + seed));
        return false;
    }

    public static boolean discoverFabricAliases(FabricImpl fabric, DiscoveryType discType) throws SnmpException {
        SwitchImpl seed = fabric.getAliasSeed();
        if (seed == null || !seed.isManageable() || seed.isNpvEnabled() || !seed.isCfsFeatureEnabled() || seed.getDeviceAliasShowCfg() != 1) {
            SwitchImpl prevSeed = seed;
            seed = fabric.selectAliasSeed();
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(fabric + " reselect device alias seed to replace " + prevSeed + " with " + seed));
            }
        }
        if (seed != null && !seed.isNpvEnabled() && seed.getDeviceAliasShowCfg() != 1) {
            SnmpAdapter.setAliasRunningConfig(seed);
        }
        if (seed != null && !seed.isNpvEnabled() && seed.getDeviceAliasShowCfg() == 1) {
            if (seed.isMDS()) {
                return SnmpAdapter.discoverDeviceAliases(seed, discType, -1);
            }
            if (seed.isQuail()) {
                return SnmpAdapter.discoverConnUnitZoneAliases(seed, null);
            }
        }
        _Log.warn((Object)(fabric + " cannot find valid device alias seed, the current one is " + seed));
        return false;
    }

    public static boolean discoverDeviceAliases(SwitchImpl sw, DiscoveryType discType, int regionId) throws SnmpException {
        _Log.debug((Object)(sw.getIpAddress() + " -- query device alias checksum"));
        FabricImpl fabric = sw.getFabric();
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addVar(_DaChecksumVar);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        byte[] chksum = vbl.byteValue(0);
        byte[] currChksum = fabric.getDeviceAliasChecksum(regionId);
        if (discType != DiscoveryType.FABRIC_INITIAL && discType != DiscoveryType.FABRIC_ONDEMAND && discType != DiscoveryType.FABRIC_AUTODEMAND && Arrays.equals(chksum, currChksum)) {
            _Log.debug((Object)(sw.getIpAddress() + " -- device-alias checksum not changed, query skipped"));
            return false;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover device alias"));
        vbl = new VarBindList(_DeviceAliasCfgVars.length);
        for (int i = 0; i < _DeviceAliasCfgVars.length; ++i) {
            vbl.add(new SnmpVarBind(_DeviceAliasCfgVars[i]));
        }
        rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        ArrayList<String> preDeviceAliases = fabric.getDeviceAliasNames(regionId);
        int offset = _DeviceAliasCfgVars[0].getValue().length + 1;
        for (int i = 0; i < vbl.size(); i += 2) {
            if (vbl.intValue(i) != 1) continue;
            Wwn pwwn = new Wwn(vbl.byteValue(i + 1));
            int[] oid = vbl.getVb(i).getOid().getValue();
            String alias = SnmpString.toString(oid, offset, oid.length);
            FcPortAlias da = fabric.createDeviceAlias(pwwn, alias, regionId);
            if (_Log.isTraceEnabled()) {
                _Log.trace((Object)(sw.getIpAddress() + " -- " + pwwn + "-- device alias: " + da));
            }
            preDeviceAliases.remove(alias);
        }
        for (String aliasName : preDeviceAliases) {
            fabric.removeDeviceAlias(aliasName, regionId);
        }
        fabric.setDeviceAliasChecksum(regionId, chksum.length == 0 ? null : chksum);
        return true;
    }

    public static boolean discoverConnUnitZoneAliases(SwitchImpl sw, Map<Short, VsanImpl> vsanById) throws SnmpException {
        short vid = vsanById == null || vsanById.size() == 0 ? (short)1 : vsanById.keySet().iterator().next();
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null || vsan.getSeed() != sw) {
            return false;
        }
        _Log.debug((Object)(sw.getIpAddress() + " -- discover ConnUnitZoningAliases in VSAN " + vid));
        VarBindList vbl = new VarBindList(_ConnUnitAliasVars.length);
        for (int i = 0; i < _ConnUnitAliasVars.length; ++i) {
            vbl.add(new SnmpVarBind(_ConnUnitAliasVars[i]));
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = rspPdu.getVariables();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < vbl.size(); i += _ConnUnitAliasVars.length) {
            String name = vbl.stringValue(i);
            int type = vbl.intValue(i + 1);
            byte[] id = vbl.byteValue(i + 2);
            if (type == 1) {
                EndPortImpl ep = sm.findEndPort(new Wwn(id), sw.getFabricPK());
                if (ep == null || !ep.isMemberOfVsan(vid)) continue;
                vsan.createFcAlias(ep.getPortWwn(), name);
                continue;
            }
            if (type != 3) continue;
        }
        return true;
    }

    public static boolean discoverGlobalIvrEnfZoneset(FabricImpl fabric) throws SnmpException {
        int[] cfsRegions = fabric.getCfsRegions("ivr");
        if (cfsRegions != null && (cfsRegions.length > 1 || cfsRegions.length == 1 && cfsRegions[0] != -1)) {
            return SnmpAdapter.discoverRegionIvrEnfZoneset(fabric, cfsRegions);
        }
        return SnmpAdapter.discoverIvrEnfZoneset(fabric);
    }

    public static boolean discoverRegionIvrEnfZoneset(FabricImpl fabric, int[] cfsRegionIds) throws SnmpException {
        ArrayList preIvrRegIds = fabric.getAllIvrEnforcedZoneSetRegionIds();
        for (int i = 0; i < cfsRegionIds.length; ++i) {
            SnmpAdapter.discoverRegionIvrEnfZoneset(fabric, cfsRegionIds[i]);
            if (preIvrRegIds == null) continue;
            preIvrRegIds.remove(new Integer(cfsRegionIds[i]));
        }
        for (Object ivrRegion : preIvrRegIds) {
            int regionId = (Integer)ivrRegion;
            fabric.removeRegionIvrSeed(regionId);
        }
        return true;
    }

    public static boolean discoverRegionIvrEnfZoneset(FabricImpl fabric, int regionId) throws SnmpException {
        CfsRegionImpl cfsRegion;
        SwitchImpl sw = fabric.getRegionIvrSeed(regionId);
        if (sw == null || !sw.isManageableMDS() || !sw.isIvrEnabled() || sw.isNpvEnabled() || sw.getCfsRegionId("ivr") != regionId) {
            sw = fabric.selectRegionIvrSeed(regionId);
        }
        if (sw == null) {
            fabric.setRegionIvrSeed(regionId, sw);
            _Log.debug((Object)(fabric + " -- IVR seed not found, zoneset query skipped"));
            return false;
        }
        fabric.setRegionIvrSeed(regionId, sw);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_IvrVars.length));
        int max = _IvrVars.length;
        for (int i = 0; i < max; ++i) {
            reqPdu.addVar(_IvrVars[i]);
        }
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        long actTime = vbl.getVb(0).getVar().getType() == 67 ? sw.getSysLastBootTime() + vbl.longValue(0) * 10L : 0L;
        String name = vbl.getVb(1).getVar().getType() == 4 ? vbl.stringValue(1) : null;
        byte[] chksum = vbl.byteValue(2);
        fabric.setIvrEnforcedZoneSetActivateTime(regionId, actTime);
        fabric.setIvrEnforcedZoneSetName(regionId, name);
        fabric.setIvrActiveZonesetChecksum(regionId, chksum.length == 0 ? null : chksum);
        if (vbl.getVb(3).getVar().getType() == 2) {
            fabric.setIvrEnforcedZoneNum(regionId, vbl.intValue(3));
        }
        if ((cfsRegion = fabric.findCfsRegion(new CfsRegionPK(fabric.getPK(), regionId))) != null) {
            cfsRegion.setIvrEnfZoneSetName(name);
            cfsRegion.setIvrSeed(sw);
        }
        return true;
    }

    public static boolean discoverIvrEnfZoneset(FabricImpl fabric) throws SnmpException {
        ArrayList preIvrRegIds = fabric.getAllIvrEnforcedZoneSetRegionIds();
        for (Object ivrRegion : preIvrRegIds) {
            int regionId = (Integer)ivrRegion;
            if (regionId == -1) continue;
            fabric.removeRegionIvrSeed(regionId);
        }
        SwitchImpl sw = fabric.getIvrSeed();
        if (sw == null || !sw.isManageableMDS() || !sw.isIvrEnabled() || sw.isNpvEnabled()) {
            fabric.selectIvrSeed();
        }
        if (sw == null) {
            _Log.debug((Object)(fabric + " -- IVR seed not found, zoneset query skipped"));
            fabric.setIvrSeed(sw);
            return false;
        }
        fabric.setIvrSeed(sw);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_IvrVars.length));
        int max = _IvrVars.length;
        for (int i = 0; i < max; ++i) {
            reqPdu.addVar(_IvrVars[i]);
        }
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        long actTime = vbl.getVb(0).getVar().getType() == 67 ? sw.getSysLastBootTime() + vbl.longValue(0) * 10L : 0L;
        String name = vbl.getVb(1).getVar().getType() == 4 ? vbl.stringValue(1) : null;
        byte[] chksum = vbl.byteValue(2);
        fabric.setIvrEnforcedZoneSetActivateTime(-1, actTime);
        fabric.setIvrEnforcedZoneSetName(-1, name);
        fabric.setIvrActiveZonesetChecksum(-1, chksum.length == 0 ? null : chksum);
        if (vbl.getVb(3).getVar().getType() == 2) {
            fabric.setIvrEnforcedZoneNum(-1, vbl.intValue(3));
        }
        return true;
    }

    public static boolean discoverGlobalIvrEnfZones(FabricImpl fabric) throws SnmpException {
        int[] cfsRegions = fabric.getCfsRegions("ivr");
        if (cfsRegions != null && (cfsRegions.length > 1 || cfsRegions.length == 1 && cfsRegions[0] != -1)) {
            return SnmpAdapter.discoverRegionIvrEnfZones(fabric, cfsRegions);
        }
        return SnmpAdapter.discoverIvrEnfZones(fabric);
    }

    public static boolean discoverRegionIvrEnfZones(FabricImpl fabric, int[] cfsRegionIds) throws SnmpException {
        for (int i = 0; i < cfsRegionIds.length; ++i) {
            SnmpAdapter.discoverRegionIvrEnfZones(fabric, cfsRegionIds[i]);
        }
        return true;
    }

    public static boolean discoverRegionIvrEnfZones(FabricImpl fabric, int regionId) throws SnmpException {
        int znIndex;
        int[] oid;
        SwitchImpl sw = fabric.getRegionIvrSeed(regionId);
        if (sw == null || !sw.isManageableMDS() || !sw.isIvrEnabled() || sw.isNpvEnabled() || sw.getCfsRegionId("ivr") != regionId) {
            sw = fabric.selectRegionIvrSeed(regionId);
        }
        if (sw == null) {
            fabric.setRegionIvrSeed(regionId, sw);
            _Log.debug((Object)(fabric + " -- IVR seed not found, zoneset query skipped"));
            return false;
        }
        fabric.setRegionIvrSeed(regionId, sw);
        boolean ivr2 = sw.isVersionGreaterThanEqual("2.1(0)");
        int numCol = ivr2 ? _IvrEnfZoneVars.length : _IvrEnfZoneVars.length - 2;
        VarBindList vbl = new VarBindList(numCol);
        for (int i = 0; i < numCol; ++i) {
            vbl.add(new SnmpVarBind(_IvrEnfZoneVars[i]));
        }
        _Log.info((Object)(fabric + " -- fetch active IVR zones from seed " + sw + ", region " + regionId + ", IvrEnforcedZoneNum = " + fabric.getIvrEnforcedZoneNum(regionId)));
        SnmpPDU respZone = SnmpFetch.getBulk(sw.createPeer(), vbl, fabric.getIvrEnforcedZoneNum(regionId));
        vbl = respZone.getVariables();
        Object[] zones = new ZoneBase[vbl.size() / numCol];
        int i = 0;
        int maxi = vbl.size();
        int j = 0;
        while (i < maxi) {
            oid = vbl.getVb(i).getOid().getValue();
            znIndex = oid[oid.length - 1];
            zones[j] = ivr2 ? new ZoneBase(znIndex, vbl.stringValue(i), vbl.intValue(i + 1) == 1, vbl.intValue(i + 2), false, regionId) : new ZoneBase(znIndex, vbl.stringValue(i), false, regionId);
            i += numCol;
            ++j;
        }
        numCol = ivr2 ? _IvrEnfZoneMbrVars.length : _IvrEnfZoneMbrVars.length - 2;
        vbl = new VarBindList(numCol);
        for (i = 0; i < numCol; ++i) {
            vbl.add(new SnmpVarBind(_IvrEnfZoneMbrVars[i]));
        }
        SnmpPDU respZnMem = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = respZnMem.getVariables();
        int maxi2 = vbl.size();
        for (int i2 = 0; i2 < maxi2; i2 += numCol) {
            oid = vbl.getVb(i2).getOid().getValue();
            znIndex = oid[oid.length - 2];
            ZoneBase parentZone = ZoneBase.findParent((ZoneBase[])zones, znIndex);
            if (parentZone != null) {
                if (ivr2) {
                    parentZone.addMember(vbl.intValue(i2), vbl.byteValue(i2 + 1), vbl.byteValue(i2 + 4), (short)vbl.intValue(i2 + 2), vbl.intValue(i2 + 3));
                    continue;
                }
                parentZone.addMember(vbl.intValue(i2), vbl.byteValue(i2 + 1), (short)vbl.intValue(i2 + 2));
                continue;
            }
            _Log.warn((Object)(sw.getIpAddress() + " -- " + znIndex + ": unknown ivr zone member " + Arrays.toString(vbl.byteValue(i2 + 1))));
        }
        Arrays.sort(zones);
        fabric.setIvrEnforcedZones(new Integer(regionId), (ZoneBase[])zones);
        fabric.resetDiscFlag(1);
        return true;
    }

    public static boolean discoverIvrEnfZones(FabricImpl fabric) throws SnmpException {
        int znIndex;
        int[] oid;
        SwitchImpl sw = fabric.selectIvrSeed();
        if (sw == null) {
            _Log.debug((Object)(fabric + " -- IVR seed not found, zones query skipped"));
            return false;
        }
        fabric.setIvrSeed(sw);
        boolean ivr2 = sw.isVersionGreaterThanEqual("2.1(0)");
        int numCol = ivr2 ? _IvrEnfZoneVars.length : _IvrEnfZoneVars.length - 2;
        VarBindList vbl = new VarBindList(numCol);
        for (int i = 0; i < numCol; ++i) {
            vbl.add(new SnmpVarBind(_IvrEnfZoneVars[i]));
        }
        _Log.info((Object)(fabric + " -- fetch active IVR zones from seed " + sw + ", IvrEnforcedZoneNum = " + fabric.getIvrEnforcedZoneNum(-1)));
        SnmpPDU respZone = SnmpFetch.getBulk(sw.createPeer(), vbl, fabric.getIvrEnforcedZoneNum(-1));
        vbl = respZone.getVariables();
        Object[] zones = new ZoneBase[vbl.size() / numCol];
        int i = 0;
        int maxi = vbl.size();
        int j = 0;
        while (i < maxi) {
            oid = vbl.getVb(i).getOid().getValue();
            znIndex = oid[oid.length - 1];
            zones[j] = ivr2 ? new ZoneBase(znIndex, vbl.stringValue(i), vbl.intValue(i + 1) == 1, vbl.intValue(i + 2), false, -1) : new ZoneBase(znIndex, vbl.stringValue(i), false);
            i += numCol;
            ++j;
        }
        numCol = ivr2 ? _IvrEnfZoneMbrVars.length : _IvrEnfZoneMbrVars.length - 2;
        vbl = new VarBindList(numCol);
        for (i = 0; i < numCol; ++i) {
            vbl.add(new SnmpVarBind(_IvrEnfZoneMbrVars[i]));
        }
        SnmpPDU respZnMem = SnmpFetch.getBulk(sw.createPeer(), vbl);
        vbl = respZnMem.getVariables();
        int maxi2 = vbl.size();
        for (int i2 = 0; i2 < maxi2; i2 += numCol) {
            oid = vbl.getVb(i2).getOid().getValue();
            znIndex = oid[oid.length - 2];
            ZoneBase parentZone = ZoneBase.findParent((ZoneBase[])zones, znIndex);
            if (parentZone != null) {
                if (ivr2) {
                    parentZone.addMember(vbl.intValue(i2), vbl.byteValue(i2 + 1), vbl.byteValue(i2 + 4), (short)vbl.intValue(i2 + 2), vbl.intValue(i2 + 3));
                    continue;
                }
                parentZone.addMember(vbl.intValue(i2), vbl.byteValue(i2 + 1), (short)vbl.intValue(i2 + 2));
                continue;
            }
            _Log.warn((Object)(sw.getIpAddress() + " -- " + znIndex + ": unknown ivr zone member " + Arrays.toString(vbl.byteValue(i2 + 1))));
        }
        Arrays.sort(zones);
        fabric.setIvrEnforcedZones(new Integer(-1), (ZoneBase[])zones);
        fabric.resetDiscFlag(1);
        return true;
    }

    public static boolean discoverFlogiPorts(SwitchImpl sw) throws SnmpException {
        if (sw.getNumOfFlogiQueries() == 0) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw + " skip flogi query for empty list"));
            }
            sw.resetDiscFlag(16384);
            return false;
        }
        if (!sw.getBase().isManageable()) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw + " skip flogi query for non-manageable switch"));
            }
            sw.clearFlogiQueries();
            sw.resetDiscFlag(16384);
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(sw.getIpAddress(), "discoverFlogiPorts");
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_FlogiCountVar));
        SnmpPDU reqPdu = new SnmpPDU(-96, vbl);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        int flogiCount = rspPdu.getVariables().intValue(0);
        if (flogiCount == 0) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw + " skip flogi query for zero flogi count is 0"));
            }
            sw.clearFlogiQueries();
            sw.resetDiscFlag(16384);
            return false;
        }
        Map<VsanFcIdKey, Wwn[]> flogiQueries = sw.getFlogiQueries();
        HashSet<Short> vsanIds = new HashSet<Short>(flogiQueries.size());
        for (VsanFcIdKey vsanFcid : flogiQueries.keySet()) {
            vsanIds.add(vsanFcid._vsanPK._id);
        }
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(_Flogi_Oids.length));
        for (int i = 0; i < _Flogi_Oids.length; ++i) {
            pdu.addNull(new SnmpOID(_Flogi_Oids[i]));
        }
        pdu.setMaxRptr(flogiCount);
        rspPdu = sw.createPeer().send(pdu);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(sw.getIpAddress(), "-- queryFlogi response:", rspVbl.toString());
        }
        FabricImpl fabric = sw.getFabric();
        for (int i = 0; i < rspVbl.size(); i += _Flogi_Oids.length) {
            SnmpVarBind vb = rspVbl.get(i);
            int vsanId = vb.getIndexFromEnd(1);
            int ifindex = vb.getIndexFromEnd(2);
            byte[] bytes = rspVbl.byteValue(i + 2);
            if (bytes == null || bytes.length < 3) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw + " cannot process flogi fcid:" + vb + ", fcid:" + Arrays.toString(bytes)));
                continue;
            }
            int fcId = ((bytes[0] & 0xFF) << 16) + ((bytes[1] & 0xFF) << 8) + (bytes[2] & 0xFF);
            VsanImpl vsan = sw.getVsan((short)vsanId);
            if (vsan == null) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw + " cannot get vsan for flogi from :" + vb));
                continue;
            }
            VsanFcIdKey vsanFcid = new VsanFcIdKey(vsan.getVsanPK(), fcId);
            Wwn[] wwns = flogiQueries.get(vsanFcid);
            if (wwns == null || wwns.length != 2) {
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw + " cannot find endport for vsan fcid:" + vsanFcid));
                continue;
            }
            Wwn pwwn = new Wwn(((SnmpString)vb.getVar()).getValue());
            if (pwwn.equals(wwns[0])) {
                sw.addFwwn2IfIndex(wwns[1], ifindex);
                EndPortImpl ep = vsan.findEndPort(fcId);
                if (ep != null) {
                    ep.setFPort(sw, ifindex);
                }
                if (ep != null) continue;
                ep = SanManager.getInstance().findEndPort(pwwn);
                if (ep.getFabricPK().equals(sw.getFabricPK())) {
                    ep.setFPort(sw, ifindex);
                    continue;
                }
                ep = null;
                continue;
            }
            if (!_Log.isDebugEnabled()) continue;
            _Log.debug((Object)(sw + " flogi pwwn does not match with endport:" + pwwn + "," + wwns[0]));
        }
        sw.clearFlogiQueries();
        sw.resetDiscFlag(16384);
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(sw.getIpAddress(), "discoverFlogiPorts", sw.getBase().getFwwn2IfIndexMap());
        }
        return true;
    }

    public static boolean discoverVfcBinding(SwitchImpl sw) throws SnmpException {
        if (!sw.getBase().isFCoEEnabled()) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " skip vfc binding for non-fcoe switch"));
            }
            sw.resetDiscFlag(32768);
            return false;
        }
        if (!sw.getBase().isManageable()) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " skip vfc binding for non-manageable switch"));
            }
            sw.resetDiscFlag(32768);
            return false;
        }
        List<Integer> vfcs = sw.findVFCIfIndices();
        if (vfcs == null || vfcs.size() == 0) {
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(sw.getIpAddress() + " skip vfc binding for empty vfc switch " + sw.getVersion() + "--" + sw.getPorts()));
            }
            sw.resetDiscFlag(32768);
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(sw.getIpAddress(), "discoverVfcBinding");
        }
        SwitchBase switchInt = sw.getBase();
        VarBindList vbl = new VarBindList(vfcs.size() * _VfcBinding_Oids.length);
        for (int i = 0; i < vfcs.size(); ++i) {
            for (int k = 0; k < _VfcBinding_Oids.length; ++k) {
                vbl.add(_VfcBinding_Oids[k], IfIndexUtil.ifIndexToVfcTableIndex(vfcs.get(i), switchInt));
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(sw.getIpAddress(), "-- queryVfcBinding response:", rspVbl.toString());
        }
        FabricImpl fabric = sw.getFabric();
        ArrayList<FcPortBase> vfcPorts = new ArrayList<FcPortBase>();
        for (int i = 0; i < rspVbl.size(); i += _VfcBinding_Oids.length) {
            ArrayList<EndPortImpl> epList;
            int opMode;
            String bindToStr;
            int vfcId = rspVbl.get(i).getIndex();
            int vfcIfindex = IfIndexUtil.vfcIndexToIfIndex(vfcId, sw.getBase().getActualType(30));
            short bindType = (short)rspVbl.intValue(i);
            FcPortBase vfcPort = sw.findPort(vfcIfindex);
            if (vfcPort == null) continue;
            vfcPorts.add(vfcPort);
            FcPortImpl vfcPortImpl = sw.getFabric().findSwitchPortByKey((SwitchIntKey)vfcPort.getSwitchPortPK());
            vfcPort.setVfcBindType(bindType);
            if (vfcPortImpl != null) {
                vfcPortImpl.setVfcBindType(bindType);
            }
            if (bindType == 2) {
                vfcPort.setVfcBindType(bindType);
                MacAddress bindMAC = null;
                try {
                    bindMAC = new MacAddress(rspVbl.stringValue(i + 2));
                    vfcPort.setVfcBindMacAddress(bindMAC);
                    if (vfcPortImpl != null) {
                        vfcPortImpl.setVfcBindMacAddress(bindMAC);
                    }
                }
                catch (Exception e) {
                    _Log.warn((Object)(sw.getIpAddress() + " cannot parse vfc binding mac"), (Throwable)e);
                }
            } else {
                int bindIfIndex = rspVbl.intValue(i + 1);
                vfcPort.setVfcBindIfindex(bindIfIndex);
                if (vfcPortImpl != null) {
                    vfcPortImpl.setVfcBindIfindex(bindIfIndex);
                }
            }
            if (vfcPort.getVfcBindType() == 1) {
                bindToStr = switchInt.ifIndexToName(vfcPort.getVfcBindIfindex());
                if (switchInt.getType(vfcPort.getVfcBindIfindex()) == 28) {
                    VarBindList vethVbl = new VarBindList();
                    int vethId = Integer.parseInt(bindToStr.replace("veth", ""));
                    int[] vethIndex = new int[]{vethId, 6};
                    vethVbl.add(VIGLESS_VETH_BINDING_IF_OID, vethIndex);
                    SnmpPDU resp = SnmpFetch.get(sw.getPeer(), vethVbl);
                    vethVbl = resp.getVariables();
                    int ethPortIfIndex = vethVbl.intValue(0);
                    bindToStr = bindToStr + "->" + switchInt.ifIndexToName(ethPortIfIndex);
                }
            } else {
                MacAddress bindMAC = vfcPort.getVfcBindMacAddress();
                if (bindMAC == null || bindMAC.isAllZeros()) continue;
                bindToStr = bindMAC.toString();
            }
            vfcPort.setVFCBindTo(bindToStr);
            if (vfcPortImpl != null) {
                vfcPortImpl.setVFCBindTo(bindToStr);
            }
            if ((opMode = vfcPort.getIfOperMode()) == 4 || opMode == 12 || (epList = fabric.findEndPortsBySwitchIfIndex(sw, vfcIfindex)) == null || epList.size() <= 0) continue;
            for (EndPortImpl ep : epList) {
                ep.setIfName(vfcPort);
            }
        }
        sw.resetDiscFlag(32768);
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(sw.getIpAddress(), "queryVfcBinding", vfcPorts);
        }
        return true;
    }

    static byte[] parseWwn(String infoList) {
        byte[] wwn = null;
        if (infoList != null) {
            int fromIndex = 0;
            try {
                int pos;
                while ((pos = infoList.indexOf(58, fromIndex)) != -1) {
                    if (infoList.charAt(pos + 3) == ':' && infoList.charAt(pos + 6) == ':' && infoList.charAt(pos + 9) == ':' && infoList.charAt(pos + 12) == ':' && infoList.charAt(pos + 15) == ':' && infoList.charAt(pos + 18) == ':') {
                        wwn = SnmpString.fromHexString(infoList.substring(pos - 2, pos + 21));
                        break;
                    }
                    fromIndex = pos + 1;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return wwn;
    }

    static SnmpOID getNonMdsSwVerOID(SwitchImpl sw) {
        byte[] b = sw.getWwn() == null ? new byte[16] : sw.getWwn().getValue();
        int vendor = WwnDictionary.getVendorId(b);
        if (vendor == 49373 || WwnDictionary.isQuailWwn(b) || vendor == 24799 || WwnDictionary.isBrocadeWwn(b)) {
            int[] index = new int[17];
            for (int i = 0; i < 8; ++i) {
                index[i] = b[i] & 0xFF;
            }
            index[16] = WwnDictionary.isQuailWwn(b) ? 0 : 1;
            return new SnmpOID(MibNode.get("connUnitRevsRevId").getOid(), index);
        }
        if (WwnDictionary.isCisco(vendor)) {
            return new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 1);
        }
        return new SnmpOID(MibNode.get("sysDescr").getOid());
    }

    protected static VarBindList buildVbl(int[][] oid, int index) {
        VarBindList vbl = new VarBindList(oid.length);
        for (int i = 0; i < oid.length; ++i) {
            if (index == 0) {
                vbl.add(new SnmpVarBind(new SnmpOID(oid[i])));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(oid[i], index)));
        }
        return vbl;
    }

    protected static VarBindList buildVbl(int[][] oids, int[] indexList) {
        VarBindList vbl = new VarBindList(oids.length * indexList.length);
        for (int i = 0; i < indexList.length; ++i) {
            for (int j = 0; j < oids.length; ++j) {
                if (indexList[i] == 0) {
                    vbl.add(new SnmpVarBind(new SnmpOID(oids[j])));
                    continue;
                }
                vbl.add(new SnmpVarBind(new SnmpOID(oids[j], indexList[i])));
            }
        }
        return vbl;
    }

    static Wwn vsanWwnToSwitchWwn(byte[] vwwn) {
        boolean isCiscoOUI = WwnDictionary.isCiscoWwn(vwwn);
        if (vwwn[0] >> 4 == 2 && !isCiscoOUI && WwnDictionary.getVendor(vwwn) == null) {
            WwnDictionary.addDiscoveredOUI(WwnDictionary.getVendorId(vwwn), "Cisco", 32);
            isCiscoOUI = true;
        }
        return new Wwn(isCiscoOUI && !WwnDictionary.isQuailWwn(vwwn) ? WwnDictionary.vsanWwnToSwwn(vwwn) : vwwn);
    }

    public static SnmpPeer createSnmpPeer(InetAddress ip, SnmpUser user) throws SnmpException {
        if (ip == null || user == null) {
            throw new SnmpException("IP address and Snmp User cannot be null");
        }
        if (ip.isLinkLocalAddress() || ip.isMulticastAddress()) {
            throw new SnmpException("IP address cannot be local or multicast");
        }
        SnmpPeer peer = null;
        Boolean v3Only = Boolean.parseBoolean(System.getProperty("snmp.v3only"));
        if (user.getSecurityModel() == 3) {
            UsmUser usmUser = (UsmUser)user;
            peer = new SnmpPeer(ip, SnmpSession.getInstance("tcp"), usmUser.getUserName(), usmUser.getAuthPassword(), usmUser.getAuthProtocol(), usmUser.getPrivacyPassword(), usmUser.getPrivacyProtocol());
            if (!v3Only.booleanValue() && !peer.isValidCredential()) {
                String community = System.getProperty("snmp.defaultCommunity");
                if (community == null || community.trim().equals("")) {
                    community = "public";
                }
                peer.setCredentials(SnmpSession.getInstance("udp"), community, community, false);
            }
        } else {
            if (v3Only.booleanValue()) {
                throw new SnmpException("Does not support SNMPv2/1 when snmp.v3only=true");
            }
            peer = new SnmpPeer(ip);
            if (user instanceof CommunityUser) {
                user.initPeer(peer, SnmpSession.getInstance("udp"));
            } else {
                String rc = null;
                String wc = null;
                SnmpCommunity sc = SnmpCommunity.getCommunity(ip);
                if (sc != null) {
                    rc = sc.getRead();
                    wc = sc.getWrite();
                } else {
                    rc = ((CommunityUser)user).getCommunity();
                    wc = ((CommunityUser)user).getCommunity();
                }
                if ("$IGNORE_COMMUNITY$".equals(rc)) {
                    throw new SnmpException("noCommunity");
                }
                peer.setCredentials(SnmpSession.getInstance("udp"), rc, wc);
            }
        }
        return peer;
    }

    public static SnmpPeer createSnmpPeer(InetAddress ip, SnmpUserOpt snmpUserOpt) throws SnmpException {
        if (ip == null || snmpUserOpt == null) {
            throw new SnmpException("IP address and Snmp User cannot be null");
        }
        if (ip.isLinkLocalAddress() || ip.isMulticastAddress()) {
            throw new SnmpException("IP address cannot be local or multicast");
        }
        SnmpPeer peer = null;
        Boolean v3Only = Boolean.parseBoolean(System.getProperty("snmp.v3only"));
        if (snmpUserOpt.isV3()) {
            peer = new SnmpPeer(ip, SnmpSession.getInstance("tcp"), snmpUserOpt.getUsername(), snmpUserOpt.getPassword(), snmpUserOpt.getAuthProtocol(), snmpUserOpt.getPrivPassword(), snmpUserOpt.getPrivProtocol());
            peer.setVersion(3);
            if (!v3Only.booleanValue() && !peer.isValidCredential()) {
                String community = System.getProperty("snmp.defaultCommunity");
                if (community == null || community.trim().equals("")) {
                    community = "public";
                }
                peer.setCredentials(SnmpSession.getInstance("udp"), community, community, false);
            }
        } else {
            if (v3Only.booleanValue()) {
                throw new SnmpException("Does not support SNMPv2/1 when snmp.v3only=true");
            }
            SnmpSession session = SnmpSession.getInstance("udp");
            peer = new SnmpPeer(ip, snmpUserOpt.getCommunity(), snmpUserOpt.getCommunity(), session);
            peer.setVersion(1);
        }
        return peer;
    }

    public static void validateSeedSwitch(SnmpPeer peer) throws Exception {
        if (peer == null) {
            throw new IllegalArgumentException("SnmpPeer cannot be null");
        }
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append("Validate seed switch:").append(peer).append(" failed \n");
        try {
            SnmpPDU reqPdu = null;
            SnmpPDU respPdu = null;
            VarBindList vbl = null;
            SnmpVar var = null;
            reqPdu = new SnmpPDU(-96, new VarBindList(_GenSysVars.length));
            for (int i = 0; i < _GenSysVars.length; ++i) {
                reqPdu.addNull(_GenSysVars[i]);
            }
            respPdu = peer.send(reqPdu);
            vbl = respPdu.getVariables();
            var = respPdu.getVar(0);
            if (var.getType() != 6) {
                throw new SnmpException(peer.getAddress() + " returns bad sysObjectID");
            }
            boolean isMds = false;
            boolean isQuail = false;
            boolean isN7k = false;
            boolean isNPVEnabled = false;
            int[] sysObjectID = ((SnmpOID)respPdu.getVar(0)).getValue();
            if (sysObjectID.length >= 7) {
                int vendorOid = sysObjectID[6];
                int type = sysObjectID[sysObjectID.length - 1];
                if (vendorOid == 9) {
                    if (SnmpOID.startsWith(sysObjectID, CISCO_CHASSIS_OID)) {
                        if (sysObjectID[sysObjectID.length - 1] == 612) {
                            isN7k = true;
                        } else {
                            isMds = true;
                        }
                    } else if (type == 514) {
                        isQuail = true;
                    } else {
                        msgBuf.append("It is not a MDS switch device: " + type);
                    }
                } else if (vendorOid == 289) {
                    msgBuf.append("Invalid switch vendor: McData");
                } else if (vendorOid == 1588) {
                    msgBuf.append("Invalid switch vendor: Brocade");
                } else if (vendorOid == 5808) {
                    msgBuf.append("Invalid switch vendor: InRange");
                } else if (vendorOid == 1663 || vendorOid == 3873) {
                    msgBuf.append("Invalid switch vendor: QLogic");
                } else {
                    msgBuf.append("Invalid switch vendor: " + vendorOid);
                }
            }
            if (isN7k) {
                isMds = true;
            }
            if (!isMds && !isQuail) {
                throw new Exception(msgBuf.toString());
            }
            vbl = new VarBindList(AbstractSwitchBase.NUM_FEATURES);
            for (int i = 1; i <= AbstractSwitchBase.NUM_FEATURES; ++i) {
                vbl.add(_FeatureOid, i);
            }
            SnmpPDU pdu = new SnmpPDU(-96, vbl);
            pdu = peer.send(pdu);
            vbl = pdu.getVariables();
            boolean[] flags = new boolean[AbstractSwitchBase.NUM_FEATURES];
            for (SnmpVarBind vb : vbl) {
                var = vb.getVar();
                if (var.getType() != 2 || ((SnmpInt)var).getValue() != 2) continue;
                flags[vb.getOid().getIndexFromEnd((int)0) - 1] = true;
            }
            if (flags[AbstractSwitchBase.Feature.NPV.flag()] || flags[AbstractSwitchBase.Feature.FCOENPV.flag()]) {
                isNPVEnabled = true;
                msgBuf.append("NPV enabled switch cannot act as a seed switch");
            }
            if (isNPVEnabled) {
                throw new Exception(msgBuf.toString());
            }
        }
        catch (SnmpException e) {
            msgBuf.append("Cannot verify seed switch from SNMP:").append(e.getMessage());
            _Log.warn((Object)msgBuf.toString(), (Throwable)e);
            throw new Exception(msgBuf.toString(), e);
        }
    }

    private static void setAliasRunningConfig(SwitchImpl sw) throws SnmpException {
        try {
            _Log.debug((Object)(sw.getIpAddress() + " -- set device alias database to running config"));
            SnmpPDU reqPdu = new SnmpPDU(-93, new VarBindList(1));
            reqPdu.addVar(_CfsFeatureOpShowCfgVar, new SnmpInt(1));
            SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
            sw.setDeviceAliasShowCfg(1);
        }
        catch (SnmpException se) {
            _Log.debug((Object)(sw.getIpAddress() + " -- set running config error"), (Throwable)se);
        }
    }

    private static int[] getIndexForVb(SnmpVarBind vb, int[] mibnode) {
        int[] oid = vb.getOid().getValue();
        int[] index = new int[oid.length - mibnode.length];
        System.arraycopy(oid, oid.length - index.length, index, 0, index.length);
        return index;
    }

    public static Map<Integer, String> getFexChassisIndex(SnmpPeer peer, SwitchVersion version) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexChassisIndex");
        }
        int chassisIndex = NexusEntityMibHelper.getFexChassisPhyIndex();
        int maxChassisIndex = NexusEntityMibHelper.getFexChassisPhyIndexMax();
        HashMap<Integer, String> retMap = new HashMap<Integer, String>();
        VarBindList vbl = new VarBindList(1);
        vbl.add(_EntityOids[7]);
        SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(peer, vbl, 0, new int[]{chassisIndex}, new int[]{maxChassisIndex});
        VarBindList rspVbl = rspPdu.getVariables();
        for (int i = 0; i < rspVbl.size(); ++i) {
            int index = NexusEntityMibHelper.getFexIdByPhyIndex(rspVbl.get(i).getIndexFromEnd(0));
            List<String> values = CdpSnmpAdapter.serialNumMap.get(peer.getAddress().getHostAddress());
            if (values != null) {
                retMap.put(index, values.get(1));
                continue;
            }
            String name = rspVbl.stringValue(i);
            retMap.put(index, name);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexChassisIndex", retMap);
        }
        return retMap;
    }

    static {
        int i;
        _Log = LogManager.getLogger((String)"fms.disc");
        _Tracer = new TraceLogger(_Log, SanManager.Test, false, false, false);
        _EnableIPFC = Boolean.parseBoolean(System.getProperty("enableIPFC", "false"));
        _EnableFV = Boolean.parseBoolean(System.getProperty("enableFV", "false"));
        _DisplayIVRZones = Boolean.parseBoolean(System.getProperty("zone.displayIVRZones", "false"));
        _RetainSETPorts = Boolean.parseBoolean(System.getProperty("fabric.retainSETPorts", "true"));
        _ReturnDownPort = Boolean.parseBoolean(System.getProperty("smis.returnDownPort", "true"));
        TrimDomain = Boolean.parseBoolean(System.getProperty("trimDomain", "true"));
        AutoCdpDiscv = Boolean.parseBoolean(System.getProperty("fabric.autoCdpDiscovery", "false"));
        _EnableVIRT = Boolean.parseBoolean(System.getProperty("enableVIRT", "false"));
        _Log.info((Object)("SnmpAdapter Properties -- trimDomain=" + TrimDomain + "; enableIPFC=" + _EnableIPFC + "; enableFV=" + _EnableFV + "; enableVIRT=" + _EnableVIRT + "; zone.displayIVRZones=" + _DisplayIVRZones + "; fabric.retainSETPort=" + _RetainSETPorts + "; smis.returnDownPort=" + _ReturnDownPort + "; fabric.autoCdpDiscovery=" + AutoCdpDiscv));
        CISCO_CHASSIS_OID = new int[]{1, 3, 6, 1, 4, 1, 9, 12, 3, 1, 3};
        _FcnsSymNodeNameOid = MibNode.get("fcNameServerSymbolicNodeName").getOid();
        _FcnsSymPortNameOid = MibNode.get("fcNameServerSymbolicPortName").getOid();
        _FcnsNodeIpAddrOid = MibNode.get("fcNameServerNodeIpAddress").getOid();
        _FeatureOid = MibNode.get("cfcFeatureCtrlOpStatus").getOid();
        _FiconVsanOid = MibNode.get("cficonVsanFiconState").getOid();
        _FcsMgmtAddrOid = MibNode.get("fcsMgmtAddr").getOid();
        _ZoneMbrFmtOid = MibNode.get("zoneMemberFormat").getOid();
        _ZoneMbrIdOid = MibNode.get("zoneMemberID").getOid();
        _FeModuleNameOid = MibNode.get("fcFeModuleName").getOid();
        _ConnUnitRevOid = MibNode.get("connUnitRevsRevId").getOid();
        _VsanWwnOid = MibNode.get("wwnmVsanWwn").getOid();
        _FeatureSetStatusOid = MibNode.get("cfcFeatureSetOpStatus").getOid();
        _LunDiscSpinLockVar = new SnmpOID(MibNode.get("ciscoExtScsiLunDiscSpinLock").getOid(), 0);
        _LunDiscTypeVar = new SnmpOID(MibNode.get("ciscoExtScsiDiscType").getOid(), 0);
        _LunDiscVsanVar = new SnmpOID(MibNode.get("ciscoExtScsiLunDiscVsanId").getOid(), 0);
        _LunDiscPortVar = new SnmpOID(MibNode.get("ciscoExtScsiLunDiscPortId").getOid(), 0);
        _StartLunDiscVar = new SnmpOID(MibNode.get("ciscoExtScsiStartLunDisc").getOid(), 0);
        _LunDiscStatusVar = new SnmpOID(MibNode.get("ciscoExtScsiLunDiscStatus").getOid(), 0);
        _FlogiCountVar = new SnmpOID(MibNode.get("fcIfLoginEntryCount").getOid(), 0);
        _FlogiPortVar = new SnmpOID(MibNode.get("fcIfNxPortName").getOid());
        _VedmVeNameVar = new SnmpOID(MibNode.get("vedmVeName").getOid());
        _VedmVepPWwnVar = new SnmpOID(MibNode.get("vedmVepPortWwn").getOid());
        _TrapTargetVar = new SnmpOID(MibNode.get("snmpTargetAddrTAddress").getOid());
        _SyslogTargetType = new SnmpOID(MibNode.get("cseSyslogServerAddressType").getOid());
        _SyslogTargetVar = new SnmpOID(MibNode.get("cseSyslogServerAddress").getOid());
        _FiconPortMaxVar = new SnmpOID(MibNode.get("cficonPortMapMax").getOid(), 0);
        _FiconPortMapVar = new SnmpOID(MibNode.get("cficonPortMapObj").getOid());
        _CiscoNumLicOid = new SnmpOID(MibNode.get("clmNoOfLicensedFeatures").getOid(), 0);
        _DaChecksumVar = new SnmpOID(MibNode.get("cfdaChecksum").getOid(), 0);
        _SsmFeatureVar = new SnmpOID(MibNode.get("ssmProvFeatureIfRowStatus").getOid());
        _SsmSsnFeatureVar = new SnmpOID(MibNode.get("ssmSsnProvFeatureRowStatus").getOid());
        _ClusterInterfaceVar = new SnmpOID(MibNode.get("cSmeClusterInterfaceState").getOid());
        _SmeChgChkVar = new SnmpOID(MibNode.get("cSmeConfigTableLastChanged").getOid(), 0);
        _FcipLinkEthIfIndexVar = new SnmpOID(MibNode.get("cfmFcipLinkExtEthIfIndex").getOid());
        _FcipLinkIfIndexVar = new SnmpOID(MibNode.get("cfmFcipLinkIfIndex").getOid());
        _CfsFeatureOpShowCfgVar = new SnmpOID(MibNode.get("cfsFeatureOpShowCfgOption").getOid(), "device-alias");
        _BaseSvcClusterInterfaceVar = new SnmpOID(MibNode.get("cSanBaseSvcClusterInterfaceState").getOid());
        _BaseSvcChgChkVar = new SnmpOID(MibNode.get("cSanBaseSvcConfigTableLastChanged").getOid(), 0);
        _CfsRegionVar = new SnmpOID(MibNode.get("cfsFeatureRegionId").getOid());
        _cfcoeVlanOperStateVar = new SnmpOID(MibNode.get("cfcoeVLANOperState").getOid());
        _cficonLogicReservedPNVar = new SnmpOID(MibNode.get("cficonLogicReservedPN").getOid(), 0);
        _CiscoChassisOid = MibNode.get("ceEntPhysicalSecondSerialNum").getOid();
        _CiscoCardOids = new int[][]{MibNode.get("cefcModuleAdminStatus").getOid(), MibNode.get("cefcModuleOperStatus").getOid(), MibNode.get("cefcModuleResetReasonDescription").getOid(), MibNode.get("cefcModuleStatusLastChangeTime").getOid(), MibNode.get("cefcFRUPowerAdminStatus").getOid(), MibNode.get("cefcFRUPowerOperStatus").getOid(), MibNode.get("cefcFRUCurrent").getOid()};
        _CiscoPowerOids = new int[][]{MibNode.get("cefcFRUPowerOperStatus").getOid(), MibNode.get("cefcPowerRedundancyMode").getOid(), MibNode.get("cefcTotalAvailableCurrent").getOid(), MibNode.get("cefcTotalDrawnCurrent").getOid(), MibNode.get("cefcPowerUnits").getOid()};
        _CiscoFanOid = MibNode.get("cefcFanTrayOperStatus").getOid();
        _FcIfOperStatusOid = MibNode.get("fcIfOperStatusCause").getOid();
        _FcIfGigEPortChannIfOid = MibNode.get("fcIfGigEPortChannelIfIndex").getOid();
        _ClmPortLicensingOperOid = MibNode.get("clmPortLicensingOper").getOid();
        _CfcoeVfcIfIndexOid = MibNode.get("cfcoeStaticVfcIndex").getOid();
        _FcIfOids = new int[][]{MibNode.get("ifName").getOid(), MibNode.get("fcIfWwn").getOid(), MibNode.get("fcIfOperMode").getOid(), MibNode.get("ifHighSpeed").getOid(), MibNode.get("ifType").getOid(), MibNode.get("fcIfPortType").getOid(), MibNode.get("fcIfConnectorType").getOid(), MibNode.get("ifDescr").getOid(), MibNode.get("vsanIfVsan").getOid(), MibNode.get("ifAdminStatus").getOid(), MibNode.get("ifOperStatus").getOid(), MibNode.get("fcIfAdminSpeed").getOid(), MibNode.get("fcIfAdminMode").getOid(), MibNode.get("ifAlias").getOid(), MibNode.get("fcIfOperStatusCause").getOid(), MibNode.get("fcIfActiveVsanUpList2k").getOid(), MibNode.get("fcIfActiveVsanUpList4k").getOid(), MibNode.get("cfcspMode").getOid(), MibNode.get("cfcspESPMode").getOid()};
        _FcGigEthernetIfOids = new int[][]{MibNode.get("ifName").getOid(), MibNode.get("ifHighSpeed").getOid(), MibNode.get("ifType").getOid(), MibNode.get("ifOperStatus").getOid(), MibNode.get("ifDescr").getOid(), MibNode.get("ifPhysAddress").getOid(), MibNode.get("ifAdminStatus").getOid(), MibNode.get("fcIfAdminSpeed").getOid(), MibNode.get("fcIfAdminMode").getOid(), MibNode.get("ifAlias").getOid(), MibNode.get("ciiIPIfAddressPrefixLength").getOid()};
        _ZoneAliasOids = new int[][]{MibNode.get("zoneAliasName").getOid(), MibNode.get("zoneAliasMemberList").getOid()};
        _DefZoneOids = new int[][]{MibNode.get("zoneDefaultZoneBehaviour").getOid(), MibNode.get("zoneDefaultZoneReadOnly").getOid(), MibNode.get("zoneDefaultZoneQos").getOid(), MibNode.get("zoneDefaultZoneQosPriority").getOid(), MibNode.get("zoneDefaultZoneBroadcast").getOid(), MibNode.get("zoneSetPropagationMode").getOid()};
        _EntChgChkVars = new SnmpOID[]{new SnmpOID(MibNode.get("entLastChangeTime").getOid(), 0), new SnmpOID(MibNode.get("cRFStatusUnitId").getOid(), 0), new SnmpOID(MibNode.get("cRFStatusPeerUnitState").getOid(), 0)};
        _ConnUnitZonesetVars = new SnmpOID[]{new SnmpOID(MibNode.get("connUnitZoneSetName").getOid()), new SnmpOID(MibNode.get("connUnitZoneSetNumZones").getOid())};
        _ConnUnitZonesVars = new SnmpOID[]{new SnmpOID(MibNode.get("connUnitZoneName").getOid()), new SnmpOID(MibNode.get("connUnitZoneMemberIdType").getOid()), new SnmpOID(MibNode.get("connUnitZoneMemberID").getOid())};
        _ConnUnitPortOids = new int[][]{MibNode.get("connUnitPortType").getOid(), MibNode.get("connUnitPortSpeed").getOid()};
        _DeviceAliasCfgVars = new SnmpOID[]{new SnmpOID(MibNode.get("cfdaConfigDeviceType").getOid()), new SnmpOID(MibNode.get("cfdaConfigDeviceId").getOid())};
        _ConnUnitAliasVars = new SnmpOID[]{new SnmpOID(MibNode.get("connUnitZoningAliasName").getOid()), new SnmpOID(MibNode.get("connUnitZoningAliasMemberIdType").getOid()), new SnmpOID(MibNode.get("connUnitZoningAliasMemberID").getOid())};
        _QuailVars = new SnmpOID[]{new SnmpOID(MibNode.get("uNumber").getOid(), 0), new SnmpOID(MibNode.get("statusChangeTime").getOid(), 0), new SnmpOID(MibNode.get("configurationChangeTime").getOid(), 0), new SnmpOID(MibNode.get("connUnitTableChangeTime").getOid(), 0), new SnmpOID(MibNode.get("connUnitSnsMaxEntry").getOid(), 0), new SnmpOID(MibNode.get("fcFeModuleCapacity").getOid(), 0), new SnmpOID(MibNode.get("fcFeElementName").getOid(), 0)};
        _SMEClusterVars = new SnmpOID[]{new SnmpOID(MibNode.get("cSmeClusterName").getOid()), new SnmpOID(MibNode.get("cSmeClusterState").getOid()), new SnmpOID(MibNode.get("cSmeClusterMasterInetAddrType").getOid()), new SnmpOID(MibNode.get("cSmeClusterMasterInetAddr").getOid())};
        _SMEInterfaceVars = new SnmpOID[]{new SnmpOID(MibNode.get("cSmeInterfaceState").getOid()), new SnmpOID(MibNode.get("cSmeInterfaceClusterId").getOid())};
        _BaseSvcClusterVars = new SnmpOID[]{new SnmpOID(MibNode.get("cSanBaseSvcClusterName").getOid()), new SnmpOID(MibNode.get("cSanBaseSvcClusterState").getOid()), new SnmpOID(MibNode.get("cSanBaseSvcClusterMasterInetAddrType").getOid()), new SnmpOID(MibNode.get("cSanBaseSvcClusterMasterInetAddr").getOid())};
        _BaseSvcInterfaceVars = new SnmpOID[]{new SnmpOID(MibNode.get("cSanBaseSvcInterfaceState").getOid()), new SnmpOID(MibNode.get("cSanBaseSvcInterfaceClusterId").getOid())};
        _McDataConnUnitOids = new int[][]{{1, 3, 6, 1, 2, 1, 8888, 1, 1, 3, 1, 6}, {1, 3, 6, 1, 2, 1, 8888, 1, 1, 3, 1, 4}, {1, 3, 6, 1, 2, 1, 8888, 1, 1, 3, 1, 8}};
        VIGLESS_VETH_BINDING_IF_OID = MibNode.get("cvifBindingIfIndex").getOid();
        String[] genSys = new String[]{"sysObjectID", "sysDescr", "sysUpTime", "sysContact", "sysName", "sysLocation"};
        _GenSysVars = new SnmpOID[genSys.length];
        for (i = 0; i < genSys.length; ++i) {
            SnmpAdapter._GenSysVars[i] = new SnmpOID(MibNode.get(genSys[i]).getOid(), 0);
        }
        String[] mdsCheck = new String[]{"cseSysUpTime", "fcNameServerTableLastChange", "vsanNumber", "vsanLastChange", "clmLicenseViolationWarnFlag", "cseSysTelnetServiceActivation", "cfdaConfigMode", "cfsFeatureOpShowCfgOption", "cfsFeatureOpShowCfgOption", "cssServiceActivation", "cfsFeatureOpStatus", "cseSysCPUUtilization", "cseSysMemoryUtilization", "cieDelayedLinkUpDownNotifEnable", "sysUpTime", "cffFcFeElementName"};
        _MdsSysVars = new SnmpOID[mdsCheck.length];
        for (i = 0; i < mdsCheck.length; ++i) {
            SnmpAdapter._MdsSysVars[i] = i == 7 ? new SnmpOID(MibNode.get(mdsCheck[i]).getOid(), "ivr") : (i == 8 || i == 10 ? new SnmpOID(MibNode.get(mdsCheck[i]).getOid(), "device-alias") : new SnmpOID(MibNode.get(mdsCheck[i]).getOid(), 0));
        }
        String[] fcsie = new String[]{"fcsIeDomainId", "fcsIeMgmtAddrListIndex", "fcsIeLogicalName", "fcsIeInfoList"};
        _FcsIeOids = new int[fcsie.length][];
        for (i = 0; i < fcsie.length; ++i) {
            SnmpAdapter._FcsIeOids[i] = MibNode.get(fcsie[i]).getOid();
        }
        String[] fspf = new String[]{"fspfLinkNbrDomainId", "fspfLinkPortIndex", "fspfLinkNbrPortIndex"};
        _FspfLsdbOids = new int[fspf.length][];
        for (i = 0; i < fspf.length; ++i) {
            SnmpAdapter._FspfLsdbOids[i] = MibNode.get(fspf[i]).getOid();
        }
        String[] hba = new String[]{"cfdmiHbaInfoNodeName", "cfdmiHbaInfoMfg", "cfdmiHbaInfoSn", "cfdmiHbaInfoModel", "cfdmiHbaInfoModelDescr", "cfdmiHbaInfoHwVer", "cfdmiHbaInfoDriverVer", "cfdmiHbaInfoOptROMVer", "cfdmiHbaInfoFwVer", "cfdmiHbaInfoOSInfo"};
        _HbaOids = new int[hba.length][];
        for (i = 0; i < _HbaOids.length; ++i) {
            SnmpAdapter._HbaOids[i] = MibNode.get(hba[i]).getOid();
        }
        String[] hbaPort = new String[]{"cfdmiHbaPortSupportedSpeed", "cfdmiHbaPortCurrentSpeed", "cfdmiHbaPortOsDevName", "cfdmiHbaPortHostName"};
        _HbaPortOids = new int[hbaPort.length][];
        for (i = 0; i < _HbaPortOids.length; ++i) {
            SnmpAdapter._HbaPortOids[i] = MibNode.get(hbaPort[i]).getOid();
        }
        String[] connUnit = new String[]{"connUnitStatus", "connUnitNumports", "connUnitSn", "connUnitProduct", "connUnitUpTime", "connUnitUrl", "connUnitName", "connUnitContact", "connUnitLocation", "connUnitDomainId", "connUnitFabricID", "connUnitNumLinks", "connUnitVendorId"};
        _ConnUnitOids = new int[connUnit.length][];
        for (i = 0; i < _ConnUnitOids.length; ++i) {
            SnmpAdapter._ConnUnitOids[i] = MibNode.get(connUnit[i]).getOid();
        }
        String[] connUnitLink = new String[]{"connUnitLinkUnitTypeY", "connUnitLinkPortNumberX", "connUnitLinkNodeIdY", "connUnitLinkPortNumberY", "connUnitLinkPortWwnY", "connUnitLinkConnIdY"};
        _ConnUnitLinkOids = new int[connUnitLink.length][];
        for (i = 0; i < _ConnUnitLinkOids.length; ++i) {
            SnmpAdapter._ConnUnitLinkOids[i] = MibNode.get(connUnitLink[i]).getOid();
        }
        String[] connUnitSns = new String[]{"connUnitSnsPortIndex", "connUnitSnsNodeName", "connUnitSnsFC4Type", "connUnitSnsPortType", "connUnitSnsFabricPortName", "connUnitSnsSymbolicNodeName", "connUnitSnsNodeIPAddress"};
        _ConnUnitSnsOids = new int[connUnitSns.length][];
        for (i = 0; i < _ConnUnitSnsOids.length; ++i) {
            SnmpAdapter._ConnUnitSnsOids[i] = MibNode.get(connUnitSns[i]).getOid();
        }
        String[] vsan = new String[]{"vsanName", "dmDomainId", "dmLocalSwitchWwn", "dmPrincipalSwitchWwn", "vsanOperState", "vsanAdminState", "vsanInterOperValue", "vsanMtu", "vsanLoadBalancingType", "vsanInorderDelivery", "vsanNetworkDropLatency", "fspfTotalCheckSum"};
        _VsanOids = new int[vsan.length][];
        for (i = 0; i < _VsanOids.length; ++i) {
            SnmpAdapter._VsanOids[i] = MibNode.get(vsan[i]).getOid();
        }
        String[] ns = new String[]{"fcNameServerPortName", "fcNameServerNodeName", "fcNameServerFabricPortName", "fcNameServerPortType", "fcNameServerFC4Type", "fcNameServerFC4Features"};
        _FcnsOids = new int[ns.length][];
        for (i = 0; i < _FcnsOids.length; ++i) {
            SnmpAdapter._FcnsOids[i] = MibNode.get(ns[i]).getOid();
        }
        String[] ent = new String[]{"entPhysicalClass", "entPhysicalParentRelPos", "entPhysicalVendorType", "entPhysicalName", "entPhysicalHardwareRev", "entPhysicalFirmwareRev", "entPhysicalSoftwareRev", "entPhysicalSerialNum", "entPhysicalMfgName", "entPhysicalModelName", "entPhysicalAssetID"};
        _EntityOids = new int[ent.length][];
        for (i = 0; i < _EntityOids.length; ++i) {
            SnmpAdapter._EntityOids[i] = MibNode.get(ent[i]).getOid();
        }
        String[] lic = new String[]{"clmLicenseFlag", "clmNoOfLicenseCurrentUsages", "clmNoOfLicenseMaxUsages", "clmNoOfMissingUsageLicenses", "clmLicenseExpiryDate", "clmLicenseGracePeriod", "clmLicenseGracePeriodLeft"};
        _LicenseOids = new int[lic.length][];
        for (i = 0; i < _LicenseOids.length; ++i) {
            SnmpAdapter._LicenseOids[i] = MibNode.get(lic[i]).getOid();
        }
        String[] licreq = new String[]{"clmLicenseConfigSpinLock", "clmLicenseRequestFeatureName", "clmLicenseRequestCommand"};
        _LicReqOids = new int[licreq.length][];
        for (i = 0; i < _LicReqOids.length; ++i) {
            SnmpAdapter._LicReqOids[i] = MibNode.get(licreq[i]).getOid();
        }
        String[] ivr = new String[]{"civrZoneEnforcedZoneSetActvtTime", "civrZoneEnforcedZoneSetName", "civrActiveZonesetChecksum", "civrZoneEnforcedZoneNumber"};
        _IvrVars = new SnmpOID[ivr.length];
        for (i = 0; i < _IvrVars.length; ++i) {
            SnmpAdapter._IvrVars[i] = new SnmpOID(MibNode.get(ivr[i]).getOid(), 0);
        }
        String[] ivrZone = new String[]{"civrZoneEnforcedZoneName", "civrZoneEnforcedZoneReadOnly", "civrZoneEnforcedZoneQosPriority"};
        _IvrEnfZoneVars = new SnmpOID[ivrZone.length];
        for (i = 0; i < _IvrEnfZoneVars.length; ++i) {
            SnmpAdapter._IvrEnfZoneVars[i] = new SnmpOID(MibNode.get(ivrZone[i]).getOid());
        }
        String[] ivrZoneMbr = new String[]{"civrZoneEnforcedZoneMemberType", "civrZoneEnforcedZoneMemberID", "civrZoneEnforcedZoneMemberVsan", "civrZoneEnforcedZoneMemberAFId", "civrZoneEnforcedZoneMemberLunID"};
        _IvrEnfZoneMbrVars = new SnmpOID[ivrZoneMbr.length];
        for (i = 0; i < _IvrEnfZoneMbrVars.length; ++i) {
            SnmpAdapter._IvrEnfZoneMbrVars[i] = new SnmpOID(MibNode.get(ivrZoneMbr[i]).getOid());
        }
        String[] enfZoneset = new String[]{"zoneEnforcedZoneSetName", "zoneEnforcedZoneSetActivateTime"};
        _EnfZonesetOids = new int[enfZoneset.length][];
        for (i = 0; i < _EnfZonesetOids.length; ++i) {
            SnmpAdapter._EnfZonesetOids[i] = MibNode.get(enfZoneset[i]).getOid();
        }
        String[] enfZone = new String[]{"zoneEnforcedZoneName", "zoneEnforcedZoneReadOnly", "zoneEnforcedZoneQos", "zoneEnforcedZoneQosPriority", "zoneEnforcedZoneBroadcast"};
        _EnfZoneOids = new int[enfZone.length][];
        for (i = 0; i < _EnfZoneOids.length; ++i) {
            SnmpAdapter._EnfZoneOids[i] = MibNode.get(enfZone[i]).getOid();
        }
        String[] enfZoneMbr = new String[]{"zoneEnforcedZoneMemberFormat", "zoneEnforcedZoneMemberID", "zoneEnforcedZoneMemberLunID"};
        _EnfZoneMbrOids = new int[enfZoneMbr.length][];
        for (i = 0; i < _EnfZoneMbrOids.length; ++i) {
            SnmpAdapter._EnfZoneMbrOids[i] = MibNode.get(enfZoneMbr[i]).getOid();
        }
        String[] target = new String[]{"ciscoScsiDscTgtName", "ciscoExtScsiIntrDiscTgtDevType", "ciscoExtScsiIntrDiscTgtVendorId", "ciscoExtScsiIntrDiscTgtProductId", "ciscoExtScsiIntrDiscTgtRevLevel", "ciscoExtScsiIntrDiscTgtOtherInfo"};
        _TargetOids = new int[target.length][];
        for (i = 0; i < target.length; ++i) {
            SnmpAdapter._TargetOids[i] = MibNode.get(target[i]).getOid();
        }
        String[] lunDiscCache = new String[]{"ciscoExtScsiLunCacheScsiIndex", "ciscoExtScsiLunCacheDevIndex", "ciscoExtScsiLunCachePortIndex", "ciscoExtScsiLunCacheTgtIndex"};
        _LunCacheVars = new SnmpOID[lunDiscCache.length];
        for (i = 0; i < _LunCacheVars.length; ++i) {
            SnmpAdapter._LunCacheVars[i] = new SnmpOID(MibNode.get(lunDiscCache[i]).getOid(), 0);
        }
        String[] ficonPort = new String[]{"cficonPortMap1", "cficonPortMap2", "cficonPortMap3", "cficonPortMap4", "cficonPortMap5", "cficonPortMap6"};
        _FiconPortVars = new SnmpOID[ficonPort.length];
        for (i = 0; i < _FiconPortVars.length; ++i) {
            SnmpAdapter._FiconPortVars[i] = new SnmpOID(MibNode.get(ficonPort[i]).getOid(), 0);
        }
        String[] rnidInfo = new String[]{"fcIfRNIDInfoStatus", "fcIfRNIDInfoTypeNumber", "fcIfRNIDInfoModelNumber", "fcIfRNIDInfoManufacturer", "fcIfRNIDInfoPlantOfMfg", "fcIfRNIDInfoSerialNumber", "fcIfRNIDInfoUnitType", "fcIfRNIDInfoPortId"};
        _FcIfRNIDOids = new int[rnidInfo.length][];
        for (i = 0; i < rnidInfo.length; ++i) {
            SnmpAdapter._FcIfRNIDOids[i] = MibNode.get(rnidInfo[i]).getOid();
        }
        String[] VfcBinding_MibCmds = new String[]{"cfcoeStaticVfcBindType", "cfcoeStaticVfcBindIfIndex", "cfcoeStaticVfcBindMACAddress"};
        _VfcBinding_Oids = new int[VfcBinding_MibCmds.length][];
        for (i = 0; i < VfcBinding_MibCmds.length; ++i) {
            SnmpAdapter._VfcBinding_Oids[i] = MibNode.get(VfcBinding_MibCmds[i]).getOid();
        }
        String[] Flogi_MibCmds = new String[]{"fcIfNxPortNodeName", "fcIfNxPortName", "fcIfNxPortAddress"};
        _Flogi_Oids = new int[Flogi_MibCmds.length][];
        for (i = 0; i < VfcBinding_MibCmds.length; ++i) {
            SnmpAdapter._Flogi_Oids[i] = MibNode.get(Flogi_MibCmds[i]).getOid();
        }
        String[] CiscoVdc_MibCmds = new String[]{"ciscoVdcName", "ciscoVdcState", "ciscoVdcFcoeCapable", "ciscoVdcMac", "ciscoVdcSwitchId"};
        _CiscoVdcOids = new int[CiscoVdc_MibCmds.length][];
        for (i = 0; i < CiscoVdc_MibCmds.length; ++i) {
            SnmpAdapter._CiscoVdcOids[i] = MibNode.get(CiscoVdc_MibCmds[i]).getOid();
        }
    }
}

