/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class VeInitWorker
implements SnmpCallbackIf {
    private AtomicInteger _numOutstanding;
    private Map<Short, VsanImpl> _vsanById;

    VeInitWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean discover(Map<Short, VsanImpl> vsanById) throws DiscoveryException {
        SwitchImpl sw;
        this._vsanById = vsanById;
        HashSet<EndPortImpl> inits = new HashSet<EndPortImpl>();
        for (VsanImpl vsan : vsanById.values()) {
            inits.addAll(vsan.getInitiators());
            vsan.resetDiscFlag(64);
        }
        if (inits.size() == 0) {
            return false;
        }
        this._numOutstanding = new AtomicInteger(0);
        ArrayList<EnclosureImpl> virtualInitEnclosures = new ArrayList<EnclosureImpl>();
        for (EndPortImpl ep : inits) {
            EnclosureImpl enc = ep.getEnclosure();
            if (!ep.isVirtualized() || enc == null || !enc.isVirtual() || virtualInitEnclosures.contains(enc)) continue;
            virtualInitEnclosures.add(enc);
        }
        if (virtualInitEnclosures.size() == 0) {
            return false;
        }
        IdentityHashMap<SwitchImpl, VarBindList> symPortNameBySwitch = new IdentityHashMap<SwitchImpl, VarBindList>();
        int[] nsIndex = new int[4];
        for (EnclosureImpl enc : virtualInitEnclosures) {
            EndPortImpl ep = enc.getEndPorts().get(0);
            if (ep == null || (sw = ep.getSwitch()) == null || !sw.isManageable() || !sw.isMDS() || sw.isNpvEnabled()) continue;
            nsIndex[0] = ep.getVsan();
            int fcId = ep.getFcId(ep.getVsan());
            nsIndex[1] = fcId >> 16;
            nsIndex[2] = fcId >> 8 & 0xFFFF00FF;
            nsIndex[3] = fcId & 0xFF0000FF;
            VarBindList vbl = (VarBindList)symPortNameBySwitch.get(ep.getSwitch());
            if (vbl == null) {
                vbl = new VarBindList();
                symPortNameBySwitch.put(ep.getSwitch(), vbl);
            }
            vbl.add(SnmpAdapter._FcnsSymPortNameOid, nsIndex);
        }
        if (symPortNameBySwitch.size() == 0) {
            return false;
        }
        this._numOutstanding.set(0);
        Object i$ = this._numOutstanding;
        synchronized (i$) {
            for (Map.Entry ent : symPortNameBySwitch.entrySet()) {
                sw = (SwitchImpl)ent.getKey();
                VarBindList vbl = (VarBindList)ent.getValue();
                try {
                    new SnmpFetch().get(sw.createPeer(), vbl, this);
                    this._numOutstanding.incrementAndGet();
                }
                catch (SnmpException se) {
                    SnmpAdapter._Log.warn((Object)se.getMessage());
                }
            }
        }
        try {
            i$ = this._numOutstanding;
            synchronized (i$) {
                this._numOutstanding.wait(DiscoveryManager.MAX_WAIT);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (timedOut) {
            SnmpAdapter._Log.warn((Object)("VeInitWorker " + pdu.getHostAddress() + " timed out"));
        } else {
            SwitchImpl sw = SanManager.getInstance().findSwitchByIP(pdu.getAddress());
            if (sw == null) {
                SnmpAdapter._Log.warn((Object)("VeInitWorker " + pdu.getHostAddress() + " unknown ipAddr"));
            } else {
                VarBindList vbl = pdu.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    String encName;
                    int sp;
                    EnclosureImpl enc;
                    SnmpVarBind vb = vbl.getVb(i);
                    int[] oid = vb.getOid().getValue();
                    short vid = (short)oid[oid.length - 4];
                    VsanImpl vsan = this._vsanById.get(vid);
                    if (vsan == null) continue;
                    EndPortImpl ep = null;
                    int fcId = (oid[oid.length - 3] << 16) + (oid[oid.length - 2] << 8) + oid[oid.length - 1];
                    ep = vsan.findEndPort(fcId);
                    if (ep == null || (enc = ep.getEnclosure()) == null || (sp = (encName = vb.getVar().toString()).indexOf(32)) == -1) continue;
                    int sp1 = encName.substring(sp + 1).indexOf(32);
                    String s = encName.substring(sp + 1, sp + sp1 + 1);
                    long ipAddr = 0L;
                    try {
                        ipAddr = Long.parseLong(s, 16);
                    }
                    catch (NumberFormatException nfEx) {
                        // empty catch block
                    }
                    if (ipAddr > 0L) {
                        String ip = (ipAddr >> 24) + "." + (ipAddr >> 16 & 0xFFFFFFFFFFFF00FFL) + "." + (ipAddr >> 8 & 0xFFFFFFFFFF0000FFL) + "." + (ipAddr & 0xFFL);
                        SanManager.getInstance().changeEnclosureName(enc, encName.substring(0, sp + 1) + ip);
                        continue;
                    }
                    SanManager.getInstance().changeEnclosureName(enc, encName);
                }
            }
        }
        if (this._numOutstanding.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this._numOutstanding;
            synchronized (atomicInteger) {
                this._numOutstanding.notify();
            }
        }
    }
}

