/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmAttrHdr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobAdditionalPeerAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobEstTimeCompAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobEventLogAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobIdAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobNameAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobNumSessionsAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobRateAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSchedAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionLunAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionProgressAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionStorageAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSsmAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobStatusAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobStorageServerAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobTypeAttr;
import com.cisco.dcbu.sm.server.se.SESshMediatorPdu;
import com.cisco.dcbu.sm.server.se.pdu.SeTLV;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SshMediatorHelper {
    public static Logger _Logger = LogManager.getLogger((String)"dmm");

    public static void writeInt(ByteBuffer stream, int value, int length) throws IOException {
        if (length == 3) {
            stream.put((byte)0);
            stream.put((byte)0);
            stream.put((byte)0);
        } else if (length == 1) {
            stream.put((byte)value);
        } else {
            stream.putInt(value);
        }
    }

    public static void writeShort(ByteBuffer stream, short value, int length) throws IOException {
        stream.putShort(value);
    }

    public static void writeLong(ByteBuffer stream, long value, int length) throws IOException {
        if (length == 8) {
            stream.putLong(value);
        } else {
            byte[] b;
            for (byte nextB : b = SshMediatorHelper.longToUnsignedByteArray(value, length)) {
                stream.put(nextB);
            }
        }
    }

    public static void writeByte(ByteBuffer stream, byte value, int length) throws IOException {
        stream.put(value);
    }

    public static void writeByteArray(ByteBuffer stream, byte[] value) throws IOException {
        stream.put(value);
    }

    public static void writeWwn(ByteBuffer stream, Wwn value, int length) throws IOException {
        stream.put(value.getValue());
        if (value.getValue().length != 8) {
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    public static void writeString(ByteBuffer stream, String in, int length) throws IOException {
        byte[] values;
        String value = in;
        if (in == null) {
            value = "";
        }
        if ((values = value.getBytes()).length < length) {
            char[] toWrite = new char[length];
            for (int i = 0; i < toWrite.length; ++i) {
                toWrite[i] = i < value.length() ? value.charAt(i) : (char)32;
            }
            String toWriteStr = new String(toWrite);
            values = toWriteStr.getBytes();
        }
        stream.put(values, 0, length);
    }

    public static int readInt(ByteBuffer stream, int length) throws IOException {
        if (length == 1) {
            int ret = stream.get();
            if (ret < 0) {
                ret += 256;
            }
            return ret;
        }
        if (length == 3) {
            stream.get();
            return stream.getShort();
        }
        return stream.getInt();
    }

    public static byte readByte(ByteBuffer stream, int length) throws IOException {
        byte ret = stream.get();
        return ret;
    }

    public static short readShort(ByteBuffer stream, int length) throws IOException {
        return stream.getShort();
    }

    public static long readLong(ByteBuffer stream, int length) throws IOException {
        if (length == 8) {
            return stream.getLong();
        }
        byte[] blong = new byte[length];
        for (int i = 0; i < length; ++i) {
            blong[i] = stream.get();
        }
        return SshMediatorHelper.unsignedByteArrayToLong(blong);
    }

    public static final long unsignedByteArrayToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < b.length; ++i) {
            byte nextb = b[i];
            result |= (long)(nextb & 0xFF);
            if (i >= b.length - 1) continue;
            result <<= 8;
        }
        return result;
    }

    public static final byte[] longToUnsignedByteArray(long value, int length) {
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[length - 1 - i] = (byte)(value >>> i * 8);
        }
        return b;
    }

    public static Wwn readWwn(ByteBuffer stream, int length) throws IOException {
        byte[] values = new byte[length];
        stream.get(values);
        return new Wwn(values);
    }

    public static String readString(ByteBuffer stream, int length) throws IOException {
        byte[] values = new byte[length];
        stream.get(values);
        return new String(values);
    }

    public static byte[] readMultipleBytes(ByteBuffer stream, int length) {
        byte[] values = new byte[length];
        stream.get(values);
        return values;
    }

    public static List readCustom(ByteBuffer stream, DmmJobInfo jobInfo) throws IOException {
        ArrayList list = new ArrayList();
        int joblength = jobInfo.getLen();
        joblength -= 4;
        HashMap<Integer, SshMediatorPdu> map = new HashMap<Integer, SshMediatorPdu>();
        list.add(map);
        boolean done = false;
        int streamStartPosition = stream.position();
        block16: while (!done) {
            int currentStreamPosition = stream.position();
            int lengthAlreadyParsed = currentStreamPosition - streamStartPosition;
            if (lengthAlreadyParsed >= joblength) {
                done = true;
                continue;
            }
            DmmAttrHdr attrHdr = new DmmAttrHdr();
            attrHdr.fromByteArray(stream);
            stream.position(stream.position() - 3);
            switch (attrHdr.getAttrId()) {
                case 1: {
                    DmmJobIdAttr attr = new DmmJobIdAttr();
                    attr.fromByteArray(stream);
                    map.put(new Integer(1), attr);
                    continue block16;
                }
                case 2: {
                    DmmJobNameAttr nameattr = new DmmJobNameAttr();
                    nameattr.fromByteArray(stream);
                    map.put(new Integer(2), nameattr);
                    continue block16;
                }
                case 3: {
                    DmmJobTypeAttr typeAttr = new DmmJobTypeAttr();
                    typeAttr.fromByteArray(stream);
                    map.put(new Integer(3), typeAttr);
                    continue block16;
                }
                case 4: {
                    DmmJobStorageServerAttr sAttr = new DmmJobStorageServerAttr();
                    sAttr.fromByteArray(stream);
                    map.put(new Integer(4), sAttr);
                    continue block16;
                }
                case 5: {
                    DmmJobStorageServerAttr esAttr = new DmmJobStorageServerAttr();
                    esAttr.fromByteArray(stream);
                    map.put(new Integer(5), esAttr);
                    continue block16;
                }
                case 6: {
                    DmmJobStorageServerAttr nsAttr = new DmmJobStorageServerAttr();
                    nsAttr.fromByteArray(stream);
                    map.put(new Integer(6), nsAttr);
                    continue block16;
                }
                case 7: {
                    DmmJobSsmAttr ssmAttr = new DmmJobSsmAttr();
                    ssmAttr.fromByteArray(stream);
                    map.put(new Integer(7), ssmAttr);
                    continue block16;
                }
                case 8: {
                    DmmJobRateAttr rateAttr = new DmmJobRateAttr();
                    rateAttr.fromByteArray(stream);
                    map.put(new Integer(8), rateAttr);
                    continue block16;
                }
                case 9: {
                    DmmJobStatusAttr statusAttr = new DmmJobStatusAttr();
                    statusAttr.fromByteArray(stream);
                    map.put(new Integer(9), statusAttr);
                    continue block16;
                }
                case 10: {
                    DmmJobNumSessionsAttr sessionsAttr = new DmmJobNumSessionsAttr();
                    sessionsAttr.fromByteArray(stream);
                    map.put(new Integer(10), sessionsAttr);
                    continue block16;
                }
                case 11: {
                    DmmJobEventLogAttr logAttr = new DmmJobEventLogAttr();
                    StringBuffer value = new StringBuffer("");
                    SshMediatorHelper.readString(stream, 3);
                    for (int i = 4; i < attrHdr.getAttrLen(); i += 128) {
                        value.append(SshMediatorHelper.readString(stream, 128).trim());
                        value.append("\n");
                    }
                    logAttr.setEventLog(value.toString());
                    map.put(new Integer(11), logAttr);
                    done = true;
                    continue block16;
                }
                case 12: {
                    DmmJobSchedAttr schedAttr = new DmmJobSchedAttr();
                    schedAttr.fromByteArray(stream);
                    map.put(new Integer(12), schedAttr);
                    continue block16;
                }
                case 13: {
                    DmmJobAdditionalPeerAttr addPeerAttr = new DmmJobAdditionalPeerAttr();
                    addPeerAttr.fromByteArray(stream);
                    map.put(new Integer(13), addPeerAttr);
                    continue block16;
                }
                case 14: {
                    DmmJobEstTimeCompAttr estTimeAttr = new DmmJobEstTimeCompAttr();
                    estTimeAttr.fromByteArray(stream);
                    map.put(new Integer(14), estTimeAttr);
                    continue block16;
                }
            }
            byte[] bytesSkipped = SshMediatorHelper.readMultipleBytes(stream, attrHdr.getAttrLen());
            Exception temp = new Exception("unknow attr id:" + attrHdr.getAttrId() + ", attr length: " + attrHdr.getAttrLen() + ", bytes skipped: " + bytesSkipped);
            _Logger.debug((Object)temp);
        }
        return list;
    }

    public static List readCustom(ByteBuffer stream, DmmJobSessionInfo jobSessionInfo) throws IOException {
        ArrayList list = new ArrayList();
        int length = jobSessionInfo.getSessionInfoLen();
        length -= 4;
        HashMap<Integer, SshMediatorPdu> map = new HashMap<Integer, SshMediatorPdu>();
        list.add(map);
        boolean done = false;
        block7: while (!done) {
            DmmAttrHdr attrHdr = new DmmAttrHdr();
            attrHdr.fromByteArray(stream);
            stream.position(stream.position() - 3);
            switch (attrHdr.getAttrId()) {
                case 1: {
                    SshMediatorPdu attr = new DmmJobSessionStorageAttr();
                    ((DmmJobSessionStorageAttr)attr).fromByteArray(stream);
                    map.put(new Integer(1), attr);
                    continue block7;
                }
                case 2: {
                    SshMediatorPdu attr = new DmmJobSessionStorageAttr();
                    ((DmmJobSessionStorageAttr)attr).fromByteArray(stream);
                    map.put(new Integer(2), attr);
                    continue block7;
                }
                case 3: {
                    SshMediatorPdu attr = new DmmJobSessionStorageAttr();
                    ((DmmJobSessionStorageAttr)attr).fromByteArray(stream);
                    map.put(new Integer(3), attr);
                    continue block7;
                }
                case 4: {
                    SshMediatorPdu attr = new DmmJobSessionLunAttr();
                    ((DmmJobSessionLunAttr)attr).fromByteArray(stream);
                    map.put(new Integer(4), attr);
                    continue block7;
                }
                case 5: {
                    SshMediatorPdu attr = new DmmJobSessionProgressAttr();
                    ((DmmJobSessionProgressAttr)attr).fromByteArray(stream);
                    map.put(new Integer(5), attr);
                    done = true;
                    continue block7;
                }
            }
            Thread.currentThread();
            Thread.dumpStack();
            done = true;
        }
        return list;
    }

    public static void writeSeTLV(ByteBuffer stream, SeTLV o) throws IOException {
        System.out.println("writeSeTLV" + o);
        int type = o.getType();
        int length = o.getLength();
        List values = o.getValue();
        stream.put(o.toByteArray());
        for (Object val : values) {
            stream.put(((SESshMediatorPdu)val).toByteArray());
        }
    }
}

