/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmFcPortInfo;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DmmItlInfo
implements SshMediatorPdu {
    private DmmFcPortInfo m_initiator;
    private DmmFcPortInfo m_target;
    private long m_lun;

    public void setInitiator(DmmFcPortInfo initiator) {
        this.m_initiator = initiator;
    }

    public DmmFcPortInfo getInitiator() {
        return this.m_initiator;
    }

    public void setTarget(DmmFcPortInfo target) {
        this.m_target = target;
    }

    public DmmFcPortInfo getTarget() {
        return this.m_target;
    }

    public void setLun(long lun) {
        this.m_lun = lun;
    }

    public long getLun() {
        return this.m_lun;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_initiator.toByteArray());
        SshMediatorHelper.writeByteArray(stream, this.m_target.toByteArray());
        SshMediatorHelper.writeLong(stream, this.m_lun, 8);
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_initiator = new DmmFcPortInfo();
        this.m_initiator.fromByteArray(stream);
        this.m_target = new DmmFcPortInfo();
        this.m_target.fromByteArray(stream);
        this.m_lun = SshMediatorHelper.readLong(stream, 8);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmItlInfo:");
        buf.append("m_init:" + this.m_initiator + ":");
        buf.append("m_target:" + this.m_target + ":");
        buf.append("m_lun:" + this.m_lun + ":");
        buf.append(")");
        return buf.toString();
    }
}

