/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorRespPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobLunmapInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmPduHdr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DmmJobLunmapResp
implements SshMediatorRespPdu {
    private DmmPduHdr m_pdu_hdr;
    private short m_status;
    private short m_reason;
    private String m_reason_str;
    private int m_rsvd;
    private int m_num_luns;
    private List m_luns;

    public void setPduHdr(DmmPduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    public DmmPduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setStatus(short status) {
        this.m_status = status;
    }

    @Override
    public short getStatus() {
        return this.m_status;
    }

    public void setReason(short reason) {
        this.m_reason = reason;
    }

    @Override
    public short getReason() {
        return this.m_reason;
    }

    public void setReasonStr(String reason_str) {
        this.m_reason_str = reason_str;
    }

    @Override
    public String getReasonStr() {
        return this.m_reason_str;
    }

    public void setRsvd(int rsvd) {
        this.m_rsvd = rsvd;
    }

    public int getRsvd() {
        return this.m_rsvd;
    }

    public void setNumLuns(int num_luns) {
        this.m_num_luns = num_luns;
    }

    public int getNumLuns() {
        return this.m_num_luns;
    }

    public void setLuns(List luns) {
        this.m_luns = luns;
    }

    public List getLuns() {
        return this.m_luns;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeShort(stream, this.m_status, 2);
        SshMediatorHelper.writeShort(stream, this.m_reason, 2);
        SshMediatorHelper.writeString(stream, this.m_reason_str, 128);
        SshMediatorHelper.writeInt(stream, this.m_rsvd, 3);
        SshMediatorHelper.writeInt(stream, this.m_luns.size(), 4);
        for (int i = 0; i < this.m_luns.size(); ++i) {
            DmmJobLunmapInfo obj = (DmmJobLunmapInfo)this.m_luns.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new DmmPduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_status = SshMediatorHelper.readShort(stream, 2);
        this.m_reason = SshMediatorHelper.readShort(stream, 2);
        this.m_reason_str = SshMediatorHelper.readString(stream, 128);
        this.m_rsvd = SshMediatorHelper.readInt(stream, 3);
        this.m_num_luns = SshMediatorHelper.readInt(stream, 4);
        this.m_luns = new ArrayList();
        for (int i = 0; i < this.m_num_luns; ++i) {
            DmmJobLunmapInfo obj = new DmmJobLunmapInfo();
            obj.fromByteArray(stream);
            this.m_luns.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmJobLunmapResp:");
        buf.append("m_status:" + this.m_status + ":");
        buf.append("m_reason:" + this.m_reason + ":");
        buf.append("m_reason_str:" + this.m_reason_str + ":");
        buf.append("m_rsvd:" + this.m_rsvd + ":");
        buf.append("m_num_luns:" + this.m_num_luns + ":");
        buf.append("m_luns:");
        for (int i = 0; i < this.m_luns.size(); ++i) {
            buf.append(":" + this.m_luns.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

