/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DmmPduHdr
implements SshMediatorPdu {
    private byte m_version;
    private byte m_opcode;
    private short m_length;
    private int m_req_identified;
    private byte m_more;
    private short m_offset;
    private short m_num_units;
    private int m_rsvd;

    public void setVersion(byte version) {
        this.m_version = version;
    }

    public byte getVersion() {
        return this.m_version;
    }

    public void setOpcode(byte opcode) {
        this.m_opcode = opcode;
    }

    public byte getOpcode() {
        return this.m_opcode;
    }

    public void setLength(short length) {
        this.m_length = (short)(2 + length);
    }

    public short getLength() {
        return this.m_length;
    }

    public void setReqIdentified(int req_identified) {
        this.m_req_identified = req_identified;
    }

    public int getReqIdentified() {
        return this.m_req_identified;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByte(stream, this.m_version, 1);
        SshMediatorHelper.writeByte(stream, this.m_opcode, 1);
        SshMediatorHelper.writeShort(stream, this.m_length, 2);
        SshMediatorHelper.writeInt(stream, this.m_req_identified, 4);
        SshMediatorHelper.writeByte(stream, this.m_more, 1);
        SshMediatorHelper.writeShort(stream, this.m_offset, 2);
        SshMediatorHelper.writeShort(stream, this.m_num_units, 2);
        SshMediatorHelper.writeInt(stream, this.m_rsvd, 3);
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_version = SshMediatorHelper.readByte(stream, 1);
        this.m_opcode = SshMediatorHelper.readByte(stream, 1);
        this.m_length = SshMediatorHelper.readShort(stream, 2);
        this.m_req_identified = SshMediatorHelper.readInt(stream, 4);
        this.m_more = SshMediatorHelper.readByte(stream, 1);
        this.m_offset = SshMediatorHelper.readShort(stream, 2);
        this.m_num_units = SshMediatorHelper.readShort(stream, 2);
        this.m_rsvd = SshMediatorHelper.readInt(stream, 3);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmPduHdr:");
        buf.append("m_version:" + this.m_version + ":");
        buf.append("m_opcode:" + this.m_opcode + ":");
        buf.append("m_more:" + this.m_more + ":");
        buf.append("m_offset:" + this.m_offset + ":");
        buf.append("m_req_identified:" + this.m_req_identified + ":");
        buf.append(")");
        return buf.toString();
    }

    public byte getMore() {
        return this.m_more;
    }

    public void setMore(byte more) {
        this.m_more = more;
    }

    public short getNumUnits() {
        return this.m_num_units;
    }

    public void setNumUnits(short num_units) {
        this.m_num_units = num_units;
    }

    public short getOffset() {
        return this.m_offset;
    }

    public void setOffset(short offset) {
        this.m_offset = offset;
    }

    public int getRsvd() {
        return this.m_rsvd;
    }

    public void setRsvd(int rsvd) {
        this.m_rsvd = rsvd;
    }
}

