/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.server.event.EventFormatType;

public class EventBuilder {
    static final String _TEMPLATE1 = "%s: %s, Port: %s, VSAN: %s, ";
    static final String _TEMPLATE2 = "%s: %s, VSAN: %s, ";
    static final String _SUFFIX = "State: %s, Reason: %s";
    public static final String DOWN = "Down";
    public static final String UP = "Up";

    public static String formatString(EventFormatType type, String desc, String port, String vsans, String state, String reason, LogEventType eveType) throws Exception {
        String result = null;
        if (type == null) {
            throw new Exception("EventFormatType must be identified");
        }
        if (type != EventFormatType.OTHER && (desc == null || desc.length() == 0)) {
            throw new Exception("Description must be given if type is not \"Other\"");
        }
        desc = desc == null ? "" : desc.trim();
        port = port == null ? "" : port.trim();
        vsans = vsans == null ? "" : vsans.trim();
        String string = state = state == null ? "" : state.trim();
        if (eveType == LogEventType.PORT_DOWN && state.length() == 0) {
            state = DOWN;
        }
        if ((eveType == LogEventType.PORT_UP || eveType == LogEventType.PORT_ALARM) && state.length() == 0) {
            state = UP;
        }
        String string2 = reason = reason == null ? "" : reason.trim();
        if (reason.length() == 0) {
            reason = "none";
        }
        result = port.length() != 0 ? String.format("%s: %s, Port: %s, VSAN: %s, State: %s, Reason: %s", type.getValue(), desc, port, vsans, state, reason) : String.format("%s: %s, VSAN: %s, State: %s, Reason: %s", type.getValue(), desc, vsans, state, reason);
        return result;
    }

    public static String formatString(EventFormatType type, String desc, String port, String vsans, LogEventType eveType) throws Exception {
        String result = null;
        if (type == null) {
            throw new Exception("EventFormatType must be identified");
        }
        if (type != EventFormatType.OTHER && (desc == null || desc.length() == 0)) {
            throw new Exception("Description must be given if type is not \"Other\"");
        }
        desc = desc == null ? "" : desc.trim();
        port = port == null ? "" : port.trim();
        vsans = vsans == null ? "" : vsans.trim();
        result = port.length() != 0 ? String.format(_TEMPLATE1, type.getValue(), desc, port, vsans) : String.format(_TEMPLATE2, type.getValue(), desc, vsans);
        return result;
    }

    public static void main(String[] strArgs) {
        try {
            String test = EventBuilder.formatString(EventFormatType.ISL, "sw172-22-46-220,fc1/13(0x100c000) <-> sw172-22-46-174,fc10/13(0x148c000)", "", "444", "", "Rx Bytes on fc1/13=0.00000% <= 1.74763%, Speed: 4.000Gbps (if 60s interval)", LogEventType.PORT_DOWN);
            System.out.println(test);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

