/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.common.event.smis.EndPortChange;
import com.cisco.dcbu.sm.common.event.smis.FRUChange;
import com.cisco.dcbu.sm.common.event.smis.FanChange;
import com.cisco.dcbu.sm.common.event.smis.LinkStateChange;
import com.cisco.dcbu.sm.common.event.smis.NameServerDBChange;
import com.cisco.dcbu.sm.common.event.smis.PowerChange;
import com.cisco.dcbu.sm.common.event.smis.SwitchChange;
import com.cisco.dcbu.sm.common.event.smis.TempChange;
import com.cisco.dcbu.sm.common.event.smis.UserChange;
import com.cisco.dcbu.sm.common.event.smis.VsanChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneEnhDBChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneSetChange;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.smis.SMISServerImpl;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SMISNotifications
implements ExceptionListener {
    private static final String TOPIC_FM = "jms/topic/smisTopic";
    private static volatile SMISNotifications _Instance;
    static final String QueryZNameByMemberID = "select z.name, zm.type from zone z, zone_member zm where z.id = zm.zone_id and zm.type = ? and zm.member_id = ? ";
    static final int[][] _AffectSMISTrapOids;
    static final byte FAN_STATUS = 0;
    static final byte LINK_DOWN = 1;
    static final byte LINK_UP = 2;
    static final byte FRU_INSERTED = 3;
    static final byte FRU_REMOVED = 4;
    static final byte FRU_CHANGED = 5;
    static final byte NS_ENTRY_ADD = 6;
    static final byte NS_ENTRY_DEL = 7;
    static final byte POWER_STATUS = 8;
    static final byte ENT_SENSOR_THR = 9;
    static final byte VSAN_CHANGE = 10;
    static final byte ZONE_ACTIVATE_NOTIFY = 11;
    static final byte IVRZONE_ACT = 12;
    static final byte IVRZONE_DEACT = 13;
    static final byte VSAN_PORT_CHANGE = 14;
    static final byte ZONE_ENHANCEDDB_CHANGE = 15;
    static Logger _Logger;
    private static AtomicBoolean _SmisEnable;
    private static String _Currentip;
    private TopicConnection _conn = null;
    private TopicSession _session = null;
    private Topic _topic = null;
    private TopicPublisher _sender = null;
    private AtomicBoolean _isShuttingDown = new AtomicBoolean();

    SMISNotifications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SMISNotifications getInstance() {
        if (_Instance != null) return _Instance;
        Class<SMISNotifications> clazz = SMISNotifications.class;
        synchronized (SMISNotifications.class) {
            if (_Instance != null) return _Instance;
            _Instance = new SMISNotifications();
            try {
                _Instance.setupPubSub();
            }
            catch (JMSException jex) {
                _Logger.log((Priority)Level.ERROR, (Object)"JMSEventForwarder setupPubSub", (Throwable)jex);
            }
            catch (NamingException ex) {
                _Logger.log((Priority)Level.ERROR, (Object)"JMSEventForwarder.setupPubSub ", (Throwable)ex);
            }
            return _Instance;
        }
    }

    public static boolean isSmisEnable() {
        return _SmisEnable.get();
    }

    public static boolean initSmisStatus() {
        boolean status = false;
        if (_Currentip == null) {
            try {
                _Currentip = FMServerImpl.getInstance().getCurrentServerIP();
            }
            catch (Exception e) {
                _Logger.warn((Object)("Cant not get current ip for checkling SMIS status: " + e.getMessage()));
            }
        }
        if (_Currentip != null) {
            status = SMISServerImpl.isSmisRunning((String)_Currentip);
            _SmisEnable.set(status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException ex) {
        if (this._isShuttingDown.get()) {
            return;
        }
        _Logger.error((Object)"onException(): SMISNotifications receive JMS Exception", (Throwable)ex);
        if (ex instanceof IllegalStateException || ex.getCause() instanceof SocketException || ex.getCause() instanceof IOException || ex.getCause() instanceof EOFException) {
            SMISNotifications sMISNotifications = this;
            synchronized (sMISNotifications) {
                this.disconnect();
                try {
                    this.setupPubSub();
                }
                catch (Exception jex) {
                    _Logger.error((Object)"EventForward Re-establish connection", (Throwable)jex);
                }
            }
        }
    }

    public void stop() {
        _SmisEnable.set(false);
        this._isShuttingDown.set(true);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        try {
            if (this._session != null) {
                this._session.close();
            }
            if (this._conn != null) {
                this._conn.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this._topic = null;
            this._session = null;
            this._conn = null;
        }
    }

    public synchronized void setupPubSub() throws JMSException, NamingException {
        Integer port = Integer.getInteger("server.port", new Integer(4447));
        String server = System.getProperty("server.bindaddrs", "localhost");
        if (server == null || server.equals("")) {
            server = "localhost";
        }
        String serverUrl = "remote://" + server + ":" + port;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
            properties.put("java.naming.provider.url", serverUrl);
            InitialContext iniCtx = new InitialContext(properties);
            Object tmp = iniCtx.lookup("jms/RemoteConnectionFactory");
            TopicConnectionFactory tcf = (TopicConnectionFactory)tmp;
            this._conn = tcf.createTopicConnection();
            this._topic = (Topic)iniCtx.lookup(TOPIC_FM);
            this._session = this._conn.createTopicSession(false, 1);
            this._conn.start();
            this._sender = this._session.createPublisher(this._topic);
            this._conn.setExceptionListener((ExceptionListener)this);
        }
        catch (NamingException ex) {
            _Logger.error((Object)("can not get initial context from: " + serverUrl + ":" + ex.getMessage()));
        }
    }

    public String toString() {
        return "EventForwarder";
    }

    private boolean assertSession() {
        if (this._session == null) {
            try {
                this.setupPubSub();
            }
            catch (Exception ex) {
                _Logger.error((Object)"can not re-establish topic connection: ");
            }
        }
        return this._session != null;
    }

    private void queue(Object evtObj) {
        if (!this.assertSession()) {
            _Logger.error((Object)"SMISNotification.queue(): cannot send message, topic session is down");
            return;
        }
        try {
            if (evtObj == null) {
                return;
            }
            ObjectMessage obj = this._session.createObjectMessage();
            obj.setObject((Serializable)evtObj);
            this._sender.publish((Message)obj);
        }
        catch (JMSException ex) {
            _Logger.error((Object)("SMISNotification.queue(): cannot send message. " + ex.getMessage()));
            this.onException(ex);
        }
    }

    public void trapReceived(SnmpTrapEntry trapEntry) {
        InetAddress trapSrc = trapEntry.getAddr();
        SwitchImpl sw = SanManager.getInstance().findSwitchByIP(trapSrc);
        VarBindList vbl = trapEntry.getVarBindList();
        if (sw == null || trapEntry.getLength() == 0 || vbl == null) {
            _Logger.debug((Object)("SMIS Notificaion: bad trap " + trapEntry));
            return;
        }
        SnmpOID trapOid = (SnmpOID)trapEntry.getVar(1);
        for (int i = 0; i < _AffectSMISTrapOids.length; ++i) {
            if (!trapOid.startsWith(_AffectSMISTrapOids[i])) continue;
            _Logger.debug((Object)("SMIS Notificaion " + trapEntry));
            this.processTrap(sw, i, vbl);
            break;
        }
    }

    private void processTrap(SwitchImpl sw, int trapNo, VarBindList vbl) {
        switch (trapNo) {
            case 0: {
                if (vbl.size() <= 2) break;
                this.onFanStatusChangeTrap(sw, vbl);
                break;
            }
            case 1: {
                this.onLinkStateChangeTrap(sw, vbl, 1);
                break;
            }
            case 2: {
                this.onLinkStateChangeTrap(sw, vbl, 0);
                break;
            }
            case 3: {
                this.onFRUChange(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), 3);
                break;
            }
            case 4: {
                this.onFRUChange(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), 4);
                break;
            }
            case 5: {
                this.onFRUChange(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), 5);
                break;
            }
            case 6: 
            case 7: {
                this.onNsEntryTrap(sw, vbl);
                break;
            }
            case 8: {
                this.onPowerStatusChangeTrap(sw, vbl);
                break;
            }
            case 9: {
                if (vbl.size() <= 3) break;
                this.onEntThresholdNotice(sw, vbl);
                break;
            }
            case 10: {
                this.onVsanChangeTrap(sw, vbl);
                break;
            }
            case 11: {
                this.onZoneActivateNotify(sw, vbl, true);
                break;
            }
            case 12: 
            case 13: {
                this.onIvrActivationTrap(sw, vbl);
                break;
            }
            case 14: {
                this.onVsanPortChange(sw, vbl);
                break;
            }
            case 15: {
                this.onZoneEnhDBChange(sw, vbl);
            }
        }
    }

    private void onLinkStateChangeTrap(SwitchImpl sw, VarBindList vbl, int linkState) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int ifIndex = vbl.intValue(2);
        int ifAdminStatus = vbl.intValue(3);
        int ifOperStatus = vbl.intValue(4);
        LinkStateChange eventObj = new LinkStateChange(fb._fname, fb._fid, fb._swWwn, linkState, ifIndex, ifAdminStatus, ifOperStatus);
        _Logger.log((Priority)Level.INFO, (Object)("SMISNotification: inside onLinkStateChangeTrap LinkState" + linkState));
        this.queue(eventObj);
    }

    private void onFRUChange(SwitchImpl sw, int phyIndex, int trapNo) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int operType = 0;
        Wwn newWwn = new Wwn(fb._swWwn);
        WwnKey key = new WwnKey(newWwn);
        List<Card> invList = InventoryManager.getInstance().findCards(key);
        Card card = null;
        if (invList != null) {
            for (Card c : invList) {
                _Logger.log((Priority)Level.DEBUG, (Object)("Card is : " + c.toString()));
                if (c.getPhysicalIndex() != phyIndex) continue;
                card = c;
                break;
            }
        }
        if (card == null) {
            _Logger.log((Priority)Level.WARN, (Object)("No information available for the card with phyIndex " + phyIndex + " in the switch " + sw.getIpAddress()));
        }
        if (trapNo == 3) {
            operType = 0;
        }
        if (trapNo == 4) {
            operType = 1;
        }
        if (trapNo == 5) {
            operType = 2;
        }
        FRUChange eventObj = null;
        if (card != null) {
            eventObj = new FRUChange(fb._fname, fb._fid, fb._swWwn, phyIndex, operType, card);
        } else {
            SnmpOID[] oids = new SnmpOID[]{new SnmpOID(MibNode.get("entPhysicalDescr").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalVendorType").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalClass").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalParentRelPos").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalName").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalHardwareRev").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalFirmwareRev").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalSerialNum").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalMfgName").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalAlias").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalAssetID").getOid(), phyIndex), new SnmpOID(MibNode.get("entPhysicalIsFRU").getOid(), phyIndex), new SnmpOID(MibNode.get("cefcModuleAdminStatus").getOid(), phyIndex), new SnmpOID(MibNode.get("cefcModuleOperStatus").getOid(), phyIndex), new SnmpOID(MibNode.get("cefcModuleResetReasonDescription").getOid(), phyIndex), new SnmpOID(MibNode.get("cefcModuleStatusLastChangeTime").getOid(), phyIndex)};
            VarBindList vbl = new VarBindList();
            for (SnmpOID o : oids) {
                vbl.add(new SnmpVarBind(o));
            }
            SnmpPeer peer = sw.getPeer();
            try {
                SnmpPDU rPdu = SnmpFetch.get(peer, vbl);
                vbl = rPdu.getVariables();
                int i = 0;
                int[] vendorType = null;
                String physDescr = vbl.stringValue(i);
                int[] oid = ((SnmpOID)vbl.getVb(++i).getVar()).getValue();
                if (oid != null && oid.length > 6) {
                    vendorType = new int[oid.length - 6];
                    System.arraycopy(oid, 6, vendorType, 0, vendorType.length);
                }
                int modelType = FRUConstants.getModuleType(vendorType);
                int classType = vbl.intValue(++i);
                int relPos = vbl.intValue(++i);
                String name = vbl.stringValue(++i);
                String hwVer = vbl.stringValue(++i);
                String fwVer = vbl.stringValue(++i);
                String swVer = vbl.stringValue(++i);
                String serialNo = ((SnmpString)vbl.get(++i).getVar()).toString();
                String mfg = vbl.stringValue(++i);
                String model = ((SnmpString)vbl.get(++i).getVar()).toString();
                String assetId = vbl.stringValue(++i);
                String secSerialNum = "n/a";
                int adminStatus = vbl.intValue(++i);
                int operStatus = vbl.intValue(++i);
                String statusDescr = vbl.enumValue(i);
                String resetReason = vbl.stringValue(++i);
                long chgTime = vbl.longValue(++i);
                eventObj = new FRUChange(fb._fname, fb._fid, fb._swWwn, phyIndex, operType, modelType, adminStatus, operStatus, resetReason, FRUConstants.getNumPorts(modelType), relPos, chgTime, statusDescr, hwVer, fwVer, swVer, serialNo, secSerialNum, mfg, model, assetId, physDescr, name);
            }
            catch (SnmpException e) {
                _Logger.log((Priority)Level.WARN, (Object)("Failed to information available for the card with phyIndex " + phyIndex + " in the switch " + sw.getIpAddress()));
            }
            catch (Exception e1) {
                _Logger.error((Object)("Error: " + e1.getMessage()));
            }
        }
        this.queue(eventObj);
    }

    private void onFanStatusChangeTrap(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int phyIndex = vbl.getVb(2).getOid().getIndexFromEnd(0);
        int status = vbl.intValue(2);
        FanChange eventObj = new FanChange(fb._fname, fb._fid, fb._swWwn, phyIndex, status);
        _Logger.log((Priority)Level.INFO, (Object)("SMISNotification: inside onFanStatusChangeTrap status" + status));
        this.queue(eventObj);
    }

    private void onNsEntryTrap(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        boolean add = ((SnmpOID)vbl.getVb(1).getVar()).startsWith(_AffectSMISTrapOids[6]);
        String pwwn = new Wwn(vbl.byteValue(2)).toString();
        int type = vbl.intValue(3);
        int vsanid = vbl.getVb(2).getOid().getIndexFromEnd(3);
        NameServerDBChange eventObj = new NameServerDBChange(fb._fname, fb._fid, fb._swWwn, add ? 0 : 1, pwwn, type, vsanid);
        _Logger.log((Priority)Level.INFO, (Object)("SMISNotification: inside onNsEntryTrap entryState" + add));
        this.queue(eventObj);
    }

    private void onPowerStatusChangeTrap(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int phyIndex = vbl.getVb(2).getOid().getIndexFromEnd(0);
        int operStatus = vbl.getVb(2).intValue();
        int adminStatus = vbl.getVb(3).intValue();
        int fruCurrent = 0;
        VarBindList svbl = new VarBindList();
        svbl.add(MibNode.get("cefcFRUCurrent").getOid(), phyIndex);
        try {
            SnmpPDU rspPdu = SnmpFetch.get(sw.createPeer(), svbl);
            VarBindList rspVbl = rspPdu.getVariables();
            fruCurrent = rspVbl.intValue(0);
        }
        catch (SnmpException e) {
            _Logger.log((Priority)Level.WARN, (Object)("Failed to get information available for the power module phyIndex " + phyIndex + " in the switch " + sw.getIpAddress()), (Throwable)e);
        }
        PowerChange eventObj = new PowerChange(fb._fname, fb._fid, fb._swWwn, phyIndex, fruCurrent, adminStatus, operStatus);
        _Logger.log((Priority)Level.INFO, (Object)("SMISNotification: inside onPowerStatusChangeTrap operStatus" + operStatus));
        this.queue(eventObj);
    }

    private void onEntThresholdNotice(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int phyIndex = vbl.getVb(3).getOid().getIndexFromEnd(0);
        int sensorValue = vbl.getVb(3).intValue();
        int thresholdIndex = vbl.getVb(2).getIndexFromEnd(0);
        int thresholdValue = vbl.getVb(2).intValue();
        TempChange eventObj = new TempChange(fb._fname, fb._fid, fb._swWwn, phyIndex, sensorValue, thresholdIndex, thresholdValue);
        _Logger.log((Priority)Level.INFO, (Object)("SMISNotification: inside onEntThresholdNotice thresholdValue" + thresholdValue));
        this.queue(eventObj);
    }

    private void onVsanChangeTrap(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        VsanChange eventObj = new VsanChange(fb._fname, fb._fid, fb._swWwn, vbl.intValue(2), vbl.intValue(4), -1);
        _Logger.log((Priority)Level.INFO, (Object)"SMISNotification: inside onVsanChangeTrap");
        this.queue(eventObj);
    }

    private void onVsanPortChange(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        VsanChange eventObj = new VsanChange(fb._fname, fb._fid, fb._swWwn, vbl.intValue(4), 2, vbl.intValue(3));
        _Logger.log((Priority)Level.INFO, (Object)"SMISNotification: inside onVsanPortChange");
        this.queue(eventObj);
    }

    private void onZoneEnhDBChange(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        ZoneEnhDBChange eventObj = new ZoneEnhDBChange(fb._fname, fb._fid, fb._swWwn, vbl.intValue(2));
        this.queue(eventObj);
    }

    private void onZoneActivateNotify(SwitchImpl sw, VarBindList vbl, boolean b) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        int zoneSetActivateResult = vbl.intValue(2);
        if (zoneSetActivateResult != 1 && zoneSetActivateResult != 3) {
            return;
        }
        Wwn zoneSwitchWwn = new Wwn(vbl.byteValue(3));
        int vsan = vbl.getVb(2).getOid().getIndexFromEnd(0);
        String zoneName = null;
        String zoneSetName = null;
        try {
            zoneName = SMISNotifications.getZoneName(zoneSwitchWwn);
        }
        catch (SQLException e) {
            // empty catch block
        }
        int state = 0;
        if (zoneSetActivateResult == 3) {
            state = 1;
        }
        ZoneChange eventObj = new ZoneChange(fb._fname, fb._fid, vsan, fb._swWwn, zoneName, state);
        eventObj.setDeviceWwn(zoneSwitchWwn.toString());
        this.queue(eventObj);
        try {
            zoneSetName = sw.createPeer().send(this.buildPDU(sw, MibNode.get("zoneEnforcedZoneSetName").getOid(), vsan)).getVariables().stringValue(0);
        }
        catch (SnmpException e) {
            // empty catch block
        }
        ZoneSetChange zsetEvent = new ZoneSetChange(fb._fname, fb._fid, vsan, fb._swWwn, zoneSetName, state);
        this.queue(zsetEvent);
    }

    private SnmpPDU buildPDU(SwitchImpl _sw, int[] _entP, int index) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addVar(new SnmpOID(_entP, index));
        pdu.setAddress(_sw.getInetAddress());
        pdu.setTimeout(SnmpPeer._Timeout);
        pdu.setPort(161);
        pdu.setRetries(0);
        return pdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getZoneName(Wwn zoneSwitchWwn) throws SQLException {
        String string;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        String zoneName = null;
        try {
            stat = con.prepareStatement(QueryZNameByMemberID);
            stat.setInt(1, 1);
            stat.setBytes(2, zoneSwitchWwn.getValue());
            rs = stat.executeQuery();
            if (rs.next()) {
                zoneName = rs.getString(1);
            }
            string = zoneName;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return string;
    }

    private void onIvrActivationTrap(SwitchImpl sw, VarBindList vbl) {
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        if (sw.getFabric().getIvrSeed() != null && sw.getFabric().getIvrSeed() != sw) {
            return;
        }
        int result = vbl.intValue(3);
        if (result != 1 && result != 9) {
            return;
        }
        int state = 0;
        if (result == 9) {
            state = 1;
        }
        String zoneset = vbl.stringValue(2);
        ZoneSetChange zsEvent = new ZoneSetChange(fb._fname, fb._fid, -1, fb._swWwn, zoneset, state);
        this.queue(zsEvent);
    }

    public void VsanSMISNotif(FabricPK fpk, boolean added, VsanPK vpk) {
        if (fpk == null || vpk == null) {
            return;
        }
        VsanChange event = new VsanChange(fpk.getName(), fpk._fid, SnmpString.toHexString(vpk._prinSwwn.getValue()), vpk._id, added ? 3 : 4, -1);
        this.queue(event);
    }

    public void VsanSMISNotif(FabricPK fpk, boolean added, WwnKey switchPk, VsanDomain vd) {
        if (fpk == null || switchPk == null || vd == null) {
            return;
        }
        VsanChange event = new VsanChange(fpk.getName(), fpk._fid, SnmpString.toHexString(switchPk._wwn.getValue()), vd._vsanPK._id, added ? 3 : 4, -1);
        this.queue(event);
    }

    public void SMISNotif(AbstractModelObjectImpl o, int state) {
        if (o instanceof SwitchImpl) {
            SwitchImpl sw = (SwitchImpl)o;
            if (sw.getWwn() == null) {
                _Logger.log((Priority)Level.DEBUG, (Object)("Suppressing the event as the Switch : " + sw.toString() + " has no wwn "));
                return;
            }
            FabricInfoBuilder fb = new FabricInfoBuilder(sw);
            SwitchChange swEvent = new SwitchChange(fb._fname, fb._fid, fb._swWwn, sw.getIpAddress(), state);
            this.queue(swEvent);
        } else if (o instanceof EndPortImpl) {
            EndPortImpl endPort = (EndPortImpl)o;
            String priKey = endPort.getEndPortPK().toString();
            String nwwn = endPort.getNodeWwn().toString();
            EndPortChange eporevent = new EndPortChange(priKey, nwwn, endPort.getIfName(), state);
            this.queue(eporevent);
        }
    }

    public void SMISNotify(InetAddress swAddr, String syslog, int sev) {
        syslog = syslog.trim();
        SwitchImpl sw = SanManager.getInstance().findSwitchByIP(swAddr);
        if (sw == null || sw.getWwn() == null) {
            if (sw == null) {
                _Logger.log((Priority)Level.DEBUG, (Object)"Suppressing the event as the Switch : sw object is null");
            } else {
                _Logger.log((Priority)Level.DEBUG, (Object)("Suppressing the event as the Switch : " + sw.toString() + " has no wwn "));
            }
            return;
        }
        FabricInfoBuilder fb = new FabricInfoBuilder(sw);
        UserChange usrEvent = null;
        if (sev == 3) {
            if (syslog.contains("Authentication failed for user")) {
                String[] result = syslog.split("\\s");
                usrEvent = new UserChange(fb._fname, fb._fid, fb._swWwn, 4, result[4]);
            }
        } else if (sev == 5) {
            if (syslog.contains("New user added with username")) {
                String[] result = syslog.split("\\s");
                usrEvent = new UserChange(fb._fname, fb._fid, fb._swWwn, 1, result[5]);
            } else if (syslog.contains("Deleted user")) {
                String[] result = syslog.split("\\s");
                usrEvent = new UserChange(fb._fname, fb._fid, fb._swWwn, 2, result[2]);
            } else if (syslog.contains("Password changed for user")) {
                String[] result = syslog.split("\\s");
                usrEvent = new UserChange(fb._fname, fb._fid, fb._swWwn, 3, result[4]);
            }
        }
        if (usrEvent != null) {
            this.queue(usrEvent);
        }
    }

    static {
        _AffectSMISTrapOids = new int[][]{MibNode.get("cefcFanTrayStatusChange").getOid(), MibNode.get("linkDown").getOid(), MibNode.get("linkUp").getOid(), MibNode.get("cefcFRUInserted").getOid(), MibNode.get("cefcFRURemoved").getOid(), MibNode.get("cefcModuleStatusChange").getOid(), MibNode.get("fcNameServerEntryAdd").getOid(), MibNode.get("fcNameServerEntryDelete").getOid(), MibNode.get("cefcPowerStatusChange").getOid(), MibNode.get("entSensorThresholdNotification").getOid(), MibNode.get("vsanStatusChange").getOid(), MibNode.get("zoneActivateNotify").getOid(), MibNode.get("civrZoneActivationDoneNotify").getOid(), MibNode.get("civrZoneDeactivationDoneNotify").getOid(), MibNode.get("vsanPortMembershipChange").getOid(), MibNode.get("czsezoneEnhDbChngNotif").getOid()};
        _Logger = LogManager.getLogger((String)"fms.event.smis");
        _SmisEnable = new AtomicBoolean();
        _Currentip = null;
    }

    private static class FabricInfoBuilder {
        int _fid;
        String _fname;
        String _swWwn;

        FabricInfoBuilder(SwitchImpl sw) {
            FabricPK fpk = sw.getFabricPK();
            this._swWwn = SnmpString.toHexString(sw.getWwn().getValue());
            this._fid = fpk._fid;
            this._fname = fpk.getName();
        }
    }
}

