/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.zm.VsanOb;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.IntPair;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationCommandsFactory;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationHelper;
import com.cisco.dcbu.lib.util.fcoe.StatusMsg;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.FCoEConfigObj;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FCoEConfigurationImpl
implements FCoEConfigurationRif {
    static final int[] _cfcoeVlanOperStateOid = MibNode.get("cfcoeVLANOperState").getOid();
    static final int[] _cfcoeVlanRowStatusOid = MibNode.get("cfcoeVLANRowStatus").getOid();
    static Logger _logger = LogManager.getLogger((String)"fms.fcoe");
    private SessionRif _session;
    private HashMap<PKIf, SnmpPeer> snmpPeerMap = new HashMap();
    public static List<Integer> fcoeCardTypes = new ArrayList<Integer>();

    @Override
    public void init(SessionRif session) throws RemoteException {
        if (this._session == null) {
            this._session = session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusMsg[] configureFCoE(FCoEConfigObj[] swConfigObjects) throws RemoteException {
        TreeSet<Integer> vfcIDsSw2;
        TreeSet<Integer> vfcIDsSw1;
        EthSwitchImpl sw2Impl;
        EthSwitchImpl sw1Impl;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"FCoEConfigurationImpl: configureFCoE(), Trying to configure VE FCoE");
        }
        PKIf[] swPKs = swConfigObjects[0].getSwitchObj().keySet().toArray(new PKIf[2]);
        PKIf sw1 = swPKs[0];
        PKIf sw2 = swPKs[1];
        try {
            sw1Impl = this.findSwitch(sw1);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: configureFCoE(), Failed to find Switch " + sw1), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        try {
            sw2Impl = this.findSwitch(sw2);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: configureFCoE(), Failed to find Switch " + sw2), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        try {
            vfcIDsSw1 = this.buildExistingViglessVifIdsSet(sw1Impl.getBase(), this.snmpPeerMap.get(sw1Impl.getPK()));
            vfcIDsSw2 = this.buildExistingViglessVifIdsSet(sw2Impl.getBase(), this.snmpPeerMap.get(sw2Impl.getPK()));
        }
        catch (SnmpException ex) {
            _logger.error((Object)"FCoEConfigurationImpl: configureFCoE(), Failed to build vfc ids list.", (Throwable)ex);
            throw new RemoteException("Failed to get available vsif id.\nError: " + ex.getMessage());
        }
        FCoEConfigCommandsIf fcoeCmdObj1 = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands(null, this.snmpPeerMap.get(sw1Impl.getPK()), sw1Impl.getBase());
        FCoEConfigCommandsIf fcoeCmdObj2 = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands(null, this.snmpPeerMap.get(sw2Impl.getPK()), sw2Impl.getBase());
        try {
            if (sw1Impl.getBase().isNuovaFamily()) {
                fcoeCmdObj1.connect();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: configureFCoE(), Failed to get terminal connection on " + sw1Impl.getBase().getSysName()), (Throwable)ex);
            throw new RemoteException("Failed to get CLI connection to the switch " + sw1Impl.getBase().getSysName() + ". Reason :" + ex.getMessage());
        }
        try {
            if (sw2Impl.getBase().isNuovaFamily()) {
                fcoeCmdObj2.connect();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: configureFCoE(), Failed to get terminal connection on " + sw2Impl.getBase().getSysName()), (Throwable)ex);
            throw new RemoteException("Failed to get CLI connection to the switch " + sw2Impl.getBase().getSysName() + ". Reason :" + ex.getMessage());
        }
        try {
            StatusMsg[] statusMsgs = new StatusMsg[swConfigObjects.length];
            SyncedInt pendingConfigs = new SyncedInt(0);
            StatusMsg[] statusMsgArray = pendingConfigs.getLock();
            synchronized (statusMsgArray) {
                for (int i = 0; i < swConfigObjects.length; ++i) {
                    ArrayList<Integer> vsifIndexes;
                    int pVsifId1 = 0;
                    int pVsifId2 = 0;
                    int vfcIfIndex1 = 0;
                    int vfcIfIndex2 = 0;
                    boolean isImplicitBindingSw1 = false;
                    boolean isImplicitBindingSw2 = false;
                    if (swConfigObjects[i].getVsifIndexes().size() > 0) {
                        vsifIndexes = swConfigObjects[i].getVsifIndexes();
                        pVsifId1 = IfIndexUtil.ifindexToVfcIndex(vsifIndexes.get(0));
                        pVsifId2 = IfIndexUtil.ifindexToVfcIndex(vsifIndexes.get(1));
                        if (vfcIDsSw1.contains(pVsifId1)) {
                            statusMsgs[i] = new StatusMsg(2, "<html>VFC Id " + pVsifId1 + " already used on switch " + sw1Impl.getBase().getSysName() + ".</html>");
                            continue;
                        }
                        if (vfcIDsSw2.contains(pVsifId2)) {
                            statusMsgs[i] = new StatusMsg(2, "<html>VFC Id " + pVsifId2 + " already used on switch " + sw2Impl.getBase().getSysName() + ".</html>");
                            continue;
                        }
                    } else {
                        String vfcNameStr;
                        isImplicitBindingSw1 = FCoEConfigurationHelper.isVfcImplicitBindingSupported(sw1Impl.getBase());
                        isImplicitBindingSw2 = FCoEConfigurationHelper.isVfcImplicitBindingSupported(sw2Impl.getBase());
                        if (!isImplicitBindingSw1 && !isImplicitBindingSw2) {
                            pVsifId2 = pVsifId1 = this.getLastCommonId(vfcIDsSw1, vfcIDsSw2) + 1;
                            vfcNameStr = "vfc" + pVsifId1;
                            vfcIfIndex2 = vfcIfIndex1 = sw1Impl.getBase().nameToIfIndex(vfcNameStr);
                        } else {
                            String vfcNameStr2;
                            String interfaceName;
                            if (!isImplicitBindingSw1) {
                                pVsifId1 = this.getLastId(vfcIDsSw1) + 1;
                                vfcNameStr = "vfc" + pVsifId1;
                                vfcIfIndex1 = sw1Impl.getBase().nameToIfIndex(vfcNameStr);
                            } else {
                                interfaceName = swConfigObjects[i].getInterfaceForSwitch(sw1Impl.getPK());
                                vfcNameStr2 = IfIndexUtil.generateVFCNameFromInterfaceName(interfaceName);
                                vfcIfIndex1 = sw1Impl.getBase().nameToIfIndex(vfcNameStr2);
                                pVsifId1 = IfIndexUtil.ifindexToVfcIndex(vfcIfIndex1);
                            }
                            if (!isImplicitBindingSw2) {
                                pVsifId2 = this.getLastId(vfcIDsSw2) + 1;
                                vfcNameStr = "vfc" + pVsifId2;
                                vfcIfIndex2 = sw2Impl.getBase().nameToIfIndex(vfcNameStr);
                            } else {
                                interfaceName = swConfigObjects[i].getInterfaceForSwitch(sw2Impl.getPK());
                                vfcNameStr2 = IfIndexUtil.generateVFCNameFromInterfaceName(interfaceName);
                                vfcIfIndex2 = sw2Impl.getBase().nameToIfIndex(vfcNameStr2);
                                pVsifId2 = IfIndexUtil.ifindexToVfcIndex(vfcIfIndex2);
                            }
                        }
                        vsifIndexes = new ArrayList();
                        vsifIndexes.add(vfcIfIndex1);
                        vsifIndexes.add(vfcIfIndex2);
                        swConfigObjects[i].setVsifIndexes(vsifIndexes);
                    }
                    pendingConfigs.increment();
                    this.getFCoEConfigThread(sw1Impl, sw2Impl, statusMsgs, swConfigObjects[i], fcoeCmdObj1, fcoeCmdObj2, isImplicitBindingSw1, isImplicitBindingSw2, sw1, sw2, i, pendingConfigs).start();
                    vfcIDsSw1.add(pVsifId1);
                    vfcIDsSw2.add(pVsifId2);
                }
                while (pendingConfigs.get() > 0) {
                    pendingConfigs.wait();
                }
            }
            statusMsgArray = statusMsgs;
            return statusMsgArray;
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationImpl: configureFCoE(), Failed to configure vfc interfaces.", (Throwable)ex);
            throw new RemoteException("Failed to configure FCoE.\n Error:" + ex.getMessage());
        }
        finally {
            fcoeCmdObj1.disconnect();
            fcoeCmdObj2.disconnect();
        }
    }

    private Thread getFCoEConfigThread(final EthSwitchImpl sw1Impl, final EthSwitchImpl sw2Impl, final StatusMsg[] statusMsgs, final FCoEConfigObj swConfigObject, final FCoEConfigCommandsIf fcoeCmdObj1, final FCoEConfigCommandsIf fcoeCmdObj2, final boolean isImplicitBindingSw1, final boolean isImplicitBindingSw2, final PKIf sw1PK, final PKIf sw2PK, final int index, final SyncedInt pendingConfigs) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StringBuilder sw1StatusStr = new StringBuilder();
                    StringBuilder sw2StatusStr = new StringBuilder();
                    int pVsifIndex1 = 0;
                    int pVsifIndex2 = 0;
                    ArrayList<Integer> vsifIndexes = swConfigObject.getVsifIndexes();
                    if (vsifIndexes.size() > 0) {
                        pVsifIndex1 = vsifIndexes.get(0);
                        pVsifIndex2 = vsifIndexes.get(1);
                    }
                    String vfcNameStr1 = sw1Impl.ifIndexToName(pVsifIndex1);
                    String vfcNameStr2 = sw2Impl.ifIndexToName(pVsifIndex2);
                    ArrayList<String> vsans = new ArrayList<String>();
                    ArrayList<String> vlans = new ArrayList<String>();
                    HashMap<Integer, Integer> mappings = swConfigObject.getMappings();
                    Integer[] vsanArr = mappings.values().toArray(new Integer[mappings.size()]);
                    for (int j = 0; j < vsanArr.length; ++j) {
                        vsans.add(Integer.toString(vsanArr[j]));
                    }
                    Integer[] vlanArr = mappings.keySet().toArray(new Integer[mappings.size()]);
                    for (int j = 0; j < vlanArr.length; ++j) {
                        vlans.add(Integer.toString(vlanArr[j]));
                    }
                    String interfaceSw1 = swConfigObject.getSwitchObj().get(sw1PK);
                    String interfaceSw2 = swConfigObject.getSwitchObj().get(sw2PK);
                    try {
                        FCoEConfigurationImpl.this.configureFCoE(sw1Impl.getBase(), (SnmpPeer)FCoEConfigurationImpl.this.snmpPeerMap.get(sw1Impl.getPK()), interfaceSw1, vsans, vfcNameStr1, pVsifIndex1, isImplicitBindingSw1, swConfigObject.getVFCModeForSwitch(sw1PK));
                    }
                    catch (Exception ex) {
                        statusMsgs[index] = new StatusMsg(2, "<html>" + ex.getMessage() + "</html>");
                        pendingConfigs.decrement();
                        SyncedInt syncedInt = pendingConfigs;
                        synchronized (syncedInt) {
                            pendingConfigs.notifyAll();
                        }
                        return;
                    }
                    sw1StatusStr.append(vfcNameStr1 + " created, bound and enabled on switch " + sw1Impl.getBase().getSysName() + ". ");
                    try {
                        FCoEConfigurationImpl.this.configureFCoE(sw2Impl.getBase(), (SnmpPeer)FCoEConfigurationImpl.this.snmpPeerMap.get(sw2Impl.getPK()), interfaceSw2, vsans, vfcNameStr2, pVsifIndex2, isImplicitBindingSw2, swConfigObject.getVFCModeForSwitch(sw2PK));
                    }
                    catch (Exception ex) {
                        sw1StatusStr.append("<br>" + ex.getMessage());
                        statusMsgs[index] = new StatusMsg(2, "<html> " + sw1StatusStr.toString() + "</html>");
                        pendingConfigs.decrement();
                        SyncedInt syncedInt = pendingConfigs;
                        synchronized (syncedInt) {
                            pendingConfigs.notifyAll();
                        }
                        return;
                    }
                    sw2StatusStr.append(vfcNameStr2 + " created, bound and enabled on switch " + sw2Impl.getBase().getSysName() + ".");
                    boolean sw1EthConfig = false;
                    boolean sw2EthConfig = false;
                    try {
                        sw1EthConfig = FCoEConfigurationHelper.checkDeviceConfiguration(sw1Impl.getBase(), (SnmpPeer)FCoEConfigurationImpl.this.snmpPeerMap.get(sw1Impl.getPK()), fcoeCmdObj1, interfaceSw1, vlans, false);
                    }
                    catch (IOException e) {
                        _logger.error((Object)("FCoEConfigurationImpl: getFCoEConfigThread(), failed to check/configure ethernet interface " + interfaceSw1 + " on switch " + sw1Impl.getName() + " ."), (Throwable)e);
                        sw1StatusStr.append("Missing ethernet configuration on switch " + sw1Impl.getBase().getSysName() + ".");
                    }
                    catch (Exception e) {
                        _logger.error((Object)("FCoEConfigurationImpl: getFCoEConfigThread(), failed to check/configure ethernet interface " + interfaceSw1 + " on switch " + sw1Impl.getName() + " ."), (Throwable)e);
                        sw1StatusStr.append("Missing ethernet configuration on switch " + sw1Impl.getBase().getSysName() + ". Error :" + e.getMessage());
                    }
                    try {
                        sw2EthConfig = FCoEConfigurationHelper.checkDeviceConfiguration(sw2Impl.getBase(), (SnmpPeer)FCoEConfigurationImpl.this.snmpPeerMap.get(sw2Impl.getPK()), fcoeCmdObj2, interfaceSw2, vlans, false);
                    }
                    catch (IOException e) {
                        _logger.error((Object)("FCoEConfigurationImpl: getFCoEConfigThread(), failed to check/configure ethernet interface " + interfaceSw2 + " on switch " + sw2Impl.getName() + " ."), (Throwable)e);
                        sw2StatusStr.append("Missing ethernet configuration on switch " + sw2Impl.getBase().getSysName() + ".");
                    }
                    catch (Exception e) {
                        _logger.error((Object)("FCoEConfigurationImpl: getFCoEConfigThread(), failed to check/configure ethernet interface " + interfaceSw2 + " on switch " + sw2Impl.getName() + " ."), (Throwable)e);
                        sw2StatusStr.append("Missing ethernet configuration on switch " + sw2Impl.getBase().getSysName() + ". Error :" + e.getMessage());
                    }
                    int status = sw1EthConfig && sw2EthConfig ? 1 : 3;
                    statusMsgs[index] = new StatusMsg(status, "<html>" + sw1StatusStr.toString() + "<br>" + sw2StatusStr.toString() + "</html>");
                    pendingConfigs.decrement();
                    SyncedInt syncedInt = pendingConfigs;
                    synchronized (syncedInt) {
                        pendingConfigs.notifyAll();
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"FCoEConfigurationImpl: getFCoEConfigThread(), Unexpected exception occurred while configuring FCoE.", (Throwable)e);
                    pendingConfigs.decrement();
                    SyncedInt syncedInt = pendingConfigs;
                    synchronized (syncedInt) {
                        pendingConfigs.notifyAll();
                    }
                }
            }
        };
        return new Thread(runnable);
    }

    private void configureFCoE(SwitchAttrIf selectedSwitch, SnmpPeer peer, String interfaceName, List<String> vsans, String vfcNameStr, int pVsifIndex, boolean isImplicitBinding, int mode) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationImpl: configureFCoE(), Configuring VE FCoE " + vfcNameStr + "  on switch " + selectedSwitch.getName()));
        }
        try {
            FCoEConfigurationHelper.cretaeFCoE(selectedSwitch, peer, interfaceName, vsans, vfcNameStr, pVsifIndex, isImplicitBinding);
        }
        catch (SnmpException e) {
            _logger.error((Object)("Failed to configure " + vfcNameStr + " on switch " + selectedSwitch.getName() + " Reason : "), (Throwable)e);
            throw new Exception("vfc creation/binding failed on switch " + selectedSwitch.getName() + ". Reason : " + e.getMessage());
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationImpl: configureFCoE(), Setting the VFC Admin mode to E on switch " + selectedSwitch.getName()));
        }
        try {
            FCoEConfigurationHelper.sendSetAdminStatePdu(selectedSwitch, peer, mode, vfcNameStr, pVsifIndex, vsans.get(0));
        }
        catch (SnmpException e) {
            _logger.error((Object)("Failed to change admin mode for " + vfcNameStr + " on switch " + selectedSwitch.getName() + " Reason : "), (Throwable)e);
            throw new Exception(vfcNameStr + " created and bound on switch " + selectedSwitch.getName() + ", vfc failed to enable. Reason : " + e.getMessage());
        }
    }

    private TreeSet<Integer> buildExistingViglessVifIdsSet(IfIndexIf selectedSwitch, SnmpPeer peer) throws SnmpException {
        VSifObj lVSifObj = VSifObj.get(peer, selectedSwitch, 6);
        return lVSifObj.getVFCIdsSet();
    }

    private int getLastCommonId(TreeSet<Integer> idsSet1, TreeSet<Integer> idsSet2) {
        int id;
        int nextIndex;
        idsSet1.addAll(idsSet2);
        Iterator<Integer> i$ = idsSet1.iterator();
        for (nextIndex = 1; i$.hasNext() && (id = i$.next().intValue()) <= nextIndex; ++nextIndex) {
        }
        return nextIndex - 1;
    }

    private int getLastId(TreeSet<Integer> idsSet) {
        int nextIndex;
        if (idsSet != null) {
            int id;
            Iterator<Integer> i$ = idsSet.iterator();
            for (nextIndex = 1; i$.hasNext() && (id = i$.next().intValue()) <= nextIndex; ++nextIndex) {
            }
        }
        return nextIndex - 1;
    }

    @Override
    public void createVLANVSANMappings(PKIf sw, HashMap<Integer, Integer> mappings) throws RemoteException {
        EthSwitchImpl swImpl;
        try {
            swImpl = this.findSwitch(sw);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: createVLANVSANMappings(), Switch " + sw + " not found."), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        SnmpPeer peer = this.snmpPeerMap.get(swImpl.getPK());
        FCoEConfigCommandsIf fcoeCmd = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands(null, this.snmpPeerMap.get(swImpl.getPK()), swImpl.getBase());
        try {
            fcoeCmd.connect();
            TreeSet configuredVlans = (TreeSet)fcoeCmd.getAllVlans();
            ArrayList<Integer> configuredVsans = this.getVsans(sw);
            Integer[] vlanKeys = mappings.keySet().toArray(new Integer[mappings.size()]);
            for (int i = 0; i < vlanKeys.length; ++i) {
                int vlan = vlanKeys[i];
                int vsan = mappings.get(vlan);
                if (!configuredVlans.contains(vlan)) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("FCoEConfigurationImpl: createVLANVSANMappings(), Creating VLAN " + vlan + " on switch " + swImpl.getBase().getSysName()));
                    }
                    try {
                        fcoeCmd.createVlan(Integer.toString(vlan));
                    }
                    catch (Exception ex) {
                        throw new Exception("Failed to provision vlan " + vlan + ". Details: " + ex.getMessage());
                    }
                }
                if (!configuredVsans.contains(vsan)) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("FCoEConfigurationImpl: createVLANVSANMappings(), Creating VSAN " + vsan + " on switch " + swImpl.getBase().getSysName()));
                    }
                    try {
                        FCoEConfigurationHelper.createVsan(peer, vsan);
                    }
                    catch (Exception ex) {
                        throw new Exception("Failed to provision vsan " + vsan + ". Details: " + ex.getMessage());
                    }
                }
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug((Object)("FCoEConfigurationImpl: createVLANVSANMappings(), Creating Mapping VLAN-VSAN(" + vlan + "-" + vsan + ") on switch " + swImpl.getBase().getSysName()));
            }
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            for (int i = 0; i < vlanKeys.length; ++i) {
                int vlan = vlanKeys[i];
                int vsan = mappings.get(vlan);
                int[] index = IfIndexUtil.getVsanVlanMappingIndex(vsan, vlan);
                pdu.addVar(new SnmpOID(_cfcoeVlanRowStatusOid, index), new SnmpInt(4));
            }
            peer.send(pdu);
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationImpl: createVLANVSANMappings(), Failed to create VLAN-VSAN Mappings.", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
        finally {
            fcoeCmd.disconnect();
        }
    }

    private EthSwitchImpl findSwitch(PKIf swPK) throws UnknownHostException {
        EthSwitchImpl swImpl = DCManager.getInstance().findEthSwitchBySwPK(swPK);
        if (swImpl == null) {
            throw new UnknownHostException("Failed to find switch in server cache.");
        }
        return swImpl;
    }

    @Override
    public void enableFCoE(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl;
        try {
            swImpl = this.findSwitch(sw);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: enableFCoE(), Switch " + sw + " not found."), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        try {
            FCoEConfigurationHelper.enableFCoE(swImpl.getBase(), this.snmpPeerMap.get(sw));
        }
        catch (Exception e) {
            _logger.error((Object)("FCoEConfigurationImpl: enableFCoE(), Failed to enable FCoE on switch " + swImpl.getBase().getSysName() + "."), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void enableNPIV(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl;
        try {
            swImpl = this.findSwitch(sw);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: enableNPIV(), Switch " + sw + " not found."), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        try {
            FCoEConfigurationHelper.enableNPIV(swImpl.getBase(), this.snmpPeerMap.get(sw));
        }
        catch (Exception e) {
            _logger.error((Object)("FCoEConfigurationImpl: enableNPIV(), Failed to enable NPIV on switch " + swImpl.getBase().getSysName() + "."), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public EthIslBase[] getEthISLs(LanBase lan) throws RemoteException {
        Collection<EthIslBase> isls = lan.getEthIsls();
        return isls.toArray(new EthIslBase[0]);
    }

    @Override
    public Object[] getVLANVSANMappings(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl;
        try {
            swImpl = this.findSwitch(sw);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: getVLANVSANMappings(), Switch " + sw + " not found."), (Throwable)e1);
            throw new RemoteException(e1.getMessage());
        }
        SnmpPeer peer = this.snmpPeerMap.get(swImpl.getPK());
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationImpl: getVLANVSANMappings(), Getting VLAN VSAN mappings from the switch " + swImpl.getBase().getSysName()));
        }
        VarBindList var = new VarBindList();
        SnmpOID mappingOID = new SnmpOID(_cfcoeVlanOperStateOid);
        SnmpVarBind vb = new SnmpVarBind(mappingOID);
        var.add(vb);
        try {
            SnmpPDU resp = SnmpFetch.getBulk(peer, var);
            VarBindList rspVbl = resp.getVariables();
            Object[] returnArr = new Object[rspVbl.size()];
            for (int i = 0; i < rspVbl.size(); ++i) {
                if (!rspVbl.getVb(i).getOid().startsWith(mappingOID)) continue;
                returnArr[i] = rspVbl.getVb(i);
            }
            return returnArr;
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationImpl: getVLANVSANMappings(), Exception occurred while getting VLAN-VSAN mappings.", (Throwable)ex);
            throw new RemoteException("Failed to get VLAN VSAN Mappings from switch " + swImpl.getBase().getSysName() + ". Reason :" + ex.getMessage());
        }
    }

    @Override
    public boolean isNPVEnabled(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl = null;
        try {
            swImpl = this.findSwitch(sw);
            SnmpPeer peer = this.snmpPeerMap.get(sw) != null ? this.snmpPeerMap.get(sw) : swImpl.getPeer();
            return FCoEConfigurationHelper.isNPVorFCoENPVEnabled(swImpl.getBase(), peer);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: isNPVEnabled(), Switch " + sw + " not found."), (Throwable)e1);
            return false;
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: isNPVEnabled(), Exception occurred while checking NPV feature status on switch " + swImpl.getBase().getSysName()), (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean isFCoEEnabled(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl = null;
        try {
            swImpl = this.findSwitch(sw);
            SnmpPeer peer = this.snmpPeerMap.get(sw) != null ? this.snmpPeerMap.get(sw) : swImpl.getPeer();
            return FCoEConfigurationHelper.isFCoEEnabled(swImpl.getBase(), peer);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: isFCoEEnabled(), Switch " + sw + " not found."), (Throwable)e1);
            return false;
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: isFCoEEnabled(), Exception occurred while checking FCoE feature status on switch " + swImpl.getBase().getSysName()), (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean isNPIVEnabled(PKIf sw) throws RemoteException {
        EthSwitchImpl swImpl = null;
        try {
            swImpl = this.findSwitch(sw);
            SnmpPeer peer = this.snmpPeerMap.get(sw) != null ? this.snmpPeerMap.get(sw) : swImpl.getPeer();
            return FCoEConfigurationHelper.isNPIVEnabled(swImpl.getBase(), peer);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: isNPIVEnabled(), Switch " + sw + " not found."), (Throwable)e1);
            return false;
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: isNPIVEnabled(), Exception occurred while checking NPIV feature status on switch " + swImpl.getBase().getSysName()), (Throwable)ex);
            return false;
        }
    }

    @Override
    public ArrayList<Integer> getVsans(PKIf sw) throws RemoteException {
        try {
            ArrayList<Integer> vsanIds = new ArrayList<Integer>();
            SnmpPeer node = this.snmpPeerMap.get(sw);
            ArrayList vsans = VsanOb.discoverVsans(node);
            VsanOb obj = null;
            for (int i = 0; i < vsans.size(); ++i) {
                obj = (VsanOb)vsans.get(i);
                vsanIds.add(obj.getVsanId());
            }
            return vsanIds;
        }
        catch (SnmpException ex) {
            _logger.error((Object)"FCoEConfigurationImpl: getVsans(), Exception occurred while getting the vsan list ", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean checkDeviceConfiguration(FCoEConfigObj swConfigObj, List<String> vlanNo) throws RemoteException {
        EthSwitchImpl sw2Impl;
        EthSwitchImpl sw1Impl;
        PKIf[] swPKs = swConfigObj.getSwitchObj().keySet().toArray(new PKIf[2]);
        PKIf sw1PK = swPKs[0];
        PKIf sw2PK = swPKs[1];
        try {
            sw1Impl = this.findSwitch(sw1PK);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: getVLANVSANMappings(), Switch " + sw1PK + " not found."), (Throwable)e1);
            return false;
        }
        try {
            sw2Impl = this.findSwitch(sw2PK);
        }
        catch (UnknownHostException e1) {
            _logger.error((Object)("FCoEConfigurationImpl: getVLANVSANMappings(), Switch " + sw2PK + " not found."), (Throwable)e1);
            return false;
        }
        String sw1Interface = swConfigObj.getSwitchObj().get(sw1PK);
        String sw2Interface = swConfigObj.getSwitchObj().get(sw2PK);
        try {
            this.checkDeviceConfig(sw1Impl.getBase(), this.snmpPeerMap.get(sw1Impl.getPK()), sw1Interface, vlanNo);
            this.checkDeviceConfig(sw2Impl.getBase(), this.snmpPeerMap.get(sw2Impl.getPK()), sw2Interface, vlanNo);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDeviceConfig(SwitchAttrIf switchAttrIf, SnmpPeer peer, String interfaceName, List<String> vlans) throws Exception {
        FCoEConfigCommandsIf fcoeCmd = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands(null, peer, switchAttrIf);
        boolean deviceEthConfigStatus = false;
        try {
            fcoeCmd.connect();
            deviceEthConfigStatus = FCoEConfigurationHelper.checkDeviceConfiguration(switchAttrIf, peer, fcoeCmd, interfaceName, vlans, false);
        }
        catch (Exception ex) {
            _logger.error((Object)("FCoEConfigurationImpl: checkDeviceConfig(), Exception occurred while checking eth port status on switch " + switchAttrIf.getName() + " "), (Throwable)ex);
        }
        finally {
            fcoeCmd.disconnect();
        }
        return deviceEthConfigStatus;
    }

    @Override
    public Vector<PKIf> getNPVSwitchList(LanPK lanPK) throws RemoteException {
        return this.getNPVSwitchList(lanPK, null);
    }

    @Override
    public Vector<PKIf> getNPVSwitchList(LanPK lanPK, ArrayList<PKIf> switches) throws RemoteException {
        try {
            LanImpl lan = DCManager.getInstance().findLan(lanPK);
            List<EthSwitchImpl> lanSwitches = lan.getEthSwitches();
            Vector<PKIf> npvSwitches = new Vector<PKIf>();
            ArrayList<Thread> switchThreads = new ArrayList<Thread>();
            for (EthSwitchImpl ethSwitch : lanSwitches) {
                if (switches != null && !switches.contains(ethSwitch.getPK()) || ethSwitch.getBase() == null || !ethSwitch.getBase().isManageable() || !ethSwitch.getBase().isNuovaFamily()) continue;
                Thread swThread = this.getNPVStatusThread(ethSwitch.getPeer(), ethSwitch, npvSwitches);
                switchThreads.add(swThread);
                swThread.start();
            }
            for (Thread t : switchThreads) {
                t.join();
            }
            return npvSwitches;
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationImpl: getNPVSwitchList(), Exception occurred while getting NPV switch list ", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    private Thread getNPVStatusThread(final SnmpPeer peer, final EthSwitchImpl ethSwitch, final Vector<PKIf> switchList) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean featureStatus = FCoEConfigurationHelper.isNPVorFCoENPVEnabled(ethSwitch.getBase(), peer);
                    if (featureStatus) {
                        switchList.add(ethSwitch.getPK());
                    }
                }
                catch (Exception ex) {
                    _logger.error((Object)("FCoEConfigurationImpl: getVEFCoESwitchList(), Exception occurred while getting VE capable switch list for switch " + ethSwitch.getBase().getSysName()), (Throwable)ex);
                }
            }
        };
        return new Thread(runnable);
    }

    @Override
    public Hashtable<PKIf, HashSet<Integer>> getVEFCoESwitchList(LanPK lanPK) throws RemoteException {
        return this.getVEFCoESwitchList(lanPK, null);
    }

    private Thread getVFCInformationThread(final SnmpPeer peer, final EthSwitchImpl ethSwitch, final Hashtable<PKIf, HashSet<Integer>> retSwitchMap, final HashMap<PKIf, HashSet<Integer>> filteredPortChannelsMap, final SyncedInt pendingSwitches) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HashSet filteredPorts;
                    VSifObj lVSifObj = VSifObj.get(peer, ethSwitch.getBase(), 6, 4);
                    TreeMap<Integer, IntArray> ethPortIfIndexToVSifIfIndicesMap = lVSifObj.getEthPortIfIndexToVSifIfIndicesMap();
                    HashSet<Integer> ethIndices = new HashSet<Integer>(ethPortIfIndexToVSifIfIndicesMap.keySet());
                    if (filteredPortChannelsMap != null && !filteredPortChannelsMap.isEmpty() && (filteredPorts = (HashSet)filteredPortChannelsMap.get(ethSwitch.getBase().getPK())) != null) {
                        ethIndices.addAll(filteredPorts);
                    }
                    retSwitchMap.put(ethSwitch.getPK(), ethIndices);
                }
                catch (Exception ex) {
                    _logger.error((Object)("FCoEConfigurationImpl: getVEFCoESwitchList(), Exception occurred while getting VE capable switch list for switch " + ethSwitch.getBase().getSysName()), (Throwable)ex);
                }
                finally {
                    Object object = pendingSwitches.getLock();
                    synchronized (object) {
                        pendingSwitches.decrement();
                        pendingSwitches.notifyAll();
                    }
                }
            }
        };
        return new Thread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable<PKIf, HashSet<Integer>> getVEFCoESwitchList(LanPK lanPK, ArrayList<PKIf> switchList) throws RemoteException {
        try {
            LanImpl lan = DCManager.getInstance().findLan(lanPK);
            List<EthSwitchImpl> lanSwitches = lan.getEthSwitches();
            HashMap<PKIf, HashSet<Integer>> filteredPortChannelsMap = this.getFilteredPortChannels(lan, switchList);
            this.filterSwitches(lanSwitches);
            Hashtable<PKIf, HashSet<Integer>> retSwitchMap = new Hashtable<PKIf, HashSet<Integer>>();
            if (lanSwitches.size() > 0) {
                Iterator<EthSwitchImpl> it = lanSwitches.iterator();
                SyncedInt pendingSwitches = new SyncedInt(0);
                while (it.hasNext()) {
                    SnmpPeer peer;
                    PKIf swPK;
                    EthSwitchImpl ethSwitch = it.next();
                    if (switchList != null && !switchList.contains(swPK = ethSwitch.getPK()) || !ethSwitch.getBase().isManageable() || (peer = ethSwitch.getPeer()) == null) continue;
                    Object object = pendingSwitches.getLock();
                    synchronized (object) {
                        pendingSwitches.increment();
                        this.getVFCInformationThread(peer, ethSwitch, retSwitchMap, filteredPortChannelsMap, pendingSwitches).start();
                    }
                }
                Object object = pendingSwitches.getLock();
                synchronized (object) {
                    while (pendingSwitches.get() > 0) {
                        pendingSwitches.wait();
                    }
                }
            }
            return retSwitchMap;
        }
        catch (Exception e) {
            _logger.error((Object)"FCoEConfigurationImpl: getVEFCoESwitchList(), Exception occurred while getting VE capable switch list ", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    private void filterSwitches(List<EthSwitchImpl> switches) {
        Iterator<EthSwitchImpl> it = switches.iterator();
        while (it.hasNext()) {
            EthSwitchImpl ethSwitch = it.next();
            EthSwitchBase swBase = ethSwitch.getBase();
            if (swBase == null || !swBase.isManageable()) {
                _logger.info((Object)("FCoEConfigurationImpl: filterSwitches(), Filtering out switch " + ethSwitch.getIpAddress() + ". Switch is not managable."));
                it.remove();
                continue;
            }
            if (swBase.isUCS()) {
                _logger.info((Object)("FCoEConfigurationImpl: filterSwitches(), Filtering out UCS switch " + swBase.getSysName() + ". UCS switches currently block SNMP write-access."));
                it.remove();
                continue;
            }
            if (!FCoEConfigurationHelper.isVeSupported(swBase)) {
                _logger.info((Object)("FCoEConfigurationImpl: filterSwitches(), Filtering out switch " + swBase.getSysName() + ". Switch version does not support VE."));
                it.remove();
                continue;
            }
            if (swBase.isFCoECapable() && (!swBase.isN5K() || swBase.getModelType() != 936)) continue;
            _logger.info((Object)("FCoEConfigurationImpl: filterSwitches(), Filtering out switch " + swBase.getSysName() + ". Switch is not FCoE capable."));
            it.remove();
        }
    }

    public HashMap<PKIf, HashSet<Integer>> getFilteredPortChannels(LanImpl lan, ArrayList<PKIf> switchList) throws RemoteException {
        try {
            HashMap<PKIf, HashSet<Integer>> filteredPortChanneMap = new HashMap<PKIf, HashSet<Integer>>();
            Iterator<EthIslImpl> islIter = lan.getEthIsls().iterator();
            block2: while (islIter.hasNext()) {
                EthIslImpl isl = islIter.next();
                if (!isl.isPortChannel()) continue;
                List<IntPair> memberPorts = isl.getChildrenPairs();
                EthSwitchImpl sw1 = isl.getSwitch1();
                EthSwitchImpl sw2 = isl.getSwitch2();
                EthSwitchBase sw1Base = sw1.getBase();
                EthSwitchBase sw2Base = sw2.getBase();
                if (sw1Base == null || !sw1Base.isManageable() || sw2Base == null || !sw2Base.isManageable() || !sw1Base.isFCoECapable() || !sw2Base.isFCoECapable()) continue;
                if (switchList != null) {
                    PKIf sw1PK = sw1.getPK();
                    PKIf sw2PK = sw2.getPK();
                    if (!switchList.contains(sw1PK) && !switchList.contains(sw2PK)) continue;
                }
                int[] cardTypesSw1 = sw1Base.getCardTypeInSlots();
                int[] cardTypesSw2 = sw2Base.getCardTypeInSlots();
                for (IntPair ifIndexPair : memberPorts) {
                    HashSet<Integer> portChannels;
                    int slot = sw1Base.ifIndex2Card(ifIndexPair._pair[0]);
                    if (cardTypesSw1 != null && !fcoeCardTypes.contains(cardTypesSw1[slot])) {
                        portChannels = filteredPortChanneMap.get(sw1.getPK());
                        if (portChannels == null) {
                            portChannels = new HashSet();
                            filteredPortChanneMap.put(sw1.getPK(), portChannels);
                        }
                        portChannels.add(isl.getIfIndex1());
                        islIter.remove();
                        continue block2;
                    }
                    slot = sw2Base.ifIndex2Card(ifIndexPair._pair[1]);
                    if (cardTypesSw2 == null || fcoeCardTypes.contains(cardTypesSw2[slot])) continue;
                    portChannels = filteredPortChanneMap.get(sw2.getPK());
                    if (portChannels == null) {
                        portChannels = new HashSet();
                        filteredPortChanneMap.put(sw2.getPK(), portChannels);
                    }
                    portChannels.add(isl.getIfIndex2());
                    islIter.remove();
                    continue block2;
                }
            }
            return filteredPortChanneMap;
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationImpl: getFilteredPortChannels(), Failed to get the Port channel map from switch ", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public ArrayList<PKIf> checkUserCredentials(PKIf sw1, PKIf sw2) throws RemoteException {
        ArrayList<PKIf> switchUsers = new ArrayList<PKIf>();
        if (this.snmpPeerMap.get(sw1) == null) {
            switchUsers.add(sw1);
        }
        if (this.snmpPeerMap.get(sw2) == null) {
            switchUsers.add(sw2);
        }
        return switchUsers;
    }

    @Override
    public void setUserCredentials(HashMap<PKIf, SnmpUserOpt> userCredentials) throws RemoteException {
        PKIf[] swPKs;
        this.snmpPeerMap.clear();
        for (PKIf sw : swPKs = userCredentials.keySet().toArray(new PKIf[userCredentials.size()])) {
            EthSwitchImpl swImpl = null;
            try {
                swImpl = this.findSwitch(sw);
                SnmpPeer peer = SnmpPeer.getSnmpPeer(swImpl.getInetAddress(), SnmpSession.getInstance(), userCredentials.get(sw));
                this.snmpPeerMap.put(sw, peer);
            }
            catch (UnknownHostException e1) {
                _logger.error((Object)("FCoEConfigurationImpl: setUserCredentials(), Switch " + sw + " not found."), (Throwable)e1);
                throw new RemoteException(e1.getMessage());
            }
            catch (Exception e) {
                _logger.error((Object)("FCoEConfigurationImpl: setUserCredentials(), Failed to create peer for switch " + swImpl.getBase().getSysName() + "."), (Throwable)e);
                throw new RemoteException("Failed to authenticate switch " + swImpl.getBase().getSysName() + ". Reason :" + e.getMessage());
            }
        }
    }

    @Override
    public void clearCache() {
        this.snmpPeerMap.clear();
    }

    static {
        int[] fcoeAllowedCardTypes = FRUConstants.getAllFCoECapableCardTypes();
        for (int i = 0; i < fcoeAllowedCardTypes.length; ++i) {
            fcoeCardTypes.add(fcoeAllowedCardTypes[i]);
        }
    }
}

