/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.zm.ZoneDataCache;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.sm.FMStandalone;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.SanException;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.facade.SuperSessionImpl;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.GlobalViManager;
import com.cisco.dcbu.sm.server.model.GroupManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import com.cisco.dcbu.vi.model.VirtualMachine;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ModelFacadeImpl
implements ModelFacadeRif,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger _Logger = LogManager.getLogger((String)"fms.session");
    private SessionRif _session;

    public ModelFacadeImpl(boolean sessionBean) throws RemoteException {
    }

    @Override
    public void init(SessionRif session) throws RemoteException {
        this._session = session;
    }

    public ModelFacadeImpl(SessionRif session) throws RemoteException {
        this._session = session;
    }

    private FabricImpl findFabric(FabricPK pkey) throws RemoteException {
        if (pkey == null) {
            throw new RemoteException("findFabric: pkey is null");
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
        this.assertFabric(fabric, pkey);
        return fabric;
    }

    @Override
    public InetAddress getSeedSwitchAddress(FabricPK pkey) throws RemoteException {
        InetAddress ret = null;
        try {
            ret = GlobalFabricManager.getInstance().getSeedSwitchAddress(pkey);
        }
        catch (Exception ex) {
            throw new RemoteException("failed to get seed switchAddress", ex);
        }
        return ret;
    }

    private FabricImpl findManageableFabric(FabricPK pkey) throws RemoteException {
        if (this._session.isManageable(pkey)) {
            FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
            if (fabric != null) {
                return fabric;
            }
            throw new RemoteException(pkey + " not found");
        }
        throw new RemoteException(pkey + " is not managed.");
    }

    @Override
    public GroupBase getGroup(GroupPK groupPK) throws RemoteException {
        return GroupManager.getInstance().getGroup(groupPK);
    }

    @Override
    public GroupBase[] getGroups(FabricPK fabricPK) throws RemoteException {
        return GroupManager.getInstance().getGroups(fabricPK);
    }

    @Override
    public GroupBase addGroup(GroupPK groupPK, short type, PKIf[] members) throws RemoteException {
        try {
            return GroupManager.getInstance().addGroup(groupPK, type, members);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public GroupBase removeGroup(GroupPK groupPK) throws RemoteException {
        try {
            return GroupManager.getInstance().removeGroup(groupPK);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public GroupPK[] removeGroup(String user) throws RemoteException {
        try {
            return GroupManager.getInstance().removeGroup(user);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void updateGroup(GroupPK groupPK, short type, PKIf[] members) throws RemoteException {
        try {
            GroupManager.getInstance().updateGroup(groupPK, type, members);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public GroupBase[] getGroups(String userName) throws RemoteException {
        return GroupManager.getInstance().getGroups(userName);
    }

    @Override
    public GroupBase addGroup(String userName, GroupPK groupPK) throws RemoteException {
        try {
            return GroupManager.getInstance().addGroup(userName, groupPK, true);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public GroupBase[] addGroup(String userName, GroupPK[] groupPKs) throws RemoteException {
        try {
            return GroupManager.getInstance().addGroup(userName, groupPKs, true);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void updateGroup(String user, GroupPK[] groups) throws RemoteException {
        try {
            GroupManager.getInstance().updateUserGroup(user, groups);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public GroupPK[] getUnAssignedGroupPKs(String user) throws RemoteException {
        return GroupManager.getInstance().getUnAssignedGroupPKs(user);
    }

    @Override
    public void syncGroups() throws RemoteException {
        try {
            GroupManager.getInstance().loadGroupsFromDB();
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Error loading all groups  : " + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void closeFabric(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        try {
            SanManager.getInstance().closeFabric(fabric);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setFabricName(FabricPK pkey, String newName) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        if (newName == null) {
            throw new RemoteException("Fabric name can not be blank");
        }
        if (fabric == null) {
            throw new RemoteException("Unable to find fabric.");
        }
        try {
            if (fabric.getFabricName().equals(newName)) {
                return;
            }
            boolean alreadyExists = SanManager.getInstance().checkIfFabricNameExists(newName);
            if (alreadyExists) {
                throw new RemoteException("A fabric already exist with that name.");
            }
            fabric.setFabricName(newName);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public void setFabricVsanScope(FabricPK pkey, String inVsans, String exVsans) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        if (fabric == null) {
            throw new RemoteException("Unable to find fabric.");
        }
        try {
            String inVsanStr = fabric.getIncludedVsanList();
            String exVsanStr = fabric.getExcludedVsanList();
            if (inVsans == null && exVsans == null ? inVsanStr == null && exVsanStr == null : (inVsans == null && exVsans != null ? inVsanStr == null && exVsans.equals(exVsanStr) : (inVsans != null && exVsans == null ? inVsans.equals(inVsanStr) && exVsanStr == null : inVsans.equals(inVsanStr) && exVsans.equals(exVsanStr)))) {
                return;
            }
            fabric.setIncludedVsanList(inVsans);
            fabric.setExcludedVsanList(exVsans);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isDiscovering(FabricPK pkey) throws RemoteException {
        if (pkey == null) {
            return false;
        }
        FabricImpl fabric = this.findFabric(pkey);
        if (fabric != null) {
            return fabric.isDiscovering();
        }
        throw new RemoteException("Fabric " + pkey + " not found");
    }

    @Override
    public boolean isOpened(FabricPK pkey) throws RemoteException {
        if (pkey == null) {
            return false;
        }
        FabricImpl fabric = this.findFabric(pkey);
        if (fabric != null) {
            int status = fabric.getFarbicStatus();
            return status == 2 || status == 4;
        }
        throw new RemoteException("Fabric " + pkey + " not found");
    }

    @Override
    public boolean isCommonSwitchFound(FabricPK[] pkeys) throws RemoteException {
        try {
            return SanManager.getInstance().isCommonSwitchFound(pkeys);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void enablePolling(FabricPK pkey, boolean enable) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        try {
            DiscoveryManager.getInstance().enablePoll(fabric, enable);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isPollingEnabled(FabricPK pkey) throws RemoteException {
        try {
            return this.findFabric(pkey).isPollingEnabled();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getPollInterval(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = null;
        try {
            fabric = this.findFabric(pkey);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fabric != null) {
            return this.findFabric(pkey).getPollInterval();
        }
        int ret = 0;
        try {
            ret = GlobalFabricManager.getInstance().getFabricPollingInterval(pkey);
        }
        catch (SQLException ex) {
            throw new RemoteException("Can not find fabric: " + pkey);
        }
        return ret;
    }

    @Override
    public void setPollInterval(FabricPK pkey, int pollInterval) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        try {
            DiscoveryManager.getInstance().setPollInterval(fabric, pollInterval);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getRediscoverInterval(FabricPK pkey) throws RemoteException {
        try {
            return GlobalFabricManager.getInstance().getFabricRediscoverInterval(pkey);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setRediscoverInterval(FabricPK pkey, int n) throws RemoteException {
        FabricImpl fabric = this.getFabricByPK(pkey);
        try {
            fabric.setRediscoverInterval(n);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setSnmpOptions(FabricPK pkey, int timeout, int retries) throws RemoteException {
        FabricImpl fabric = this.getFabricByPK(pkey);
        try {
            if (timeout != -1) {
                fabric.setTimeout(timeout);
            }
            if (retries != -1) {
                fabric.setRetries(retries);
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    private FabricImpl getFabricByPK(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        this.assertFabric(fabric, pkey);
        return fabric;
    }

    @Override
    public Object[] getFabricCredentials(FabricPK pkey) throws RemoteException {
        SnmpUser user = null;
        try {
            FabricImpl fabric = this.getFabricByPK(pkey);
            user = fabric.getCredentials();
            if (user == null) {
                throw new Exception("getFabricCredentials fabric :" + pkey + ": credentials is missing in cache");
            }
        }
        catch (Exception ex) {
            _Logger.debug((Object)("Retrying to get fabric credential from DB since:  " + ex.getMessage()));
            try {
                user = FabricImpl.getSnmpUser(pkey);
            }
            catch (SQLException e) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
        if (user instanceof CommunityUser) {
            return null;
        }
        UsmUser usmuser = (UsmUser)user;
        return new Object[]{usmuser.getUserName(), new Integer(usmuser.getAuthProtocol())};
    }

    @Override
    public String getFabricName(FabricPK pkey) throws RemoteException {
        if (pkey == null) {
            return null;
        }
        try {
            String ret = GlobalFabricManager.getInstance().getFabricName(pkey);
            return ret;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public SnmpUserOpt getFabricSnmpUserOpt(FabricPK pkey) throws RemoteException {
        SnmpUserOpt snmpUserOpt;
        block8: {
            SnmpUser user = null;
            snmpUserOpt = null;
            if (pkey == null) {
                return snmpUserOpt;
            }
            try {
                FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
                if (fabric != null && (user = fabric.getCredentials()) != null) {
                    snmpUserOpt = new SnmpUserOpt();
                    if (user instanceof CommunityUser) {
                        snmpUserOpt.setV3(false);
                        snmpUserOpt.setCommunity(((CommunityUser)user).getCommunity());
                    } else {
                        UsmUser usmuser = (UsmUser)user;
                        snmpUserOpt.setV3(true);
                        snmpUserOpt.setUsername(usmuser.getUserName());
                        snmpUserOpt.setPassword(usmuser.getAuthPassword());
                        snmpUserOpt.setAuthProtocol(usmuser.getAuthProtocol());
                        snmpUserOpt.setPrivProtocol(usmuser.getPrivacyProtocol());
                    }
                    break block8;
                }
                throw new RemoteException("Can not find fabric or snmp user is null in cache");
            }
            catch (Exception ex) {
                _Logger.debug((Object)("Retrying to get fabric snmp user from DB since:  " + ex.getMessage()));
                try {
                    user = FabricImpl.getSnmpUser(pkey);
                    snmpUserOpt = SessionImpl.convertSnmpUserOpt(user);
                }
                catch (Exception e) {
                    _Logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new RemoteException(ex.getMessage() + ", " + e.getMessage());
                }
            }
        }
        return snmpUserOpt;
    }

    @Override
    public void setFabricCredentials(FabricPK pkey, SnmpUserOpt snmpUserOpt) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        this.assertFabric(fabric, pkey);
        SnmpUser user = SessionImpl.convertSnmpUser(snmpUserOpt);
        try {
            if (fabric.getSwitches().length == 0) {
                fabric.setDBCredentials(user);
            } else {
                SecurityManager.authenticate(user, fabric);
            }
            fabric.setCredentials(user, true);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    private void assertFabric(FabricImpl fabric, FabricPK pkey) throws RemoteException {
        if (fabric == null) {
            throw new RemoteException("Can not find fabric:" + pkey);
        }
    }

    @Override
    public boolean isPersistent(FabricPK pkey) throws RemoteException {
        try {
            return GlobalFabricManager.getInstance().isFabricPersistent(pkey);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setPersistent(FabricPK pkey, boolean isPersistent) throws RemoteException {
        FabricImpl fabric = this._session instanceof SuperSessionImpl ? this.findFabric(pkey) : this.findManageableFabric(pkey);
        if (isPersistent && FMStandalone.isStandAlone()) {
            throw new RemoteException("You can not manage fabric continuously in Stand-Alone mode");
        }
        SanManager.getInstance().persistFabric(fabric, isPersistent);
    }

    @Override
    public void rediscoverFabric(FabricPK pkey, DiscoveryType discType) throws RemoteException {
        if (this._session == null) {
            throw new RemoteException("FM server session is not available");
        }
        try {
            FabricPK[] fpks = null;
            fpks = pkey == null ? this._session.getManageableFabrics() : new FabricPK[]{pkey};
            if (fpks != null) {
                for (int i = 0; i < fpks.length; ++i) {
                    if (this._session.isManageable(fpks[i])) {
                        FabricImpl fabric = SanManager.getInstance().findFabric(fpks[i]);
                        if (fabric == null) continue;
                        DiscoveryManager.getInstance().discoverFabric(fabric, discType);
                        fabric.setDiscoveryType(discType);
                        ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(fpks[i], IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fpks[i].toString() + "' rediscovered", Severity.INFO.getValue(), 0));
                        continue;
                    }
                    throw new RemoteException(pkey + " is not managed.");
                }
                try {
                    ZoneDataCache.getZoneDataCahche().invalidateCache();
                }
                catch (Exception ex) {
                    _Logger.info((Object)("Failed in clearing Zone Manager WS cache " + ex.getMessage()));
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException("rediscover error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void rediscoverFabric(FabricPK pkey) throws RemoteException {
        this.rediscoverFabric(pkey, DiscoveryType.FABRIC_ONDEMAND);
    }

    @Override
    public void rediscoverLun0(FabricPK pkey) throws RemoteException {
        try {
            FabricPK[] fpks = null;
            fpks = pkey == null ? this._session.getManageableFabrics() : new FabricPK[]{pkey};
            if (fpks != null) {
                for (int i = 0; i < fpks.length; ++i) {
                    if (this._session.isManageable(fpks[i])) {
                        FabricImpl fabric = SanManager.getInstance().findFabric(fpks[i]);
                        if (fabric == null) continue;
                        DiscoveryManager.getInstance().discoverLun0(fabric);
                        continue;
                    }
                    throw new RemoteException(pkey + " is not managed.");
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException("rediscover error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public EnclosureBase[] getEnclosures() throws RemoteException {
        try {
            EnclosureImpl[] encls = SanManager.getInstance().getEnclosures();
            EnclosureBase[] encs = new EnclosureBase[encls.length];
            for (int i = 0; i < encs.length; ++i) {
                encs[i] = (EnclosureBase)encls[i].getBaseObject();
            }
            return encs;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<FcPortBase> getFcPortsBySwitch(WwnKey swPK, FabricPK fabricPK) throws RemoteException {
        if (swPK == null) {
            return null;
        }
        return SanManager.getInstance().getFcPortsBySwitch(swPK, fabricPK);
    }

    @Override
    public void purgeAll(FabricPK pkey) throws RemoteException {
        if (pkey == null) {
            return;
        }
        try {
            FabricImpl fabric = this.findFabric(pkey);
            if (fabric != null) {
                fabric.purgeAll();
                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(pkey, IdentityManager.getInstance().getClientAddress(), fabric.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + pkey.toString() + "' purged", Severity.INFO.getValue(), 0));
            }
        }
        catch (SanException sanex) {
            throw sanex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RemoteException("purging " + pkey + " error: " + ex.getMessage());
        }
    }

    @Override
    public void changeIpAddress(PKIf swKey, InetAddress inetAddr) throws RemoteException {
        try {
            if (swKey instanceof WwnKey) {
                SanManager.getInstance().changeSwitchIp((WwnKey)swKey, inetAddr);
            } else if (swKey instanceof SerialNumKey || swKey instanceof VdcPK) {
                DCManager.getInstance().changeSwitchIp(swKey, inetAddr);
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void propertyChanged(FabricPK fabricPK, ChangedModelObject chgObj) throws RemoteException {
        block12: {
            SessionImpl._Logger.info((Object)("change notification from " + this._session.getClient() + " : " + chgObj));
            try {
                if (chgObj._propId == 522) {
                    FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
                    if (fabric != null) {
                        fabric.useFcAlias((Boolean)chgObj.getNewValue());
                    }
                    break block12;
                }
                if (chgObj._propId == 1546) {
                    EndPortImpl ep = SanManager.getInstance().findEndPort((WwnKey)chgObj._objKey, fabricPK);
                    if (ep != null) {
                        ep.setAutoAlias((String)((Object)chgObj.getNewValue()));
                    }
                    break block12;
                }
                if (chgObj._propId == 1558) {
                    EndPortImpl ep = SanManager.getInstance().findEndPort((WwnKey)chgObj._objKey, fabricPK);
                    if (ep != null) {
                        String da = ep.getDeviceAlias();
                        FabricImpl fabric = ep.getFabric();
                        if (fabric != null) {
                            fabric.removeDeviceAlias(da);
                            fabric.createDeviceAlias(ep.getPortWwn(), (String)((Object)chgObj.getNewValue()), -1);
                        }
                    }
                    break block12;
                }
                if (chgObj._propId == 786) {
                    EndPortImpl ep = SanManager.getInstance().findEndPort((WwnKey)chgObj._objKey, fabricPK);
                    if (ep != null) {
                        ArrayList oldFA = (ArrayList)chgObj.getOldValue();
                        int oldVsanId = (Integer)oldFA.get(0);
                        String oldAlias = (String)oldFA.get(1);
                        ArrayList newFA = (ArrayList)chgObj.getNewValue();
                        int newVsanId = (Integer)newFA.get(0);
                        String newAlias = (String)newFA.get(1);
                        ep.removeFcAlias(oldVsanId, oldAlias);
                        ep.createFcAlias(newVsanId, newAlias);
                    }
                    break block12;
                }
                if (chgObj._propId != 1046) break block12;
                SwitchImpl sw = SanManager.getInstance().findSwitch((WwnKey)chgObj.getPK(), fabricPK);
                if (sw != null) {
                    sw.setFeatureFlags((boolean[])chgObj.getNewValue());
                    break block12;
                }
                throw new RemoteException("switch not found");
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public SwitchBase findSwitchByPK(WwnKey swPK) throws RemoteException {
        try {
            SwitchImpl sw = SanManager.getInstance().findSwitch(swPK, null);
            return sw != null ? (SwitchBase)sw.getBaseObject() : null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public Map<SwitchBase, List<Integer>> findVFCIfIndices(List<WwnKey> swPKs) throws RemoteException {
        try {
            HashMap<SwitchBase, List<Integer>> resultMap = new HashMap<SwitchBase, List<Integer>>();
            SanManager sanMInst = SanManager.getInstance();
            for (int i = 0; i < swPKs.size(); ++i) {
                WwnKey swPK = swPKs.get(i);
                SwitchImpl swImpl = sanMInst.findSwitchByPK(swPK);
                if (swImpl == null) continue;
                resultMap.put((SwitchBase)swImpl.getBaseObject(), swImpl.findVFCIfIndices());
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting ports for switches", e);
        }
    }

    @Override
    public List<Integer> findVFCIfIndicesByPK(WwnKey swPK) throws RemoteException {
        try {
            SwitchImpl sw = SanManager.getInstance().findSwitchByPK(swPK);
            return sw != null ? sw.findVFCIfIndices() : null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public IslBase findIslBySwitchIntKey(SwitchIntKey swIntKey) throws RemoteException {
        try {
            IslImpl isl;
            FabricImpl fabric = SanManager.getInstance().findFabricBySwitchPK(swIntKey._swPK, null);
            if (fabric != null && (isl = fabric.findIsl(swIntKey)) != null) {
                return (IslBase)isl.getBaseObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public NpvLinkBase findNpvLinkByFPortPK(SwitchIntKey fportPK) throws RemoteException {
        try {
            NpvLinkImpl npvl;
            FabricImpl fabric = SanManager.getInstance().findFabricBySwitchPK(fportPK._swPK, null);
            if (fabric != null && (npvl = fabric.findNpvLink(fportPK)) != null) {
                return (NpvLinkBase)npvl.getBaseObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<EndPortBase> findEndPortsByPKList(List<WwnKey> epPKs) throws RemoteException {
        try {
            ArrayList<EndPortBase> ret = new ArrayList<EndPortBase>();
            for (WwnKey key : epPKs) {
                EndPortImpl[] eps = SanManager.getInstance().findEndPorts(key);
                for (int i = 0; eps != null && i < eps.length; ++i) {
                    ret.add((EndPortBase)eps[i].getBaseObject());
                }
            }
            return ret;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public EndPortBase findEndPort(WwnKey epPK, FabricPK fPK) throws RemoteException {
        try {
            EndPortImpl ep = SanManager.getInstance().findEndPort(epPK, fPK);
            return ep != null ? (EndPortBase)ep.getBaseObject() : null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public EndPortBase findEndPort(WwnKey epPK) throws RemoteException {
        try {
            EndPortImpl ep = SanManager.getInstance().findEndPort(epPK);
            return ep != null ? (EndPortBase)ep.getBaseObject() : null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public EndPortBase findEndPortByPK(WwnKey epPK) throws RemoteException {
        return this.findEndPort(epPK);
    }

    @Override
    public EnclosureBase findEnclosureByPK(NameKey enclPK) throws RemoteException {
        try {
            EnclosureImpl encl = SanManager.getInstance().findEnclosureByPK(enclPK);
            if (encl != null) {
                return (EnclosureBase)encl.getBaseObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VirtualMachine[] findVirtualMachinesByEnclosurePK(NameKey pkey) throws RemoteException {
        try {
            VirtualMachine[] vms = SanManager.getInstance().findVirtualMachinesByEnclosurePK(pkey);
            return vms;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VsanBase findVsanByPK(VsanPK vsanPK) throws RemoteException {
        try {
            VsanImpl vsan = SanManager.getInstance().findVsan(vsanPK);
            if (vsan != null) {
                return (VsanBase)vsan.getBaseObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public ClusterBase findClusterByPK(ClusterPK clusterPK) throws RemoteException {
        try {
            ClusterImpl cluster = SanManager.getInstance().findCluster(clusterPK);
            if (cluster != null) {
                return (ClusterBase)cluster.getBaseObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public FabricPK findFabricByIpAddress(InetAddress inetAddr) throws RemoteException {
        try {
            FabricPK ret = SanManager.getInstance().findFabricPK(inetAddr);
            if (ret == null) {
                ret = GlobalFabricManager.getInstance().findFabricPK(inetAddr);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public Wwn findSwitchWwn(InetAddress inetAddr) throws RemoteException {
        try {
            SwitchImpl switchImpl = SanManager.getInstance().findSwitchByIP(inetAddr);
            if (switchImpl != null) {
                return switchImpl.getWwn();
            }
            return GlobalFabricManager.getInstance().findSwitchWwn(inetAddr);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<FabricPK> findFabricListByIpAddress(InetAddress inetAddr) throws RemoteException {
        try {
            return GlobalFabricManager.getInstance().findFabricPKs(inetAddr);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public FabricPK findFabricByIpVsans(InetAddress inetAddr, String inVsans, String exVsans) throws RemoteException {
        try {
            FabricPK ret = SanManager.getInstance().findFabricPK(inetAddr, inVsans, exVsans);
            if (ret == null) {
                ret = GlobalFabricManager.getInstance().findFabricPK(inetAddr, inVsans, exVsans);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void updateEnclosures(NameKey[] encPKs, String[] newEncNames, String[] ipAddresses, String[] dmPaths, int[] types, String[] vendors, String[] models, String[] vers, String[] osInfos) throws RemoteException {
        if (encPKs == null) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < encPKs.length; ++i) {
            try {
                sm.updateEnclosure(encPKs[i], newEncNames[i], ipAddresses[i], dmPaths[i], types[i], vendors[i], models[i], vers[i], osInfos[i]);
                continue;
            }
            catch (Exception ex) {
                errMsg.append(ex.getMessage()).append(",\n");
            }
        }
        if (errMsg.length() != 0) {
            errMsg.setLength(errMsg.length() - 2);
            throw new RemoteException(errMsg.toString());
        }
        sm.cleanEnclosure();
    }

    @Override
    public void updateEnclosures(NameKey[] encPKs, WwnKey[] epPKs, FabricPK fpk) throws RemoteException {
        if (encPKs == null) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < encPKs.length; ++i) {
            try {
                sm.updateEndPortEnclosure(fpk, epPKs[i], encPKs[i]);
                continue;
            }
            catch (Exception ex) {
                errMsg.append(ex.getMessage()).append(",\n");
            }
        }
        if (errMsg.length() != 0) {
            errMsg.setLength(errMsg.length() - 2);
            throw new RemoteException(errMsg.toString());
        }
        sm.cleanEnclosure();
    }

    @Override
    public void removeEnclosures(NameKey[] encPKs) throws RemoteException {
        if (encPKs == null) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < encPKs.length; ++i) {
            try {
                sm.removeEnclosure(encPKs[i]);
                continue;
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) continue;
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() != 0) {
            throw new RemoteException(errMsg.toString());
        }
    }

    @Override
    public void deleteFabric(FabricPK pk) throws RemoteException {
        if (pk != null) {
            if (this.isFabricInPmCollection(pk)) {
                String msg = "Cannot remove " + pk + " it is used by Performance Manager, \n" + "Please remove from PM Collections. (Webclient Admin->Performance->Collections)";
                throw new RemoteException(msg);
            }
            try {
                FabricImpl fabric = SanManager.getInstance().findFabric(pk);
                if (fabric != null) {
                    SanManager.getInstance().purgeFabric(fabric);
                }
                SanManager.getInstance().purgeFabricfromDB(pk);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        } else {
            throw new RemoteException("Invalid fabric key " + pk);
        }
    }

    @Override
    public boolean isFabricInPmCollection(FabricPK pkey) throws RemoteException {
        return FMServerImpl.getInstance().isFabricInPmCollection(pkey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void purgeSwitch(FabricPK fpk, WwnKey pk) throws RemoteException {
        if (fpk == null || pk == null) throw new RemoteException("Invalid fabric/switch key " + fpk + ":" + pk);
        SwitchImpl sw = SanManager.getInstance().findSwitch(pk, fpk);
        if (sw == null) throw new RemoteException("Switch does not exist");
        FabricImpl fabric = sw.getFabric();
        if (fabric != null && fabric.isDiscovering()) {
            throw new RemoteException("DCNM is busy polling/discovering this fabric. Please wait and retry again.");
        }
        if (fabric != null && fabric.getNumSwitches() <= 1) {
            throw new RemoteException("Cannot purge the last switch in the fabric");
        }
        try {
            SanManager.getInstance().purgeSwitch(sw);
            return;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Cannot completely purge switch:" + sw), (Throwable)ex);
            throw new RemoteException("Cannot completely purge switch:" + sw + " because of " + ex.getMessage(), ex);
        }
    }

    @Override
    public void purgeIsl(IslPK pk) throws RemoteException {
        if (pk != null) {
            try {
                SanManager.getInstance().purgeIsl(pk);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        } else {
            throw new RemoteException("Invalid ISL key " + pk);
        }
    }

    @Override
    public void purgeNpvLink(SwitchIntKey fpkey) throws RemoteException {
        if (fpkey != null) {
            try {
                SanManager.getInstance().purgeNpvLink(fpkey);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        } else {
            throw new RemoteException("Invalid NPV fabric port key " + fpkey);
        }
    }

    @Override
    public void purgeEndPort(WwnKey pk, FabricPK fPK) throws RemoteException {
        if (pk != null) {
            try {
                SanManager.getInstance().purgeEndPort(pk, fPK);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        } else {
            throw new RemoteException("Invalid EndPort key " + pk);
        }
    }

    @Override
    public void purgeEnclosure(NameKey pk) throws RemoteException {
        if (pk != null) {
            try {
                SanManager.getInstance().purgeEnclosure(pk);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        } else {
            throw new RemoteException("Invalid Enclosure key " + pk);
        }
    }

    public void purgeHba(WwnKey pk) throws RemoteException {
        throw new RemoteException("purging HBA is not supported");
    }

    @Override
    public boolean isFabricOpened(FabricPK pk) throws RemoteException {
        if (pk == null) {
            return false;
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
        if (fabric == null) {
            return GlobalFabricManager.getInstance().isFabricManageable(pk);
        }
        return fabric != null && (fabric.getFarbicStatus() == 2 || fabric.getFarbicStatus() == 4);
    }

    @Override
    public boolean useFcAlias(FabricPK pk) throws RemoteException {
        if (pk == null) {
            return false;
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
        return fabric != null && fabric.useFcAlias();
    }

    @Override
    public SnmpUserOpt getSnmpUserOpt(FabricPK fabricPK) throws RemoteException {
        return this._session.getSnmpUserOpt(fabricPK);
    }

    @Override
    public FabricBase manageFabric(FabricPK fabricPK, SnmpUserOpt snmpUserOpt) throws RemoteException {
        return this._session.getFabric(fabricPK, snmpUserOpt);
    }

    @Override
    public void manageFabric(FabricPK fabricPK) throws RemoteException {
        try {
            FabricImpl fabric = SanManager.getInstance().manageFabric(fabricPK);
            if (fabric == null) {
                String errorStr = "manage fabric failed, can not find fabric in Cache or Database";
                _Logger.error((Object)errorStr);
                throw new RemoteException(errorStr);
            }
            this._session.addManageableFabric(fabricPK, null);
        }
        catch (Exception ex) {
            _Logger.error((Object)"manage fabric failed:", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public FabricPK[] getFabricPKs() throws RemoteException {
        List<FabricPK> ret = GlobalFabricManager.getInstance().getAllNonEmptyFabricPKs();
        return ret.size() != 0 ? ret.toArray(new FabricPK[ret.size()]) : new FabricPK[]{};
    }

    @Override
    public String[][] getInExVsans(FabricPK[] fpks) throws RemoteException {
        return GlobalFabricManager.getInstance().getInExVsans(fpks);
    }

    @Override
    public void unmanageFabric(FabricPK fabricPK) throws RemoteException {
        if (PMImpl.getInstance().isRunning() && this.isFabricInPmCollection(fabricPK)) {
            throw new RemoteException("PM is collecting stats on " + fabricPK + ", please stop PM or remove this fabric from PM collection.");
        }
        try {
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            SanManager.getInstance().unmanageFabric(fabricPK);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void unmanageAllFabrics() throws RemoteException {
        this._session.removeAllManagableFabric();
    }

    @Override
    public boolean isManaged(FabricPK fabricPK) throws RemoteException {
        return GlobalFabricManager.getInstance().isFabricManageable(fabricPK);
    }

    @Override
    public void validateSeedSwitch(InetAddress swIp, SnmpUser user) throws RemoteException {
        try {
            SanManager.getInstance().validateSeedSwitch(swIp, user);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void validateSeedSwitch(InetAddress swIp, SnmpUserOpt snmpUserOpt) throws RemoteException {
        try {
            SanManager.getInstance().validateSeedSwitch(swIp, snmpUserOpt);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isBrcdNpvFabric(FabricPK fabricPK) throws RemoteException {
        try {
            return SanManager.getInstance().isBrcdNpvFabric(fabricPK);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void addBrcdNpvCore(FabricPK fabricPK, InetAddress swIP) throws RemoteException {
        try {
            SanManager.getInstance().addBrcdNpvCore(fabricPK, swIP);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<Card> getCardsWithFeatureEnabled(FabricPK fabricPK, String featureName) throws RemoteException {
        try {
            return SanManager.getInstance().getCardsWithFeatureEnabled(fabricPK, featureName);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<Card> getCardsWithFeatureEnabled(List<SwitchBase> swBases, String featureName) throws RemoteException {
        try {
            SanManager sanM = SanManager.getInstance();
            ArrayList<SwitchImpl> switches = new ArrayList<SwitchImpl>();
            for (SwitchBase nextBase : swBases) {
                SwitchImpl nextSw = sanM.findSwitch((WwnKey)nextBase.getSwitchPK(), nextBase.getFabricPK());
                if (nextSw == null) {
                    throw new Exception("Cannot find the Switch for the key:" + nextBase.getSwitchPK());
                }
                switches.add(nextSw);
            }
            return SanManager.getInstance().getCardsWithFeatureEnabled(switches, featureName);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VirtualCenterBase addVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().createVirtualCenter(0, vcIP, username, passwd, discovery);
            if (vcImpl == null) {
                return null;
            }
            if (discovery) {
                DiscoveryManager.getInstance().discoverVC(vcImpl, DiscoveryType.VI_INITIAL);
            }
            return (VirtualCenterBase)vcImpl.getBaseObject();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VirtualCenterBase removeVirtualCenter(InetAddress vcIP) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().removeVirtualCenter(vcIP);
            return vcImpl == null ? null : (VirtualCenterBase)vcImpl.getBaseObject();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void updateVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().findVirtualCenterByIp(vcIP);
            ViManager.getInstance().updateVirtualCenter(vcIP, username, passwd, discovery);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void manageVirtualCenter(InetAddress vcIP) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().findVirtualCenterByIp(vcIP);
            ViManager.getInstance().manageVirtualCenter(vcIP);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void unManageVirtualCenter(InetAddress vcIP) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().findVirtualCenterByIp(vcIP);
            ViManager.getInstance().unManageVirtualCenter(vcIP);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VirtualCenterBase[] getVirtualCenters() throws RemoteException {
        try {
            return GlobalViManager.getInstance().getAllVCenters();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean rediscoverVirtualCenter(InetAddress vcIP, String username, String passwd) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().findVirtualCenterByIp(vcIP);
            boolean res = ViManager.getInstance().rediscoverVirtualCenter(vcIP, username, passwd);
            return res;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean rediscoverVirtualCenter(InetAddress vcIP) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().findVirtualCenterByIp(vcIP);
            boolean res = ViManager.getInstance().rediscoverVirtualCenter(vcIP);
            return res;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }
}

