/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.server.dmm.DMMHelper;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import com.cisco.dcbu.sm.server.dmm.MediatorFactory;
import com.cisco.dcbu.sm.server.dmm.SshMediator;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobQueryReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobQueryResp;
import com.cisco.dcbu.sm.server.facade.DDMServerImpl;
import com.cisco.dcbu.sm.server.facade.StopWatch;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.util.ArrayList;
import java.util.List;

class QueryThread
extends Thread {
    private DDMSwitch _switch;
    private DDMServerImpl _parent;
    private List<DDMJob> _list;

    public QueryThread(DDMSwitch switch1, DDMServerImpl parent) {
        this._switch = switch1;
        this._parent = parent;
        this._list = new ArrayList<DDMJob>();
    }

    @Override
    public void run() {
        StopWatch jobtimer = new StopWatch();
        if (this._parent._logger.isDebugEnabled()) {
            jobtimer.start();
        }
        String ipAddress = this._switch.getSwitch().getIpAddress();
        try {
            if (this._switch.getSsmCard() == null) {
                return;
            }
            int slotId = this._switch.getSsmCard().getSlotId();
            FabricImpl fabricImpl = SanManager.getInstance().findFabric(this._switch.getSwitch().getFabricPK());
            SnmpUser snmpUser = this._parent.getUser().getSnmpUser(fabricImpl == null ? null : fabricImpl.getPK());
            if (this._parent._logger.isDebugEnabled()) {
                long timeTo = jobtimer.stop();
                this._parent._logger.debug((Object)("QueryThread - Time to get snmpUser info - for - " + this._switch + " - " + timeTo));
            }
            if (snmpUser == null) {
                return;
            }
            String ssmIpAddress = this._parent.getSsmIpAddress(ipAddress, this._switch.getSsmCard(), snmpUser);
            if (ssmIpAddress == null || ssmIpAddress.equals("")) {
                return;
            }
            if (this._parent._logger.isDebugEnabled()) {
                long timeTo = jobtimer.stop();
                this._parent._logger.debug((Object)("QueryThread - Time to get ssm for - " + this._switch + " - " + timeTo));
            }
            Mediator mediator = MediatorFactory.getMediator((short)1, ipAddress, snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getUserName() : ((CommunityUser)snmpUser).getCommunity(), snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getAuthPassword() : null);
            mediator.setUp(ipAddress, ssmIpAddress, false);
            if (this._parent._logger.isDebugEnabled()) {
                long timeTo = jobtimer.stop();
                this._parent._logger.debug((Object)("QueryThread - Time to setup mediator - for - " + this._switch + " - " + timeTo));
            }
            DmmJobQueryReq req = new DmmJobQueryReq();
            req.setAttrBitMap((short)24575);
            req.setJobId(new ArrayList());
            req.setNumJob((byte)0);
            req.setPduHdr(SshMediator.getHeader((byte)1, req));
            if (this._parent._logger.isDebugEnabled()) {
                long timeTo = jobtimer.stop();
                this._parent._logger.debug((Object)("QueryThread - Time to create job query pdu - for - " + this._switch + " -  " + timeTo));
            }
            DmmJobQueryResp resp = (DmmJobQueryResp)mediator.sendRecv((short)1, req);
            if (this._parent._logger.isDebugEnabled()) {
                long timeTo = jobtimer.stop();
                this._parent._logger.debug((Object)("QueryThread - Time to get job list from switch - for - " + this._switch + " number of jobs - " + resp.getNumJob() + " - " + timeTo));
            }
            for (int k = 0; k < resp.getNumJob(); ++k) {
                DDMJob dJob = DMMHelper.getInstance().toDDMJob((DmmJobInfo)resp.getJobs().get(k), this._switch);
                dJob.setSsm1(this._switch);
                this._list.add(dJob);
            }
            mediator.disconnect();
        }
        catch (Exception t) {
            t.printStackTrace();
            return;
        }
    }

    public List<DDMJob> getList() {
        return this._list;
    }
}

