/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.rif.SuperSessionRif;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import java.rmi.RemoteException;

public class SuperSessionImpl
extends SessionImpl
implements SuperSessionRif {
    private static final long serialVersionUID = 1L;

    public SuperSessionImpl(boolean sessionB) throws RemoteException {
        super(sessionB);
    }

    public SuperSessionImpl(String client, FMUser user) throws RemoteException {
        super(client, user);
    }

    @Override
    public int getMaxSessions() throws RemoteException {
        Integer maxopen = Integer.getInteger("session.maxopen");
        return maxopen == null ? 0 : maxopen;
    }

    @Override
    public void setMaxSessions(int maxNum) throws RemoteException {
        System.setProperty("session.maxopen", String.valueOf(maxNum));
    }

    @Override
    public void killSession(int sessionId) throws RemoteException {
        try {
            SessionRif s = FMSessionManager.getInstance().findSession(sessionId);
            if (s != null) {
                if (s.getDetails()._sessionId == this._sessionId) {
                    throw new RemoteException("You cannot kill your own session");
                }
                s.logoff();
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getMaxFabrics() throws RemoteException {
        Integer maxopen = Integer.getInteger("fabric.maxopen");
        return maxopen == null ? 0 : maxopen;
    }

    @Override
    public void setMaxFabrics(int maxNum) throws RemoteException {
        System.setProperty("fabric.maxopen", String.valueOf(maxNum));
    }

    @Override
    public void resetFailedAttempts(String username) throws RemoteException {
        try {
            FMUserFailedAttempts.getInstance().purgeFailedAttempt(username);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }
}

