/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.fc.CheckData;
import com.cisco.dcbu.sm.server.fc.FabricCheckTable;
import com.cisco.dcbu.sm.server.fc.ResolveData;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import org.w3c.dom.Node;

class FabricCheckVsanTable
extends FabricCheckTable {
    static final int[] _interopValueOid = MibNode.get("vsanInterOperValue").getOid();
    static final MibNode _interopModeNode = MibNode.get("vsanInterOperMode");
    static final MibNode _ficonStatModeNode = MibNode.get("cficonVsanFiconState");
    private SnmpPDU[] _ficonPdus;

    FabricCheckVsanTable() {
    }

    @Override
    protected SnmpVarBind buidPolicyFileVarBind(Node rootNd, int[] oid, SnmpVar theVar) {
        String refVersion = this.getSwVersionFromFile(rootNd);
        SnmpOID theOid = new SnmpOID(oid);
        int vsanIndex = oid[oid.length - 1];
        if (refVersion.indexOf("1.2") == -1 && MibNode.lookupOid(oid) == _interopModeNode) {
            SnmpInt intVar = (SnmpInt)theVar;
            int newVal = intVar.getValue() == 2 ? 0 : 1;
            intVar.setValue(newVal);
            theOid = new SnmpOID(_interopValueOid, vsanIndex);
        }
        return new SnmpVarBind(theOid, theVar);
    }

    @Override
    protected void modifyForVersion(SnmpPeer peer, int attrLen, SnmpPDU response) {
        response.setVariables(this.modifySwitchResponse(peer, attrLen, response.getVariables()));
    }

    @Override
    protected void addData(SnmpPeer peer, boolean resolvable, String type, String description, ResolveData data) {
        boolean canResolve = resolvable;
        FabricPK[] pks = SanManager.getInstance().getFabricPKs();
        SwitchImpl sw = null;
        for (FabricPK fKey : pks) {
            sw = SanManager.getInstance().findSwitch(peer.getAddress(), fKey);
            if (sw != null) break;
        }
        if (sw != null && !sw.isVersionGreaterThanEqual("1.2(0)") && data != null && data._varBinds != null) {
            for (int i = 0; i < data._varBinds.length; ++i) {
                Array arVbnd = (Array)data._varBinds[i];
                int maxj = arVbnd.size();
                for (int j = 0; j < maxj; ++j) {
                    SnmpVarBind vbnd = (SnmpVarBind)arVbnd.elementAt(j);
                    if (MibNode.lookupOid(vbnd.getOid().getValue()) != MibNode.lookupOid(_interopValueOid)) continue;
                    int val = ((SnmpInt)vbnd.getVar()).getValue();
                    if (val >= 2) {
                        canResolve = false;
                        continue;
                    }
                    SnmpInt newInt = new SnmpInt(val == 0 ? 2 : 1);
                    int[] theOid = vbnd.getOid().getValue();
                    int vsanIndex = theOid[theOid.length - 1];
                    SnmpVarBind vbndNew = new SnmpVarBind(new SnmpOID(_interopModeNode.getOid(), vsanIndex), newInt);
                    arVbnd.setElementAt(vbndNew, j);
                }
            }
        }
        super.addData(peer, canResolve, type, description, data);
    }

    @Override
    protected VarBindList getRefData(String[] attrs, SnmpPeer peer, FabricPK fpk) throws SnmpException {
        VarBindList response = super.getRefData(attrs, peer, fpk);
        return this.modifySwitchResponse(peer, attrs.length, response);
    }

    @Override
    public void addToFile(SnmpPeer peer, String category, CheckData chkAttrs, Node elNd, FabricPK fpk) throws SnmpException {
        VarBindList vbLs = new VarBindList();
        vbLs.add(MibNode.get("cficonVsanFiconState").getOid());
        this._ficonPdus = new SnmpAggregrate().getBulk(new SnmpPeer[]{peer}, vbLs);
        super.addToFile(peer, category, chkAttrs, elNd, fpk);
    }

    private VarBindList modifySwitchResponse(SnmpPeer peer, int attrLen, VarBindList vbLstResp) {
        FabricPK[] pks = SanManager.getInstance().getFabricPKs();
        SwitchImpl sw = null;
        for (FabricPK fKey : pks) {
            sw = SanManager.getInstance().findSwitch(peer.getAddress(), fKey);
            if (sw != null) break;
        }
        boolean ver12OrHigh = sw.isVersionGreaterThanEqual("1.2(0)");
        VarBindList vbLst = new VarBindList();
        for (int i = 0; i < vbLstResp.size(); i += attrLen) {
            int[] vsanOid = vbLstResp.getVb(i).getOid().getValue();
            int vsanIndex = vsanOid[vsanOid.length - 1];
            for (int j = 0; j < attrLen - 2; ++j) {
                vbLst.add(vbLstResp.getVb(i + j));
            }
            if (!ver12OrHigh) {
                int val = vbLstResp.intValue(i + attrLen - 1) == 2 ? 0 : 1;
                SnmpVarBind newVb = new SnmpVarBind(new SnmpOID(_interopValueOid, vsanIndex), new SnmpInt(val));
                vbLst.add(newVb);
            } else {
                vbLst.add(vbLstResp.getVb(i + attrLen - 2));
            }
            SnmpVarBind newVb = new SnmpVarBind(new SnmpOID(_ficonStatModeNode.getOid(), vsanIndex), new SnmpInt(this.isFiconVsan(vsanIndex, peer) ? 4 : 0));
            vbLst.add(newVb);
        }
        return vbLst;
    }

    private boolean isFiconVsan(int vsanId, SnmpPeer peer) {
        if (this._ficonPdus == null) {
            return false;
        }
        for (int i = 0; i < this._ficonPdus.length; ++i) {
            VarBindList vbLst;
            SnmpPDU pdu = this._ficonPdus[i];
            if (!pdu.getAddress().equals(peer.getAddress()) || (vbLst = pdu.getVariables()) == null) continue;
            for (int k = 0; k < vbLst.size(); ++k) {
                int[] oid = vbLst.getVb(k).getOid().getValue();
                if (oid[oid.length - 1] != vsanId) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd, FabricPK fpk) throws SnmpException {
        SnmpPeer[] allPeers = new SnmpPeer[peers.size() + (peer != null ? 1 : 0)];
        if (peer != null) {
            allPeers[peers.size()] = peer;
        }
        for (int i = 0; i < peers.size(); ++i) {
            allPeers[i] = (SnmpPeer)peers.elementAt(i);
        }
        VarBindList vbLs = new VarBindList();
        vbLs.add(MibNode.get("cficonVsanFiconState").getOid());
        this._ficonPdus = new SnmpAggregrate().getBulk(allPeers, vbLs);
        super.doIt(peer, peers, category, chkAttrs, data, rowAddRm, rtNd, fpk);
    }

    @Override
    protected void checkMismatch(SnmpPeer peer, String name, FabricCheckTable.SnmpRow sRow, Array target, int targetIndex) {
        if (this._checkMismatch) {
            FabricCheckTable.SnmpRow tRow = (FabricCheckTable.SnmpRow)target.elementAt(targetIndex);
            boolean isTargetFicon = ((SnmpInt)tRow._vars[tRow._vars.length - 1].getVar()).getValue() == 4;
            int vsanIndex = tRow._index[tRow._index.length - 1];
            for (int j = 0; j < sRow._vars.length; ++j) {
                if (this.equals(sRow._vars[j].getVar(), tRow._vars[j].getVar())) continue;
                Array<SnmpVarBind> varbind = new Array<SnmpVarBind>();
                varbind.addElement(sRow._vars[j]);
                if (MibNode.lookupOid(sRow._vars[j].getOid().getValue()) == _ficonStatModeNode) {
                    this.addData(peer, false, name, "Mismatch Ficon " + (isTargetFicon ? "enabled" : "disabled") + " Vsan " + vsanIndex, null);
                    continue;
                }
                this.addData(peer, true, name, this.buildMismatchmessage(tRow, j), new ResolveData(varbind, this._rndr));
            }
        }
        target.removeElementAt(targetIndex);
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        StringBuffer missing = new StringBuffer();
        StringBuffer missingFicon = new StringBuffer();
        boolean resolvable = this._rowAddRm != null;
        this._lastTargetIndex = this.buildLastIndex(target);
        Array varbinds = new Array();
        for (int i = 0; i < source.size(); ++i) {
            FabricCheckTable.SnmpRow sRow = (FabricCheckTable.SnmpRow)source.elementAt(i);
            int targetIndex = this.findRow(sRow, target);
            if (targetIndex == -1) {
                boolean isFicon;
                int vsanIndex = sRow._index[sRow._index.length - 1];
                boolean bl = isFicon = ((SnmpInt)sRow._vars[sRow._vars.length - 1].getVar()).getValue() == 4;
                if (!isFicon) {
                    this.checkMissing(peer, name, varbinds, missing, sRow);
                    varbinds.removeElementAt(varbinds.size() - 1);
                    continue;
                }
                if (missingFicon.length() == 0) {
                    missingFicon.append("Missing Ficon VSAN(s):");
                } else {
                    missingFicon.append(", ");
                }
                missingFicon.append(vsanIndex);
                continue;
            }
            this.checkMismatch(peer, name, sRow, target, targetIndex);
        }
        if (missing.length() > 0) {
            this.addData(peer, resolvable, name, missing.toString(), new ResolveData(varbinds, this._rndr));
        }
        if (missingFicon.length() > 0) {
            this.addData(peer, false, name, missingFicon.toString(), null);
        }
        if (this._checkExtra) {
            this.checkExtra(peer, name, target);
        }
    }
}

