/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.flexattach.BasicRunnable;
import java.util.ArrayList;
import java.util.List;

public class FlexAtahVPWWNRunnable
extends BasicRunnable {
    static final int[] _cfaPwwnVirtualWwnMapRowStatusOid = MibNode.get("cfaPwwnVirtualWwnMapRowStatus").getOid();
    static final int[] _cfaPwwnVirtualWwnMapVpwwnOid = MibNode.get("cfaPwwnVirtualWwnMapVpwwn").getOid();
    private int _jobType;
    private long _requestId;
    private SwitchBase _sw;
    private List<FlexAtahVPWWN> _vPWWNs;
    private List<FlexAtahVPWWN> _existingVPWWNs;
    private SnmpUserOpt _snmpUserOpt;
    private CommunicationObjectSender _sender;

    public FlexAtahVPWWNRunnable(int jobType, long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender, List<FlexAtahVPWWN> existingVPWWNs, List<FlexAtahVPWWN> vPWWNs) {
        this._jobType = jobType;
        this._requestId = requestId;
        this._sw = sw;
        this._vPWWNs = vPWWNs;
        this._existingVPWWNs = existingVPWWNs;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahVPWWNRunnable called for sw -" + sw + " for existingVPWWNs - " + existingVPWWNs + " -- setVPWWNs - " + this._vPWWNs + " for jobType - " + jobType));
        }
    }

    @Override
    public void run() {
        try {
            switch (this._jobType) {
                case 3: {
                    try {
                        QueueResponseObject portResults = this.setFlexAtahVPWWN();
                        this._sender.send(portResults);
                        break;
                    }
                    catch (Exception se) {
                        if (se.getMessage().indexOf("requested config change not allowed") != -1) {
                            throw new Exception(se.getMessage().trim() + ", please check that your switch rebooted after last NPV mode change.");
                        }
                        throw se;
                    }
                }
            }
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set FlexAttach port Config for switch/requestId:" + this._sw.toString() + "/" + this._requestId + " received error: " + se.getMessage()));
            }
            if (!this._isExceptionClear) {
                this._isOK = false;
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    private QueueResponseObject setFlexAtahVPWWN() throws Exception {
        int i;
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        if (FlexAtahVPWWNRunnable.isCFSPending(peer, null)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"FlexAtahVPWWNRunnable::setFlexAtahVPWWN cfs locked,  please clear lock first.");
            }
            throw new Exception("cfs locked,  please clear lock first.");
        }
        ArrayList<VarBindList> newVL = new ArrayList<VarBindList>();
        VarBindList varList = new VarBindList();
        for (i = 0; i < this._vPWWNs.size(); ++i) {
            FlexAtahVPWWN nextVPWWN = this._vPWWNs.get(i);
            Wwn newPWWN = nextVPWWN.getSvrWWN();
            Wwn newVPWWN = nextVPWWN.getSvrVPWWN();
            byte[] b = newPWWN.getValue();
            int[] index = new int[b.length];
            for (int k = 0; k < b.length; ++k) {
                index[k] = b[k] & 0xFF;
            }
            boolean found = false;
            for (int j = this._existingVPWWNs.size() - 1; j >= 0; --j) {
                FlexAtahVPWWN oldVP = this._existingVPWWNs.get(j);
                if (!newPWWN.equals(oldVP.getSvrWWN())) continue;
                if (!newVPWWN.equals(oldVP.getSvrVPWWN())) {
                    varList.add(_cfaPwwnVirtualWwnMapVpwwnOid, index, (SnmpVar)new SnmpString(nextVPWWN.getSvrVPWWN().getValue()));
                }
                this._existingVPWWNs.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            VarBindList vl = new VarBindList();
            vl.add(_cfaPwwnVirtualWwnMapRowStatusOid, index, (SnmpVar)new SnmpInt(4));
            vl.add(_cfaPwwnVirtualWwnMapVpwwnOid, index, (SnmpVar)new SnmpString(nextVPWWN.getSvrVPWWN().getValue()));
            newVL.add(vl);
        }
        for (i = 0; i < this._existingVPWWNs.size(); ++i) {
            Wwn vp = this._existingVPWWNs.get(i).getSvrWWN();
            byte[] b = vp.getValue();
            int[] index = new int[b.length];
            for (int k = 0; k < b.length; ++k) {
                index[k] = b[k] & 0xFF;
            }
            varList.add(_cfaPwwnVirtualWwnMapRowStatusOid, index, (SnmpVar)new SnmpInt(6));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahVPWWNRunnable::setFlexAtahVPWWN for sw -" + this._sw + " for existingVPWWNs - " + this._existingVPWWNs + " -- setVPWWNs - " + this._vPWWNs + " for jobType - " + this._jobType + " varList - " + varList.toString()));
        }
        try {
            if (varList.size() > 0) {
                SnmpFetch.set(peer, varList);
            }
            for (i = 0; i < newVL.size(); ++i) {
                SnmpFetch.set(peer, (VarBindList)newVL.get(i));
            }
        }
        catch (SnmpException ex) {
            StringBuffer errString = this.handleSetConfigException(this._sw, peer, varList, ex);
            this._isExceptionClear = true;
            throw new Exception(errString.toString());
        }
        try {
            VarBindList varList1 = new VarBindList();
            varList1.add(_cfsFeatureOpActionOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(4));
            varList1.add(_cfsFeatureOpScopeTypeOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(1));
            varList1.add(_cfsFeatureOpScopeValOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpString(new byte[0]));
            SnmpFetch.set(peer, varList1);
        }
        catch (SnmpException ex) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("FlexAtahVPWWNRunnable::setFlexAtahVPWWN cfs commit SET failed, ex=" + ex));
            }
            throw new Exception("cfs commit SET failed, ex=" + ex);
        }
        this.doPoll(peer, 4, "");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahVPWWNRunnable::setFlexAtahVPWWN success  sw/requestId=" + this._sw + "/" + this._requestId));
        }
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }
}

