/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.flexattach.Job;
import java.util.List;

public class SwitchJob
extends Job {
    private List<SwitchBase> _jobSwitchObjects;
    private List<SnmpUserOpt> _snmpCreds;
    private CommunicationObjectSender _commObjSender;
    private Object _extraData = null;

    public SwitchJob(int jobType, long requestId, List<SwitchBase> jobSwitches, List<SnmpUserOpt> snmpCreds) throws IllegalArgumentException {
        super(jobType, requestId);
        if (snmpCreds == null || snmpCreds.size() <= 0) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for switches.");
        }
        if (jobSwitches == null || jobSwitches.size() == 0) {
            throw new IllegalArgumentException("Must provide at least one switch to perform the action upon.");
        }
        if (jobSwitches != null && jobSwitches.size() > snmpCreds.size()) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for all switches.");
        }
        this._jobSwitchObjects = jobSwitches;
        this._snmpCreds = snmpCreds;
    }

    public List<SwitchBase> getSwitchObjects() {
        return this._jobSwitchObjects;
    }

    public List<SnmpUserOpt> getSnnpCreds() {
        return this._snmpCreds;
    }

    public CommunicationObjectSender getSender() {
        return this._commObjSender;
    }

    public void setSender(CommunicationObjectSender commObj) {
        this._commObjSender = commObj;
    }

    @Override
    public String toString() {
        String strSuper = super.toString();
        StringBuilder str = new StringBuilder(strSuper);
        str.append(" sender - ").append(this._commObjSender);
        str.append(" snmpCreds - ").append(this._snmpCreds);
        str.append(" jobSwitchObjects - ").append(this._jobSwitchObjects);
        return str.toString();
    }

    public Object getExtraData() {
        return this._extraData;
    }

    public void setExtraData(Object extraData) {
        this._extraData = extraData;
    }
}

