/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.comm;

import com.cisco.dcbu.sm.server.ioa.comm.SwitchCommFactory;
import com.cisco.dcbu.sm.server.ioa.comm.Vsh;
import com.cisco.dcbu.sm.server.ioa.exception.IOAException;
import com.cisco.dcbu.sm.server.ioa.exception.IOASwitchCommunicationException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IOACLIHandler {
    private String clusterName = null;
    private String switchIP = null;
    private String user = null;
    private String pwd = null;
    private boolean isEncrypted = true;
    private String msgIn = null;
    static Logger _Logger = Logger.getLogger((String)"IOA_SRV");

    public String sendReceive(String msgOut) throws IOAException {
        Vsh _vsh = null;
        msgOut = msgOut + "\n";
        _Logger.debug((Object)("Obtaining a session for user " + this.user + " cluster " + this.clusterName + " to switch " + this.switchIP));
        try {
            SwitchCommFactory commFactory = SwitchCommFactory.getInstance();
            _vsh = commFactory.getCLISshSession(this.clusterName, this.switchIP, this.user, this.pwd, this.isEncrypted);
        }
        catch (IOASwitchCommunicationException swe) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw swe;
        }
        catch (IOAException se) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw se;
        }
        if (_vsh != null) {
            try {
                _Logger.debug((Object)("Sending message to " + _vsh.getHost()));
                _vsh.send(msgOut);
                this.msgIn = _vsh.readPrompt();
                _Logger.debug((Object)("Received message from " + _vsh.getHost()));
                _vsh.disconnect();
            }
            catch (IOException ioe) {
                if (_vsh != null) {
                    _vsh.disconnect();
                }
                throw new IOASwitchCommunicationException(ioe.getMessage());
            }
        } else {
            _Logger.warn((Object)("No Session could be obtained for user " + this.user + " cluster " + this.clusterName + " to switch " + this.switchIP));
            throw new IOASwitchCommunicationException("No Session can be initialized for switch: " + this.switchIP + "for user: " + this.user);
        }
        return this.msgIn;
    }

    public IOACLIHandler(String clusterName, String switchIP, String userName, String password) {
        this.clusterName = clusterName;
        this.user = userName;
        this.pwd = password;
        this.switchIP = switchIP;
    }
}

