/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.xmltool;

import com.cisco.dcbu.sm.server.ioa.xmltool.IO;
import com.cisco.dcbu.sm.server.ioa.xmltool.SimpleType;
import com.cisco.dcbu.sm.server.ioa.xmltool.Struct;

public class Data {
    private SimpleType[] simpleType;
    private int simpleTypeIndex = 0;
    private Struct[] struct = new Struct[1000];
    private int structindex = 0;

    public Data() {
        this.simpleType = new SimpleType[1000];
    }

    public SimpleType getSimpleType(int index) {
        return this.simpleType[index];
    }

    public SimpleType getLastSimpleType() {
        return this.simpleType[this.simpleTypeIndex - 1];
    }

    public void setSimpleType(SimpleType simpleType) {
        this.simpleType[this.simpleTypeIndex++] = simpleType;
    }

    public void setLastSimpleTypes(SimpleType simpleType) {
        this.simpleType[this.simpleTypeIndex - 1] = simpleType;
    }

    public Struct getStruct(int index) {
        return this.struct[index];
    }

    public Struct getLastStruct() {
        return this.struct[this.structindex - 1];
    }

    public void setStruct(Struct struct) {
        this.struct[this.structindex++] = struct;
    }

    public void setLastStruct(Struct struct) {
        this.struct[this.structindex - 1] = struct;
    }

    public Struct getStructbyType(String type) {
        for (int i = 0; i < this.structindex; ++i) {
            if (!this.struct[i].getStructName().equalsIgnoreCase(type)) continue;
            return this.struct[i];
        }
        return null;
    }

    public Struct[] getAllStruct() {
        return this.struct;
    }

    public void sortEnumLists() {
        for (int i = 0; i < this.simpleTypeIndex; ++i) {
            this.simpleType[i].sortEnumLists();
        }
    }

    public void print() {
        int i;
        for (i = 0; i < this.structindex; ++i) {
            this.struct[i].print();
        }
        System.out.println("simpletypes:::");
        for (i = 0; i < this.simpleTypeIndex; ++i) {
            this.simpleType[i].print();
        }
    }

    public void generateCStructures(IO io, Data data) {
        int i;
        io.writetofile(" ");
        io.writetofile("/* simple Types defined in the schema*/");
        for (i = 0; i < this.simpleTypeIndex; ++i) {
            if (!this.simpleType[i].isShouldDefine() || this.simpleType[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.simpleType[i].generateSimpleTypeDefs(io);
        }
        io.writetofile(" ");
        io.writetofile("/* enumns to identify union member */");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCStructuresPass2(io, data);
        }
        io.writetofile(" ");
        io.writetofile("/* macros for offset (variable lenght arrays) */");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCStructuresPass4(io, data);
        }
        io.writetofile(" ");
        io.writetofile("/* struct/union definitions */");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCStructuresPass5(io, data);
        }
    }

    public void generateCEnums(IO io, Data data) {
        io.writetofile(" ");
        io.writetofile("/* enums defined in the schema*/");
        for (int i = this.simpleTypeIndex - 1; i >= 0; --i) {
            if (this.simpleType[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.simpleType[i].generateCEnums(io, data);
        }
    }

    public void generateDefines(IO io, Data data) {
        int i;
        io.writetofile(" ");
        for (i = 0; i < this.simpleTypeIndex; ++i) {
            if (this.simpleType[i].getDefineName().length() == 0 || this.simpleType[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            io.writetofile("#define " + this.simpleType[i].getDefineName() + "   " + this.simpleType[i].getMaxLength());
        }
        io.writetofile(" ");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateDefines(io, data);
        }
    }

    public SimpleType getSimpleTypeByName(String name) {
        for (int i = 0; i < this.simpleTypeIndex; ++i) {
            if (!this.simpleType[i].getName().equalsIgnoreCase(name)) continue;
            return this.simpleType[i];
        }
        return null;
    }

    public void generateCParseFunctions(IO io, Data data) {
        for (int i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCParseFunctions(io, data);
        }
    }

    public void generateCBuildFunctions(IO io, Data data) {
        for (int i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCBuildFunctions(io, data);
        }
    }

    public void generateCParseFunctionsDefines(IO io, Data data) {
        for (int i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCParseFunctionsDefines(io, data);
        }
    }

    public void generateCBuildFunctionsDefines(IO io, Data data) {
        for (int i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateCBuildFunctionsDefines(io, data);
        }
    }

    public void generateEndianFunctionsDefines(IO io, Data data) {
        int i;
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateEndianConversion(io, data, true, true);
        }
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateEndianConversion(io, data, false, true);
        }
    }

    public void generateEndianFunctions(IO io, Data data) {
        int i;
        io.writetofile("\n/*------------------------------------------------------------------------*\n *                ntoh functions for all the structures\n *------------------------------------------------------------------------*/\n\n");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateEndianConversion(io, data, true, false);
        }
        io.writetofile("\n/*------------------------------------------------------------------------*\n *                hton functions for all the structures\n *------------------------------------------------------------------------*/\n\n");
        for (i = 0; i < this.structindex; ++i) {
            if (this.struct[i].isHidden() != Boolean.FALSE.booleanValue()) continue;
            this.struct[i].generateEndianConversion(io, data, false, false);
        }
    }

    public boolean isSimpleType(String name) {
        for (int i = 0; i < this.simpleTypeIndex; ++i) {
            if (!this.simpleType[i].getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

