/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.xmltool;

import com.cisco.dcbu.sm.server.ioa.xmltool.Data;
import com.cisco.dcbu.sm.server.ioa.xmltool.EnumList;
import com.cisco.dcbu.sm.server.ioa.xmltool.IO;
import com.cisco.dcbu.sm.server.ioa.xmltool.SimpleType;
import com.cisco.dcbu.sm.server.ioa.xmltool.Struct;
import com.cisco.dcbu.sm.server.ioa.xmltool.StructElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDParse {
    private Data data = new Data();
    private final String TAB = "     ";

    public void print() {
        System.out.println(" ");
        System.out.println("Printing Data ");
        this.data.print();
    }

    public void generateCBuildFunctions(IO io) {
        System.out.println(" ");
        System.out.println("Generating C Build functions in file");
        this.data.generateCBuildFunctions(io, this.data);
    }

    public void generateCParseFunctions(IO io) {
        System.out.println(" ");
        System.out.println("Generating C Parse functions in file");
        this.data.generateCParseFunctions(io, this.data);
    }

    public void generateCBuildFunctionsDefines(IO io) {
        System.out.println(" ");
        System.out.println("Generating C Build functions in file");
        this.data.generateCBuildFunctionsDefines(io, this.data);
    }

    public void generateCParseFunctionsDefines(IO io) {
        System.out.println(" ");
        System.out.println("Generating C Parse functions in file");
        this.data.generateCParseFunctionsDefines(io, this.data);
    }

    public void generateCStructures(IO io) {
        this.data.sortEnumLists();
        System.out.println(" ");
        System.out.println("Generating C Datastructures in file");
        this.data.generateCStructures(io, this.data);
    }

    public void generateCEnums(IO io) {
        this.data.sortEnumLists();
        System.out.println(" ");
        System.out.println("Generating C Enums in file");
        this.data.generateCEnums(io, this.data);
    }

    public void generateCDefines(IO io) {
        System.out.println(" ");
        System.out.println("Generating C Defines in file");
        this.data.generateDefines(io, this.data);
    }

    public void generateEndianFunctionsDefines(IO io) {
        System.out.println(" ");
        System.out.println("Generating Endian functions defines in file");
        this.data.generateEndianFunctionsDefines(io, this.data);
    }

    public void generateEndianFunctions(IO io) {
        System.out.println(" ");
        System.out.println("Generating Endian functions in file");
        this.data.generateEndianFunctions(io, this.data);
    }

    public static Node getNodeByName(Element ele, String tagName) {
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            return nl.item(0);
        }
        return null;
    }

    public void parse(Element node, Boolean hidden) {
        if (node == null) {
            return;
        }
        if (node.getNodeName().equals("xsd:simpleType")) {
            System.out.println("Simple Type: " + node.getAttribute("name"));
            System.out.println("Simple Type define name: " + node.getAttribute("xtra:defineName"));
            Element restrictionNode = (Element)XSDParse.getNodeByName(node, "xsd:restriction");
            Element maxLengthNode = (Element)XSDParse.getNodeByName(node, "xsd:maxLength");
            Element minLengthNode = (Element)XSDParse.getNodeByName(node, "xsd:minLength");
            if (restrictionNode != null) {
                System.out.println("     restriction: " + restrictionNode.getAttribute("base"));
            }
            if (maxLengthNode != null) {
                System.out.println("     maxLength: " + maxLengthNode.getAttribute("value"));
            }
            if (minLengthNode != null) {
                System.out.println("     minLength: " + minLengthNode.getAttribute("value"));
            }
            SimpleType simpleType = new SimpleType();
            simpleType.setHidden(hidden);
            simpleType.setName(node.getAttribute("name"));
            simpleType.setDefineName(node.getAttribute("xtra:defineName"));
            if (node.getAttribute("xtra:generateCDefinition").equalsIgnoreCase("NO")) {
                simpleType.setShouldDefine(false);
            }
            if (restrictionNode != null) {
                simpleType.setType(restrictionNode.getAttribute("base"));
                Element enumNode = (Element)XSDParse.getNodeByName(restrictionNode, "xsd:enumeration");
                while (enumNode != null) {
                    if (enumNode.getNodeName().equalsIgnoreCase("xsd:enumeration")) {
                        EnumList enumitem = new EnumList();
                        enumitem.setLable(enumNode.getAttribute("value"));
                        simpleType.setEnumList(enumitem);
                        simpleType.setEnumeration(true);
                    }
                    enumNode = (Element)enumNode.getNextSibling().getNextSibling();
                }
            }
            if (maxLengthNode != null) {
                simpleType.setMaxLength(new Integer(maxLengthNode.getAttribute("value")));
            }
            if (minLengthNode != null) {
                simpleType.setMinLength(new Integer(minLengthNode.getAttribute("value")));
            }
            this.data.setSimpleType(simpleType);
        }
        if (node.getNodeName().equals("xsd:complexType")) {
            System.out.println(" ");
            System.out.println("Structure: " + node.getAttribute("name") + " has:");
            Struct struct = new Struct();
            struct.setHidden(hidden);
            struct.setStructName(node.getAttribute("name"));
            if (node.getAttribute("xtra:generateCDefinition").equalsIgnoreCase("NO")) {
                struct.setShouldDefine(false);
            }
            this.data.setStruct(struct);
        } else if (node.getNodeName().equals("xsd:element")) {
            System.out.println("   Element: " + node.getAttribute("name") + " type: " + node.getAttribute("type") + " minOccurs: " + node.getAttribute("minOccurs") + " maxOccurs: " + node.getAttribute("maxOccurs") + " Variable: " + node.getAttribute("variable"));
            StructElement ele = new StructElement();
            ele.setName(node.getAttribute("name"));
            ele.setType(node.getAttribute("type"));
            if (node.getAttribute("minOccurs").length() > 0) {
                ele.setMinOccurs(new Integer(node.getAttribute("minOccurs")));
            }
            if (node.getAttribute("maxOccurs").length() > 0) {
                ele.setMaxOccurs(new Integer(node.getAttribute("maxOccurs")));
            }
            if (node.getAttribute("xtra:variable").length() > 0 && node.getAttribute("xtra:variable").equalsIgnoreCase("true")) {
                ele.setVariable(true);
            }
            ele.setDefineName(node.getAttribute("xtra:defineName"));
            this.data.setLastStruct(this.data.getLastStruct().setElement(ele));
        } else if (node.getNodeName().equalsIgnoreCase("xsd:choice")) {
            System.out.println(" ");
            System.out.println("This is a Union");
            this.data.setLastStruct(this.data.getLastStruct().setChoice(true));
        }
        NodeList xsdChilds = node.getChildNodes();
        if (xsdChilds != null) {
            for (int i = 0; i < xsdChilds.getLength(); ++i) {
                if (xsdChilds.item(i).getNodeType() != 1) continue;
                this.parse((Element)xsdChilds.item(i), hidden);
            }
        }
    }
}

