/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import com.cisco.dcbu.lan.webservice.client.LanWSDelegator;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.ScheduledTask;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.dto.LicenseFileUsage;
import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.licmgr.HostIdGenerator;
import com.cisco.dcbu.sm.server.licmgr.LicenseValidatorFlexnet;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FileLicensingHelper {
    static final String GETALL_STMT = "SELECT l.SIGN, l.DETAILS from file_lic l";
    static final String GET_FILE_STMT = "SELECT l.SIGN, l.DETAILS from file_lic l where l.SIGN=?";
    static final String INSERT_STMT = "INSERT INTO file_lic( SIGN, DETAILS) VALUES(?, ?)";
    static final String UPDATE_STMT = "UPDATE file_lic set DETAILS=? where SIGN=?";
    static final String DELETE_STMT = "DELETE FROM file_lic WHERE SIGN = ?";
    static final String GET_SAN_LIC_USAGE_COUNT_STMT = "Select count (*) from switch where sign = ?";
    static final String GET_LAN_LIC_USAGE_COUNT_STMT = "Select count (Distinct serial_number) from ethswitch where sign = ?";
    static final String COUNT_SAN_SWITCHES_STMT = "Select count (*) from switch";
    static final String COUNT_LAN_SWITCHES_STMT = "Select count (*) from ethswitch";
    static final String GETALL_SAN_SWITCHES_LIC_STMT = "Select s.id, s.sys_name, s.wwn, s.fabric_id, s.ip_address, s.type, s.non_mds_model, s.sign, s.lic_details, f.is_manageable, f.name, f.fid, s.is_vdc from switch s, Fabric f where s.fabric_id = f.id";
    static final String GET_SAN_SWITCH_LIC_STMT = "Select s.id, s.sys_name, s.wwn, s.fabric_id, s.ip_address, s.type, s.non_mds_model, s.sign, s.lic_details, f.is_manageable, f.name, f.fid, s.is_vdc from switch s, Fabric f where s.id=? AND s.fabric_id = f.id";
    static final String ASSIGN_SAN_SWITCH_LIC_STMT = "UPDATE Switch set sign=?, lic_details=?, l_report=? where id=?";
    static final String GETALL_LAN_SWITCHES_LIC_STMT = "Select s.id, s.sys_name, s.serial_number, l.id, s.ip_address, s.type, s.model_name, s.sign, s.lic_details, s.is_manageable, navg.name, l.lan_id, s.is_vdc, s.is_fex from ethSwitch s, lan l, lanswitch_map lsm, nav_group_member navm, nav_groups navg where s.id = lsm.id AND s.is_fex = FALSE AND l.id = lsm.lan_id AND (s.id = navm.mem_dbid) AND (navm.group_id=navg.id)";
    static final String ADDITION_WHERE_FOR_VDC_CHASSIS = " AND s.serial_number = ?";
    static final String GET_LAN_SWITCH_LIC_STMT = "Select s.id, s.sys_name, s.serial_number, l.id, s.ip_address, s.type, s.model_name, s.sign, s.lic_details, s.is_manageable, navg.name, l.lan_id, s.is_vdc, s.is_fex from ethSwitch s, lan l, lanswitch_map lsm, nav_group_member navm, nav_groups navg where s.id = lsm.id AND l.id = lsm.lan_id AND s.id=? AND (s.id = navm.mem_dbid) AND (navm.group_id=navg.id)";
    static final String ASSIGN_LAN_SWITCH_LIC_STMT = "UPDATE ethSwitch set sign=?, lic_details=?, l_report=? where id=?";
    String beingManagedStr = "The fabric or LAN this switch belongs to is in the process of being managed.\nUntil this process is complete license state can not be modified";
    String beingUnManagedStr = "Your fabric or LAN this switch belongs to is in the process of being unmanaged.\nUntil this process is complete license state can not be modified";
    private static FileLicensingHelper _Instance = null;
    private String _LicenseDir = ClientCache.getDcmDir() + "licenses";
    static Logger _Logger = LogManager.getLogger((String)"fms.license");
    private static LicenseEventWorker eventWorker;
    private static LicenseInfoFlex[] _LastLoadeddetailedLicense;
    private static final int _30DaysInSec = 2592000;

    public static List<Integer> getProductTypes(String featureNameStr) {
        return LicenseValidatorFlexnet.getProductTypes(featureNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLicensingHelper getInstance() {
        if (_Instance != null) {
            return _Instance;
        }
        Class<FileLicensingHelper> clazz = FileLicensingHelper.class;
        synchronized (FileLicensingHelper.class) {
            if (_Instance == null) {
                _Instance = new FileLicensingHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _Instance;
        }
    }

    public String getLicenseDir() {
        return this._LicenseDir;
    }

    private FileLicensingHelper() {
        int currentServerId = -1;
        try {
            currentServerId = Sequence.getSequence().getServerId();
            if (currentServerId == 0) {
                this.synchDBwithLicenseFiles();
            } else {
                _Logger.info((Object)"This Server is not the first server in the Federation, so skipping call to load license files for this server.");
            }
        }
        catch (Exception e) {
            _Logger.error((Object)e);
        }
        eventWorker = new LicenseEventWorker(this);
        SchedulerSingleton.getInstance().addTask(eventWorker);
    }

    public synchronized List<String> reloadLicenseFiles() throws Exception {
        List<String> macs = HostIdGenerator.getInstance().getHostMacs();
        if (macs == null || macs.size() == 0) {
            HostIdGenerator.getInstance().retryMacQuery();
        }
        List<String> errFileNames = this.synchDBwithLicenseFiles();
        return errFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLicenseFileToServer(String fileContent, String fileName) throws Exception {
        if (fileName == null) {
            throw new Exception("Filename should not be null.");
        }
        File licDirFile = new File(this._LicenseDir);
        if (!licDirFile.exists() && !licDirFile.mkdir()) {
            throw new Exception("License directory '" + this._LicenseDir + "' doesn't exist. Unable to create directory.");
        }
        File licFile = new File(this._LicenseDir + File.separator + fileName);
        if (licFile.exists()) {
            throw new Exception("A file with name " + fileName + " already exists in the license directory on the Server.");
        }
        licFile.createNewFile();
        if (!licFile.exists()) {
            throw new Exception("Unable to create file on server: " + licFile);
        }
        if (!licFile.canWrite()) {
            throw new Exception("File cannot be written to server: " + licFile);
        }
        _Logger.info((Object)("Writing to file named " + fileName));
        try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(licFile));){
            out.write(fileContent);
        }
    }

    private synchronized List<String> synchDBwithLicenseFiles() throws Exception {
        LicenseInfoFlex[] detailedLicense;
        ArrayList<String> errFileNames = new ArrayList<String>();
        this._LicenseDir = ClientCache.getDcmDir() + "licenses";
        _Logger.info((Object)("Checking for Licenses under Folder " + this._LicenseDir));
        Exception licenseDirException = null;
        try {
            File[] contents = LicenseValidatorFlexnet.validateAndRetrieveFileFromLicDir(this._LicenseDir);
            detailedLicense = LicenseValidatorFlexnet.getDetailedLicenseInfo(contents, errFileNames);
        }
        catch (Exception e) {
            _Logger.error((Object)e);
            detailedLicense = new LicenseInfoFlex[]{};
            licenseDirException = e;
        }
        List<LicenseInfoFlex> dbLicData = this.getLicDataFromDB();
        if (_Logger.isDebugEnabled()) {
            StringBuilder strBulder = new StringBuilder("LicenseDataInDB - ");
            for (LicenseInfoFlex nextLic : dbLicData) {
                strBulder.append(" Licnense entry - ").append(nextLic);
            }
            _Logger.debug((Object)strBulder.toString());
        }
        ArrayList<LicenseInfoFlex> detailedLicenseList = new ArrayList<LicenseInfoFlex>();
        for (LicenseInfoFlex nextLic : detailedLicense) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("License - " + nextLic));
            }
            detailedLicenseList.add(nextLic);
            if (dbLicData.contains(nextLic)) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("License already found in DB, so updating db entry to - " + nextLic));
                }
                this.updateLicDataInDB(nextLic);
                continue;
            }
            try {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Valid License not found in DB, so inserting license - " + nextLic));
                }
                this.insertLicDataToDB(nextLic);
            }
            catch (SQLException e) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Insert license failed so will delete any license from db with same signature incase there is an invalid license - " + nextLic));
                }
                this.deleteLicDataFromDB(nextLic.getSignature());
                this.insertLicDataToDB(nextLic);
            }
        }
        for (LicenseInfoFlex nextLic : dbLicData) {
            if (detailedLicenseList.contains(nextLic)) continue;
            this.deleteLicDataFromDB(nextLic.getSignature());
        }
        _LastLoadeddetailedLicense = detailedLicense;
        if (licenseDirException != null) {
            throw licenseDirException;
        }
        return errFileNames;
    }

    public void checkAndSendFileLicneseExpireEvent() {
        try {
            EventLoggerService evtLogSrv = (EventLoggerService)ServiceConfig.findService((String)"Event Logger Service");
            List<SwitchAssignedLicenseInfo> switchSanAssignLicInfo = this.getSanLicenseInfoSwitchAssignment();
            for (SwitchAssignedLicenseInfo nextLic : switchSanAssignLicInfo) {
                try {
                    if (!nextLic.isLicenseFileType() || !nextLic.isEval() || nextLic.timeLeft() >= 2592000L) continue;
                    FabricPK fabPk = FabricImpl.findFPKByDbId(nextLic.getFabOrLanDbId());
                    SwitchImpl sw = SanManager.getInstance().findSwitch(new Wwn(nextLic.getSwitchKey()), fabPk);
                    if (sw == null) continue;
                    evtLogSrv.logEvent(new LogEvent((Object)fabPk, LogEventType.LICENSE, Severity.WARNING, "License Manager", "DCNM-SAN file license expires in less than 30 days.", nextLic.getFabOrLanDbId(), nextLic.getDbID(), sw.getSwitchPK()));
                }
                catch (Exception ex) {
                    _Logger.error((Object)"Exception", (Throwable)ex);
                }
            }
            List<SwitchAssignedLicenseInfo> switchLanAssignLicInfo = this.getLanLicenseInfoSwitchAssignment();
            for (SwitchAssignedLicenseInfo nextLic : switchLanAssignLicInfo) {
                try {
                    if (!nextLic.isLicenseFileType() || !nextLic.isEval() || nextLic.timeLeft() >= 2592000L) continue;
                    InetAddress addr = null;
                    addr = InetAddress.getByName(nextLic.getIpAddress());
                    if (addr == null) continue;
                    evtLogSrv.logEvent(new LogEvent(LogEventType.LICENSE, Severity.WARNING, "License Manager", "DCNM-LAN file license expires in less than 30 days.", System.currentTimeMillis(), addr, 1));
                }
                catch (Exception ex) {
                    _Logger.error((Object)"Exception", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    private synchronized void updateLicDataInDB(LicenseInfoFlex licFlex) throws Exception {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(UPDATE_STMT);
            stat.setString(1, licFlex.getBlobForDB());
            stat.setString(2, licFlex.getSignature());
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (Exception e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private synchronized void insertLicDataToDB(LicenseInfoFlex licFlex) throws Exception {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(INSERT_STMT);
            stat.setString(1, licFlex.getSignature());
            stat.setString(2, licFlex.getBlobForDB());
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (Exception e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private synchronized void deleteLicDataFromDB(String signature) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(DELETE_STMT);
            stat.setString(1, signature);
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (SQLException e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public boolean areAllFabricsLicensed() {
        FabricImpl[] fabrics;
        for (FabricImpl next : fabrics = SanManager.getInstance().getFabrics()) {
            boolean licensed = next.isLicensed();
            if (licensed || !next.isPersisted()) continue;
            return false;
        }
        return true;
    }

    public boolean hasAtLeastOneLicenseFileInstalled() {
        try {
            List<LicenseInfoFlex> licenseFiles = this.getLicDataFromDB();
            for (LicenseInfoFlex nextLic : licenseFiles) {
                if (!nextLic.isValid()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            _Logger.warn((Object)"FileLicenseHelper caught exception in hasAtLeastOneLicenseFileInstalled():", e);
            return false;
        }
    }

    public boolean isSwitchTypeLicenseable(int switchType, int licenseType) {
        return LicenseValidatorFlexnet.isSwitchTypeLicenseable(switchType, licenseType);
    }

    public synchronized List<SwitchAssignedLicenseInfo> getLicenseInfoSwitchAssignment() {
        ArrayList<SwitchAssignedLicenseInfo> sanAndLanSwitches = new ArrayList<SwitchAssignedLicenseInfo>();
        sanAndLanSwitches.addAll(this.getSanLicenseInfoSwitchAssignment());
        sanAndLanSwitches.addAll(this.getLanLicenseInfoSwitchAssignment());
        return sanAndLanSwitches;
    }

    public synchronized int getUnlicensedSwitchCount(int productType) {
        if (productType == 1) {
            return this.getUnlicensedSanSwitchCount();
        }
        if (productType == 2) {
            return this.getUnlicensedLanSwitchCount();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getUnlicensedLanSwitchCount() {
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        int unlicensedCount = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(GETALL_LAN_SWITCHES_LIC_STMT));
            rs = stat.executeQuery();
            while (rs.next()) {
                boolean licensed;
                int licenseId;
                String key = rs.getString(3);
                String sign = rs.getString(8);
                String licDetailContents = rs.getString(9);
                Calendar expDate = null;
                try {
                    licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(key, licDetailContents);
                    if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                        expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(key, licDetailContents);
                    }
                }
                catch (Exception e) {
                    licenseId = -1;
                }
                if (licensed = new SwitchLicenseDetails(licenseId, sign, expDate).isLicensed()) continue;
                ++unlicensedCount;
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return unlicensedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SwitchAssignedLicenseInfo> getAllLanSwitchesWithSameChassis(String chassisSerialNumber) {
        ArrayList<SwitchAssignedLicenseInfo> ret = new ArrayList<SwitchAssignedLicenseInfo>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString("Select s.id, s.sys_name, s.serial_number, l.id, s.ip_address, s.type, s.model_name, s.sign, s.lic_details, s.is_manageable, navg.name, l.lan_id, s.is_vdc, s.is_fex from ethSwitch s, lan l, lanswitch_map lsm, nav_group_member navm, nav_groups navg where s.id = lsm.id AND s.is_fex = FALSE AND l.id = lsm.lan_id AND (s.id = navm.mem_dbid) AND (navm.group_id=navg.id) AND s.serial_number = ?"));
            stat.setString(1, chassisSerialNumber);
            rs = stat.executeQuery();
            while (rs.next()) {
                int licenseId;
                long swDbId = rs.getLong(1);
                String sysName = rs.getString(2);
                String key = rs.getString(3);
                long lanDbId = rs.getLong(4);
                String ipAddress = null;
                try {
                    byte[] b = rs.getBytes(5);
                    if (b != null) {
                        InetAddress ip = InetAddress.getByAddress(b);
                        ipAddress = ip.getHostAddress();
                    }
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                int switchType = rs.getInt(6);
                String switchModelStr = rs.getString(7);
                String sign = rs.getString(8);
                String licDetailContents = rs.getString(9);
                boolean managed = rs.getBoolean(10);
                String lanName = rs.getString(11);
                LanPK lpk = new LanPK((int)rs.getLong(12));
                boolean isVDC = rs.getBoolean(13);
                boolean isFex = rs.getBoolean(14);
                lpk.setName(lanName);
                lpk._dbid = lanDbId;
                Calendar expDate = null;
                try {
                    licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(key, licDetailContents);
                    if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                        expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(key, licDetailContents);
                    }
                }
                catch (Exception e) {
                    licenseId = -1;
                }
                ret.add(new SwitchAssignedLicenseInfo(2, swDbId, sysName, key, lpk, ipAddress, switchType, switchModelStr, licenseId, sign, expDate, managed, isVDC, isFex, this.isSwitchTypeLicenseable(switchType, 2)));
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SwitchAssignedLicenseInfo> getLanLicenseInfoSwitchAssignment() {
        ArrayList<SwitchAssignedLicenseInfo> ret = new ArrayList<SwitchAssignedLicenseInfo>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(GETALL_LAN_SWITCHES_LIC_STMT));
            rs = stat.executeQuery();
            while (rs.next()) {
                int licenseId;
                long swDbId = rs.getLong(1);
                String sysName = rs.getString(2);
                String key = rs.getString(3);
                long lanDbId = rs.getLong(4);
                String ipAddress = null;
                try {
                    byte[] b = rs.getBytes(5);
                    if (b != null) {
                        InetAddress ip = InetAddress.getByAddress(b);
                        ipAddress = ip.getHostAddress();
                    }
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                int switchType = rs.getInt(6);
                String switchModelStr = rs.getString(7);
                String sign = rs.getString(8);
                String licDetailContents = rs.getString(9);
                boolean managed = rs.getBoolean(10);
                String lanName = rs.getString(11);
                LanPK lpk = new LanPK((int)rs.getLong(12));
                boolean isVDC = rs.getBoolean(13);
                boolean isFex = rs.getBoolean(14);
                lpk.setName(lanName);
                lpk._dbid = lanDbId;
                Calendar expDate = null;
                try {
                    licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(key, licDetailContents);
                    if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                        expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(key, licDetailContents);
                    }
                }
                catch (Exception e) {
                    licenseId = -1;
                }
                ret.add(new SwitchAssignedLicenseInfo(2, swDbId, sysName, key, lpk, ipAddress, switchType, switchModelStr, licenseId, sign, expDate, managed, isVDC, isFex, this.isSwitchTypeLicenseable(switchType, 2)));
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getUnlicensedSanSwitchCount() {
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        int unlicensedCount = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETALL_SAN_SWITCHES_LIC_STMT);
            rs = stat.executeQuery();
            while (rs.next()) {
                boolean licensed;
                int licenseId;
                Wwn wwn = new Wwn(rs.getBytes(3));
                String sign = rs.getString(8);
                String licDetailContents = rs.getString(9);
                String wwnStr = SnmpString.toHexString(wwn.getValue());
                Calendar expDate = null;
                try {
                    licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(wwnStr, licDetailContents);
                    if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                        expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(wwnStr, licDetailContents);
                    }
                }
                catch (Exception e) {
                    licenseId = -1;
                }
                if (licensed = new SwitchLicenseDetails(licenseId, sign, expDate).isLicensed()) continue;
                ++unlicensedCount;
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return unlicensedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SwitchAssignedLicenseInfo> getSanLicenseInfoSwitchAssignment() {
        ArrayList<SwitchAssignedLicenseInfo> ret = new ArrayList<SwitchAssignedLicenseInfo>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETALL_SAN_SWITCHES_LIC_STMT);
            rs = stat.executeQuery();
            while (rs.next()) {
                int licenseId;
                long swDbId = rs.getLong(1);
                String sysName = rs.getString(2);
                Wwn wwn = new Wwn(rs.getBytes(3));
                long fabDbId = rs.getLong(4);
                String ipAddress = null;
                try {
                    byte[] b = rs.getBytes(5);
                    if (b != null) {
                        InetAddress ip = InetAddress.getByAddress(b);
                        ipAddress = ip.getHostAddress();
                    }
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                int switchType = rs.getInt(6);
                String switchModelStr = rs.getString(7);
                String sign = rs.getString(8);
                String licDetailContents = rs.getString(9);
                boolean managedFabric = rs.getBoolean(10);
                String fabricName = rs.getString(11);
                FabricPK fpk = new FabricPK((int)rs.getLong(12));
                boolean isVDC = rs.getBoolean(13);
                fpk.setName(fabricName);
                fpk.id = fabDbId;
                String wwnStr = SnmpString.toHexString(wwn.getValue());
                Calendar expDate = null;
                try {
                    licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(wwnStr, licDetailContents);
                    if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                        expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(wwnStr, licDetailContents);
                    }
                }
                catch (Exception e) {
                    licenseId = -1;
                }
                ret.add(new SwitchAssignedLicenseInfo(1, swDbId, sysName, wwnStr, fpk, ipAddress, switchType, switchModelStr, licenseId, sign, expDate, managedFabric, isVDC, false, this.isSwitchTypeLicenseable(switchType, 1)));
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public synchronized SwitchAssignedLicenseInfo getSanLicenseInfoSwitchAssignment(long swDbId) {
        return this.getLicenseInfoSwitchAssignment(swDbId, 1);
    }

    public synchronized SwitchAssignedLicenseInfo getLanLicenseInfoSwitchAssignment(long swDbId) {
        return this.getLicenseInfoSwitchAssignment(swDbId, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SwitchAssignedLicenseInfo getLicenseInfoSwitchAssignment(long swDbId, int licenseType) {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        SwitchAssignedLicenseInfo ret;
        block13: {
            ret = null;
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = licenseType == 1 ? con.prepareStatement(GET_SAN_SWITCH_LIC_STMT) : con.prepareStatement(GET_LAN_SWITCH_LIC_STMT);
                stat.setLong(1, swDbId);
                rs = stat.executeQuery();
                if (rs.next()) {
                    int licenseId;
                    String key;
                    String sysName = rs.getString(2);
                    long fabOrLanDbId = rs.getLong(4);
                    String ipAddress = null;
                    try {
                        byte[] b = rs.getBytes(5);
                        if (b != null) {
                            InetAddress ip = InetAddress.getByAddress(b);
                            ipAddress = ip.getHostAddress();
                        }
                    }
                    catch (UnknownHostException ex) {
                        ex.printStackTrace();
                    }
                    int switchType = rs.getInt(6);
                    String switchModelStr = rs.getString(7);
                    String sign = rs.getString(8);
                    String licDetailContents = rs.getString(9);
                    boolean managed = rs.getBoolean(10);
                    String fabricOrLanName = rs.getString(11);
                    FabricPK fpk = licenseType == 1 ? new FabricPK((int)rs.getLong(12)) : new LanPK((int)rs.getLong(12));
                    boolean isVDC = rs.getBoolean(13);
                    boolean isFex = licenseType == 1 ? false : rs.getBoolean(14);
                    fpk.setName(fabricOrLanName);
                    fpk.id = fabOrLanDbId;
                    if (licenseType == 1) {
                        Wwn wwn = new Wwn(rs.getBytes(3));
                        key = SnmpString.toHexString(wwn.getValue());
                    } else {
                        key = rs.getString(3);
                    }
                    Calendar expDate = null;
                    try {
                        licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(key, licDetailContents);
                        if (SwitchLicenseDetails.isValidLicenseState(licenseId)) {
                            expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(key, licDetailContents);
                        }
                    }
                    catch (Exception e) {
                        licenseId = -1;
                    }
                    ret = new SwitchAssignedLicenseInfo(licenseType, swDbId, sysName, key, fpk, ipAddress, switchType, switchModelStr, licenseId, sign, expDate, managed, isVDC, isFex, this.isSwitchTypeLicenseable(switchType, licenseType));
                    break block13;
                }
                _Logger.error((Object)("Error query for switch license details from switch table returns no data fro switch id - " + swDbId));
            }
            catch (SQLException ex) {
                try {
                    _Logger.error((Object)"DB error", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LicenseInfoFlex getLicDataFromDB(String sign) {
        LicenseInfoFlex ret;
        block8: {
            ret = null;
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(GET_FILE_STMT);
                stat.setString(1, sign);
                rs = stat.executeQuery();
                while (rs.next()) {
                    String licDetails = rs.getString(2);
                    try {
                        ret = new LicenseInfoFlex(sign, licDetails);
                    }
                    catch (Exception e) {
                        _Logger.error((Object)("skipped file_lic, sign = " + sign + " format invalid"), (Throwable)e);
                    }
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _Logger.error((Object)"DB error", (Throwable)ex);
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<LicenseInfoFlex> getLicDataFromDB() {
        ArrayList<LicenseInfoFlex> ret = new ArrayList<LicenseInfoFlex>();
        ArrayList<LicenseInfoFlex> evalLicList = new ArrayList<LicenseInfoFlex>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETALL_STMT);
            rs = stat.executeQuery();
            while (rs.next()) {
                String sign = rs.getString(1);
                String licDetails = rs.getString(2);
                try {
                    LicenseInfoFlex nextLic = new LicenseInfoFlex(sign, licDetails);
                    if (nextLic.isPermanent()) {
                        ret.add(nextLic);
                        continue;
                    }
                    evalLicList.add(nextLic);
                }
                catch (Exception e) {
                    _Logger.error((Object)("skipped file_lic, sign = " + sign + " format invalid"), (Throwable)e);
                }
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        ret.addAll(evalLicList);
        return ret;
    }

    public synchronized Map<String, LicenseFileUsage> getLicUsageDataFromDB() {
        List<LicenseInfoFlex> licenseInfo = this.getLicDataFromDB();
        HashMap<String, LicenseFileUsage> map = new HashMap<String, LicenseFileUsage>();
        for (LicenseInfoFlex nextLic : licenseInfo) {
            LicenseFileUsage nextLicUsage = this.getLicUsageDataFromDB(nextLic.getSignature());
            map.put(nextLic.getSignature(), nextLicUsage);
        }
        return map;
    }

    public int getSwitchCount() {
        int sanCount = this.getSwitchCountPerStmt(COUNT_SAN_SWITCHES_STMT);
        int lanCount = this.getSwitchCountPerStmt(COUNT_LAN_SWITCHES_STMT);
        return sanCount + lanCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSwitchCountPerStmt(String stmt) {
        int n;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block5: {
            con = null;
            stat = null;
            rs = null;
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(stmt);
            rs = stat.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return n2;
        }
        try {
            _Logger.error((Object)"Error - empty result set for switch count query");
            n = -1;
        }
        catch (SQLException ex) {
            int n3;
            try {
                _Logger.error((Object)"DB error", (Throwable)ex);
                n3 = -1;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return n3;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public synchronized LicenseFileUsage getLicUsageDataFromDB(String signature) {
        LicenseInfoFlex licDetails = this.getLicDataFromDB(signature);
        int usageSanCount = this.getSpecifiedLicUsageDataFromDB(signature, GET_SAN_LIC_USAGE_COUNT_STMT);
        int usageLanCount = this.getSpecifiedLicUsageDataFromDB(signature, GET_LAN_LIC_USAGE_COUNT_STMT);
        List<Integer> productTypes = LicenseValidatorFlexnet.getProductTypes(licDetails.getFeatureName());
        return new LicenseFileUsage(signature, 0, usageSanCount, usageLanCount, productTypes);
    }

    public String getLicenseHostID() {
        List<String> hostMacs = HostIdGenerator.getInstance().getHostMacs();
        return hostMacs.get(0);
    }

    public List<String> getAllPossibleLicenseHostIDs() {
        return HostIdGenerator.getInstance().getHostMacs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int getSpecifiedLicUsageDataFromDB(String signature, String licQuery) {
        int n;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block8: {
            int n2;
            block7: {
                con = null;
                stat = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(licQuery);
                    stat.setString(1, signature);
                    rs = stat.executeQuery();
                    if (rs.next()) {
                        n2 = rs.getInt(1);
                        DbUtil.close(rs);
                        break block7;
                    }
                    _Logger.error((Object)"Error - empty result set for license usage query");
                    n = -1;
                    DbUtil.close(rs);
                    break block8;
                }
                catch (SQLException ex) {
                    _Logger.error((Object)"DB error", (Throwable)ex);
                    int n3 = -1;
                    return n3;
                }
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return n2;
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public synchronized void unassignLicenseFromSwitch(SwitchImpl swImpl, boolean throwErrorForNotAlreadyLicensed) throws Exception {
        SwitchAssignedLicenseInfo switchCurrentLicAssign = this.getSanLicenseInfoSwitchAssignment(swImpl.getDBID());
        if (switchCurrentLicAssign == null || switchCurrentLicAssign.getLicenseType().equals("Switch")) {
            if (throwErrorForNotAlreadyLicensed) {
                throw new Exception("This switch has a switch bound license that can not be unassigned, only file based license can be unassigned");
            }
            return;
        }
        if (switchCurrentLicAssign.getSign() == null) {
            if (throwErrorForNotAlreadyLicensed) {
                throw new Exception("This switch doesn't have an assigned license, unassign license not allowed");
            }
            return;
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("UnAssigning license from switch:" + swImpl + " will free up one count for lic sign:" + switchCurrentLicAssign.getSign()));
        }
        swImpl.setLicenseDetails(new SwitchLicenseDetails(0, null, null));
        this.updateSwitchLicDBFields(swImpl);
    }

    public synchronized boolean assignAvailableLicenseToSwitch(SwitchImpl swImpl, boolean throwErrorForAlreadyLicensed, boolean allowOverwriteSwitchEvalLicense) throws Exception {
        List<LicenseInfoFlex> licDetails = this.getLicDataFromDB();
        Map<String, LicenseFileUsage> licUsage = this.getLicUsageDataFromDB();
        SwitchLicenseDetails switchCurrentLicDetails = swImpl.getLicenseDetails();
        if (switchCurrentLicDetails != null && switchCurrentLicDetails.isLicensed() && (switchCurrentLicDetails.isLicenseFileType() || !switchCurrentLicDetails.isEval() || !allowOverwriteSwitchEvalLicense)) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("No license assigned to switch, as switch is already licensed:" + swImpl));
            }
            if (throwErrorForAlreadyLicensed) {
                throw new Exception("Switch is already licensed");
            }
            return false;
        }
        int licId = 0;
        String sign = null;
        for (LicenseInfoFlex nextLic : licDetails) {
            LicenseFileUsage usage = licUsage.get(nextLic.getSignature());
            if (usage.getUsedSanCount() >= nextLic.getDeviceCount() || nextLic.timeLeft() <= 0L || !LicenseValidatorFlexnet.isLicenseForType(nextLic, swImpl.getModelType(), 1)) continue;
            licId = nextLic.isPermanent() ? 2 : 5;
            sign = nextLic.getSignature();
            swImpl.setLicenseDetails(new SwitchLicenseDetails(licId, sign, nextLic.getExpDate()));
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("Assigning license switch:" + swImpl + " lic sign:" + sign));
            }
            this.updateSwitchLicDBFields(swImpl);
            break;
        }
        return licId != 0;
    }

    public synchronized void unassignLicenseFromSwitch(EthSwitchImpl ethSwImpl, boolean throwErrorForNotAlreadyLicensed) throws Exception {
        SwitchAssignedLicenseInfo switchCurrentLicAssign = this.getLanLicenseInfoSwitchAssignment(ethSwImpl.getDBID());
        if (switchCurrentLicAssign == null || switchCurrentLicAssign.getSign() == null) {
            if (throwErrorForNotAlreadyLicensed) {
                throw new Exception("No license assigned to switch, unassign license not allowed");
            }
            return;
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("UnAssigning license from eth switch:" + ethSwImpl + " will free up one count for lic sign:" + switchCurrentLicAssign.getSign()));
        }
        ethSwImpl.setLicenseDetails(new SwitchLicenseDetails(0, null, null));
        this.updateSwitchLicDBFields(ethSwImpl);
    }

    public synchronized boolean assignAvailableLicenseToSwitch(EthSwitchImpl swImpl, boolean throwErrorForAlreadyLicensed) throws Exception {
        List<LicenseInfoFlex> licDetails = this.getLicDataFromDB();
        SwitchLicenseDetails switchCurrentLicDetails = swImpl.getLicenseDetails();
        if (switchCurrentLicDetails != null && switchCurrentLicDetails.isLicensed()) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("No license assigned to switch, as switch is already licensed:" + swImpl));
            }
            if (throwErrorForAlreadyLicensed) {
                throw new Exception("Switch is already licensed");
            }
            return false;
        }
        int licId = 0;
        String sign = null;
        if (!swImpl.getBase().isFex()) {
            LicenseInfoFlex licToAssign = null;
            List<SwitchAssignedLicenseInfo> allVDCsInChassis = null;
            allVDCsInChassis = this.getAllLanSwitchesWithSameChassis(swImpl.getChassisKey().toString());
            if (allVDCsInChassis.size() > 1) {
                for (SwitchAssignedLicenseInfo nextLic : allVDCsInChassis) {
                    if (!nextLic.isLicensed()) continue;
                    licToAssign = this.getLicDataFromDB(nextLic.getSign());
                    break;
                }
            } else if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("licensing did not find more than one switch in the db with chassis key" + swImpl.getChassisKey().toString()));
            }
            if (_Logger.isDebugEnabled() && licToAssign == null) {
                _Logger.debug((Object)("licensing did not find that switch:" + swImpl + " had other licensed VDCs in the DB"));
            }
            if (licToAssign == null) {
                Map<String, LicenseFileUsage> licUsage = this.getLicUsageDataFromDB();
                for (LicenseInfoFlex nextLic : licDetails) {
                    LicenseFileUsage usage = licUsage.get(nextLic.getSignature());
                    if (usage.getUsedLanCount() >= nextLic.getDeviceCount() || nextLic.timeLeft() <= 0L || !LicenseValidatorFlexnet.isLicenseForType(nextLic, swImpl.getBase().getModelType(), 2)) continue;
                    licToAssign = nextLic;
                    break;
                }
            }
            if (licToAssign != null) {
                licId = licToAssign.isPermanent() ? 2 : 5;
                sign = licToAssign.getSignature();
                swImpl.setLicenseDetails(new SwitchLicenseDetails(licId, sign, licToAssign.getExpDate()));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Assigning license switch:" + swImpl + " lic sign:" + sign));
                }
                this.updateSwitchLicDBFields(swImpl);
            }
        }
        return licId != 0;
    }

    private synchronized void updateSwitchLicDBFields(SwitchImpl sw) throws SQLException {
        SwitchLicenseDetails switchCurrentLicDetails = sw.getLicenseDetails();
        long swDbId = sw.getDBID();
        String key = SnmpString.toHexString(sw.getWwn().getValue());
        this.updateSwitchLicDBFields(switchCurrentLicDetails, swDbId, key, 1);
    }

    private synchronized void updateSwitchLicDBFields(EthSwitchImpl sw) throws SQLException {
        SwitchLicenseDetails switchCurrentLicDetails = sw.getLicenseDetails();
        long swDbId = sw.getDBID();
        String key = sw.getChassisKey().toString();
        this.updateSwitchLicDBFields(switchCurrentLicDetails, swDbId, key, 2);
    }

    private synchronized void updateSwitchLicDBFields(SwitchLicenseDetails switchCurrentLicDetails, long swDbId, String key, int licenseType) throws SQLException {
        String licTypeString;
        int licId = 0;
        String sign = null;
        Calendar expDate = null;
        boolean licenseBoolean = false;
        if (switchCurrentLicDetails != null) {
            licId = switchCurrentLicDetails.getLicenseId();
            sign = switchCurrentLicDetails.getSign();
            expDate = switchCurrentLicDetails.getExpireDate();
            licenseBoolean = switchCurrentLicDetails.isLicensed();
        }
        String string = licTypeString = licenseType == 1 ? "SAN" : "LAN";
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("Updating switch license values: " + licTypeString + " switch " + swDbId + " sign: " + sign));
        }
        String licDetailsString = "";
        try {
            licDetailsString = FileLicensingHelper.constructLicDetailStringForDB(key, (long)licId, sign, expDate);
        }
        catch (Exception e) {
            _Logger.error((Object)("Unable to encrypt " + licTypeString + " switch license details for DB, switch will show as unlicesed - " + swDbId), (Throwable)e);
            sign = "";
        }
        FileLicensingHelper.updateSwitchLicDBFields(sign, licDetailsString, swDbId, licenseBoolean, licenseType);
    }

    public boolean postDiscoveryLicenseProcessing(EthSwitchImpl sw) {
        if (sw.getBase().getModelType() == -1) {
            return false;
        }
        if (!sw.isAssignedLicenseTried()) {
            boolean licenseAssignSuccess = false;
            try {
                licenseAssignSuccess = this.assignAvailableLicenseToSwitch(sw, false);
            }
            catch (Exception e) {
                _Logger.error((Object)("Error while attempting to automatically assign license to sw:" + sw), (Throwable)e);
            }
            sw.setAssignedLicenseTried(true);
            return licenseAssignSuccess;
        }
        return false;
    }

    public boolean postDiscoveryLicenseProcessing(SwitchImpl sw) {
        if (sw.getBase().getModelType() == -1) {
            return false;
        }
        LicenseInfo lic = sw.getFmServerPkgLicenseInfo();
        if (lic != null && lic.isPermanent()) {
            SwitchLicenseDetails currentLicDetails = sw.getLicenseDetails();
            if (currentLicDetails != null && currentLicDetails.isLicenseFileType()) {
                try {
                    this.unassignLicenseFromSwitch(sw, false);
                }
                catch (Exception e) {
                    _Logger.error((Object)("Error while attempting to automatically unassign license from sw:" + sw), (Throwable)e);
                }
            }
            if (currentLicDetails == null || currentLicDetails.getLicenseId() != 3) {
                sw.setLicenseDetails(new SwitchLicenseDetails(3, null, null));
                try {
                    this.updateSwitchLicDBFields(sw);
                }
                catch (Exception e) {
                    _Logger.error((Object)"switch license db update error", (Throwable)e);
                }
            }
            return true;
        }
        if (lic != null && (lic.isEval() && lic.isCheckedout() || lic.isTemp()) && lic.timeLeft() > 0L) {
            SwitchLicenseDetails currentLicDetails = sw.getLicenseDetails();
            if (currentLicDetails != null && currentLicDetails.isLicenseFileType()) {
                return true;
            }
            if (currentLicDetails == null || currentLicDetails.getLicenseId() != 4) {
                long timeleft;
                Calendar expDate = lic.getExpDate();
                if (expDate == null && (timeleft = lic.timeLeft()) > 0L) {
                    long expDateMil = Calendar.getInstance().getTimeInMillis() + timeleft * 1000L;
                    expDate = Calendar.getInstance();
                    expDate.setTimeInMillis(expDateMil);
                }
                sw.setLicenseDetails(new SwitchLicenseDetails(4, null, expDate));
                try {
                    this.updateSwitchLicDBFields(sw);
                }
                catch (Exception e) {
                    _Logger.error((Object)"switch license db update error", (Throwable)e);
                }
            }
            return true;
        }
        SwitchLicenseDetails currentLicDetails = sw.getLicenseDetails();
        if (currentLicDetails != null && !currentLicDetails.isLicenseFileType()) {
            sw.setLicenseDetails(new SwitchLicenseDetails(0, null, null));
            try {
                this.updateSwitchLicDBFields(sw);
            }
            catch (Exception e) {
                _Logger.error((Object)"switch license db update error", (Throwable)e);
            }
        }
        if (!sw.isAssignedLicenseTried()) {
            boolean licenseAssignSuccess = false;
            try {
                licenseAssignSuccess = this.assignAvailableLicenseToSwitch(sw, false, false);
            }
            catch (Exception e) {
                _Logger.error((Object)("Error while attempting to automatically assign license to sw:" + sw), (Throwable)e);
            }
            sw.setAssignedLicenseTried(true);
            return licenseAssignSuccess;
        }
        return false;
    }

    public synchronized SwitchAssignedLicenseInfo manuallyUnassignLicenseFromSwitch(long swDbId, FabricPK fPK, int licenseType) throws Exception {
        AbstractModelObjectImpl swImpl;
        if (licenseType == 1) {
            FabricImpl fabImpl = SanManager.getInstance().findFabric(fPK);
            if (this.checkFabricManagedStatus(fabImpl)) {
                swImpl = fabImpl.findSwitchByDbId(swDbId);
                this.unassignLicenseFromSwitch((SwitchImpl)swImpl, true);
            } else {
                this.unassignLicenseFromSwitch(swDbId, licenseType);
            }
        } else {
            LanImpl lan = DCManager.getInstance().findLan((LanPK)fPK);
            if (this.checkLanManagedStatus(lan)) {
                swImpl = DCManager.getInstance().findLan((LanPK)fPK).findEthSwitchByDBID(swDbId);
                this.unassignLicenseFromSwitch((EthSwitchImpl)swImpl, true);
            } else {
                this.unassignLicenseFromSwitch(swDbId, licenseType);
            }
        }
        SwitchAssignedLicenseInfo newState = this.getLicenseInfoSwitchAssignment(swDbId, licenseType);
        if (licenseType == 2) {
            try {
                LanWSDelegator.getInstance().modifyLanLicensedState(newState.getSwitchKey(), newState.isLicensed());
            }
            catch (Exception e) {
                _Logger.error((Object)"Call to DCNM LAN Server for license state change threw an exception", (Throwable)e);
            }
        }
        return newState;
    }

    public synchronized SwitchAssignedLicenseInfo manuallyAssignAvailableLicenseToSwitch(long swDbId, FabricPK fPK, int licenseType) throws Exception {
        LanImpl lan;
        AbstractModelObjectImpl swImpl;
        FabricImpl fabImpl;
        if (licenseType == 1 ? (this.checkFabricManagedStatus(fabImpl = SanManager.getInstance().findFabric(fPK)) ? !this.assignAvailableLicenseToSwitch((SwitchImpl)(swImpl = SanManager.getInstance().findFabric(fPK).findSwitchByDbId(swDbId)), true, true) : !this.assignAvailableLicenseToSwitch(swDbId, licenseType)) : (this.checkLanManagedStatus(lan = DCManager.getInstance().findLan((LanPK)fPK)) ? !this.assignAvailableLicenseToSwitch((EthSwitchImpl)(swImpl = lan.findEthSwitchByDBID(swDbId)), true) : !this.assignAvailableLicenseToSwitch(swDbId, licenseType))) {
            throw new Exception("No valid or unused licenses available for this switch type.");
        }
        SwitchAssignedLicenseInfo newState = this.getLicenseInfoSwitchAssignment(swDbId, licenseType);
        if (licenseType == 2) {
            try {
                LanWSDelegator.getInstance().modifyLanLicensedState(newState.getSwitchKey(), newState.isLicensed());
            }
            catch (Exception e) {
                _Logger.error((Object)"Call to DCNM LAN Server for license state change threw an exception", (Throwable)e);
            }
        }
        return newState;
    }

    public synchronized void unassignLicenseFromSwitch(long swDbId, int licenseType) throws Exception {
        SwitchAssignedLicenseInfo switchCurrentLicAssign = this.getSanLicenseInfoSwitchAssignment(swDbId);
        if (switchCurrentLicAssign == null || switchCurrentLicAssign.getLicenseType().equals("Switch")) {
            throw new Exception("This switch has a switch bound license that can not be unassigned, only file based license can be unassigned");
        }
        if (switchCurrentLicAssign.getSign() == null) {
            throw new Exception("This switch doesn't have an assigned license, unassign license not allowed");
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("UnAssigning license from switch:" + swDbId + " will free up one count for lic sign:" + switchCurrentLicAssign.getSign()));
        }
        SwitchLicenseDetails licDetails = new SwitchLicenseDetails(0, null, null);
        this.updateSwitchLicDBFields(licDetails, swDbId, switchCurrentLicAssign.getSwitchKey(), licenseType);
    }

    public synchronized boolean assignAvailableLicenseToSwitch(long swDbId, int licenseType) throws Exception {
        List<LicenseInfoFlex> licDetails = this.getLicDataFromDB();
        SwitchAssignedLicenseInfo switchCurrentLicAssign = this.getLicenseInfoSwitchAssignment(swDbId, licenseType);
        if (switchCurrentLicAssign == null) {
            throw new Exception("Unable to retrieve switch details for license assignment");
        }
        if (switchCurrentLicAssign.isLicensed() && (switchCurrentLicAssign.isLicenseFileType() || !switchCurrentLicAssign.isEval())) {
            throw new Exception("Switch is already licensed");
        }
        if (switchCurrentLicAssign.isManaged().booleanValue()) {
            throw new Exception(this.beingManagedStr);
        }
        int licId = 0;
        String sign = null;
        if (!switchCurrentLicAssign.isFex()) {
            LicenseInfoFlex licToAssign = null;
            List<SwitchAssignedLicenseInfo> allVDCsInChassis = null;
            if (licenseType == 2 && switchCurrentLicAssign.isVDC() && (allVDCsInChassis = this.getAllLanSwitchesWithSameChassis(switchCurrentLicAssign.getSwitchKey())).size() > 1) {
                for (SwitchAssignedLicenseInfo nextLic : allVDCsInChassis) {
                    if (!nextLic.isLicensed()) continue;
                    licToAssign = this.getLicDataFromDB(nextLic.getSign());
                    break;
                }
            }
            if (licToAssign == null) {
                Map<String, LicenseFileUsage> licUsage = this.getLicUsageDataFromDB();
                for (LicenseInfoFlex nextLic : licDetails) {
                    LicenseFileUsage usage = licUsage.get(nextLic.getSignature());
                    if (usage.getUsedLanCount() >= nextLic.getDeviceCount() || nextLic.timeLeft() <= 0L || !LicenseValidatorFlexnet.isLicenseForType(nextLic, switchCurrentLicAssign.getSwitchType(), licenseType)) continue;
                    licToAssign = nextLic;
                    break;
                }
            }
            if (licToAssign != null) {
                licId = licToAssign.isPermanent() ? 2 : 5;
                sign = licToAssign.getSignature();
                SwitchLicenseDetails licDetailsString = new SwitchLicenseDetails(licId, sign, licToAssign.getExpDate());
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("updating license switch in db:" + swDbId + " lic sign:" + sign));
                }
                this.updateSwitchLicDBFields(licDetailsString, swDbId, switchCurrentLicAssign.getSwitchKey(), licenseType);
            }
        }
        return licId != 0;
    }

    private boolean checkFabricManagedStatus(FabricImpl fabImpl) throws Exception {
        block8: {
            int fabStatus;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            if (fabImpl == null) break block8;
                            fabStatus = fabImpl.getStatus();
                            if (fabStatus == 4) break block9;
                            if (fabStatus != 2) break block10;
                        }
                        return true;
                    }
                    if (fabStatus == 6) {
                        return false;
                    }
                    if (fabStatus == 3) break block11;
                    if (fabStatus != 1) break block12;
                }
                throw new Exception(this.beingManagedStr);
            }
            if (fabStatus == 5) {
                throw new Exception(this.beingUnManagedStr);
            }
            throw new Exception("Unknown Fabric status");
        }
        throw new Exception("Unable to find the Fabric object that this switch belongs to");
    }

    private boolean checkLanManagedStatus(LanImpl lan) throws Exception {
        block8: {
            int lanStatus;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            if (lan == null) break block8;
                            lanStatus = lan.getStatus();
                            if (lanStatus == 4) break block9;
                            if (lanStatus != 2) break block10;
                        }
                        return true;
                    }
                    if (lanStatus == 6) {
                        return false;
                    }
                    if (lanStatus == 3) break block11;
                    if (lanStatus != 1) break block12;
                }
                throw new Exception(this.beingManagedStr);
            }
            if (lanStatus == 5) {
                throw new Exception(this.beingUnManagedStr);
            }
            throw new Exception("Unknown LAN status");
        }
        throw new Exception("Unable to find the LAN object that this switch belongs to");
    }

    private static synchronized void updateSwitchLicDBFields(String sign, String licDetailsString, long swDbId, boolean lreport, int licenseType) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = licenseType == 1 ? con.prepareStatement(ASSIGN_SAN_SWITCH_LIC_STMT) : con.prepareStatement(ASSIGN_LAN_SWITCH_LIC_STMT);
            stat.setString(1, sign);
            stat.setString(2, licDetailsString);
            stat.setBoolean(3, lreport);
            stat.setLong(4, swDbId);
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (SQLException e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private static String getValue(String blobStr, String startStr, String endStr) {
        String str = null;
        int idx = blobStr.indexOf(startStr);
        if (idx != -1) {
            int lastIdx = blobStr.indexOf(endStr, idx += startStr.length());
            str = lastIdx != -1 ? blobStr.substring(idx, lastIdx).trim() : blobStr.substring(idx).trim();
        }
        return str;
    }

    public static void handleLicenseDecodingFromDBValue(AbstractSwitchBase base, String sign, String switchDbLicDetailsValue) {
        Calendar expDate = null;
        int licenseId = 0;
        if (switchDbLicDetailsValue != null && switchDbLicDetailsValue.trim().length() > 0) {
            try {
                String key = null;
                key = base instanceof SwitchBase ? SnmpString.toHexString(((SwitchBase)base).getWwn().getValue()) : ((EthSwitchBase)base).getChassisKey().toString();
                licenseId = FileLicensingHelper.parseLicenseIdFromDBLicDetailValue(key, switchDbLicDetailsValue);
                expDate = FileLicensingHelper.parseCalFromDbLicDetailValue(key, switchDbLicDetailsValue);
            }
            catch (Exception e) {
                _Logger.error((Object)("Database value for license details for switch is invalid, setting license id to invalid for switch - " + base));
                licenseId = -1;
            }
        }
        base.setLicenseDetails(new SwitchLicenseDetails(licenseId, sign, expDate));
    }

    public static String processLicDetailStringForDB(AbstractSwitchBase base) throws Exception {
        if (base.getLicenseDetails() == null) {
            return "";
        }
        long licenseId = base.getLicenseDetails().getLicenseId();
        String key = base instanceof SwitchBase ? SnmpString.toHexString(((SwitchBase)base).getWwn().getValue()) : base.getChassisKey().toString();
        Calendar expDate = base.getLicenseDetails().getExpireDate();
        String sign = base.getLicenseDetails().getSign();
        return FileLicensingHelper.constructLicDetailStringForDB(key, licenseId, sign, expDate);
    }

    public static String constructLicDetailStringForDB(String key, long licenseId, String sign, long expValue) throws Exception {
        StringBuilder str = new StringBuilder("");
        str.append(" <id>").append(licenseId);
        str.append(" <k>").append(key);
        str.append(" <s>").append(sign == null ? "n" : sign);
        str.append(" <ed>").append(expValue <= 0L ? "n" : Long.valueOf(expValue));
        String encryptedStr = StringEncrypter.encryptString("DES", str.toString());
        return "#" + encryptedStr;
    }

    public static String constructLicDetailStringForDB(String key, long licenseId, String sign, Calendar date) throws Exception {
        return FileLicensingHelper.constructLicDetailStringForDB(key, licenseId, sign, date == null ? 0L : date.getTimeInMillis());
    }

    public static int parseLicenseIdFromDBLicDetailValue(String key, String switchDbLicenseDetailValueEncrypted) throws Exception {
        if (switchDbLicenseDetailValueEncrypted == null) {
            return 0;
        }
        String switchDbLicDetailValue = switchDbLicenseDetailValueEncrypted.startsWith("#") ? StringEncrypter.decryptString("DES", switchDbLicenseDetailValueEncrypted.substring(1)) : switchDbLicenseDetailValueEncrypted;
        if (switchDbLicDetailValue == null || switchDbLicDetailValue.trim().length() == 0) {
            return 0;
        }
        int licenseId = 0;
        String endStr = "<";
        String blobKey = FileLicensingHelper.getValue(switchDbLicDetailValue, "<k>", endStr);
        if (!key.equals(blobKey)) {
            throw new Exception("switch database license Details doesn't match license assigned to the switch");
        }
        String idStr = FileLicensingHelper.getValue(switchDbLicDetailValue, "<id>", endStr);
        if (idStr == null) {
            throw new Exception("switch database license Details format is invalid");
        }
        licenseId = new Integer(idStr);
        return licenseId;
    }

    public static Calendar parseCalFromDbLicDetailValue(String key, String switchDbLicenseDetailValueEncrypted) throws Exception {
        String switchDbLicenseDetailValue = switchDbLicenseDetailValueEncrypted.startsWith("#") ? StringEncrypter.decryptString("DES", switchDbLicenseDetailValueEncrypted.substring(1)) : switchDbLicenseDetailValueEncrypted;
        Calendar expDate = null;
        String endStr = "<";
        String blobKey = FileLicensingHelper.getValue(switchDbLicenseDetailValue, "<k>", endStr);
        if (!key.equals(blobKey)) {
            throw new Exception("switch database license details doesn't match license assigned to the switch");
        }
        String dateStrInMillis = FileLicensingHelper.getValue(switchDbLicenseDetailValue, "<ed>", endStr);
        if (dateStrInMillis != null) {
            if (dateStrInMillis.equals("n")) {
                expDate = null;
            } else {
                long timeMillis = new Long(dateStrInMillis);
                expDate = Calendar.getInstance();
                expDate.setTimeInMillis(timeMillis);
            }
        } else {
            throw new Exception("switch database license details format is invalid");
        }
        return expDate;
    }

    public static void test() {
        try {
            FileLicensingHelper flh = FileLicensingHelper.getInstance();
            List<LicenseInfoFlex> dbLicData = flh.getLicDataFromDB();
            System.out.println("****** Contents of DB before modification");
            for (LicenseInfoFlex nextLic : dbLicData) {
                System.out.println("DB License Data - " + nextLic);
            }
            System.out.println("****** License Data from file");
            for (LicenseInfoFlex nextLic : _LastLoadeddetailedLicense) {
                System.out.println("License - " + nextLic);
                if (dbLicData.contains(nextLic)) {
                    flh.updateLicDataInDB(nextLic);
                    continue;
                }
                try {
                    flh.insertLicDataToDB(nextLic);
                }
                catch (SQLException e) {
                    flh.deleteLicDataFromDB(nextLic.getSignature());
                    flh.insertLicDataToDB(nextLic);
                }
            }
            System.out.println("****** Contents of DB after sych to file data");
            dbLicData = flh.getLicDataFromDB();
            for (LicenseInfoFlex nextLic : dbLicData) {
                System.out.println("DB License Data - " + nextLic);
            }
        }
        catch (Exception e) {
            System.out.println("Exception" + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        FileLicensingHelper.test();
    }

    static {
        _LastLoadeddetailedLicense = null;
    }

    class LicenseEventWorker
    extends ScheduledTask {
        FileLicensingHelper _flh;

        public LicenseEventWorker(FileLicensingHelper flh) {
            super("LicenseEventWorker-", new Schedule(10000L, 86400000L, false));
            this._flh = flh;
        }

        @Override
        public void run() {
            this._flh.checkAndSendFileLicneseExpireEvent();
        }
    }
}

